/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.iprm.gcpapi;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.MultiLangEnumBridge;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.iprm.gcpapi.AbstractGcpBridgeManager;
import kd.imsc.cc.business.iprm.gcpapi.GcpDigestApiBuilder;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;
import kd.imsc.cc.common.constants.iprm.model.GcpApiType;
import kd.imsc.cc.common.utils.OkHttpUtils;

public class GcpDigestManager
extends AbstractGcpBridgeManager<GcpApiType> {
    private static final Log logger = LogFactory.getLog(GcpDigestManager.class);

    @Override
    public BizOperationResult baseGcpRequestByGet(Map<String, Object> params, String path) {
        return this.baseGcpRequestByGet(params, new GcpApiType(new MultiLangEnumBridge(ResManager.loadKDString((String)"GET\u8bf7\u6c42", (String)"GcpDigestManager_0", (String)"imsc-cc", (Object[])new Object[0]), "GcpDigestManager_1", "imsc-iprm-business", new Object[0]), path));
    }

    @Override
    public BizOperationResult baseGcpRequestByGet(Map<String, Object> params, GcpApiType gcpApiType) {
        long startTime = System.currentTimeMillis();
        long gcpTime = 0L;
        BizOperationResult result = new BizOperationResult(false);
        if (null == params) {
            params = new HashMap<String, Object>(10);
        }
        if (null == gcpApiType) {
            result.setErrorCode(99);
            result.setErrorDesc(ResManager.loadKDString((String)"\u8bf7\u6c42API\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GcpDigestManager_1", (String)"imsc-cc", (Object[])new Object[0]));
            return result;
        }
        try {
            String tenantInfo;
            GcpDigestApiBuilder gcpDigestApiBuilder = GcpDigestApiBuilder.getGcpDigestApiBuilder();
            String url = gcpDigestApiBuilder.getFullUrl(gcpApiType);
            params.putAll(this.baseReqParams());
            if (gcpApiType.isRecTenant() && StringUtils.isNotEmpty((String)(tenantInfo = this.recordTenantInfo()))) {
                params.put("rec_tenant", tenantInfo);
            }
            url = url + gcpDigestApiBuilder.doGetDigest(params);
            logger.info("Http Get|Url\uff1a{}", (Object)url);
            long gcpStartTime = System.currentTimeMillis();
            String resultPost = OkHttpUtils.getRequest(url);
            gcpTime = System.currentTimeMillis() - gcpStartTime;
            this.parseHttpResp(resultPost, result, url);
        }
        catch (Exception ex) {
            logger.error(gcpApiType.getName(), (Throwable)ex);
            result.setErrorCode(99);
            result.setErrorDesc(String.format("%1$s %2$s", gcpApiType.getName(), ex.getMessage()));
        }
        logger.info("{}|gcp\u529f\u80fd\u8bf7\u6c42\u8017\u65f6\uff1a{}ms|\u603b\u8017\u65f6\uff1a{}ms", new Object[]{gcpApiType.getPath(), gcpTime, System.currentTimeMillis() - startTime});
        logger.info("Gcp request finish");
        return result;
    }

    @Override
    public BizOperationResult baseGcpRequestByPostJson(Map<String, Object> params, String path) {
        return this.baseGcpRequestByPostJson(params, new GcpApiType(new MultiLangEnumBridge(ResManager.loadKDString((String)"POST\u8bf7\u6c42", (String)"GcpDigestManager_2", (String)"imsc-cc", (Object[])new Object[0]), "GcpDigestManager_2", "imsc-iprm-business", new Object[0]), path));
    }

    @Override
    public BizOperationResult baseGcpRequestByPostJson(Map<String, Object> params, GcpApiType gcpApiType) {
        long startTime = System.currentTimeMillis();
        long gcpTime = 0L;
        BizOperationResult result = new BizOperationResult(false);
        if (null == params) {
            params = new HashMap<String, Object>(10);
        }
        if (null == gcpApiType) {
            result.setErrorCode(99);
            result.setErrorDesc(ResManager.loadKDString((String)"\u8bf7\u6c42API\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GcpDigestManager_1", (String)"imsc-cc", (Object[])new Object[0]));
            return result;
        }
        try {
            String tenantInfo;
            GcpDigestApiBuilder gcpDigestApiBuilder = GcpDigestApiBuilder.getGcpDigestApiBuilder();
            String url = gcpDigestApiBuilder.getFullUrl(gcpApiType);
            Map<String, String> baseParamMap = this.baseReqParams();
            params.put("base", baseParamMap);
            if (gcpApiType.isRecTenant() && StringUtils.isNotEmpty((String)(tenantInfo = this.recordTenantInfo()))) {
                baseParamMap.put("rec_tenant", tenantInfo);
            }
            Map<String, String> header = gcpDigestApiBuilder.doPostDigest(params);
            logger.info("Http Post|Url\uff1a{}|header\uff1a{}|parameter {}", new Object[]{url, OpenJsonUtil.toJson(header), OpenJsonUtil.toJson(params)});
            long gcpStartTime = System.currentTimeMillis();
            String resultPost = OkHttpUtils.postJsonRequest(url, header, OpenJsonUtil.toJson(params));
            gcpTime = System.currentTimeMillis() - gcpStartTime;
            this.parseHttpResp(resultPost, result, url);
        }
        catch (Exception ex) {
            logger.error(gcpApiType.getName(), (Throwable)ex);
            result.setErrorCode(99);
            result.setErrorDesc(String.format("%1$s,%2$s", gcpApiType.getName(), ex.getMessage()));
        }
        logger.info("{}|gcp\u529f\u80fd\u8bf7\u6c42\u8017\u65f6\uff1a{}ms|\u603b\u8017\u65f6\uff1a{}ms", new Object[]{gcpApiType.getPath(), gcpTime, System.currentTimeMillis() - startTime});
        logger.info("Gcp request finish");
        return result;
    }
}

