/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.proxy;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.builder.ShowParameterBuilder;
import kd.imsc.cc.common.exception.KdXkIprmException;

public class ImportParamAdapterProxy {
    private static final Log LOGGER = LogFactory.getLog(ImportParamAdapterProxy.class);
    private static final String SETCUSTOMPARAM = "setCustomParam";
    private static final String SETAPPID = "setAppId";
    private static final String SETCAPTION = "setCaption";
    private static final String ADDCUSTPLUGIN = "addCustPlugin";

    private ImportParamAdapterProxy() {
        throw new IllegalStateException("Utility class");
    }

    public static FormShowParameter createFormShowParamForImport(String formId, String pageType, Map<String, String> excelParams) throws KdXkIprmException {
        if (StringUtils.isEmpty((String)formId)) {
            return null;
        }
        Object showParameter = "bos_dynamicform".equals(pageType) ? ShowParameterBuilder.formShowParameter(formId, ShowType.MainNewTabPage, null, null, null) : ShowParameterBuilder.listShowParameter(formId, pageType, ShowType.MainNewTabPage, null, null, "", "");
        if (showParameter == null) {
            return null;
        }
        FormConfig formConfig = ImportParamAdapterProxy.getFormConfig(formId, showParameter);
        String bizAppNumber = formConfig.getBizAppNumber();
        String serviceAppId = ImportParamAdapterProxy.getServiceAppId(formConfig.getAppId(), bizAppNumber, showParameter.getServiceAppId());
        LOGGER.info(String.format("createFormShowParamForImport serviceAppId:%1$s,appid:%2$s", serviceAppId, formConfig.getAppId()));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        String entityDisplayName = entityType.getDisplayName().getLocaleValue();
        String entityName = entityType.getName();
        String saveOp = EntityMetadataCache.getDataEntityOperations((String)entityName).getSave();
        String importPlugin = ImportParamAdapterProxy.getImportPlugin(entityName);
        if (excelParams != null && !excelParams.isEmpty()) {
            String importType = excelParams.get("dataimporttype");
            if (StringUtils.isEmpty((String)importType)) {
                if ("bd_accountview".equals(formId)) {
                    showParameter.setCustomParam("Type", (Object)"new");
                } else {
                    showParameter.setCustomParam("Type", (Object)"overridenew");
                }
            } else {
                showParameter.setCustomParam("Type", (Object)importType);
            }
            String keyFields = excelParams.get("keyfields");
            if (StringUtils.isEmpty((String)keyFields) || keyFields.replace(",", "").length() == 0) {
                showParameter.setCustomParam("KeyFields", (Object)",id,");
            } else {
                showParameter.setCustomParam("KeyFields", (Object)keyFields);
            }
            String isOverrideEntry = excelParams.get("isoverrideentry");
            showParameter.setCustomParam("OverrideEntry", (Object)isOverrideEntry);
        } else {
            showParameter.setCustomParam("Type", (Object)"overridenew");
            showParameter.setCustomParam("KeyFields", (Object)",id,");
            showParameter.setCustomParam("OverrideEntry", (Object)"true");
        }
        showParameter.setAppId(bizAppNumber);
        showParameter.setCustomParam("SetNULL", (Object)"true");
        showParameter.setCustomParam("ServiceAppId", (Object)serviceAppId);
        showParameter.setCustomParam("CheckRightAppId", (Object)bizAppNumber);
        showParameter.setCustomParam("BillFormId", (Object)formId);
        showParameter.setCustomParam("ListName", (Object)entityDisplayName);
        showParameter.setCustomParam("OpSave", (Object)saveOp);
        showParameter.setCustomParam("ImportPlugin", (Object)importPlugin);
        showParameter.setCustomParam("OperateKey", (Object)saveOp);
        showParameter.setCustomParam("appId", (Object)bizAppNumber);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        return showParameter;
    }

    private static FormConfig getFormConfig(String formId, FormShowParameter showParameter) {
        FormConfig formConfig = null;
        formConfig = showParameter instanceof ListShowParameter ? FormMetadataCache.getListFormConfig((String)((ListShowParameter)showParameter).getBillFormId()) : FormMetadataCache.getFormConfig((String)formId);
        return formConfig;
    }

    public static void specialFormParameters(String pageEnterParam, FormShowParameter formShowParameter) {
        if (StringUtils.isEmpty((String)pageEnterParam)) {
            return;
        }
        JSONObject map = JSONObject.parseObject((String)pageEnterParam).getJSONObject("params");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Map tempMap = (Map)entry.getValue();
            for (Map.Entry anoentry : tempMap.entrySet()) {
                String name = (String)anoentry.getKey();
                String value = (String)anoentry.getValue();
                switch (key) {
                    case "setCustomParam": {
                        formShowParameter.setCustomParam(name, (Object)value);
                        break;
                    }
                    case "setAppId": {
                        formShowParameter.setAppId(value);
                        break;
                    }
                    case "setCaption": {
                        formShowParameter.setCaption(value);
                        break;
                    }
                    case "addCustPlugin": {
                        formShowParameter.addCustPlugin(value);
                        break;
                    }
                }
            }
        }
    }

    private static String getServiceAppId(String appId, String bizAppNumber, String serviceAppId) {
        return serviceAppId;
    }

    private static String getImportPlugin(String entityName) throws KdXkIprmException {
        Map importOpMap = EntityMetadataCache.getDataEntityOperate((String)entityName, (String)"importdata");
        if (importOpMap == null || !importOpMap.containsKey("parameter")) {
            return "";
        }
        LinkedHashMap opParam = (LinkedHashMap)importOpMap.get("parameter");
        if (!opParam.containsKey("plugins")) {
            return "";
        }
        ArrayList plugins = (ArrayList)opParam.get("plugins");
        if (plugins == null || plugins.isEmpty()) {
            return "";
        }
        for (int i = 0; i < plugins.size(); ++i) {
            Map p = (Map)plugins.get(i);
            if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
            return String.valueOf(p.get("ClassName"));
        }
        return "";
    }

    public static void checkImportBtn(String entityName) throws KdXkIprmException {
        FormMetadata listMeta;
        String entityNumber = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((String)entityNumber)) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u67e5\u8be2\u5143\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportParamAdapterProxy_0", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)entityNumber, (MetaCategory)MetaCategory.Form);
        if (null == formMetadata || null == formMetadata.getRootAp()) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u67e5\u8be2\u5143\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportParamAdapterProxy_0", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        FormAp rootAp = formMetadata.getRootAp();
        if (rootAp instanceof BasedataFormAp) {
            listMeta = ((BasedataFormAp)rootAp).getListMeta();
        } else if (rootAp instanceof BillFormAp) {
            listMeta = ((BillFormAp)rootAp).getListMeta();
        } else {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5bf9\u8c61\u5c1a\u672a\u652f\u6301\u5bfc\u5165\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportParamAdapterProxy_1", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        if (null == listMeta || CollectionUtils.isEmpty((Collection)listMeta.getItems())) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u67e5\u8be2\u5143\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportParamAdapterProxy_0", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        List items = listMeta.getItems();
        List barCollect = items.stream().filter(t -> t instanceof BarItemAp).collect(Collectors.toList());
        for (Object control : barCollect) {
            BarItemAp barItemAp = (BarItemAp)control;
            if (barItemAp.isHidden()) continue;
            if ("importdata".equals(barItemAp.getOperationKey())) {
                return;
            }
            List dropdownItems = barItemAp.getDropdownItems();
            if (CollectionUtils.isEmpty((Collection)dropdownItems)) continue;
            for (DropdownItem dropdownItem : dropdownItems) {
                if (!"importdata".equals(dropdownItem.getOperationKey())) continue;
                return;
            }
        }
        throw new KdXkIprmException(ResManager.loadKDString((String)"\u6b64\u4e1a\u52a1\u5bf9\u8c61\u5df2\u7ecf\u4e0d\u652f\u6301\u5bfc\u5165\uff0c\u8bf7\u624b\u5de5\u7ef4\u62a4\u3002", (String)"ImportParamAdapterProxy_2", (String)"imsc-cc", (Object[])new Object[0]), 1001);
    }

    public static String openFormView(String formId, FormShowParameter parameter) {
        FormConfigFactory.createConfig((FormShowParameter)parameter);
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{parameter.getPageId(), "[{\"key\":\"\",\"methodName\":\"loadData\",\"args\":[],\"postData\":[]}]"});
        return parameter.getPageId();
    }

    public static void closeFormView(String formId, String pageId) {
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{pageId, "[{\"key\":\"toolbarap\",\"methodName\":\"itemClick\",\"args\":[\"tblclose\",\"close\"],\"postData\":[{},[]]}]"});
    }
}

