/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.resource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.gcpmanage.GcpManager;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;
import kd.imsc.cc.common.exception.KdXkIprmException;

public class ResourceInfoListProxy {
    public static Map<String, Object> getInfoData(String number) throws KdXkIprmException {
        if (StringUtils.isEmpty((String)number)) {
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a\uff1a\u5185\u5bb9\u5305\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"ResourceInfoListProxy_0", (String)"imsc-cc", (Object[])new Object[0]), 1001);
        }
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("pkgNum", number);
        BizOperationResult bizOperationResult = GcpManager.getDetail(header);
        if (bizOperationResult == null) {
            return new HashMap<String, Object>();
        }
        if (!bizOperationResult.getSuccess()) {
            throw new KdXkIprmException(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a:%s", (String)"ResourceInfoListProxy_1", (String)"imsc-cc", (Object[])new Object[0]), bizOperationResult.getErrorDesc()), 1001);
        }
        Object data = bizOperationResult.getData();
        if (data == null || !(data instanceof Map)) {
            return new HashMap<String, Object>();
        }
        return (Map)data;
    }

    public static Object getPkUrl(String billNo) throws KdXkIprmException {
        if (billNo == null) {
            return null;
        }
        Map<String, Object> dataMap = ResourceInfoListProxy.getInfoData(billNo);
        if (!dataMap.containsKey("pkgFileUrl")) {
            return null;
        }
        return dataMap.get("pkgFileUrl");
    }

    public static Map<String, Object> load(ListSelectedRow content, String attachmentUrl) throws KdXkIprmException {
        if (content == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", content.getPrimaryKeyValue());
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"cc_resourcenew", (String)"id,name,version,billno,entryentity,entryentity.sourcename,entryentity.businessobjecttype", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (dy == null) {
            return params;
        }
        params.put("form_key_attachment", attachmentUrl);
        params.put("form_key_name", dy.getString("name"));
        params.put("form_key_version", dy.getString("version"));
        params.put("form_key_billno", dy.getString("billno"));
        params.put("form_key_entryinfo", ResourceInfoListProxy.getEntryInfo(dy));
        return params;
    }

    private static Map<String, String> getEntryInfo(DynamicObject dy) throws KdXkIprmException {
        HashMap<String, String> billNameMap = new HashMap<String, String>();
        Map<String, Object> dataMap = ResourceInfoListProxy.getInfoData(dy.getString("billno"));
        String packStr = dataMap.getOrDefault("packageInfoContent", "").toString();
        if (!StringUtils.isEmpty((String)packStr)) {
            Map mapData = (Map)SerializationUtils.fromJsonString((String)packStr, Map.class);
            List contentList = (List)mapData.get("files");
            for (Map content : contentList) {
                billNameMap.put(content.get("fileName").toString(), content.get("businessObjectType").toString());
            }
        }
        return billNameMap;
    }
}

