/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.resource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.cc.business.gcpmanage.GcpManager;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;
import kd.imsc.cc.common.exception.KdXkIprmException;
import kd.imsc.cc.common.model.ContentDetailModel;
import kd.imsc.cc.common.model.ContentListModel;
import org.apache.commons.collections.map.HashedMap;

public class ResourceListProxy {
    private static Log LOGGER = LogFactory.getLog(ResourceListProxy.class);

    public static int getResourceCountFromGcp(String adaindustry, String domain, String classification, String supportLang, String country, String searchKey, String collectFiler, String schemeFilter) {
        HashMap<String, Object> header = new HashMap<String, Object>(8);
        header.put("pageIndex", 0);
        header.put("pageSize", 1000);
        header.put("adaindustry", adaindustry);
        header.put("domain", domain);
        header.put("classification", classification);
        header.put("supportlang", supportLang);
        header.put("country", country);
        header.put("collectFilter", collectFiler);
        header.put("isCount", true);
        header.put("search", searchKey);
        header.put("lang", RequestContext.get().getLang());
        header.put("schemeFilter", schemeFilter);
        BizOperationResult bizOperationResult = GcpManager.getList(header);
        if (bizOperationResult == null || !bizOperationResult.getSuccess() || bizOperationResult.getData() == null) {
            return 0;
        }
        List resultData = (List)bizOperationResult.getData();
        if (resultData == null || resultData.isEmpty()) {
            return 0;
        }
        Map resultData1 = (Map)resultData.get(0);
        if (!resultData1.containsKey("totalCount")) {
            return 0;
        }
        return (Integer)resultData1.get("totalCount");
    }

    public static ContentListModel getResourceListFromGcp(int pageIndex, int pageSize, String adaindustry, String domain, String classification, String supportLang, String country, String searchKey, String collectFilter, String schemeFilter) throws KdXkIprmException {
        HashMap<String, Object> header = new HashMap<String, Object>(4);
        header.put("pageIndex", pageIndex);
        header.put("pageSize", pageSize);
        header.put("adaindustry", adaindustry);
        header.put("domain", domain);
        header.put("classification", classification);
        header.put("supportlang", supportLang);
        header.put("country", country);
        header.put("isCount", false);
        header.put("search", searchKey);
        header.put("lang", RequestContext.get().getLang());
        header.put("collectFilter", collectFilter);
        header.put("schemeFilter", schemeFilter);
        BizOperationResult bizOperationResult = GcpManager.getList(header);
        if (bizOperationResult == null || !bizOperationResult.getSuccess()) {
            LOGGER.error("\u4e91\u5185\u5bb9\u5217\u8868\u67e5\u8be2|\u67e5\u8be2\u5931\u8d25|{}", (Object)JSON.toJSONString((Object)bizOperationResult));
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u670d\u52a1\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ResourceListProxy_0", (String)"imsc-iprm-business", (Object[])new Object[0]), 500);
        }
        List resultData = (List)bizOperationResult.getData();
        if (resultData == null || resultData.isEmpty()) {
            LOGGER.info("\u4e91\u5185\u5bb9\u5217\u8868\u67e5\u8be2|\u7ed3\u679c\u4fe1\u606f\u4e3a\u7a7a|{}", (Object)JSON.toJSONString((Object)bizOperationResult));
            return null;
        }
        return (ContentListModel)JSONObject.parseObject((String)JSON.toJSONString(resultData.get(0)), ContentListModel.class);
    }

    public static List<String> getResourceListByNumber(String number) throws KdXkIprmException {
        HashMap<String, Object> header = new HashMap<String, Object>(4);
        header.put("number", number);
        header.put("lang", RequestContext.get().getLang());
        BizOperationResult bizOperationResult = GcpManager.getListByNumber(header);
        if (bizOperationResult == null || !bizOperationResult.getSuccess()) {
            LOGGER.error("\u4e91\u5185\u5bb9\u67e5\u8be2|\u67e5\u8be2\u5931\u8d25|{}", (Object)JSON.toJSONString((Object)bizOperationResult));
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u670d\u52a1\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ResourceListProxy_0", (String)"imsc-iprm-business", (Object[])new Object[0]), 500);
        }
        List resultData = (List)bizOperationResult.getData();
        if (resultData == null || resultData.isEmpty()) {
            LOGGER.info("\u4e91\u5185\u5bb9\u67e5\u8be2|\u7ed3\u679c\u4fe1\u606f\u4e3a\u7a7a|{}", (Object)JSON.toJSONString((Object)bizOperationResult));
            return null;
        }
        return resultData;
    }

    public static Map<String, Integer> getResourceListByClassification(String classification) throws KdXkIprmException {
        HashMap<String, Object> header = new HashMap<String, Object>(4);
        header.put("classification", classification);
        header.put("lang", RequestContext.get().getLang());
        BizOperationResult bizOperationResult = GcpManager.getListByClassification(header);
        if (bizOperationResult == null || !bizOperationResult.getSuccess()) {
            LOGGER.error("\u4e91\u5185\u5bb9\u67e5\u8be2|\u67e5\u8be2\u5931\u8d25|{}", (Object)JSON.toJSONString((Object)bizOperationResult));
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u670d\u52a1\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ResourceListProxy_0", (String)"imsc-iprm-business", (Object[])new Object[0]), 500);
        }
        Map resultData = (Map)bizOperationResult.getData();
        if (resultData == null || resultData.isEmpty()) {
            LOGGER.info("\u4e91\u5185\u5bb9\u67e5\u8be2|\u7ed3\u679c\u4fe1\u606f\u4e3a\u7a7a|{}", (Object)JSON.toJSONString((Object)bizOperationResult));
            return null;
        }
        return resultData;
    }

    public static List<String> getIntegratedServiceList() {
        ArrayList<String> result = new ArrayList<String>(10);
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"ccas_cisconfig", (String)"integratedserviceid", (QFilter[])new QFilter[]{qFilter});
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return result;
        }
        for (DynamicObject dyObj : dynamicObjects) {
            String integratedId = dyObj.getString("integratedserviceid");
            result.add(integratedId);
        }
        return result;
    }

    public static ContentListModel getMyResourceListFromGcp(int pageIndex, int pageSize, String searchKey, List<String> integratedServiceList) throws KdXkIprmException {
        HashMap<String, Object> header = new HashMap<String, Object>(4);
        header.put("pageIndex", pageIndex);
        header.put("pageSize", pageSize);
        header.put("isCount", false);
        header.put("search", searchKey);
        header.put("integratedserviceid", integratedServiceList);
        BizOperationResult bizOperationResult = GcpManager.getMyResourceList(header);
        if (bizOperationResult == null || !bizOperationResult.getSuccess()) {
            LOGGER.error("\u67e5\u8be2\u6211\u7684\u5e94\u7528\u5217\u8868|\u67e5\u8be2\u5931\u8d25\u7ed3\u679c|{}", (Object)JSON.toJSONString((Object)bizOperationResult));
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u670d\u52a1\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ResourceListProxy_0", (String)"imsc-iprm-business", (Object[])new Object[0]), 500);
        }
        ContentListModel listModel = (ContentListModel)JSONObject.parseObject((String)JSON.toJSONString(bizOperationResult.getData()), ContentListModel.class);
        return listModel;
    }

    public static synchronized void updateResourceClassify() {
        HashMap<String, Object> header = new HashMap<String, Object>(2);
        header.put("pageNo", 1);
        header.put("pageSize", 1000);
        header.put("lang", RequestContext.get().getLang());
        BizOperationResult bizOperationResult = GcpManager.getResourceTypeNew(header);
        if (bizOperationResult == null || !bizOperationResult.getSuccess() || bizOperationResult.getData() == null) {
            return;
        }
        Map resultData = (Map)bizOperationResult.getData();
        if (resultData == null || resultData.isEmpty()) {
            return;
        }
        List dataListIndustry = (List)resultData.get("adaindustry");
        List dataListDomain = (List)resultData.get("domain");
        List dataListClassification = (List)resultData.get("classification");
        List dataListSupportLang = (List)resultData.get("supportlang");
        List dataListCountry = (List)resultData.get("country");
        String properties = "id,number,name";
        DynamicObject[] rTypeAll = BusinessDataServiceHelper.load((String)"cc_res_rtype", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "is not null", (Object)"")});
        DynamicObject[] iTypeAll = BusinessDataServiceHelper.load((String)"cc_res_itype", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "is not null", (Object)"")});
        DynamicObject[] tTypeAll = BusinessDataServiceHelper.load((String)"cc_res_ttype", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "is not null", (Object)"")});
        DynamicObject[] supportlangAll = BusinessDataServiceHelper.load((String)"cc_res_supportlang", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "is not null", (Object)"")});
        DynamicObject[] countryAll = BusinessDataServiceHelper.load((String)"cc_res_country", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "is not null", (Object)"")});
        ResourceListProxy.saveClassify(rTypeAll, dataListIndustry, 1);
        ResourceListProxy.saveClassify(iTypeAll, dataListDomain, 2);
        ResourceListProxy.saveClassify(tTypeAll, dataListClassification, 3);
        ResourceListProxy.saveClassify(supportlangAll, dataListSupportLang, 4);
        ResourceListProxy.saveClassify(countryAll, dataListCountry, 5);
    }

    private static void saveClassify(DynamicObject[] localDataAll, List<Map<String, Object>> gcpDataList, int intLevel) {
        if (localDataAll == null) {
            localDataAll = new DynamicObject[]{};
        }
        ArrayList<DynamicObject> lstObjectNew = new ArrayList<DynamicObject>();
        for (Map<String, Object> map : gcpDataList) {
            Object gcpName;
            DynamicObject localData;
            OrmLocaleValue objName;
            int blnIfExist = 0;
            List listByFilter = Arrays.stream(localDataAll).filter(t -> t.get("number").equals(map.get("number"))).collect(Collectors.toList());
            if (listByFilter.size() > 0 && ResourceListProxy.ifSameNameItem(objName = (OrmLocaleValue)(localData = (DynamicObject)listByFilter.get(0)).get("name"), gcpName = map.get("name"))) {
                blnIfExist = 1;
            }
            if (blnIfExist != 0) continue;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)(intLevel == 1 ? "cc_res_rtype" : (intLevel == 2 ? "cc_res_itype" : (intLevel == 3 ? "cc_res_ttype" : (intLevel == 4 ? "cc_res_supportlang" : "cc_res_country")))));
            dynamicObject.set("number", map.get("number"));
            dynamicObject.set("enable", (Object)1);
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("name", map.get("name"));
            lstObjectNew.add(dynamicObject);
        }
        if (!lstObjectNew.isEmpty()) {
            DynamicObject[] objectArr = new DynamicObject[lstObjectNew.size()];
            lstObjectNew.toArray(objectArr);
            DynamicObject[] dynamicObjectArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objectArr);
        }
        ArrayList<Object> lstIdDel = new ArrayList<Object>();
        for (DynamicObject localData : localDataAll) {
            boolean blnIfExist = false;
            List listByFilter = gcpDataList.stream().filter(t -> t.get("number").equals(localData.get("number"))).collect(Collectors.toList());
            if (listByFilter.size() > 0) {
                Object gcpName;
                Map gcpData = (Map)listByFilter.get(0);
                OrmLocaleValue objName = (OrmLocaleValue)localData.get("name");
                if (ResourceListProxy.ifSameNameItem(objName, gcpName = gcpData.get("name"))) {
                    blnIfExist = true;
                }
            }
            if (blnIfExist) continue;
            lstIdDel.add(localData.get("id"));
        }
        if (lstIdDel.size() > 0) {
            Object[] objectArray = new Object[lstIdDel.size()];
            lstIdDel.toArray(objectArray);
            IDataEntityType type = localDataAll[0].getDataEntityType();
            DeleteServiceHelper.delete((IDataEntityType)type, (Object[])objectArray);
        }
    }

    private static boolean ifSameNameItem(OrmLocaleValue objName, Object gcpName) {
        if (StringUtils.isBlank((Object)objName) || objName.size() == 0) {
            return false;
        }
        return objName.toString().equals(gcpName);
    }

    public static Map<String, Object> getLoadParam(Map<String, Object> dataMap) {
        Map mapData;
        List contentList;
        HashMap<String, Object> prams = new HashMap<String, Object>();
        if (dataMap == null) {
            return prams;
        }
        prams.put("form_key_attachment", dataMap.get("pkgFileUrl"));
        prams.put("form_key_name", dataMap.get("pkgName"));
        prams.put("form_key_version", dataMap.get("version"));
        prams.put("form_key_billno", dataMap.get("pkgNumber"));
        HashMap billNameMap = new HashMap();
        String packStr = dataMap.getOrDefault("packageInfoContent", "").toString();
        if (!kd.bos.util.StringUtils.isEmpty((String)packStr) && (contentList = (List)(mapData = (Map)SerializationUtils.fromJsonString((String)packStr, Map.class)).get("files")) != null) {
            for (Map content : contentList) {
                billNameMap.put(content.get("fileName"), content.get("businessObjectType"));
            }
        }
        prams.put("form_key_entryinfo", billNameMap);
        return prams;
    }

    public static Map<String, Object> getLoadParam(String name, String version, String billNo, List<Map<String, String>> contentList) {
        HashMap<String, Object> prams = new HashMap<String, Object>(4);
        prams.put("form_key_name", name);
        prams.put("form_key_version", version);
        prams.put("form_key_billno", billNo);
        HashMap<String, String> billNameMap = new HashMap<String, String>(4);
        if (contentList != null) {
            for (Map<String, String> content : contentList) {
                billNameMap.put(content.get("fileName"), content.get("businessObjectType"));
                billNameMap.put("dataencrypt", content.get("dataencrypt"));
            }
        }
        prams.put("form_key_entryinfo", billNameMap);
        return prams;
    }

    public static String downloadFile(String number) {
        BizOperationResult bizOperationResult;
        HashMap<String, Object> header = new HashMap<String, Object>(4);
        header.put("number", number);
        header.put("tenantId", RequestContext.get().getTenantId());
        header.put("tenantCode", RequestContext.get().getTenantCode());
        header.put("accouontId", RequestContext.get().getAccountId());
        header.put("lang", RequestContext.get().getLang());
        header.put("accountType", "");
        List productInfos = LicenseServiceHelper.getProductInfos();
        if (CollectionUtils.isNotEmpty((Collection)productInfos)) {
            for (Map prodInfo : productInfos) {
                if (!kd.bos.util.StringUtils.isNotEmpty((String)((String)prodInfo.get("softwareCode")))) continue;
                header.put("softwarecode", prodInfo.get("softwareCode"));
            }
        }
        if ((bizOperationResult = GcpManager.downloadFile(header)) == null || !bizOperationResult.getSuccess() || bizOperationResult.getData() == null) {
            return null;
        }
        JSONObject resultData = (JSONObject)bizOperationResult.getData();
        if (resultData == null || resultData.isEmpty()) {
            return null;
        }
        return (String)resultData.get((Object)"url");
    }

    public static synchronized void updateResourceType() {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("pageNo", 1);
        header.put("pageSize", 1000);
        BizOperationResult bizOperationResult = GcpManager.getResourceType(header);
        if (bizOperationResult == null || !bizOperationResult.getSuccess() || bizOperationResult.getData() == null) {
            return;
        }
        Map resultData = (Map)bizOperationResult.getData();
        if (resultData == null || resultData.isEmpty()) {
            return;
        }
        List dataList = (List)resultData.get("rows");
        QFilter qFilter = new QFilter("rtype", "=", (Object)0);
        DeleteServiceHelper.delete((String)"cc_res_ttype", (QFilter[])new QFilter[]{qFilter});
        String properties = "id,number,name";
        DynamicObject[] rTypeAll = BusinessDataServiceHelper.load((String)"cc_res_rtype", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "is not null", (Object)"")});
        DynamicObject[] iTypeAll = BusinessDataServiceHelper.load((String)"cc_res_itype", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "is not null", (Object)"")});
        DynamicObject[] tTypeAll = BusinessDataServiceHelper.load((String)"cc_res_ttype", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "is not null", (Object)"")});
        Map<Object, Object> mapLevel1 = ResourceListProxy.saveTypeNew(rTypeAll, dataList, 1, null, null);
        Map<Object, Object> mapLevel2 = ResourceListProxy.saveTypeNew(iTypeAll, dataList, 2, mapLevel1, null);
        ResourceListProxy.saveTypeNew(tTypeAll, dataList, 3, mapLevel1, mapLevel2);
    }

    private static Map<Object, Object> saveTypeNew(DynamicObject[] localDataAll, List<Map<String, Object>> gcpDataList, int intLevel, Map<Object, Object> mapLevel1, Map<Object, Object> mapLevel2) {
        if (localDataAll == null) {
            localDataAll = new DynamicObject[]{};
        }
        List gcpDataListByLevel = gcpDataList.stream().filter(t -> t.get("level").equals(intLevel)).collect(Collectors.toList());
        ArrayList<DynamicObject> lstObjectNew = new ArrayList<DynamicObject>();
        for (Map gcpData : gcpDataListByLevel) {
            DynamicObject localData;
            OrmLocaleValue objName;
            boolean blnIfExist = false;
            DynamicObject[] listByFilter = Arrays.stream(localDataAll).filter(t -> t.get("number").equals(gcpData.get("number"))).collect(Collectors.toList());
            if (listByFilter.size() > 0 && (objName = (OrmLocaleValue)(localData = (DynamicObject)listByFilter.get(0)).get("name")).getLocaleValue().equals(gcpData.get("name"))) {
                blnIfExist = true;
            }
            if (blnIfExist) continue;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)(intLevel == 1 ? "cc_res_rtype" : (intLevel == 2 ? "cc_res_itype" : "cc_res_ttype")));
            dynamicObject.set("number", gcpData.get("number"));
            dynamicObject.set("enable", (Object)1);
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("name", gcpData.get("name"));
            Object parent_number = gcpData.get("parent_number");
            if (intLevel == 2 && mapLevel1 != null && mapLevel1.containsKey(parent_number)) {
                dynamicObject.set("rtype", mapLevel1.get(parent_number));
            }
            if (intLevel == 3) {
                String level1Number;
                String long_number;
                if (mapLevel2 != null && mapLevel2.containsKey(parent_number)) {
                    dynamicObject.set("itype", mapLevel2.get(parent_number));
                }
                if (!kd.bos.util.StringUtils.isEmpty((String)(long_number = gcpData.get("longnumber").toString())) && mapLevel1.containsKey(level1Number = long_number.split("\\.")[0])) {
                    dynamicObject.set("rtype", mapLevel1.get(level1Number));
                }
            }
            lstObjectNew.add(dynamicObject);
        }
        HashedMap mapResult = new HashedMap();
        if (lstObjectNew.size() > 0) {
            DynamicObject[] saveResult;
            DynamicObject[] objectArr = new DynamicObject[lstObjectNew.size()];
            lstObjectNew.toArray(objectArr);
            for (DynamicObject dynamicObject : saveResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objectArr)) {
                mapResult.put(dynamicObject.get("number"), dynamicObject.get("id"));
            }
        }
        for (DynamicObject dynamicObject : localDataAll) {
            if (mapResult.containsKey(dynamicObject.get("number"))) continue;
            mapResult.put(dynamicObject.get("number"), dynamicObject.get("id"));
        }
        ArrayList<Object> lstIdDel = new ArrayList<Object>();
        for (DynamicObject localData : localDataAll) {
            boolean blnIfExist = false;
            List listByFilter = gcpDataListByLevel.stream().filter(t -> t.get("number").equals(localData.get("number"))).collect(Collectors.toList());
            if (listByFilter.size() > 0) {
                Map gcpData = (Map)listByFilter.get(0);
                OrmLocaleValue objName = (OrmLocaleValue)localData.get("name");
                if (objName.getLocaleValue().equals(gcpData.get("name"))) {
                    blnIfExist = true;
                }
            }
            if (blnIfExist) continue;
            lstIdDel.add(localData.get("id"));
        }
        if (lstIdDel.size() > 0) {
            Object[] objectArr = new Object[lstIdDel.size()];
            lstIdDel.toArray(objectArr);
            IDataEntityType type = localDataAll[0].getDataEntityType();
            DeleteServiceHelper.delete((IDataEntityType)type, (Object[])objectArr);
        }
        return mapResult;
    }

    public static String getAppLiOutSideChainByCache(String billNo, String pageCacheStr) {
        if (kd.bos.util.StringUtils.isEmpty((String)billNo) || kd.bos.util.StringUtils.isEmpty((String)pageCacheStr)) {
            return "";
        }
        JSONObject cacheObj = JSON.parseObject((String)pageCacheStr);
        JSONObject rowObj = cacheObj.getJSONObject(billNo);
        if (null == rowObj) {
            return "";
        }
        return rowObj.getString("applioutsidechain");
    }

    public static Map<String, Object> getLoadParamWithModel(ContentDetailModel dataMap) {
        Map mapData;
        List contentList;
        HashMap<String, Object> prams = new HashMap<String, Object>();
        if (dataMap == null) {
            return prams;
        }
        prams.put("form_key_name", dataMap.getPkgName());
        prams.put("form_key_version", dataMap.getVersion());
        prams.put("form_key_billno", dataMap.getPkgNumber());
        HashMap billNameMap = new HashMap();
        String packStr = dataMap.getpInfoContent();
        if (!kd.bos.util.StringUtils.isEmpty((String)packStr) && (contentList = (List)(mapData = (Map)SerializationUtils.fromJsonString((String)packStr, Map.class)).get("files")) != null) {
            for (Map content : contentList) {
                billNameMap.put(content.get("fileName"), content.get("businessObjectType"));
            }
        }
        prams.put("form_key_entryinfo", billNameMap);
        return prams;
    }
}

