/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.utils;

import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SessionManager;
import kd.imsc.cc.common.utils.CommonUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ResourceInfoUtil {
    private static final int MULTIPLE_VALUE_MAX = 9;
    private static final int SINGLE_VALUE_MAX = 6;
    private static final String BASE64_HEADER = "data:image/png;base64,";

    public static Object getIndustry(Object industryObj, boolean isSubstring) {
        List industries;
        Object industry = industryObj instanceof List ? ((industries = (List)industryObj).isEmpty() ? "" : industries.get(0)) : industryObj;
        if (!isSubstring) {
            return industry;
        }
        return ResourceInfoUtil.subStr(industry);
    }

    public static Object getDomainFromList(List<String> list) {
        if (list != null) {
            if (list.size() > 3) {
                return list.subList(0, 3).stream().filter(s -> !s.trim().isEmpty()).map(String::valueOf).collect(Collectors.joining(",")) + "...";
            }
            return list.stream().filter(s -> !s.trim().isEmpty()).map(String::valueOf).collect(Collectors.joining(","));
        }
        return null;
    }

    public static Object getDomain(Object o, boolean isSubstring) {
        if (o instanceof List) {
            List list = (List)o;
            String str = list.stream().filter(s -> !s.trim().isEmpty()).map(String::valueOf).collect(Collectors.joining(","));
            if (!isSubstring) {
                return str;
            }
            if (str.length() > 9) {
                str = str.substring(0, 9) + "...";
            }
            return str;
        }
        return null;
    }

    public static Object getClassification(Object classification, boolean isSubstring) {
        if (!isSubstring) {
            return classification;
        }
        return ResourceInfoUtil.subStr(classification);
    }

    private static Object subStr(Object value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return value;
        }
        String s = value.toString();
        if (s.length() > 6) {
            s = s.substring(0, 6) + "...";
        }
        return s;
    }

    public static String convertFromBase64Image(String detail) {
        if (StringUtils.isEmpty((CharSequence)detail)) {
            return null;
        }
        Document doc = Jsoup.parse((String)detail, (String)"UTF-8");
        Elements select = doc.select("body").select("p");
        for (Element element : select) {
            String text = element.text();
            Elements children = element.children();
            if (!"".equals(text) || children != null && !children.isEmpty()) continue;
            element.getAllElements().remove();
        }
        Elements images = doc.getElementsByTag("img");
        for (Element img : images) {
            String base64Data = img.attr("src");
            if (!base64Data.startsWith(BASE64_HEADER)) continue;
            base64Data = base64Data.substring(StringUtils.length((CharSequence)BASE64_HEADER));
            String url = ResourceInfoUtil.getUrlByImageBase64(base64Data);
            img.attr("src", url);
        }
        return doc.outerHtml();
    }

    private static String getUrlByImageBase64(String base64Data) {
        Base64.Decoder decoder = Base64.getDecoder();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String fullUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(uuid + ".jpg", decoder.decode(base64Data), 300);
        RequestContext requestContext = RequestContext.get();
        if (requestContext == null) {
            return "";
        }
        return fullUrl + "&kd_cs_ticket=" + SessionManager.getCSRFTokenValue((String)requestContext.getGlobalSessionId());
    }

    public static String getManyExpense(String lang) {
        DynamicObject[] languageRelations;
        List<DynamicObject> langRelationList;
        Map<String, String> customlanMap;
        String relationlang;
        if (StringUtils.isNotBlank((CharSequence)lang) && lang.contains("-")) {
            lang = lang.replace("-", "_");
        }
        if (StringUtils.isNotBlank((CharSequence)(relationlang = CommonUtils.getValueIgnoreCase(customlanMap = (langRelationList = Arrays.asList(languageRelations = BusinessDataServiceHelper.load((String)"inte_language_relation", (String)"standardlan,customlan", (QFilter[])new QFilter[0]))).stream().collect(Collectors.toMap(e -> e.getString("customlan"), e -> e.getString("standardlan"))), lang)))) {
            lang = relationlang;
        }
        return lang;
    }
}

