/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.common.log;

import kd.bos.util.StringUtils;
import kd.imsc.cc.common.log.AbstractLogRecord;
import kd.imsc.cc.common.utils.CommonUtils;

public class LogRecordBuilder
extends AbstractLogRecord {
    private static final long serialVersionUID = -5528233108127311614L;
    private StringBuilder message = new StringBuilder();
    private StringBuilder devMessage = new StringBuilder();
    private String entryLogs;

    public String getEntryLogs() {
        return this.entryLogs;
    }

    public void setEntryLogs(String entryLogs) {
        this.entryLogs = entryLogs;
    }

    @Override
    public LogRecordBuilder append(String errorMsg) {
        this.message.append(errorMsg);
        return this;
    }

    @Override
    public LogRecordBuilder insert(int pos, String str) {
        this.message.insert(pos, str);
        return this;
    }

    @Override
    public LogRecordBuilder append(Object obj) {
        this.message.append(String.valueOf(obj));
        return this;
    }

    public LogRecordBuilder append(StringBuilder obj) {
        this.message.append((CharSequence)obj);
        return this;
    }

    @Override
    public AbstractLogRecord appendDev(String devErrorMsg) {
        this.devMessage.append(devErrorMsg);
        return this;
    }

    public StringBuilder getMessage() {
        return this.message;
    }

    public StringBuilder getDevMessage() {
        return this.devMessage;
    }

    @Override
    public String getMessageStr() {
        return this.message.toString();
    }

    @Override
    public String getDevMessageStr() {
        return this.devMessage.toString();
    }

    public void setMessage(StringBuilder message) {
        this.message = message;
    }

    public void setMessage(String message) {
        this.message.append(message);
    }

    public void setDevMessage(StringBuilder devMessage) {
        this.devMessage = devMessage;
    }

    public void setDevMessage(String devMessage) {
        this.devMessage.append(devMessage);
    }

    @Override
    public LogRecordBuilder append(String errorMsg, Throwable exception) {
        this.message.append(errorMsg);
        if (exception != null) {
            if (exception.getMessage() != null) {
                this.message.append(exception.getMessage());
            }
            this.devMessage.append(errorMsg).append(CommonUtils.getExceptionDetailInfo(exception));
        }
        return this;
    }

    @Override
    public LogRecordBuilder append(String errorMsg, String devErrorMsg) {
        this.message.append(errorMsg);
        if (StringUtils.isNotEmpty((String)devErrorMsg)) {
            this.devMessage.append(errorMsg).append(devErrorMsg);
        }
        return this;
    }

    public int length() {
        return this.message.length();
    }
}

