/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;

public class CommonUtils {
    private CommonUtils() {
        throw new IllegalStateException("Utikity class");
    }

    public static String checkUrl(String url) {
        if (!StringUtils.isEmpty((CharSequence)url) && url.contains("path=")) {
            url = url.split("path=")[1];
        }
        return url;
    }

    public static String getExceptionDetailInfo(Throwable exception) {
        String retMsg;
        if (exception == null) {
            return "exception is null";
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            exception.printStackTrace(pw);
            pw.flush();
            sw.flush();
            retMsg = sw.toString();
        }
        catch (IOException e) {
            String msgTpl = ResManager.loadKDString((String)"\u5f02\u5e38\u89e3\u6790\u5931\u8d25\u3002%s\u3002", (String)"CommonUtils_0", (String)"imsc-cc", (Object[])new Object[0]);
            retMsg = String.format(msgTpl, e.getMessage());
        }
        return retMsg;
    }

    public static String getUsedTime(long startTime, long completeTime) {
        if (startTime > completeTime || completeTime <= 0L) {
            return String.format(ResManager.loadKDString((String)"%d\u6beb\u79d2", (String)"CommonUtils_1", (String)"imsc-cc", (Object[])new Object[0]), 1);
        }
        return CommonUtils.getUsedTimeStringByUsedTime(completeTime - startTime);
    }

    public static String getUsedTimeStringByUsedTime(long useTime) {
        if (useTime <= 0L) {
            useTime = 1L;
        }
        long days = useTime / 86400000L;
        long remain = useTime % 86400000L;
        long hours = remain / 3600000L;
        long minutes = (remain %= 3600000L) / 60000L;
        long seconds = (remain %= 60000L) / 1000L;
        long millis = remain % 1000L;
        if (hours > 0L) {
            return String.format(ResManager.loadKDString((String)"%1$d\u5c0f\u65f6%2$d\u5206%3$d\u79d2%4$d\u6beb\u79d2", (String)"CommonUtils_2", (String)"imsc-cc", (Object[])new Object[0]), days * 24L + hours, minutes, seconds, millis);
        }
        if (minutes > 0L) {
            return String.format(ResManager.loadKDString((String)"%1$d\u5206%2$d\u79d2%3$d\u6beb\u79d2", (String)"CommonUtils_3", (String)"imsc-cc", (Object[])new Object[0]), minutes, seconds, millis);
        }
        if (seconds > 0L) {
            return String.format(ResManager.loadKDString((String)"%1$d\u79d2%2$d\u6beb\u79d2", (String)"CommonUtils_4", (String)"imsc-cc", (Object[])new Object[0]), seconds, millis);
        }
        if (millis > 0L) {
            return String.format(ResManager.loadKDString((String)"%d\u6beb\u79d2", (String)"CommonUtils_1", (String)"imsc-cc", (Object[])new Object[0]), millis);
        }
        return String.format(ResManager.loadKDString((String)"%d\u6beb\u79d2", (String)"CommonUtils_1", (String)"imsc-cc", (Object[])new Object[0]), 1);
    }

    public static boolean isNumeric(String str) {
        try {
            String string = new BigDecimal(str).toString();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static <V> V getValueIgnoreCase(Map<String, V> map, String keyIgnoreCase) {
        if (map == null || keyIgnoreCase == null) {
            return null;
        }
        String lowerCaseKey = keyIgnoreCase.toLowerCase();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            if (!entry.getKey().toLowerCase().equals(lowerCaseKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static LocaleString getLocaleStringFromMap(JSONObject strMap) {
        LocaleString result = new LocaleString();
        for (Map.Entry entry : strMap.entrySet()) {
            result.put((String)entry.getKey(), (Object)entry.getValue().toString());
        }
        return result;
    }
}

