/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.common.utils;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtils {
    private static final Log logger = LogFactory.getLog(OkHttpUtils.class);
    private static final int CONNECTION_TIMEOUT = 3;
    private static final int READ_TIMEOUT = 60;
    private static final int WRITE_TIMEOUT = 60;

    public static String getRequest(String url) throws IOException {
        return OkHttpUtils.getRequest(url, 3, 60, 60);
    }

    public static String getRequest(String url, int connectTime, int readTime, int writeTime) throws IOException {
        OkHttpClient client = OkHttpUtils.createOkHttpClient(connectTime, readTime, writeTime);
        Request request = new Request.Builder().get().url(url).build();
        try (Response response = client.newCall(request).execute();){
            logger.info("url {} response code {}", (Object)url, (Object)response.code());
            if (!response.isSuccessful()) {
                throw new IOException("response is unSuccessful" + response.code());
            }
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }

    public static String postJsonRequest(String url, Map<String, String> header, String jsonBody) throws IOException {
        return OkHttpUtils.postJsonRequest(url, header, jsonBody, 3, 60, 60);
    }

    public static String postJsonRequest(String url, Map<String, String> header, String jsonBody, int connectTime, int readTime, int writeTime) throws IOException {
        OkHttpClient client = OkHttpUtils.createOkHttpClient(connectTime, readTime, writeTime);
        RequestBody body = RequestBody.create((String)jsonBody, null);
        Request.Builder builder = new Request.Builder();
        OkHttpUtils.setHeaders(header, builder);
        Request request = builder.post(body).addHeader("Content-Type", "application/json").url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (response == null) {
                throw new IOException("response is null!");
            }
            logger.info("url {} response code {}", (Object)url, (Object)response.code());
            if (!response.isSuccessful()) {
                throw new IOException("response is unSuccessful" + response.code());
            }
            String string = response.body().string();
            return string;
        }
    }

    private static OkHttpClient createOkHttpClient(int connectTime, int readTime, int writeTime) {
        return new OkHttpClient.Builder().connectTimeout((long)connectTime, TimeUnit.SECONDS).readTimeout((long)readTime, TimeUnit.SECONDS).writeTimeout((long)writeTime, TimeUnit.SECONDS).connectionPool(new ConnectionPool(0, 1L, TimeUnit.NANOSECONDS)).build();
    }

    private static void setHeaders(Map<String, String> headerMap, Request.Builder builder) {
        if (headerMap == null || headerMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : headerMap.entrySet()) {
            builder.addHeader(header.getKey(), header.getValue());
        }
    }
}

