/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import java.sql.Timestamp;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.imsc.cc.common.utils.CommonUtils;

public class InstallLogPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(InstallLogPlugin.class);
    private static final String START_TIME = "starttime";
    private static final String END_TIME = "endtime";
    private static final String DURATION = "duration";
    private static final String SUB_INSTALL_ENTRY = "sub_install_entry";
    private static final String SUB_DURATION = "subduration";
    private static final String SUB_NAME = "subname";
    private static final String SUB_OBJ = "subobj";

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void afterBindData(EventObject e) {
        long startTime = ((Timestamp)this.getModel().getValue(START_TIME)).getTime();
        long endTime = ((Timestamp)this.getModel().getValue(END_TIME)).getTime();
        this.getModel().setValue(DURATION, (Object)CommonUtils.getUsedTime(startTime, endTime));
        this.initEntry();
    }

    private void initEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SUB_INSTALL_ENTRY);
        if (null == entryEntity || entryEntity.isEmpty()) {
            return;
        }
        for (DynamicObject dynamicObject : entryEntity) {
            String subduration = dynamicObject.getString(SUB_DURATION);
            if (CommonUtils.isNumeric(subduration)) {
                dynamicObject.set(SUB_DURATION, (Object)CommonUtils.getUsedTimeStringByUsedTime(Long.parseLong(subduration)));
            }
            try {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)dynamicObject.getString(SUB_NAME));
                if (null == dataEntityType) {
                    logger.error("\u5185\u5bb9\u5305\u52a0\u8f7d\u65e5\u5fd7\u8be6\u60c5\u67e5\u8be2|\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0\u591a\u8bed\u8a00\u7ffb\u8bd1\u9519\u8bef|\u7ed3\u679c\u4e3a\u7a7a");
                    continue;
                }
                String businessName = dataEntityType.getDisplayName().toString();
                dynamicObject.set(SUB_OBJ, (Object)businessName);
            }
            catch (Exception e) {
                logger.error("\u5185\u5bb9\u5305\u52a0\u8f7d\u65e5\u5fd7\u8be6\u60c5\u67e5\u8be2|\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0\u591a\u8bed\u8a00\u7ffb\u8bd1\u9519\u8bef|", (Throwable)e);
            }
        }
        this.getView().updateView(SUB_INSTALL_ENTRY);
    }
}

