/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.imsc.cc.business.helper.installprogress.InstallProgressHelper;
import kd.imsc.cc.common.entity.InstallFeedbackResult;

public class InstallProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(InstallProgressPlugin.class);
    private static final String TITLE = "title";
    private static final String PROGRESSBAR = "progressbar";
    private static final String TOTAL_COUNT = "totalcount";
    private static final String SUCCESS_COUNT = "successcount";
    private static final String PART_SUCCESS_COUNT = "partsuccesscount";
    private static final String WAIT_COUNT = "waitcount";
    private static final String SUCCESS_FLEX = "successflexpanelap";
    private static final String NO_SUCCESS_FLEX = "nosuccessflexpanelap";
    private static final String REASON_FLEX = "reasonflexpanelap";
    private static final String LOG_FLEX = "logflexpanelap";
    private static final String PROGRESS_LAB = "progress";
    private static final String BTN_STOP = "btnstop";
    private static final String BTN_CLOSE = "btnclose";
    private static final String IS_START_KEY = "is_start";
    private static final String IS_FINISH_KEY = "is_finish";
    private static final String CACHE_KEY_TASK_ID = "cache_key_task_id";
    private static final String CALL_BACK_CONTINUE_STOP = "continue_stop";
    private static final String OPERATION_OPRNEXCEPTIONHELP = "openexceptionhelp";
    private boolean canClose = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTN_STOP, BTN_CLOSE});
    }

    public void onProgress(ProgressEvent e) {
        String importServiceId = this.getInstallServiceId();
        boolean start = this.isStart();
        this.getPageCache().put(IS_START_KEY, String.valueOf(true));
        if (!start && StringUtils.isEmpty((CharSequence)importServiceId)) {
            this.dispatchTask();
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)importServiceId)) {
            this.updateTaskProgress(e);
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CLOSE, SUCCESS_FLEX, NO_SUCCESS_FLEX, REASON_FLEX, LOG_FLEX});
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBAR);
        bar.start();
    }

    public void click(EventObject e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_STOP)) {
            this.clickStop();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_CLOSE)) {
            this.closeForm();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getCallBackId().equals(CALL_BACK_CONTINUE_STOP) && MessageBoxResult.Yes == evt.getResult()) {
            this.doStop();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!this.canClose || !this.isFinished()) {
            e.setCancel(true);
            this.clickStop();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (OPERATION_OPRNEXCEPTIONHELP.equals(args.getOperateKey())) {
            this.getView().openUrl("https://vip.kingdee.com/article/610901661695043840");
        }
    }

    private void clickStop() {
        if (this.isFinished()) {
            this.closeForm();
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALL_BACK_CONTINUE_STOP, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u6267\u884c", (String)"InstallProgressPlugin_0", (String)"imsc-cc-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62\u6267\u884c", (String)"InstallProgressPlugin_1", (String)"imsc-cc-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u7ec8\u6b62\u6267\u884c\uff1f", (String)"InstallProgressPlugin_2", (String)"imsc-cc-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    private void doStop() {
        logger.info("\u52a0\u8f7d\u5185\u5bb9\u5305|\u7ec8\u6b62\u52a0\u8f7d\u4efb\u52a1");
        String taskId = this.getInstallServiceId();
        InstallProgressHelper.stopTaskById(taskId);
    }

    private void closeForm() {
        this.canClose = true;
        this.returnResult();
        this.getView().close();
    }

    private void returnResult() {
        String feedBackCache = this.getFeedBackCache();
        this.getView().returnDataToParent((Object)feedBackCache);
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
            jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
        }
        this.getPageCache().put(CACHE_KEY_TASK_ID, ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo()));
    }

    private boolean isStart() {
        String start = this.getPageCache().get(IS_START_KEY);
        return !StringUtils.isBlank((CharSequence)start) && Boolean.parseBoolean(start);
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(IS_FINISH_KEY);
        return !StringUtils.isBlank((CharSequence)finished) && Boolean.parseBoolean(finished);
    }

    private String getInstallServiceId() {
        return this.getPageCache().get(CACHE_KEY_TASK_ID);
    }

    private JobFormInfo getJobFormInfo() {
        String jobStr = (String)this.getView().getFormShowParameter().getCustomParam("install_job_info");
        if (StringUtils.isEmpty((CharSequence)jobStr)) {
            this.getView().close();
            throw new KDException(new ErrorCode("100021", ResManager.loadKDString((String)"\u65e0\u6267\u884c\u4efb\u52a1\u4fe1\u606f", (String)"InstallProgressPlugin_3", (String)"imsc-cc-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)jobStr, JobFormInfo.class);
    }

    private void setTitleInfo(String desc) {
        Label lblDesc = (Label)this.getControl(TITLE);
        lblDesc.setText(desc);
        this.getView().updateView(TITLE);
    }

    private void setProgressValue(int progress) {
        ((Label)this.getView().getControl(PROGRESS_LAB)).setText(String.format("%d", progress) + "%");
    }

    private void updateTaskProgress(ProgressEvent e) {
        String serviceId = this.getInstallServiceId();
        InstallFeedbackResult result = InstallProgressHelper.getImportResultByTaskId(serviceId);
        if (null == result) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"BEGIN", (CharSequence)result.getStatus())) {
            this.setProgressValue(result.getProgress() >= 100 ? 99 : result.getProgress());
            e.setProgress(result.getProgress() >= 100 ? 99 : result.getProgress());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)result.getStatus()) || StringUtils.equalsIgnoreCase((CharSequence)"COMPLETED", (CharSequence)result.getStatus())) {
            this.getPageCache().put(IS_FINISH_KEY, String.valueOf(true));
            this.setProgressValue(100);
            e.setProgress(100);
            this.setTitleInfo(ResManager.loadKDString((String)"\u52a0\u8f7d\u5b8c\u6210", (String)"InstallProgressPlugin_4", (String)"imsc-cc-formplugin", (Object[])new Object[0]));
            this.setFeedBackCache(result);
            this.setLabelValue(TOTAL_COUNT, String.format(ResManager.loadKDString((String)"\u5171\u52a0\u8f7d%d\u4e2a\u4e1a\u52a1\u5bf9\u8c61\uff1a", (String)"InstallProgressPlugin_5", (String)"imsc-cc-formplugin", (Object[])new Object[0]), result.getTotalTaskNum()));
            this.setLabelValue(SUCCESS_COUNT, result.getSuccessTaskNum());
            this.setLabelValue(PART_SUCCESS_COUNT, result.getPartSuccessTaskNum());
            this.setLabelValue("failcount", result.getFailTaskNum());
            int waitTaskNum = result.getTotalTaskNum() - result.getSuccessTaskNum() - result.getPartSuccessTaskNum() - result.getFailTaskNum();
            this.setLabelValue(WAIT_COUNT, waitTaskNum);
            if (result.getTotalTaskNum() == result.getSuccessTaskNum()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE, SUCCESS_FLEX});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE, SUCCESS_FLEX, NO_SUCCESS_FLEX, REASON_FLEX, LOG_FLEX});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_STOP});
            if (!StringUtils.isBlank((CharSequence)result.getErrMsg())) {
                this.getView().showErrorNotification(result.getErrMsg());
            }
        }
    }

    private void setLabelValue(String key, Object value) {
        Label label = (Label)this.getView().getControl(key);
        label.setText(String.valueOf(value));
    }

    private void setFeedBackCache(InstallFeedbackResult feedbackResult) {
        if (null == feedbackResult) {
            return;
        }
        this.getPageCache().put("installFeedbackResult", JSON.toJSONString((Object)feedbackResult));
    }

    private String getFeedBackCache() {
        return this.getPageCache().get("installFeedbackResult");
    }
}

