/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.service.bo.Version;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.cc.business.gcpmanage.GcpManager;
import kd.imsc.cc.business.helper.FormOpenHelper;
import kd.imsc.cc.business.helper.LoadPackageHelper;
import kd.imsc.cc.business.helper.installprogress.InstallProgressHelper;
import kd.imsc.cc.business.helper.installprogress.InstallProgressServiceTaskImpl;
import kd.imsc.cc.business.install.IDataPackageInstallListener;
import kd.imsc.cc.business.iprm.IprmHelper;
import kd.imsc.cc.business.proxy.DataPackageInstallerProxy;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;
import kd.imsc.cc.common.entity.DataPackageInputModel;
import kd.imsc.cc.common.entity.DataPackageModifyConfig;
import kd.imsc.cc.common.entity.DataPackageModifyResult;
import kd.imsc.cc.common.entity.InstallFailResult;
import kd.imsc.cc.common.entity.InstallFeedbackResult;
import kd.imsc.cc.common.entity.InstallFinishResult;
import kd.imsc.cc.common.entity.InstallSubDataResult;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import kd.imsc.cc.common.model.ContentDetailModel;
import kd.imsc.cc.common.utils.ContentHelper;
import kd.imsc.cc.formplugin.NewResourcePlugin;

public class LoadPackagePlugin
extends AbstractFormPlugin
implements IDataPackageInstallListener,
RowClickEventListener,
ProgresssListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(LoadPackagePlugin.class);
    private static final String BTN_INSTALL = "btninstall";
    private static final String BTN_CANCEL = "btncancel";
    private static final String CONTROL_ENTRYENTITY = "entryentity";
    private static final String CONTROL_ROW_OPERATIONCOLUMNAP = "operationcolumnap";
    private static final String ENTRY_FIELD_SOURCE_OBJECT = "sourceobject";
    private static final String ENTRY_FIELD_SOURCE_NAME = "sourcename";
    private static final String ENTRY_FIELD_BILLNAME = "billname";
    private static final String ENTRY_FIELD_BUSINESSOBJECTTYPE = "businessobjecttype";
    private static final String ENTRY_FIELD_CHECK_RESULT = "checkresult";
    private static final String ENTRY_FIELD_REPLACE_MAP = "replacemap";
    private static final String ENTRY_FIELD_SELECTEDDATA = "selecteddata";
    private static final String ENTRY_FIELD_INSTALL_RESULT = "installresult";
    private static final String ENTRY_FIELD_OBJECT_ROAD = "objectroad";
    private static final String ENTRY_FIELD_INSTALLFORMID = "installformid";
    private static final String ENTRY_FIELD_INSTALLLOGID = "installlogid";
    private static final String ENTRY_FIELD_OPEN = "open";
    private static final String ENTITY_SELECTBASEDATA = "cc_selectbasedata";
    private static final String ENTITY_CC_INSTALLLOG = "cc_installlog";
    private static final String ENTITY_CC_INSTALLLOGSHOW = "cc_installlogshow";
    private static final String ENTITY_BOS_USER = "bos_user";
    private static final String ENTITY_BOS_ORG = "bos_org";
    private static final String CALLBACK_KEY_SELECTBASEDATA = "callback_selectbasedata";
    private static final String CALLBACK_KEY_BTN_INSTALL = "callback_btninstall";
    private static final String CALLBACK_KEY_CHECK_DEPENDENCY = "callback_checkdependency";
    private static final String CALLBACK_KEY_INSTALL_PROGRESS = "callback_installprogress";
    private static final String CACHE_KEY_INDEX = "cache_key_index";
    private static final String OPERATION_KEY_SELECTBASEDATA = "selectbasedata";
    private static final String CONTROL_PROGRESS = "progressbarap";
    private static final String CONTROL_PROGRESS_TIPS = "progresstips";
    private static final String CALLBACK_KEY_RESOURCE_SCORE = "callback_resource_score";

    private int getCurRowIndex() {
        int value = -1;
        String content = this.getPageCache().get(CACHE_KEY_INDEX);
        if (!kd.bos.util.StringUtils.isBlank((String)content)) {
            value = (Integer)SerializationUtils.fromJsonString((String)content, Integer.class);
        }
        return value;
    }

    private void setCurRowIndex(Object value) {
        this.getPageCache().put(CACHE_KEY_INDEX, SerializationUtils.toJsonString((Object)value));
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String name = (String)formShowParameter.getCustomParam("form_key_name");
        String billno = (String)formShowParameter.getCustomParam("form_key_billno");
        this.getModel().setValue("name", (Object)name);
        this.getModel().setValue("billno", (Object)billno);
        DataPackageInputModel model = this.getDataPackageInputModel();
        if (model != null) {
            DataPackageInstallerProxy installerProxy = new DataPackageInstallerProxy(model, this);
            installerProxy.invokeDataPackageInstallCheck();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CONTROL_ENTRYENTITY);
        if (StringUtils.isNotBlank((Object)entryEntity) && !entryEntity.isEmpty()) {
            int size = entryEntity.size();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(CONTROL_ENTRYENTITY);
            int[] entrySize = new int[size];
            for (int i = 0; i < size; ++i) {
                entrySize[i] = i;
            }
            entryGrid.selectRows(entrySize, 0);
        }
        String type = (String)this.getView().getFormShowParameter().getCustomParam("tabSelectType");
        this.getView().setVisible(Boolean.valueOf(!"localtab".equals(type)), new String[]{"btnscore"});
    }

    private DataPackageInputModel getDataPackageInputModel() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String id = formShowParameter.getCustomParam("form_key_billno").toString();
        String name = formShowParameter.getCustomParam("form_key_name").toString();
        String version = formShowParameter.getCustomParam("form_key_version").toString();
        String type = (String)formShowParameter.getCustomParam("tabSelectType");
        String resourceFile = (String)formShowParameter.getCustomParam("resourcefile");
        Map billNameMap = (Map)formShowParameter.getCustomParam("form_key_entryinfo");
        return new DataPackageInputModel.Builder().id(id).name(name).ver(version).type(type).resourceFileUrl(resourceFile).objInfoMap(billNameMap).builder();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_INSTALL, BTN_CANCEL});
        EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source == null) {
            return;
        }
        if (source instanceof Control && (key = ((Control)source).getKey()).equals(BTN_CANCEL)) {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals(CALLBACK_KEY_BTN_INSTALL) && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_ENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            if (rows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u52a0\u8f7d\u7684\u6570\u636e\u3002", (String)"LoadPackagePlugin_0", (String)"imsc-cc", (Object[])new Object[0]));
                return;
            }
            DataPackageInputModel model = this.getDataPackageInputModel();
            if (model != null) {
                Map<String, DataPackageModifyResult> replaceData = this.getDataPackageReplaceAsync();
                HashMap<String, Object> jobParam = new HashMap<String, Object>(2);
                jobParam.put("job_param_model", JSON.toJSONString((Object)model));
                jobParam.put("job_param_replaceData", JSON.toJSONString(replaceData));
                InstallProgressHelper.buildAndCommitJobFormInfo(this.getView(), InstallProgressServiceTaskImpl.class.getName(), jobParam, new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_INSTALL_PROGRESS));
            }
        } else if (evt.getCallBackId().equals(CALLBACK_KEY_CHECK_DEPENDENCY) && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.showLoadTip();
        }
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_ENTRYENTITY);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && CONTROL_ROW_OPERATIONCOLUMNAP.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                String content = pkEvent.getRowData().get(ENTRY_FIELD_REPLACE_MAP).toString();
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (!OPERATION_KEY_SELECTBASEDATA.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                    operationColItem.setVisible(!StringUtils.isEmpty((CharSequence)content));
                    break;
                }
            }
        });
        super.initialize();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int index = hyperLinkClickEvent.getRowIndex();
        if (hyperLinkClickEvent.getFieldName().equals(ENTRY_FIELD_BUSINESSOBJECTTYPE)) {
            String isOpen = (String)this.getModel().getValue(ENTRY_FIELD_OPEN, index);
            String formId = (String)this.getModel().getValue(ENTRY_FIELD_BILLNAME, index);
            if (StringUtils.isBlank((CharSequence)isOpen) || !"true".equals(isOpen) || StringUtils.isBlank((CharSequence)formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u6b64\u7c7b\u6570\u636e\u3002", (String)"LoadPackagePlugin_1", (String)"imsc-cc", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)formId) || formId.length() <= 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u6b64\u7c7b\u6570\u636e\u3002", (String)"LoadPackagePlugin_1", (String)"imsc-cc", (Object[])new Object[0]));
                return;
            }
            FormOpenHelper.showList(this, formId);
            return;
        }
        if (hyperLinkClickEvent.getFieldName().equals(ENTRY_FIELD_OBJECT_ROAD)) {
            String logId = (String)this.getModel().getValue(ENTRY_FIELD_INSTALLLOGID, index);
            String fileName = (String)this.getModel().getValue(ENTRY_FIELD_SOURCE_NAME, index);
            logger.info("\u67e5\u770b\u65e5\u5fd7\uff1a" + logId);
            if (StringUtils.isEmpty((CharSequence)logId)) {
                return;
            }
            DynamicObject logObj = BusinessDataServiceHelper.loadSingle((Object)logId, (String)ENTITY_CC_INSTALLLOG);
            DynamicObjectCollection subInstallEntry = logObj.getDynamicObjectCollection("sub_install_entry");
            String largeTextTag = "";
            for (DynamicObject subLog : subInstallEntry) {
                if (!subLog.getString("subtitle").equals(fileName)) continue;
                largeTextTag = subLog.getString("subinstallmsg_tag");
                break;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(ENTITY_CC_INSTALLLOGSHOW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u5b50\u5305\u5b89\u88c5\u65e5\u5fd7", (String)"LoadPackagePlugin_2", (String)"imsc-cc", (Object[])new Object[0]));
            showParameter.setCustomParam("lock", (Object)true);
            showParameter.setCustomParam("largeTextValue", (Object)largeTextTag);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
            return;
        }
    }

    @Override
    public void dataPackageInstallInfoCallback(int totalPackageCount, int subPackageCount) {
    }

    @Override
    public void dataPackageInstallProgress(String fileName, SubDataInstallResult installResult, int subStatus) {
        logger.info("fileName {} installResult {}", (Object)fileName, (Object)JSONObject.toJSONString((Object)installResult));
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(CONTROL_ENTRYENTITY);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.get(ENTRY_FIELD_SOURCE_NAME).equals(installResult.getFileName())) continue;
            dynamicObject.set(ENTRY_FIELD_INSTALL_RESULT, (Object)subStatus);
            if (installResult.getFormId() != null) {
                dynamicObject.set(ENTRY_FIELD_INSTALLFORMID, (Object)installResult.getFormId());
            }
            dynamicObject.set(ENTRY_FIELD_OBJECT_ROAD, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u65e5\u5fd7", (String)"LoadPackagePlugin_3", (String)"imsc-cc", (Object[])new Object[0]));
            break;
        }
        this.getView().updateView(CONTROL_ENTRYENTITY);
    }

    @Override
    public void dataPackageInstallFinish(String installMsg, String id, int status, List<String> fileNames) {
        logger.info("installMsg {} ", (Object)installMsg);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(CONTROL_ENTRYENTITY);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String fileName = dynamicObject.get(ENTRY_FIELD_SOURCE_NAME).toString();
            if (!ArrayUtils.contains((Object[])fileNames.toArray(), (Object)fileName)) continue;
            dynamicObject.set(ENTRY_FIELD_OBJECT_ROAD, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u65e5\u5fd7", (String)"LoadPackagePlugin_3", (String)"imsc-cc", (Object[])new Object[0]));
            dynamicObject.set(ENTRY_FIELD_INSTALLLOGID, (Object)id);
        }
        this.getView().updateView(CONTROL_ENTRYENTITY);
    }

    @Override
    public void dataPackageInstallFail(int code, String errMsg) {
        logger.error("dataPackageInstallFail code {} msg {}", (Object)code, (Object)errMsg);
        this.getView().showTipNotification(errMsg);
    }

    @Override
    public Map<String, DataPackageModifyResult> checkDataPackageReplaceCallBack(Map<String, DataPackageModifyConfig> beforeDataPackageMap) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_ENTRYENTITY);
        DynamicObjectCollection entryData = this.getModel().getEntryEntity(CONTROL_ENTRYENTITY);
        Map billNameMap = new HashMap(4);
        Object entryInfo = this.getView().getFormShowParameter().getCustomParam("form_key_entryinfo");
        if (entryInfo instanceof Map) {
            billNameMap = (Map)entryInfo;
        }
        int[] selectRows = new int[beforeDataPackageMap.size()];
        int intIndex = 0;
        int intRow = 0;
        for (Map.Entry<String, DataPackageModifyConfig> entry : beforeDataPackageMap.entrySet()) {
            DynamicObject entryRow = entryData.addNew();
            entryRow.set(ENTRY_FIELD_SOURCE_NAME, (Object)entry.getKey());
            String objName = (String)billNameMap.get(entry.getKey());
            if (objName != null) {
                entryRow.set(ENTRY_FIELD_BUSINESSOBJECTTYPE, (Object)objName);
            }
            DataPackageModifyConfig dataPackageModifyConfig = entry.getValue();
            entryRow.set("dataencrypt", (Object)dataPackageModifyConfig.isDataEncrypt());
            entryRow.set(ENTRY_FIELD_BILLNAME, (Object)dataPackageModifyConfig.getFormId());
            int installCount = dataPackageModifyConfig.getInstallCount();
            if (installCount == 0) {
                entryRow.set(ENTRY_FIELD_CHECK_RESULT, (Object)ResManager.loadKDString((String)"\u8be5\u6587\u4ef6\u53ef\u52a0\u8f7d\u3002", (String)"LoadPackagePlugin_4", (String)"imsc-cc", (Object[])new Object[0]));
                selectRows[intIndex++] = intRow;
            } else {
                entryRow.set(ENTRY_FIELD_CHECK_RESULT, (Object)String.format(ResManager.loadKDString((String)"\u8be5\u6587\u4ef6\u5df2\u6210\u529f\u5b89\u88c5%s\u6b21\u3002\u5982\u4ecd\u9700\u5b89\u88c5\uff0c\u53ef\u91cd\u65b0\u52fe\u9009\u5b89\u88c5\u3002", (String)"LoadPackagePlugin_5", (String)"imsc-cc", (Object[])new Object[0]), installCount));
            }
            Map<String, JSONObject> replaceRegMap = dataPackageModifyConfig.getReplaceRegMap();
            if (replaceRegMap != null && replaceRegMap.size() > 0) {
                replaceRegMap = this.defaultValueOfReplaceMap(replaceRegMap);
                entryRow.set(ENTRY_FIELD_REPLACE_MAP, (Object)SerializationUtils.toJsonString(replaceRegMap));
                Map<String, Object> showMapOfReplaceMap = this.getShowMapOfReplaceMap(replaceRegMap);
                entryRow.set(ENTRY_FIELD_SELECTEDDATA, showMapOfReplaceMap);
            }
            entryRow.set(ENTRY_FIELD_SOURCE_OBJECT, (Object)SerializationUtils.toJsonString((Object)dataPackageModifyConfig));
            entryRow.set(ENTRY_FIELD_OPEN, (Object)dataPackageModifyConfig.isOpen());
            ++intRow;
        }
        entryGrid.selectRows(selectRows, 0);
        return null;
    }

    Map<String, JSONObject> defaultValueOfReplaceMap(Map<String, JSONObject> replaceRegMap) {
        long id = UserServiceHelper.getCurrentUserId();
        DynamicObject user = UserServiceHelper.getCurrentUser((String)"name,number");
        long orgId = RequestContext.get().getOrgId();
        ArrayList<String> propertyNameList = new ArrayList<String>();
        propertyNameList.add("name");
        propertyNameList.add("number");
        Map orgProperty = OrgUnitServiceHelper.getOrgProperty((long)orgId, propertyNameList);
        for (Map.Entry<String, JSONObject> entry : replaceRegMap.entrySet()) {
            JSONObject valueMap;
            String number;
            String name;
            if (entry.getValue().get((Object)"new_data") == null && entry.getValue().get((Object)"target_formId").equals(ENTITY_BOS_USER)) {
                name = user.get("name").toString();
                number = user.get("number").toString();
                valueMap = entry.getValue();
                this.setNewData(valueMap, "new_data", id);
                this.setNewData(valueMap, "new_data_chn", name);
                this.setNewData(valueMap, "new_data_number", number);
            }
            if (entry.getValue().get((Object)"new_data") != null || !entry.getValue().get((Object)"target_formId").equals(ENTITY_BOS_ORG)) continue;
            name = orgProperty.get("name").toString();
            number = orgProperty.get("number").toString();
            valueMap = entry.getValue();
            this.setNewData(valueMap, "new_data", orgId);
            this.setNewData(valueMap, "new_data_chn", name);
            this.setNewData(valueMap, "new_data_number", number);
        }
        return replaceRegMap;
    }

    Map<String, Object> getShowMapOfReplaceMap(Map<String, JSONObject> replaceRegMap) {
        HashMap<String, Object> mapDataNewData = new HashMap<String, Object>();
        String key_new_data = "new_data_chn";
        String key_display_name = "display_name";
        for (Map.Entry<String, JSONObject> entry : replaceRegMap.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue().containsKey((Object)key_display_name)) {
                key = entry.getValue().get((Object)key_display_name).toString();
            }
            if (!entry.getValue().containsKey((Object)key_new_data)) continue;
            mapDataNewData.put(key, entry.getValue().get((Object)key_new_data));
        }
        return mapDataNewData;
    }

    void setNewData(JSONObject valueMap, String key, Object newData) {
        if (valueMap == null) {
            return;
        }
        if (valueMap.containsKey((Object)key)) {
            valueMap.remove((Object)key);
        }
        valueMap.put(key, newData);
    }

    @Override
    public Map<String, DataPackageModifyResult> getDataPackageReplaceAsync() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_ENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        DynamicObjectCollection entryDataList = this.getModel().getEntryEntity(CONTROL_ENTRYENTITY);
        HashMap<String, DataPackageModifyResult> dataMap = new HashMap<String, DataPackageModifyResult>();
        int index = 0;
        for (DynamicObject entryRowData : entryDataList) {
            if (!ArrayUtils.contains((int[])rows, (int)index++)) continue;
            String key = entryRowData.get(ENTRY_FIELD_SOURCE_NAME).toString();
            String content = (String)entryRowData.get(ENTRY_FIELD_SOURCE_OBJECT);
            DataPackageModifyConfig dataPackageModifyConfig = (DataPackageModifyConfig)SerializationUtils.fromJsonString((String)content, DataPackageModifyConfig.class);
            boolean isReplace = true;
            HashMap<String, Object> mapResult = new HashMap<String, Object>();
            if (dataPackageModifyConfig == null || dataPackageModifyConfig.getReplaceRegMap() == null || dataPackageModifyConfig.getReplaceRegMap().isEmpty()) {
                isReplace = false;
            } else {
                Set<Map.Entry<String, JSONObject>> entrySet = dataPackageModifyConfig.getReplaceRegMap().entrySet();
                for (Map.Entry<String, JSONObject> entry : entrySet) {
                    String column = entry.getKey();
                    HashMap<String, Object> modifyObj = new HashMap<String, Object>();
                    JSONObject entryValue = entry.getValue();
                    String pkId = entryValue.getString("new_data");
                    if (StringUtils.isEmpty((CharSequence)pkId)) continue;
                    modifyObj.put("fields", entryValue.getJSONArray("fields"));
                    DynamicObject valueObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entryValue.getString("target_formId"));
                    if (valueObj == null) continue;
                    modifyObj.put("pkId", pkId);
                    modifyObj.put("entityName", entryValue.getString("target_formId"));
                    mapResult.put(column, modifyObj);
                }
            }
            DataPackageModifyResult dataPackageModifyResult = new DataPackageModifyResult(true, isReplace);
            dataPackageModifyResult.setReplaceRegMap(mapResult);
            dataMap.put(key, dataPackageModifyResult);
        }
        return dataMap;
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.setCurRowIndex(row);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String tabSelectType;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (OPERATION_KEY_SELECTBASEDATA.equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(ENTITY_SELECTBASEDATA);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_SELECTBASEDATA));
            formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            int index = this.getCurRowIndex();
            if (index < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c", (String)"LoadPackagePlugin_6", (String)"imsc-cc", (Object[])new Object[0]));
                return;
            }
            String content = this.getModel().getValue(ENTRY_FIELD_REPLACE_MAP, index).toString();
            if (StringUtils.isEmpty((CharSequence)content)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u9700\u66ff\u6362\u5173\u952e\u503c\u3002", (String)"LoadPackagePlugin_7", (String)"imsc-cc", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> prams = new HashMap<String, String>();
            prams.put("form_key_replace_map", content);
            formShowParameter.setCustomParams(prams);
            this.getView().showForm(formShowParameter);
        } else if ("previewfile".equals(operateKey)) {
            int index = this.getCurRowIndex();
            if (index < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c", (String)"LoadPackagePlugin_6", (String)"imsc-cc", (Object[])new Object[0]));
                return;
            }
            String sourceName = this.getModel().getValue(ENTRY_FIELD_SOURCE_NAME, index).toString();
            if (StringUtils.isEmpty((CharSequence)sourceName) || !sourceName.endsWith(".xlsx")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9884\u89c8xlsx\u683c\u5f0f\u7684Excel\u6587\u4ef6\u3002", (String)"LoadPackagePlugin_8", (String)"imsc-cc", (Object[])new Object[0]));
                return;
            }
            Boolean isDataEncrypt = (Boolean)this.getModel().getValue("dataencrypt", index);
            if (isDataEncrypt.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u6570\u636e\u52a0\u5bc6\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"LoadPackagePlugin_9", (String)"imsc-cc", (Object[])new Object[0]));
                return;
            }
            DataPackageInputModel model = this.getDataPackageInputModel();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cc_excelpreview");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("c_c_i", (Object)JSONObject.toJSONString((Object)model));
            formShowParameter.setCustomParam("p_f_n", (Object)sourceName);
            this.getView().showForm(formShowParameter);
        } else if ("btnscore".equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cc_resource_score");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_RESOURCE_SCORE));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> prams = new HashMap<String, Object>(2);
            prams.put("form_key_billno", this.getModel().getValue("billno"));
            formShowParameter.setCustomParams(prams);
            this.getView().showForm(formShowParameter);
        } else if (BTN_INSTALL.equals(operateKey) && !"localtab".equals(tabSelectType = (String)this.getView().getFormShowParameter().getCustomParam("tabSelectType"))) {
            String version;
            String[] langs;
            HashMap<String, Object> header = new HashMap<String, Object>(2);
            header.put("pkgNum", this.getModel().getValue("billno"));
            header.put("need_pic", "0");
            BizOperationResult detail = GcpManager.getDetail(header);
            if (null == detail || !detail.getSuccess() || null == detail.getData()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u5df2\u4e0b\u67b6\u6216\u7981\u7528\uff0c\u6b64\u5b89\u88c5\u4e0d\u53ef\u7528\u3002", (String)"LoadPackagePlugin_10", (String)"imsc-cc", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ContentDetailModel contentDetailModel = (ContentDetailModel)JSON.parseObject((String)JSON.toJSONString(detail.getData()), ContentDetailModel.class);
            String supportlanguage = contentDetailModel.getSupportlanguage();
            if (kd.bos.util.StringUtils.isNotEmpty((String)supportlanguage) && !Arrays.asList(langs = supportlanguage.split(",")).contains(RequestContext.get().getLang().getLocale().toString())) {
                args.setCancel(true);
                ContentHelper.getLanguageAuthenTips();
                return;
            }
            List versions = VersionService.getVersionInfos();
            boolean backwards = contentDetailModel.isBackwards();
            Optional<Version> constellation = versions.stream().filter(o -> o.getProductNumber().startsWith("constellation_")).findFirst();
            List starryVersion = contentDetailModel.getStarryVersion().stream().map(o -> o.split("V")[1]).sorted().collect(Collectors.toList());
            if (constellation.isPresent() && !starryVersion.contains(version = this.removeLastVersion(constellation.get().getVersion()))) {
                String maxVersion = (String)starryVersion.get(starryVersion.size() - 1);
                if (!backwards || maxVersion.compareTo(version) > 0) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u4e0d\u9002\u7528\u4e8e\u5f53\u524d\u7cfb\u7edf\u7248\u672c\u3002", (String)"LoadPackagePlugin_11", (String)"imsc-cc", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals(BTN_INSTALL)) {
            try {
                String type = (String)this.getView().getFormShowParameter().getCustomParam("tabSelectType");
                if ("localtab".equals(type)) {
                    boolean checkResult = this.checkDependency();
                    if (checkResult) {
                        this.showLoadTip();
                    }
                } else {
                    IprmHelper.checkFuncEnableUse("imsc", "cc", "startLoading");
                    boolean checkResult = this.checkDependency();
                    if (checkResult) {
                        this.showLoadTip();
                    }
                }
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
            }
            return;
        }
    }

    private void showLoadTip() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u52a0\u8f7d\u987b\u77e5", (String)"LoadPackagePlugin_12", (String)"imsc-cc", (Object[])new Object[0]), NewResourcePlugin.getLoadTipHintMsg(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_KEY_BTN_INSTALL, (IFormPlugin)this));
    }

    private boolean checkDependency() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_ENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            return true;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(CONTROL_ENTRYENTITY);
        String tip = LoadPackageHelper.getDependencyTip(dynamicObjects, rows);
        if (StringUtils.isBlank((CharSequence)tip)) {
            return true;
        }
        this.getView().showConfirm(LoadPackageHelper.getCheckDependTitle(), tip, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_KEY_CHECK_DEPENDENCY, (IFormPlugin)this));
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(CALLBACK_KEY_SELECTBASEDATA) && closedCallBackEvent.getReturnData() != null) {
            Map mapData = (Map)closedCallBackEvent.getReturnData();
            int index = this.getCurRowIndex();
            if (index >= 0) {
                Map<String, Object> showMapOfReplaceMap = this.getShowMapOfReplaceMap(mapData);
                this.getModel().setValue(ENTRY_FIELD_SELECTEDDATA, showMapOfReplaceMap, index);
                this.getModel().setValue(ENTRY_FIELD_REPLACE_MAP, (Object)SerializationUtils.toJsonString((Object)mapData), index);
                DataPackageModifyConfig dataPackageModifyConfig = (DataPackageModifyConfig)SerializationUtils.fromJsonString((String)this.getModel().getValue(ENTRY_FIELD_SOURCE_OBJECT, index).toString(), DataPackageModifyConfig.class);
                dataPackageModifyConfig.setReplaceRegMap(mapData);
                this.getModel().setValue(ENTRY_FIELD_SOURCE_OBJECT, (Object)SerializationUtils.toJsonString((Object)dataPackageModifyConfig), index);
            }
        } else if (actionId.equals(CALLBACK_KEY_RESOURCE_SCORE)) {
            Map data;
            boolean submitSuccess;
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 instanceof Map && (submitSuccess = Boolean.parseBoolean((data = (Map)returnData2).get("submitSuccess").toString()))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"LoadPackagePlugin_13", (String)"imsc-cc", (Object[])new Object[0]));
            }
        } else if (actionId.equals(CALLBACK_KEY_INSTALL_PROGRESS) && !StringUtils.isBlank((CharSequence)(returnData = (String)closedCallBackEvent.getReturnData()))) {
            InstallFailResult installFailResult;
            InstallFinishResult installFinishResult;
            InstallFeedbackResult feedbackResult = (InstallFeedbackResult)JSON.parseObject((String)returnData, InstallFeedbackResult.class);
            List<InstallSubDataResult> installSubDataResults = feedbackResult.getSubInstallResult();
            if (CollectionUtils.isNotEmpty(installSubDataResults)) {
                for (InstallSubDataResult subDataResult : installSubDataResults) {
                    this.dataPackageInstallProgress(subDataResult.getFileName(), subDataResult.getResult(), subDataResult.getSubStatus());
                }
            }
            if (null != (installFinishResult = feedbackResult.getInstallFinishResult())) {
                this.dataPackageInstallFinish(installFinishResult.getMsg(), installFinishResult.getLogPKId(), installFinishResult.getStatus(), installFinishResult.getFileNames());
            }
            if (null != (installFailResult = feedbackResult.getInstallFailResult())) {
                this.dataPackageInstallFail(installFailResult.getCode(), installFailResult.getErrMsg());
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
        if (progressBar.getKey().equals(CONTROL_PROGRESS)) {
            int progress = 0;
            progressEvent.setProgress(progress);
            Label label = (Label)this.getView().getControl(CONTROL_PROGRESS_TIPS);
            label.setText(progress + "%");
        }
    }

    private String removeLastVersion(String version) {
        String[] split;
        if (StringUtils.isNotEmpty((CharSequence)version) && (split = version.split("\\.")).length == 4) {
            version = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
        }
        return version;
    }
}

