/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.cc.business.resource.ResourceListProxy;

public class MyContentCardFromPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(MyContentCardFromPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label collectLabel = (Label)this.getControl("collect_count");
        Label localLabel = (Label)this.getControl("local_count");
        collectLabel.addClickListener((ClickListener)this);
        localLabel.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QFilter qFilter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()).and("type", "in", Arrays.asList("collect", "subscribe"));
        DynamicObjectCollection packRecordList = QueryServiceHelper.query((String)"cc_pack_record", (String)"id,contentinfo", (QFilter[])qFilter.toArray());
        List contentNumberList = packRecordList.stream().map(y -> y.getString("contentinfo")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        Label collectCountLabel = (Label)this.getView().getControl("collect_count");
        if (contentNumberList.isEmpty()) {
            collectCountLabel.setText(kd.bos.util.StringUtils.getStringValue((Object)0));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fc", "#bbbbbb");
            this.getView().updateControlMetadata("collect_count", map);
        } else {
            HashMap<String, String> map;
            try {
                List<String> contentList = ResourceListProxy.getResourceListByNumber(JSON.toJSONString(contentNumberList));
                if (CollectionUtils.isEmpty(contentList)) {
                    collectCountLabel.setText(kd.bos.util.StringUtils.getStringValue((Object)0));
                    map = new HashMap();
                    map.put("fc", "#bbbbbb");
                    this.getView().updateControlMetadata("collect_count", map);
                } else {
                    collectCountLabel.setText(kd.bos.util.StringUtils.getStringValue((Object)contentList.size()));
                }
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff1a", (Object)ex.getMessage());
                map = new HashMap<String, String>();
                map.put("fc", "#bbbbbb");
                this.getView().updateControlMetadata("collect_count", map);
            }
        }
        List localIds = QueryServiceHelper.queryPrimaryKeys((String)"cc_mycontent", null, null, (int)-1);
        Label locaCountLabel = (Label)this.getView().getControl("local_count");
        locaCountLabel.setText(kd.bos.util.StringUtils.getStringValue((Object)localIds.size()));
        if (localIds.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fc", "#bbbbbb");
            this.getView().updateControlMetadata("local_count", map);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("collect_count".equals(ctlSource.getKey()) || "local_count".equals(ctlSource.getKey())) {
            String tabSelectType = "collect_count".equals(ctlSource.getKey()) ? "collecttab" : "localtab";
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("cc_mycontent");
            param.setCustomParam("tabSelectType", (Object)tabSelectType);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }
}

