/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.helper.NewResourceHelper;
import kd.imsc.cc.business.resource.ResourceListProxy;
import kd.imsc.cc.formplugin.ResourceListDataProvider;
import kd.imsc.cc.formplugin.helper.CollectHelper;

public class NewResourceListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(NewResourceListPlugin.class);
    private static final String CACHE_KEY_CUSTOMFILTERS = "cache_key_customfilters";
    private static final String CACHE_KEY_IFHAVEUPDATETYPE = "cache_key_ifhaveupdatetype";
    private static final String CALLBACK_BILLINFO_RESOURCE = "callback_billinfo_resource";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"collect", "cancelcollect", "cardop", "carddetail"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null && formShowParameter.getCustomParam("billFormId") != null && !this.getIfHaveUpdateType()) {
            this.getPageCache().put(CACHE_KEY_IFHAVEUPDATETYPE, SerializationUtils.toJsonString((Object)true));
            try {
                ResourceListProxy.updateResourceClassify();
            }
            catch (Exception exc) {
                logger.error("\u66f4\u65b0\u5185\u5bb9\u5305\u5206\u7c7b\u5f02\u5e38", (Throwable)exc);
            }
        }
        Map<String, String> filterData = this.getCustomFilters();
        String schemeFilter = filterData.getOrDefault("filters", "");
        ResourceListDataProvider.Param param = new ResourceListDataProvider.Param();
        param.setSchemeFilter(schemeFilter);
        args.setListDataProvider((IListDataProvider)new ResourceListDataProvider(param, this.getView()));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
        String isVisibleNoDataFlex = this.getView().getPageCache().get("isVisibleNoDataFlex");
        this.getView().setVisible(Boolean.valueOf("true".equals(isVisibleNoDataFlex)), new String[]{"nodataflex"});
        this.getView().setVisible(Boolean.valueOf(!"true".equals(isVisibleNoDataFlex)), new String[]{"billlistap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        String billNo = currentSelectedRowInfo.getBillNo();
        switch (key) {
            case "collect": {
                CollectHelper.collectClick(billNo, "cc_resourcenew", this.getView());
                break;
            }
            case "cancelcollect": {
                CollectHelper.cancelCollectClick(billNo, "cc_resourcenew", this.getView(), this.getPluginName());
                break;
            }
            default: {
                if (StringUtils.isEmpty((String)billNo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u4e91\u5185\u5bb9\u7f16\u7801\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"NewResourceListPlugin_0", (String)"imsc-cc", (Object[])new Object[0]));
                    return;
                }
                this.openForm(billNo, "cc_resourcenew", "");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("cancelcollect".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String params = messageBoxClosedEvent.getCustomVaule();
            Map map = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
            boolean isSuccess = CollectHelper.collect((String)map.get("contentNumber"), RequestContext.get().getCurrUserId(), false);
            if (isSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u85cf\u6210\u529f\u3002", (String)"NewResourceListPlugin_1", (String)"imsc-cc", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject data = e.getRowData();
        this.getPageCache().put(data.getString("billno"), data.getString("name"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals(CALLBACK_BILLINFO_RESOURCE) && closedCallBackEvent.getReturnData() != null && !StringUtils.isEmpty((String)closedCallBackEvent.getReturnData().toString())) {
            this.getView().showErrorNotification(closedCallBackEvent.getReturnData().toString());
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List fastFilters = args.getFastQFilters();
        HashMap<String, String> filterData = new HashMap<String, String>(2);
        List qFilters = args.getFilterParameter().getQFilters();
        for (QFilter qFilter : qFilters) {
            String property;
            switch (property = qFilter.getProperty()) {
                case "rtype.id": {
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"cc_res_rtype", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", qFilter.getValue())});
                    qFilter.__setProperty("adaindustry.number");
                    qFilter.__setCP("in");
                    qFilter.__setValue(query.stream().map(y -> y.get("number")).collect(Collectors.toList()));
                    break;
                }
                case "itype.id": 
                case "domain2.fbasedataid.id": {
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"cc_res_itype", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", qFilter.getValue())});
                    qFilter.__setProperty("domain.number");
                    qFilter.__setCP("in");
                    qFilter.__setValue(query.stream().map(y -> y.get("number")).collect(Collectors.toList()));
                    break;
                }
                case "ttype.id": {
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"cc_res_ttype", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", qFilter.getValue())});
                    qFilter.__setProperty("classification.number");
                    qFilter.__setCP("in");
                    qFilter.__setValue(query.stream().map(y -> y.get("number")).collect(Collectors.toList()));
                    break;
                }
                case "supportlangtype.id": 
                case "supportlang2.fbasedataid.id": {
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"cc_res_supportlang", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", qFilter.getValue())});
                    qFilter.__setProperty("supportlang.number");
                    qFilter.__setCP("in");
                    qFilter.__setValue(query.stream().map(y -> y.get("number")).collect(Collectors.toList()));
                    break;
                }
                case "countrytype.id": 
                case "country2.fbasedataid.id": {
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"cc_res_country", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", qFilter.getValue())});
                    qFilter.__setProperty("country.number");
                    qFilter.__setCP("in");
                    qFilter.__setValue(query.stream().map(y -> y.get("number")).collect(Collectors.toList()));
                    break;
                }
                case "billno": {
                    qFilter.__setProperty("number");
                    break;
                }
                case "brief": {
                    qFilter.__setProperty("intro");
                    break;
                }
                case "entryentity.businessobjecttype": 
                case "resource_entry.businessobjecttype": {
                    qFilter.__setProperty("businessobject.businessobjname");
                    break;
                }
            }
        }
        if (fastFilters != null && !fastFilters.isEmpty()) {
            QFilter filter = (QFilter)fastFilters.get(0);
            String value = (String)filter.getValue();
            QFilter filterFasts = new QFilter("number", "!=", (Object)"-1");
            String[] split = value.split("#", 2);
            if (split.length == 2) {
                String[] fields;
                String fieldName = split[0];
                String valueStr = split[1];
                String[] stringArray = fields = fieldName.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String field;
                    switch (field = stringArray[i]) {
                        case "billno": {
                            field = "number";
                            break;
                        }
                        case "brief": {
                            field = "intro";
                            break;
                        }
                        case "entryentity.businessobjecttype": {
                            field = "businessobject.businessobjname";
                            break;
                        }
                    }
                    filterFasts.or(new QFilter(field, "=", (Object)valueStr));
                }
                qFilters.add(filterFasts);
            }
        }
        List qFilterList = qFilters.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
        filterData.put("filters", JSON.toJSONString(qFilterList));
        this.getPageCache().put(CACHE_KEY_CUSTOMFILTERS, JSON.toJSONString(filterData));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String businessNumber = this.getPageCache().get("cache_key_business_number");
        if (StringUtils.isEmpty((String)businessNumber)) {
            businessNumber = (String)this.getView().getFormShowParameter().getCustomParam("businessNumber");
            String businessName = (String)this.getView().getFormShowParameter().getCustomParam("businessName");
            if (StringUtils.isNotEmpty((String)businessNumber) && StringUtils.isNotEmpty((String)businessName)) {
                FilterColumn column = args.getFilterColumn("businessobjecttype");
                column.setDefaultValue(businessName);
                this.getPageCache().put("cache_key_business_number", businessNumber);
                this.getPageCache().put("cache_key_business_name", businessName);
            }
        }
    }

    protected void openForm(String billNo, String formId, String type) {
        HashMap<String, String> customParam = new HashMap<String, String>(2);
        billNo = NewResourceHelper.getBillNoByBillNo(billNo);
        customParam.put("billno", billNo);
        customParam.put("tabSelectType", type);
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(formId);
        billShowParameter.setCustomParams(customParam);
        if (formId.equals("cc_resourcenew")) {
            billShowParameter.setCaption(ResManager.loadKDString((String)"\u4e91\u5185\u5bb9", (String)"NewResourceListPlugin_2", (String)"imsc-cc", (Object[])new Object[0]));
        } else {
            billShowParameter.setCaption(ResManager.loadKDString((String)"\u6211\u7684\u5185\u5bb9", (String)"NewResourceListPlugin_3", (String)"imsc-cc", (Object[])new Object[0]));
        }
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_BILLINFO_RESOURCE));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    protected Map<String, String> getCustomFilters() {
        Map<String, String> value = new HashMap<String, String>(4);
        String content = this.getPageCache().get(CACHE_KEY_CUSTOMFILTERS);
        if (!StringUtils.isEmpty((String)content)) {
            value = (Map)JSON.parseObject((String)content, Map.class);
        }
        return value;
    }

    private boolean getIfHaveUpdateType() {
        boolean value = false;
        String content = this.getPageCache().get(CACHE_KEY_IFHAVEUPDATETYPE);
        if (!StringUtils.isEmpty((String)content)) {
            value = (Boolean)SerializationUtils.fromJsonString((String)content, Boolean.class);
        }
        return value;
    }
}

