/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.util.StringUtils;
import kd.imsc.cc.common.entity.DataPackageModifyConfig;

public class SelectBaseDataPlugin
extends AbstractFormPlugin {
    private static final String CONTROL_ENTRYENTITY = "entryentity";
    private static final String ENTRY_FIELD1_OBJECTNAME = "objectname";
    private static final String ENTRY_FIELD1_OBJECT_KEY = "object_key";
    private static final String ENTRY_FIELD1_OBJECTFORMID = "objectformid";
    private static final String ENTRY_FIELD1_SELECTEDID = "selectedid";
    private static final String ENTRY_FIELD1_SELECTEDNAME = "selectedname";
    private static final String ENTRY_FIELD1_SELECTEDNUMBER = "selectednumber";
    private static final String ENTITY_BOS_USER = "bos_user";
    private static final String CALLBACK_KEY_SELECTBASEDATA = "callback_key_selectbasedata";
    private static final String CACHE_KEY_INDEX = "cache_key_index";
    private static final String CACHE_KEY_DATAMAP = "cache_key_datamap";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String CONTROL_ROW_OPERATIONCOLUMNAP = "operationcolumnap1";
    private static final String OPERATION_KEY_SELECTBASEDATA = "selectbasedata";
    public static final String FORM_KEY_REPLACE_MAP = "form_key_replace_map";

    private int getIndex() {
        int value = -1;
        String content = this.getPageCache().get(CACHE_KEY_INDEX);
        if (!StringUtils.isBlank((String)content)) {
            value = (Integer)SerializationUtils.fromJsonString((String)content, Integer.class);
        }
        return value;
    }

    private Map<String, JSONObject> getDataMap() {
        Map<String, JSONObject> value = null;
        String content = this.getPageCache().get(CACHE_KEY_DATAMAP);
        if (!StringUtils.isBlank((String)content)) {
            value = DataPackageModifyConfig.parseReplaceRegMap(content);
        }
        return value;
    }

    private void setDataMap(Object value) {
        this.getPageCache().put(CACHE_KEY_DATAMAP, SerializationUtils.toJsonString((Object)value));
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_ENTRYENTITY);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && CONTROL_ROW_OPERATIONCOLUMNAP.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                String formId = pkEvent.getRowData().get(ENTRY_FIELD1_OBJECTFORMID).toString();
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (!OPERATION_KEY_SELECTBASEDATA.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                    operationColItem.setVisible(!formId.equals(ENTITY_BOS_USER));
                    break;
                }
            }
        });
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue(CONTROL_ENTRYENTITY);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String content = formShowParameter.getCustomParam(FORM_KEY_REPLACE_MAP).toString();
        Map<String, JSONObject> replaceRegMap = null;
        if (!StringUtils.isBlank((String)content)) {
            replaceRegMap = DataPackageModifyConfig.parseReplaceRegMap(content);
        }
        if (replaceRegMap != null && replaceRegMap.size() > 0) {
            for (Map.Entry<String, JSONObject> entry : replaceRegMap.entrySet()) {
                DynamicObject dynamicObject = dynamicObjects.addNew();
                dynamicObject.set(ENTRY_FIELD1_OBJECT_KEY, (Object)entry.getKey());
                dynamicObject.set(ENTRY_FIELD1_OBJECTNAME, (Object)String.format("%s(%s)", entry.getValue().get((Object)"display_name"), entry.getKey()));
                dynamicObject.set(ENTRY_FIELD1_OBJECTFORMID, entry.getValue().get((Object)"target_formId"));
                dynamicObject.set(ENTRY_FIELD1_SELECTEDID, entry.getValue().get((Object)"new_data"));
                dynamicObject.set(ENTRY_FIELD1_SELECTEDNAME, entry.getValue().get((Object)"new_data_chn"));
                dynamicObject.set(ENTRY_FIELD1_SELECTEDNUMBER, entry.getValue().get((Object)"new_data_number"));
            }
            this.setDataMap(replaceRegMap);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate.getOperateKey().equals(OPERATION_KEY_SELECTBASEDATA)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c", (String)"SelectBaseDataPlugin_0", (String)"imsc-iprm-formplugin", (Object[])new Object[0]));
                return;
            }
            int index = selectRows[0];
            this.getPageCache().put(CACHE_KEY_INDEX, SerializationUtils.toJsonString((Object)index));
            String entityNumber = this.getModel().getValue(ENTRY_FIELD1_OBJECTFORMID, index).toString();
            ListShowParameter listShowParameter = new ListShowParameter();
            FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)entityNumber);
            if (listFormConfig == null) {
                return;
            }
            listShowParameter.setFormId(listFormConfig.getF7ListFormId());
            listShowParameter.setBillFormId(entityNumber);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("580");
            inlineStyleCss.setWidth("960");
            listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            listShowParameter.setMultiSelect(false);
            listShowParameter.setLookUp(true);
            listShowParameter.setShowApproved(true);
            listShowParameter.setShowUsed(true);
            listShowParameter.setF7ClickByFilter(true);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_SELECTBASEDATA);
            listShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listSelectedRows;
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals(CALLBACK_KEY_SELECTBASEDATA) && (returnData = closedCallBackEvent.getReturnData()) != null && (listSelectedRows = (ListSelectedRowCollection)returnData).size() > 0) {
            int index = this.getIndex();
            String id = listSelectedRows.get(0).getPrimaryKeyValue().toString();
            String name = listSelectedRows.get(0).getName();
            String number = listSelectedRows.get(0).getNumber();
            if (index >= 0) {
                this.getModel().setValue(ENTRY_FIELD1_SELECTEDID, (Object)id, index);
                this.getModel().setValue(ENTRY_FIELD1_SELECTEDNAME, (Object)name, index);
                this.getModel().setValue(ENTRY_FIELD1_SELECTEDNUMBER, (Object)number, index);
                Map<String, JSONObject> replaceRegMap = this.getDataMap();
                if (replaceRegMap != null) {
                    String key = this.getModel().getValue(ENTRY_FIELD1_OBJECT_KEY).toString();
                    JSONObject valueMap = replaceRegMap.get(key);
                    this.setNewData(valueMap, "new_data", id);
                    this.setNewData(valueMap, "new_data_chn", name);
                    this.setNewData(valueMap, "new_data_number", number);
                }
                this.setDataMap(replaceRegMap);
            }
        }
    }

    void setNewData(JSONObject valueMap, String key, Object newData) {
        if (valueMap == null) {
            return;
        }
        valueMap.remove((Object)key);
        valueMap.put(key, newData);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    public void click(EventObject evt) {
        String controlKey;
        super.click(evt);
        Object source = evt.getSource();
        if (source == null) {
            return;
        }
        if (source instanceof Control && (controlKey = ((Control)source).getKey()).equals(BTN_OK)) {
            Map<String, JSONObject> returnData = this.getDataMap();
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

