/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin.mycontent;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.cc.formplugin.NewResourceListPlugin;
import kd.imsc.cc.formplugin.ResourceListDataProvider;
import kd.imsc.cc.formplugin.helper.CollectHelper;

public class MyContentListPlugin
extends NewResourceListPlugin
implements TabSelectListener {
    private static final Log logger = LogFactory.getLog(MyContentListPlugin.class);
    private static final String TAB_SELECT_TYPE_CACHE = "tabSelectType";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject contentRecord = this.getCurrentUserRecord();
        String type = "collecttab";
        if (contentRecord != null) {
            type = contentRecord.getString("type");
        }
        logger.info("\u7528\u6237\uff1a{} \u8fdb\u5165\u6211\u7684\u5185\u5bb9\u7684\u9875\u7b7e\u7c7b\u578b\u4e3a {}", (Object)UserServiceHelper.getCurrentUserId(), (Object)type);
        this.setButtonVisible(type);
        Tab tab = (Tab)this.getView().getControl("tabap");
        String typeParam = (String)this.getView().getFormShowParameter().getCustomParam(TAB_SELECT_TYPE_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)typeParam)) {
            type = typeParam;
        }
        this.getView().getPageCache().put(TAB_SELECT_TYPE_CACHE, type);
        tab.activeTab(type);
    }

    private DynamicObject getCurrentUserRecord() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter typeFilter = new QFilter("user", "=", (Object)currentUserId).and(new QFilter("type", "is not null", (Object)"-1"));
        return BusinessDataServiceHelper.loadSingle((String)"cc_mycontent_record", (String)"id,type,user", (QFilter[])typeFilter.toArray());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String type = this.getView().getPageCache().get(TAB_SELECT_TYPE_CACHE);
        DynamicObject packRecord = this.getCurrentUserRecord();
        if (packRecord == null) {
            packRecord = BusinessDataServiceHelper.newDynamicObject((String)"cc_mycontent_record");
            packRecord.set("user", (Object)UserServiceHelper.getCurrentUserId());
        }
        packRecord.set("type", (Object)type);
        SaveServiceHelper.saveOperate((String)"cc_mycontent_record", (DynamicObject[])new DynamicObject[]{packRecord}, (OperateOption)OperateOption.create());
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String type = this.getView().getPageCache().get(TAB_SELECT_TYPE_CACHE);
        if ("collecttab".equals(type)) {
            long currentUserId = UserServiceHelper.getCurrentUserId();
            QFilter typeFilter = new QFilter("user", "=", (Object)currentUserId).and(new QFilter("type", "=", (Object)"collect"));
            DynamicObjectCollection packRecordList = QueryServiceHelper.query((String)"cc_pack_record", (String)"id,contentinfo", (QFilter[])typeFilter.toArray());
            List contentNumberList = packRecordList.stream().map(y -> y.getString("contentinfo")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            Map<String, String> filterData = this.getCustomFilters();
            String schemeFilter = filterData.getOrDefault("filters", "");
            ResourceListDataProvider.Param param = new ResourceListDataProvider.Param();
            param.setCollectFilter(JSON.toJSONString(contentNumberList));
            param.setSchemeFilter(schemeFilter);
            args.setListDataProvider((IListDataProvider)new ResourceListDataProvider(param, this.getView()));
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodataflex"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"refresh", (CharSequence)key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            if (billList != null) {
                billList.clearSelection();
                billList.refresh();
            }
        } else if (StringUtils.equals((CharSequence)"upload", (CharSequence)key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("cc_packageupload");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "packUploadClose"));
            this.getView().showForm(formShowParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("packUploadClose".equals(actionId) && (returnData = event.getReturnData()) != null) {
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        String billNo = currentSelectedRowInfo.getBillNo();
        switch (key) {
            case "collect": {
                CollectHelper.collectClick(billNo, "cc_mycontent", this.getView());
                break;
            }
            case "cancelcollect": {
                CollectHelper.cancelCollectClick(billNo, "cc_mycontent", this.getView(), this.getPluginName());
                break;
            }
            default: {
                if (StringUtils.isEmpty((CharSequence)billNo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u4e91\u5185\u5bb9\u7f16\u7801\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MyContentListPlugin_0", (String)"imsc-cc", (Object[])new Object[0]));
                    return;
                }
                String tabSelectType = this.getView().getPageCache().get(TAB_SELECT_TYPE_CACHE);
                logger.info("\u5217\u8868\u6253\u5f00\u6211\u7684\u5185\u5bb9 {},\u7c7b\u578b\u4e3a {}", (Object)billNo, (Object)tabSelectType);
                this.openForm(billNo, "cc_mycontent", tabSelectType);
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.setButtonVisible(tabKey);
        this.getView().getPageCache().put(TAB_SELECT_TYPE_CACHE, tabKey);
        if ("collecttab".equals(tabKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"labelap3", "labelap", "cardflexpanelap41"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap3", "labelap", "cardflexpanelap41"});
        }
        this.getView().updateView("billlistap");
    }

    private void setButtonVisible(String tabKey) {
        this.getView().setVisible(Boolean.valueOf(!StringUtils.equals((CharSequence)tabKey, (CharSequence)"collecttab")), new String[]{"upload", "delete"});
    }
}

