/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.engine.eas.action.AbstractMigrateAction;
import kd.imsc.dmw.engine.eas.action.impl.migrate.IscSchemeGroupDeal;
import kd.imsc.dmw.engine.eas.core.config.MigrateIscSchemeConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.param.MigrateRequestParam;
import kd.imsc.dmw.engine.eas.core.progress.ActionProgress;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideExcuteHelper;
import kd.imsc.dmw.utils.IscUtils;

public class MigrateExecAction
extends AbstractMigrateAction {
    private static final Log log = LogFactory.getLog(MigrateExecAction.class);
    private final MigrateRequestParam param;

    public MigrateExecAction(MigrateContext executeContext, MigrateRequestParam param, ActionProgress progress) {
        this.setExecuteContext(executeContext);
        this.setProgress(progress);
        this.param = param;
    }

    @Override
    public void doExec() {
        try {
            Map<String, List<MigrateIscSchemeConfig>> migrateIscSchemeConfs = this.getMigrateIscSchemeConf();
            this.getProgress().updateComplete(10);
            ArrayList<String> schemeSortList = new ArrayList<String>(migrateIscSchemeConfs.keySet());
            List sortList = schemeSortList.stream().sorted(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    BigDecimal o1Sort = new BigDecimal(o1);
                    BigDecimal o2Sort = new BigDecimal(o2);
                    if (o1Sort.compareTo(o2Sort) > 0) {
                        return 1;
                    }
                    if (o1Sort.compareTo(o2Sort) < 0) {
                        return -1;
                    }
                    return 0;
                }
            }).collect(Collectors.toList());
            for (String sort : sortList) {
                List<MigrateIscSchemeConfig> configGroup = migrateIscSchemeConfs.get(sort);
                if (this.getExecuteContext().isTerminate()) break;
                try {
                    IscSchemeGroupDeal schemeGroup = new IscSchemeGroupDeal(this.getExecuteContext(), configGroup, this.getProgress());
                    List<String> groupResults = schemeGroup.deal();
                    boolean result = groupResults.stream().anyMatch(MigrateExecAction::hasFail);
                    if (!result) {
                        this.getProgress().addComplete(configGroup.size());
                        continue;
                    }
                    break;
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u96c6\u6210\u65b9\u6848\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u8fc1\u79fb\u5931\u8d25,", (Throwable)e);
            this.rollbackStatus();
            throw e;
        }
        this.updateProjectStatus();
        this.getProgress().complete();
    }

    private void rollbackStatus() {
        HashSet<Long> migrateEntryIds = this.param.getMigrateEntryIdSet();
        Map<Long, Object> migOldStatus = this.param.getMigOldStatus();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getExecuteContext().getProjectId(), (String)this.getExecuteContext().getProjectFormId());
        DynamicObjectCollection execEntrys = project.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject entry : execEntrys) {
            String entryStatus = entry.getString("migratestatus");
            if (!migrateEntryIds.contains((Long)entry.getPkValue()) || !"F".equals(entryStatus) && !"A".equals(entryStatus)) continue;
            Object oldStatus = migOldStatus.get((Long)entry.getPkValue());
            entry.set("migratestatus", oldStatus);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
    }

    private void updateProjectStatus() {
        this.rollbackStatus();
        MigrateUserGuideExcuteHelper.updateProjectStatus(this.getExecuteContext().getProjectId(), this.getExecuteContext().getProjectFormId());
    }

    private static boolean hasFail(String status) {
        return "D".equals(status) || "E".equals(status);
    }

    private Map<String, List<MigrateIscSchemeConfig>> getMigrateIscSchemeConf() {
        List<DynamicObject> migrateEntryList = this.loadNeededSchemeEntrys();
        ArrayList<Long> triggerIds = new ArrayList<Long>(16);
        ArrayList<Long> flowIds = new ArrayList<Long>(16);
        for (DynamicObject dyo : migrateEntryList) {
            String schemeType = dyo.getString("integrattype");
            DynamicObject startScheme = dyo.getDynamicObject("startscheme");
            if ("isc_data_copy_trigger".equals(schemeType)) {
                triggerIds.add((Long)startScheme.getPkValue());
                continue;
            }
            if (!"isc_service_flow".equals(schemeType)) continue;
            flowIds.add((Long)startScheme.getPkValue());
        }
        Map triggers = BusinessDataServiceHelper.loadFromCache((String)"isc_data_copy_trigger", (String)"number, name,data_copy,params_entryentity.params_name,params_entryentity.params_value,params_entryentity.params_data_type", (QFilter[])new QFilter("id", "in", triggerIds).toArray());
        Map flows = BusinessDataServiceHelper.loadFromCache((String)"isc_service_flow", (String)"number, name,variables.var_name,variables.default_value,variables.is_input_param,resources.res_category,resources.res_ref", (QFilter[])new QFilter("id", "in", flowIds).toArray());
        IscUtils.updateDatasource(this.param.getMigrateDataLink(), this.getExecuteContext().getProjectFormId());
        return this.getGroupData(migrateEntryList, triggers, flows);
    }

    private Map<String, List<MigrateIscSchemeConfig>> getGroupData(List<DynamicObject> migrateEntryList, Map<Object, DynamicObject> triggers, Map<Object, DynamicObject> flows) {
        LinkedHashMap<String, List<MigrateIscSchemeConfig>> migrateObjConfigList = new LinkedHashMap<String, List<MigrateIscSchemeConfig>>(16);
        Long maxSort = migrateEntryList.stream().map(n -> n.getLong("sortnumexec")).sorted(Comparator.reverseOrder()).findFirst().get();
        for (DynamicObject entry : migrateEntryList) {
            MigrateIscSchemeConfig schemeConfig = this.buildSchemeConfig(entry, triggers, flows, maxSort);
            if (schemeConfig == null) continue;
            migrateObjConfigList.putIfAbsent(schemeConfig.getSortnumexec(), new ArrayList(16));
            List schemeListMap = (List)migrateObjConfigList.get(schemeConfig.getSortnumexec());
            schemeListMap.add(schemeConfig);
        }
        return migrateObjConfigList;
    }

    private MigrateIscSchemeConfig buildSchemeConfig(DynamicObject entry, Map<Object, DynamicObject> triggers, Map<Object, DynamicObject> flows, Long maxSort) {
        String schemeType = entry.getString("integrattype");
        String executeType = "1";
        if (entry.getDataEntityType().getProperties().get((Object)"executetype") != null) {
            executeType = entry.getString("executetype");
        }
        if (StringUtils.isEmpty((CharSequence)schemeType) && StringUtils.isEmpty((CharSequence)executeType)) {
            return null;
        }
        long entryId = (Long)entry.getPkValue();
        String sortNumExec = entry.getString("sortnumexec");
        MigrateIscSchemeConfig config = null;
        DynamicObject dynObj = null;
        if ("1".equals(executeType)) {
            long schemeId = (Long)entry.getDynamicObject("startscheme").getPkValue();
            if ("isc_data_copy_trigger".equals(schemeType)) {
                dynObj = triggers.get(schemeId);
            } else if ("isc_service_flow".equals(schemeType)) {
                dynObj = flows.get(schemeId);
            }
        } else {
            sortNumExec = String.valueOf(maxSort + 1L);
        }
        DynamicObject migObj = entry.getDynamicObject("migrateobject");
        boolean entryIsAutoGenerate = false;
        if (migObj == null && "0".equals(sortNumExec)) {
            if ("1".equals(entry.getString("invalidatastatus"))) {
                QFilter qFilter = new QFilter("id", "=", (Object)this.getExecuteContext().getProjectId());
                qFilter.and("treeentryentity.migrateobject", "=", entry.getDynamicObject("parentmigobj").getPkValue());
                DynamicObject result = QueryServiceHelper.queryOne((String)this.getExecuteContext().getProjectFormId(), (String)"treeentryentity.sortnumexec", (QFilter[])qFilter.toArray());
                if (result != null) {
                    String sort = result.getString("treeentryentity.sortnumexec");
                    BigDecimal sortQty = new BigDecimal(sort);
                    BigDecimal changeSort = sortQty.add(new BigDecimal("0.1"));
                    sortNumExec = changeSort.toString();
                }
            } else {
                entryIsAutoGenerate = true;
                int seq = entry.getInt("seq");
                sortNumExec = String.valueOf(maxSort + 1L + (long)seq);
            }
        }
        config = MigrateIscSchemeConfig.build(dynObj, schemeType, entryId, sortNumExec, executeType, entryIsAutoGenerate);
        config.setIgnoreExistData(entry.getBoolean("isignoreexistdata"));
        config.setInvalidatastatus(entry.getString("invalidatastatus"));
        return config;
    }

    private List<DynamicObject> loadNeededSchemeEntrys() {
        long projectId = this.getExecuteContext().getProjectId();
        HashSet<Long> migrateEntryIds = this.param.getMigrateEntryIdSet();
        ArrayList<DynamicObject> migrateEntryList = new ArrayList<DynamicObject>(16);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)this.getExecuteContext().getProjectFormId());
        DynamicObjectCollection treeEntryList = dynamicObject.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject entry : treeEntryList) {
            if (!migrateEntryIds.contains((Long)entry.getPkValue())) continue;
            migrateEntryList.add(entry);
        }
        return migrateEntryList;
    }
}

