/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.reportpush;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.eas.action.impl.reportpush.exec.AbstractBcmReportEntity;
import kd.imsc.dmw.engine.eas.action.impl.reportpush.exec.EASFiReportPushImpl;
import kd.imsc.dmw.engine.eas.action.impl.reportpush.exec.EASMergeReportPushImpl;
import kd.imsc.dmw.engine.eas.core.config.ReportPushConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.log.ReportPushLog;
import kd.imsc.dmw.helper.BalanceCheckDataHelper;
import kd.imsc.dmw.helper.eas.EasReportHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;

public class ReportPushCallable
implements Callable<List<ReportPushLog>> {
    private static final Log logger = LogFactory.getLog(ReportPushCallable.class);
    private MigrateContext context;
    private List<ReportPushConfig> reportPushConfigList;

    public ReportPushCallable(List<ReportPushConfig> reportPushConfig, MigrateContext context) {
        this.reportPushConfigList = reportPushConfig;
        this.context = context;
    }

    @Override
    public List<ReportPushLog> call() {
        ArrayList<ReportPushLog> reportPushLogList = new ArrayList<ReportPushLog>(16);
        try {
            if (this.context.isTerminate()) {
                String msg = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"ReportPushCallable_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                reportPushLogList.add(new ReportPushLog(this.reportPushConfigList.get(0).getPushRecordId(), 0L, false, msg));
            } else {
                this.updatePushRecordBill(this.reportPushConfigList, "2", StringUtils.getEmpty(), true);
                reportPushLogList.addAll(this.doExcute());
            }
            EasReportHelper.updatePushRecordEntry(reportPushLogList);
            EasReportHelper.updatePushRecordBillStatusByEntry(this.reportPushConfigList.get(0).getPushRecordId());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u62a5\u8868\u63a8\u9001\u9519\u8bef,", (Throwable)e);
            String msg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
            this.updatePushRecordBill(this.reportPushConfigList, "4", msg, false);
        }
        return reportPushLogList;
    }

    private List<ReportPushLog> doExcute() {
        ArrayList<ReportPushLog> reportPushLogList = new ArrayList<ReportPushLog>(16);
        if (!this.context.isTerminate()) {
            for (ReportPushConfig reportPushConfig : this.reportPushConfigList) {
                AbstractBcmReportEntity repairExec;
                ReportPushLog reportPushLog = new ReportPushLog(reportPushConfig.getPushRecordId(), reportPushConfig.getPushRecordEntryId(), false, StringUtils.getEmpty());
                if ("1".equals(reportPushConfig.getEasReportType())) {
                    repairExec = new EASFiReportPushImpl(reportPushConfig);
                    reportPushLog = repairExec.doReportPush();
                } else if ("2".equals(reportPushConfig.getEasReportType())) {
                    repairExec = new EASMergeReportPushImpl(reportPushConfig);
                    reportPushLog = repairExec.doReportPush();
                }
                reportPushLogList.add(reportPushLog);
            }
        }
        return reportPushLogList;
    }

    private void updatePushRecordBill(List<ReportPushConfig> reportPushConfigList, String status, String errorMsg, boolean isUpdateEntry) {
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_reportpushrecord");
        String recordTableName = newDynObj.getDynamicObjectType().getAlias();
        long pushRecordId = reportPushConfigList.get(0).getPushRecordId();
        QFilter filter = new QFilter("id", "=", (Object)pushRecordId);
        DynamicObjectCollection recordDynObjColl = QueryServiceHelper.query((String)"dmw_reportpushrecord", (String)String.join((CharSequence)",", "pushstatus", "entryentity.pushsubstatus"), (QFilter[])filter.toArray());
        long count = recordDynObjColl.stream().filter(o -> "3".equals(o.getString("entryentity.pushsubstatus"))).count();
        String pushgrogress = count + "/" + recordDynObjColl.size();
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(" update ").append(recordTableName).append(" set fpushstatus=?,ferrorinfo=?,ferrorinfo_tag=?,fpushgrogress=?,fserviceid=?,ftraceid=? where fid =? ");
        String msg = StringUtil.subDataDeal(errorMsg, 500);
        BalanceCheckDataHelper.execute(DBRoute.of((String)"imsc"), updateSql.toString(), new Object[]{status, msg, errorMsg, pushgrogress, this.context.getTaskId(), RequestContext.get().getTraceId(), pushRecordId});
        if (isUpdateEntry) {
            updateSql.setLength(0);
            String recordEntryTableName = newDynObj.getDynamicObjectCollection("entryentity").getDynamicObjectType().getAlias();
            updateSql.append(" update ").append(recordEntryTableName).append(" set fpushsubstatus='").append(status).append("' where fentryid IN ").append(CommonUtils.getSqlInStr(reportPushConfigList.size()));
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            paramsList.add(reportPushConfigList.stream().map(ReportPushConfig::getPushRecordEntryId).toArray());
            BalanceCheckDataHelper.executeBatch(DBRoute.of((String)"imsc"), updateSql.toString(), paramsList);
        }
    }
}

