/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.config.isc.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imsc.dmw.engine.eas.core.config.MigrateLinkConf;
import kd.imsc.dmw.engine.eas.core.config.isc.IscService;
import kd.imsc.dmw.engine.eas.core.model.IscDataResult;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.helper.PermissionHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DbUtil;
import kd.imsc.dmw.utils.IscUtils;
import org.apache.commons.collections.CollectionUtils;

public class IscServiceImpl
implements IscService {
    private static final Log log = LogFactory.getLog(IscServiceImpl.class);
    private MigrateLinkConf linkConf;

    public IscServiceImpl(MigrateLinkConf linkConf) {
        this.linkConf = linkConf;
    }

    public IscServiceImpl(Long linkConfId) {
        DynamicObject iscLink = BusinessDataServiceHelper.loadSingle((Object)linkConfId, (String)"isc_database_link");
        this.linkConf = MigrateLinkConf.build(iscLink);
    }

    @Override
    public Object executeQuerySql(String sql, long limit) {
        String linkNumber = this.linkConf.getObj().getString("number");
        Long linkId = (Long)this.linkConf.getObj().getPkValue();
        Object result = null;
        try {
            boolean dmwApiQuery = CommonUtils.checkParams("dmwapiquery");
            if (dmwApiQuery) {
                result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"executeQuerySQL", (Object[])new Object[]{linkNumber, sql, null, null, limit});
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("sql", sql);
                IscUtils.updateDatasourceByApi(Collections.singletonList(2089284213516860416L), linkId);
                map.put("limit", limit);
                result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscApicService", (String)"invokeScriptApi2", (Object[])new Object[]{"KD_IMSC_checkapi", map, null});
            }
        }
        catch (Exception e) {
            String errMsg = ResManager.loadKDString((String)"\u8c03\u7528\u96c6\u6210\u4e91\u67e5\u8be2sql\u5f02\u5e38\uff0c\u539f\u56e0\u4e3a:", (String)"IscServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            log.error(errMsg, (Throwable)e);
            throw new DmwBizException(errMsg, (Throwable)e);
        }
        log.info("\u6267\u884csql\u6210\u529f");
        return result;
    }

    @Override
    public List<Map<String, Object>> pageQuery(String templateSql, String countSql, long limit) {
        int loopNum = this.getLoopCount(countSql);
        String querySql = String.format(templateSql, "' '");
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(2);
        for (int i = 0; i < loopNum; ++i) {
            Object iscDataResult = this.executeQuerySql(querySql, 1000L);
            List tempResultList = (List)iscDataResult;
            if (tempResultList == null || tempResultList.isEmpty()) continue;
            resultList.addAll(tempResultList);
            Object startId = ((Map)tempResultList.get(tempResultList.size() - 1)).get("fid");
            querySql = String.format(templateSql, "'" + startId + "'");
        }
        return resultList;
    }

    @Override
    public Map<String, Object> testConnect() {
        PermissionHelper.hasPermission("isc_database_link", "1O5/61259CWS");
        DynamicObject iscLink = BusinessDataServiceHelper.loadSingle((Object)this.linkConf.getObjId(), (String)"isc_database_link");
        String linkNumber = iscLink.getString("number");
        return (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"testConnection", (Object[])new Object[]{linkNumber});
    }

    @Override
    public Object executeFlow(String flowNumber, Map<String, Object> params) {
        Map invokeResult = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"execute", (Object[])new Object[]{flowNumber, new ArrayList<Object>(params.values())});
        return JSONObject.toJSONString((Object)invokeResult);
    }

    @Override
    public IscDataResult executeUpdateSql(String updateSql) {
        IscDataResult iscDataResult = new IscDataResult();
        String flowNumber = "dmw_easupdate";
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("sql", updateSql);
        Object result = null;
        try {
            result = this.executeFlow(flowNumber, map);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u96c6\u6210\u4e91\u67e5\u8be2sql\u5f02\u5e38\uff0c\u539f\u56e0\u4e3a:", (Throwable)e);
            iscDataResult.setSuccess(false);
            iscDataResult.setErrorMessage(e.getMessage());
            return iscDataResult;
        }
        iscDataResult.setSuccess(true);
        iscDataResult.setResult(result);
        log.info("\u6267\u884csql\u6210\u529f");
        return iscDataResult;
    }

    @Override
    public List<Object> pageQuery(String sql, boolean isReturnId) {
        ArrayList<Object> datas = new ArrayList<Object>(16);
        if (sql == null) {
            return datas;
        }
        String countSql = DbUtil.changeCountSql(sql);
        int loopNum = this.getLoopCount(countSql);
        if (loopNum == 0) {
            return datas;
        }
        this.loopQuery(sql, isReturnId, datas, loopNum);
        return datas;
    }

    private void loopQuery(String sql, boolean isReturnId, List<Object> datas, int loopNum) {
        Object pageStartValue = null;
        for (int i = 0; i < loopNum; ++i) {
            String pageSql = DbUtil.changePageSql(sql, 1000, pageStartValue, "a.fid");
            Object iscDataResult = this.executeQuerySql(pageSql, 1000L);
            List results = (List)iscDataResult;
            if (!CollectionUtils.isNotEmpty((Collection)results)) continue;
            List easIdList = results.stream().map(n -> n.get("fid")).collect(Collectors.toList());
            pageStartValue = easIdList.get(easIdList.size() - 1);
            if (isReturnId) {
                datas.addAll(easIdList);
                continue;
            }
            datas.addAll(results);
        }
    }

    private int getLoopCount(String sumSql) {
        Object iscDataResult = this.executeQuerySql(sumSql, 1000L);
        List result = (List)iscDataResult;
        if (CommonUtils.isNull(result)) {
            return 0;
        }
        Map resultMap = (Map)result.get(0);
        if (resultMap == null) {
            return 0;
        }
        String sumStr = String.valueOf(resultMap.get("c"));
        BigDecimal sum = new BigDecimal(sumStr);
        BigDecimal numBig = sum.divide(new BigDecimal(1000), 0, RoundingMode.CEILING);
        int num = numBig.intValue();
        if (num > 10) {
            num = 10;
        }
        return num;
    }
}

