/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.checkitems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.engine.eas.core.config.isc.IscService;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.plugin.IMigrateCheckItemPlugin;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DbUtil;

public abstract class AbstractCheckPlugin
implements IMigrateCheckItemPlugin {
    protected String tableNameXh;
    protected String tableNameEas;
    private Map<String, Object> paramMap = new HashMap<String, Object>(2);
    private Map<String, List<Object>> errorEasIdsMap = new HashMap<String, List<Object>>(16);
    private Map<String, List<Object>> errorXhIdMap = new HashMap<String, List<Object>>(8);
    private StringBuilder errMsgBuild = new StringBuilder();
    private List<Map<String, Object>> fixSrcSysDataList = new ArrayList<Map<String, Object>>(8);
    private List<Map<String, Object>> fixXhSysDataList = new ArrayList<Map<String, Object>>(8);
    private Set<String> fixXhDataTypeSet = new HashSet<String>(8);

    public AbstractCheckPlugin() {
    }

    public AbstractCheckPlugin(String tableNameEas) {
        this.tableNameEas = tableNameEas;
    }

    public AbstractCheckPlugin(String tableNameXh, String tableNameEas) {
        this.tableNameEas = tableNameEas;
        this.tableNameXh = tableNameXh;
    }

    public Map<String, List<Object>> queryXhData(Set<String> fieldList, QFilter[] qFilters) {
        String fields = String.join((CharSequence)",", fieldList);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(fieldList.size());
        DynamicObjectCollection dataArray = QueryServiceHelper.query((String)this.tableNameXh, (String)fields, (QFilter[])qFilters);
        for (String field : fieldList) {
            map.put(field, new ArrayList());
        }
        for (DynamicObject data : dataArray) {
            for (String field : fieldList) {
                map.get(field).add(data.getString(field));
            }
        }
        return map;
    }

    public Map<String, List<String>> queryXhStrData(Set<String> fieldList, QFilter[] qFilters) {
        String fields = String.join((CharSequence)",", fieldList);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(fieldList.size());
        DynamicObjectCollection dataArray = QueryServiceHelper.query((String)this.tableNameXh, (String)fields, (QFilter[])qFilters);
        for (String field : fieldList) {
            map.put(field, new ArrayList());
        }
        for (DynamicObject data : dataArray) {
            for (String field : fieldList) {
                map.get(field).add(data.getString(field));
            }
        }
        return map;
    }

    public List<Map<String, Object>> executePageQuery(IscService service, String sql) {
        String templateSql = DbUtil.buildPaginationSql(sql);
        String countSql = DbUtil.buildCountSql(sql);
        return service.pageQuery(templateSql, countSql, 1000L);
    }

    protected List<Map<String, Object>> executePageQuery(IscService service, String templateSql, String countSql) {
        return service.pageQuery(templateSql, countSql, 1000L);
    }

    protected void buildCheckItemLog(CheckItemLog checkItemLog) {
        if (this.errMsgBuild.length() > 0) {
            checkItemLog.setStatus("B");
            checkItemLog.setSrcSysTableName(this.tableNameEas);
            checkItemLog.setErrorSrcSysIdMap(this.errorEasIdsMap);
            checkItemLog.setErrorXhIdMap(this.errorXhIdMap);
            this.errMsgBuild.deleteCharAt(this.errMsgBuild.length() - 1);
            checkItemLog.setValidateInfo(this.errMsgBuild.toString());
            checkItemLog.setFixSrcSysDataList(this.fixSrcSysDataList);
            checkItemLog.setFixXhSysDataList(this.fixXhSysDataList);
            checkItemLog.setParamMap(this.paramMap);
        } else {
            checkItemLog.setStatus("A");
        }
    }

    protected void buildErrMsg(String errMsg) {
        if (!this.errMsgBuild.toString().contains(errMsg)) {
            this.errMsgBuild.append(errMsg).append('\n');
        }
    }

    protected void buildFixDataList(String sourceSystem, Object id, Object number, Object name, String errMsg) {
        HashMap<String, Object> errDataMap = new HashMap<String, Object>(8);
        errDataMap.put("id", id);
        errDataMap.put("number", number);
        errDataMap.put("name", name);
        errDataMap.put("errortype", errMsg);
        if ("A".equals(sourceSystem)) {
            this.fixSrcSysDataList.add(errDataMap);
        } else {
            this.buildFixXhSysDataList(errDataMap);
        }
    }

    protected void buildFixDataList(String sourceSystem, Object id, Object number, Object name, Object orgNum, Object orgName, String errorType) {
        HashMap<String, Object> errDataMap = new HashMap<String, Object>(8);
        errDataMap.put("id", id);
        errDataMap.put("number", number);
        errDataMap.put("name", name);
        errDataMap.put("orgnum", orgNum);
        errDataMap.put("orgname", orgName);
        errDataMap.put("errortype", errorType);
        if ("A".equals(sourceSystem)) {
            this.fixSrcSysDataList.add(errDataMap);
        } else {
            this.buildFixXhSysDataList(errDataMap);
        }
    }

    protected void buildFixXhSysDataList(Map<String, Object> errDataMap) {
        String errMsg = (String)errDataMap.get("errortype");
        String number = (String)errDataMap.get("number");
        StringBuilder sb = new StringBuilder(errMsg);
        sb.append(number);
        if (!this.fixXhDataTypeSet.contains(sb.toString())) {
            this.fixXhDataTypeSet.add(sb.toString());
            this.fixXhSysDataList.add(errDataMap);
        }
    }

    protected String verifyDataIsNull(Object verifiedField, String fieldName) {
        if (CommonUtils.isNull(verifiedField)) {
            String detailMsg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d%s\u4e3a\u7a7a\u3002", (String)"AbstractCheckPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[]{fieldName});
            this.buildErrMsg(detailMsg);
            return detailMsg;
        }
        return "";
    }

    protected String verifyDataCompliance(Object verifiedField, Object easId, String fieldName, Pattern pattern) {
        String name = (String)verifiedField;
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            String detailMsg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d%s\u4e0d\u5408\u89c4\u3002", (String)"AbstractCheckPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[]{fieldName});
            this.buildErrMsg(detailMsg);
            return detailMsg;
        }
        return "";
    }

    protected String verifyDataDuplicateEas(List<String> originalFieldList, String verifiedField, String fieldName) {
        if (originalFieldList.contains(verifiedField)) {
            String detailMsg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d%s\u91cd\u590d\u3002", (String)"AbstractCheckPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[]{fieldName});
            this.buildErrMsg(detailMsg);
            return detailMsg;
        }
        return "";
    }

    protected String verifyDataDuplicate(List<String> originalFieldList, String verifiedField, String fieldName) {
        if (originalFieldList.contains(verifiedField)) {
            String detailMsg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d%s\u4e0e\u661f\u701a\u7cfb\u7edf\u6570\u636e\u91cd\u590d\u3002", (String)"AbstractCheckPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[]{fieldName});
            this.buildErrMsg(detailMsg);
            return detailMsg;
        }
        return "";
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(Map<String, Object> paramMap) {
        this.paramMap = paramMap;
    }

    public Map<String, List<Object>> getErrorXhIdMap() {
        return this.errorXhIdMap;
    }

    public void setErrorXhIdMap(Map<String, List<Object>> errorXhIdMap) {
        this.errorXhIdMap = errorXhIdMap;
    }
}

