/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.eas.checkitems.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtils;

public class CombinationVerifyCheckPlugin
extends AbstractCheckPlugin {
    protected String easTableName;
    protected String sql;
    protected String xhTableName;
    protected String combineFieldName;
    private static final String COMBINE = "combine";

    public CombinationVerifyCheckPlugin(String easTableName, String sql, String xhTableName, String combineFieldName) {
        super(xhTableName, easTableName);
        this.easTableName = easTableName;
        this.sql = sql;
        this.xhTableName = xhTableName;
        this.combineFieldName = combineFieldName;
    }

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        CheckItemLog checkItemLog = new CheckItemLog();
        Long dbLinkId = param.getDbLinkId();
        IscServiceImpl service = new IscServiceImpl(dbLinkId);
        List<Map<String, Object>> resultList = this.executePageQuery(service, this.sql);
        QFilter qFilter = QFilter.isNotNull((String)"number");
        DynamicObjectCollection dataArray = QueryServiceHelper.query((String)this.tableNameXh, (String)"id,number,name,fullname,standard,standard.number", (QFilter[])qFilter.toArray());
        Map<String, List<String>> map = this.buildXhCombinationList(dataArray);
        List<String> xhCombinationList = map.get(COMBINE);
        List<String> xhIdList = map.get("id");
        List<String> xhNumList = map.get("number");
        List<String> xhNameList = map.get("name");
        ArrayList<String> easCombinationList = new ArrayList<String>(8);
        for (Map<String, Object> result : resultList) {
            Object easId = result.get("fid");
            Object easNum = result.get("fnumber");
            Object easName = result.get("fname_l2");
            StringBuilder combination = new StringBuilder();
            combination.append(result.get("fdisplayname_l2")).append(result.get("standard"));
            String errMsg = this.verifyDataDuplicate(xhCombinationList, combination.toString(), this.combineFieldName);
            if (StringUtils.isNotEmpty(errMsg)) {
                this.buildFixDataList("A", easId, easNum, easName, errMsg);
                int index = xhCombinationList.indexOf(combination.toString());
                this.buildFixDataList("B", xhIdList.get(index), xhNumList.get(index), xhNameList.get(index), errMsg);
            }
            if (StringUtils.isNotEmpty(errMsg = this.verifyDataDuplicateEas(easCombinationList, combination.toString(), this.combineFieldName))) {
                this.buildFixDataList("A", easId, easNum, easName, errMsg);
            }
            easCombinationList.add(combination.toString());
        }
        this.buildCheckItemLog(checkItemLog);
        return checkItemLog;
    }

    private Map<String, List<String>> buildXhCombinationList(DynamicObjectCollection dataArray) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(3);
        ArrayList<String> xhCombinationList = new ArrayList<String>(8);
        ArrayList<String> xhIdList = new ArrayList<String>(8);
        ArrayList<String> xhNumList = new ArrayList<String>(8);
        ArrayList<String> xhNameList = new ArrayList<String>(8);
        for (DynamicObject data : dataArray) {
            StringBuilder combination = new StringBuilder();
            String id = data.getString("id");
            String number = data.getString("number");
            String name = data.getString("name");
            String fullName = data.getString("fullname");
            String standard = data.getString("standard.number");
            combination.append(fullName);
            if (!CommonUtils.isNull(standard)) {
                combination.append(standard);
            }
            xhIdList.add(id);
            xhNumList.add(number);
            xhNameList.add(name);
            xhCombinationList.add(combination.toString());
        }
        map.put("id", xhIdList);
        map.put("number", xhNumList);
        map.put("name", xhNameList);
        map.put(COMBINE, xhCombinationList);
        return map;
    }
}

