/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.eas.checkitems.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;

public class MeasurementPrecisionCheckPlugin
extends AbstractCheckPlugin {
    private static final String PRECISION = "precision";

    public MeasurementPrecisionCheckPlugin() {
        super("bd_measureunits", "");
    }

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        CheckItemLog checkItemLog = new CheckItemLog();
        String sql = "select a.fid,a.fnumber,a.fname_l2,a.fqtyprecision  from T_BD_MeasureUnit as a where a.fnumber in ('CM','G','KG','M','MM','TON') ";
        IscServiceImpl service = new IscServiceImpl(param.getDbLinkId());
        List<Map<String, Object>> resultList = this.executePageQuery(service, sql);
        HashSet<String> fieldList = new HashSet<String>(2);
        fieldList.add("id");
        fieldList.add("number");
        fieldList.add("name");
        fieldList.add(PRECISION);
        QFilter filter = new QFilter("number", "in", (Object)new String[]{"cm", "g", "kg", "m", "mm", "t"});
        Map<String, List<Object>> map = this.queryXhData(fieldList, filter.toArray());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        for (Map<String, Object> result : resultList) {
            String easNum;
            switch (easNum = (String)result.get("fnumber")) {
                case "CM": {
                    this.judgeIfEqual(result, map, paramMap, "cm");
                    break;
                }
                case "G": {
                    this.judgeIfEqual(result, map, paramMap, "g");
                    break;
                }
                case "KG": {
                    this.judgeIfEqual(result, map, paramMap, "kg");
                    break;
                }
                case "M": {
                    this.judgeIfEqual(result, map, paramMap, "m");
                    break;
                }
                case "MM": {
                    this.judgeIfEqual(result, map, paramMap, "mm");
                    break;
                }
                case "TON": {
                    this.judgeIfEqual(result, map, paramMap, "t");
                    break;
                }
            }
        }
        HashMap<String, List<Object>> errorXhIdMap = new HashMap<String, List<Object>>(8);
        ArrayList<Long> repairIdList = new ArrayList<Long>(2);
        repairIdList.add(1855901196817073152L);
        repairIdList.add(2194211528578723840L);
        errorXhIdMap.put("isc_value_conver_rule", repairIdList);
        this.setErrorXhIdMap(errorXhIdMap);
        this.setParamMap(paramMap);
        this.buildCheckItemLog(checkItemLog);
        return checkItemLog;
    }

    private void judgeIfEqual(Map<String, Object> result, Map<String, List<Object>> map, Map<String, Object> paramMap, String xhNumber) {
        Object easId = result.get("fid");
        Object easName = result.get("fname_l2");
        Object easNum = result.get("fnumber");
        String tempPrecision = result.get("fqtyprecision").toString();
        int easPrecision = Integer.parseInt(tempPrecision);
        List<Object> idListXh = map.get("id");
        List<Object> numListXh = map.get("number");
        List<Object> nameListXh = map.get("name");
        List<Object> precisionListXh = map.get(PRECISION);
        int index = numListXh.indexOf(xhNumber);
        if (index == -1) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u661f\u701a\u4e2d\u7f3a\u5c11\u7f16\u7801\u4e3a%s\u7684\u8ba1\u91cf\u5355\u4f4d", (String)"MeasurementPrecisionCheckPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), xhNumber);
            this.buildErrMsg(errMsg);
            this.buildFixDataList("B", "", xhNumber, "", errMsg);
            paramMap.put("isSupportRepair", "no");
            return;
        }
        int xhPrecision = Integer.parseInt((String)precisionListXh.get(index));
        if (easPrecision > xhPrecision) {
            String errMsg = String.format(ResManager.loadKDString((String)"EAS\u7f16\u7801\u4e3a%s\u7684\u8ba1\u91cf\u5355\u4f4d\u7cbe\u5ea6\u4e0e\u661f\u701a\u4e0d\u540c", (String)"MeasurementPrecisionCheckPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), easNum);
            paramMap.put(xhNumber, easPrecision);
            this.buildErrMsg(errMsg);
            this.buildFixDataList("A", easId, easNum, easName, errMsg);
            this.buildFixDataList("B", idListXh.get(index), xhNumber, nameListXh.get(index), errMsg);
        }
    }
}

