/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.log;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.utils.DateUtils;
import kd.imsc.dmw.utils.StringUtil;

public class RepairLog {
    private DynamicObject repairLogObj;

    public RepairLog(String repairlogFormId) {
        DynamicObject repairLog = BusinessDataServiceHelper.newDynamicObject((String)repairlogFormId);
        repairLog.set("id", (Object)DB.genLongId((String)repairLog.getDynamicObjectType().getAlias()));
        String number = CodeRuleServiceHelper.getNumber((String)repairlogFormId, (DynamicObject)repairLog, null);
        repairLog.set("number", (Object)number);
        RequestContext requestContext = RequestContext.get();
        if (requestContext != null) {
            repairLog.set("traceid", (Object)requestContext.getTraceId());
            repairLog.set("operator", (Object)requestContext.getCurrUserId());
            repairLog.set("creator", (Object)requestContext.getCurrUserId());
            repairLog.set("starttime", (Object)new Date());
        }
        this.repairLogObj = repairLog;
    }

    public void setValue(String key, Object value) {
        this.repairLogObj.set(key, value);
    }

    public void setStatus(String status) {
        this.repairLogObj.set("repairstatus", (Object)status);
    }

    public void setlogDetail(String detail) {
        String msg = detail == null ? "" : detail;
        this.repairLogObj.set("repairlog", (Object)StringUtil.subDataDeal(msg, 50));
        this.repairLogObj.set("repairlog_tag", (Object)msg);
    }

    public Object getValue(String key) {
        return this.repairLogObj.get(key);
    }

    public void saveLog() {
        Date date = new Date();
        this.repairLogObj.set("endtime", (Object)date);
        long result = DateUtils.dataReduce((Date)date, (Date)this.repairLogObj.getDate("starttime"));
        this.repairLogObj.set("timeconsum", (Object)(result + "ms"));
        try (TXHandle tx = TX.notSupported();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.repairLogObj});
        }
    }
}

