/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.helper.ExcelConvertHelper;
import kd.imsc.dmw.engine.multiimport.helper.MultiImpTaskHelper;
import kd.imsc.dmw.engine.multiimport.install.StdImportHandlerImpl;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTemplateReadInfoModel;
import kd.imsc.dmw.engine.multiimport.model.SheetDataInfoModel;
import kd.imsc.dmw.engine.multiimport.model.SubDataConfigureInfo;
import kd.imsc.dmw.engine.multiimport.model.SubDataInstallInfo;
import kd.imsc.dmw.engine.multiimport.model.SubDataInstallResult;
import kd.imsc.dmw.engine.multiimport.result.ImportSimpleResult;
import kd.imsc.dmw.engine.multiimport.result.MultiImpTaskDetailExecResult;
import kd.imsc.dmw.engine.multiimport.result.MultiImpTaskExecResult;
import kd.imsc.dmw.enums.ImpFailCodeEnum;
import kd.imsc.dmw.enums.MultiImpTaskEntryStatusEnum;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.helper.PermissionHelper;
import kd.imsc.dmw.utils.StringUtil;
import org.apache.commons.io.FileUtils;

public class SimpleImportServiceCallable
implements Callable<ImportSimpleResult> {
    private static final Log logger = LogFactory.getLog(SimpleImportServiceCallable.class);
    private File file;
    private long taskId;
    private SubDataConfigureInfo configInfo;
    private ImportTemplateReadInfoModel templateReadInfoModel;
    private SheetDataInfoModel sheetDataInfo;

    public SimpleImportServiceCallable(File file, long taskId, SubDataConfigureInfo configInfo, ImportTemplateReadInfoModel templateReadInfoModel, SheetDataInfoModel sheetDataInfo) {
        this.file = file;
        this.taskId = taskId;
        this.configInfo = configInfo;
        this.templateReadInfoModel = templateReadInfoModel;
        this.sheetDataInfo = sheetDataInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportSimpleResult call() throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.file == null || !this.file.exists()) {
            return this.buildImportSimpleResult(new ImportSimpleResult(null, 0, 0, true, 1L, ImpFailCodeEnum.PARAMS), startTime);
        }
        SubDataInstallInfo installInfo = this.configInfo.getInstallInfo();
        DynamicObject entryByNumber = MultiImpTaskHelper.getEntryByNumber(this.taskId, installInfo.getFormId());
        if (entryByNumber == null) {
            return this.buildImportSimpleResult(new ImportSimpleResult(null, 0, 0, true, 1L, ImpFailCodeEnum.PARAMS), startTime);
        }
        this.feedbackTaskEntryResult(this.taskId, this.configInfo.getInstallInfo().getFormId(), 0, -1, null, "");
        if (!PermissionHelper.hasPermission(installInfo.getFormId(), "47156aff000000ac")) {
            String failReason = ResManager.loadKDString((String)"\u65e0\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u65b0\u589e\u6743\u9650\u3002", (String)"SimpleImportServiceCallable_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.feedbackTaskEntryResult(this.taskId, this.configInfo.getInstallInfo().getFormId(), 0, -2, null, failReason);
            return this.buildImportSimpleResult(new ImportSimpleResult(null, 0, 0, true, 1L, ImpFailCodeEnum.NO_PERMISSION, failReason), startTime);
        }
        String fileUrl = this.configInfo.getInstallInfo().getFileUrl();
        if (StringUtils.isEmpty((String)fileUrl)) {
            try {
                long convertStartTime = System.currentTimeMillis();
                List<String> sheetList = this.parseSheetList(entryByNumber.getString("sourcesheet"));
                Map<String, ExcelFieldInfoModel> modelMap = ExcelConvertHelper.diyTemplateDataPrepare(this.templateReadInfoModel, sheetList);
                Tuple<File, Integer> stdConvertResp = ExcelConvertHelper.doTemplateConvertAction(entryByNumber, modelMap, this.file, this.sheetDataInfo);
                logger.info("\u4e1a\u52a1\u5bf9\u8c61 {} \u8f6c\u6362\u6210\u529f\uff0c\u6761\u6570\u4e3a{} \u6587\u4ef6\u8def\u5f84\u4e3a{} \u8f6c\u6362\u65f6\u95f4 {}ms", new Object[]{installInfo.getFormId(), stdConvertResp.item2, stdConvertResp.item1, System.currentTimeMillis() - convertStartTime});
                this.configInfo.setFileDirectory(((File)stdConvertResp.item1).getParentFile().getAbsolutePath());
                this.configInfo.setFileName(((File)stdConvertResp.item1).getName());
                this.configInfo.setTotal((Integer)stdConvertResp.item2);
            }
            catch (Exception e) {
                logger.error("\u8f6c\u6362\u6807\u51c6\u6a21\u677f\u5931\u8d25", (Throwable)e);
                this.feedbackTaskEntryResult(this.taskId, this.configInfo.getInstallInfo().getFormId(), 0, -2, null, e.getMessage());
                return this.buildImportSimpleResult(new ImportSimpleResult(null, 0, 0, true, 1L, ImpFailCodeEnum.CONVERT, e.getMessage()), startTime);
            }
        }
        try {
            File tempFile = MultiImpAttachmentHelper.downloadFile(fileUrl, this.taskId + "_" + this.configInfo.getInstallInfo().getFormId(), "xlsx");
            this.configInfo.setFileDirectory(tempFile.getParentFile().getAbsolutePath());
            this.configInfo.setFileName(tempFile.getName());
        }
        catch (Exception e) {
            this.feedbackTaskEntryResult(this.taskId, this.configInfo.getInstallInfo().getFormId(), 0, -2, null, e.getMessage());
            return this.buildImportSimpleResult(new ImportSimpleResult(null, 0, 0, true, 1L, ImpFailCodeEnum.DOWWLOADFAIL, e.getMessage()), startTime);
        }
        logger.info("SimpleImportServiceCallable->call doTemplateConvertAction {} costtime {}ms", (Object)this.configInfo.getInstallInfo().getFormId(), (Object)(System.currentTimeMillis() - startTime));
        try {
            long importStartTime = System.currentTimeMillis();
            StdImportHandlerImpl importHandler = new StdImportHandlerImpl();
            SubDataInstallResult installResult = importHandler.executeImport(this.configInfo, true);
            Object logId = installResult.getLogId();
            logger.info(" Import End {} logId {} total {} fail {} Lang {} costtime {}ms", new Object[]{installResult.getReport(), logId, installResult.getTotal(), installResult.getFailed(), Lang.get(), System.currentTimeMillis() - importStartTime});
            logger.info("SimpleImportServiceCallable->call StdImportHandlerImpl.executeImport {} costtime {}ms", (Object)this.configInfo.getInstallInfo().getFormId(), (Object)(System.currentTimeMillis() - importStartTime));
            ImpFailCodeEnum resultCode = ImpFailCodeEnum.SUCCESS;
            String failReason = "";
            if (installResult.getTotal() <= 0 || installResult.getFailed() > 0) {
                resultCode = ImpFailCodeEnum.IMPFAIL;
                failReason = installResult.getTotal() == 0 ? (StringUtil.isNotEmpty(installResult.getReport()) ? installResult.getReport() : ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\u6216\u65e0\u4efb\u4f55\u5bfc\u5165\u6570\u636e\u3002", (String)"SimpleImportServiceCallable_1", (String)"imsc-dmw-platform", (Object[])new Object[0])) : (installResult.getTotal() == -1 ? ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c\u7b49\u5f85\u8d85\u8fc730\u5206\u949f\uff0c\u8bf7\u8fdb\u5165\u6807\u51c6\u5bfc\u5165\u7ed3\u679c\u67e5\u8be2\u9875\u9762\u67e5\u8be2\u6700\u7ec8\u7ed3\u679c\u3002", (String)"SimpleImportServiceCallable_2", (String)"imsc-dmw-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5bfc\u5165\u65e5\u5fd7\u3002", (String)"SimpleImportServiceCallable_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            this.feedbackTaskEntryResult(this.taskId, this.configInfo.getInstallInfo().getFormId(), installResult.getTotal(), installResult.getFailed(), logId, failReason);
            logger.info("SimpleImportServiceCallable->call {} costtime {}ms", (Object)this.configInfo.getInstallInfo().getFormId(), (Object)(System.currentTimeMillis() - startTime));
            ImportSimpleResult importSimpleResult = this.buildImportSimpleResult(new ImportSimpleResult(logId, installResult.getTotal(), installResult.getFailed(), true, System.currentTimeMillis() - startTime, resultCode, failReason), startTime);
            return importSimpleResult;
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            this.feedbackTaskEntryResult(this.taskId, this.configInfo.getInstallInfo().getFormId(), this.configInfo.getTotal(), this.configInfo.getTotal(), null, e.getMessage());
            ImportSimpleResult importSimpleResult = this.buildImportSimpleResult(new ImportSimpleResult(null, this.configInfo.getTotal(), this.configInfo.getTotal(), true, 1L, ImpFailCodeEnum.IMPFAIL, e.getMessage()), startTime);
            return importSimpleResult;
        }
        finally {
            FileUtils.deleteDirectory((File)new File(this.configInfo.getFileDirectory()));
        }
    }

    private ImportSimpleResult buildImportSimpleResult(ImportSimpleResult simpleResult, long startTime) {
        ImportSimpleResult result = simpleResult;
        result.setStartTime(startTime);
        result.setEndTime(System.currentTimeMillis());
        result.setFormId(this.configInfo.getInstallInfo().getFormId());
        result.setFormName(this.configInfo.getInstallInfo().getName());
        return result;
    }

    private List<String> parseSheetList(String sheetNames) {
        if (sheetNames.startsWith(",")) {
            sheetNames = sheetNames.replaceFirst(",", "");
        }
        return Arrays.asList(sheetNames.split(","));
    }

    private void feedbackTaskEntryResult(long taskId, String formId, int total, int fail, Object logId, String failReason) {
        MultiImpTaskExecResult importExecResult = new MultiImpTaskExecResult();
        importExecResult.setTaskId(taskId);
        MultiImpTaskDetailExecResult detailExecResult = new MultiImpTaskDetailExecResult(formId, total, fail < 0 ? 0 : fail, this.getStatus(total, fail), logId);
        detailExecResult.setFailReason(failReason);
        importExecResult.setDetailResults(Collections.singletonList(detailExecResult));
        logger.info("\u53cd\u9988\u5bfc\u5165\u7ed3\u679c {}", (Object)JSON.toJSONString((Object)importExecResult));
        MultiImpTaskHelper.updateEntryExecuteResult(importExecResult);
    }

    private MultiImpTaskEntryStatusEnum getStatus(int total, int failSize) {
        if (failSize == 0 && total > 0) {
            return MultiImpTaskEntryStatusEnum.SUCCESS;
        }
        if (failSize == -1) {
            return MultiImpTaskEntryStatusEnum.EXECUTING;
        }
        return MultiImpTaskEntryStatusEnum.FAIL;
    }
}

