/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.helper.ImportServiceManagerHelper;
import kd.imsc.dmw.engine.multiimport.model.SubDataConfigureInfo;
import kd.imsc.dmw.engine.multiimport.model.SubDataInstallInfo;
import kd.imsc.dmw.engine.multiimport.result.MultiImpTaskDetailExecResult;
import kd.imsc.dmw.engine.multiimport.result.MultiImpTaskExecResult;
import kd.imsc.dmw.enums.MultiImpTaskEntryStatusEnum;
import kd.imsc.dmw.enums.MultiImpTaskStatusEnum;
import kd.imsc.dmw.utils.DynamicObjectUtils;

public class MultiImpTaskHelper {
    private static final Log logger = LogFactory.getLog(MultiImpTaskHelper.class);
    private static final int FAIL_REASON_MAXLENGTH = 1000;

    private MultiImpTaskHelper() {
    }

    public static OperationResult terminateTasks(DynamicObject[] tasks) {
        if (tasks == null) {
            return new OperationResult();
        }
        Predicate<DynamicObject> entryFilter = entry -> {
            String entryStatus = entry.getString("execstatus");
            return StringUtils.isEmpty((String)entryStatus) || !MultiImpTaskEntryStatusEnum.SUCCESS.getStatus().equals(entryStatus) && !MultiImpTaskEntryStatusEnum.EXECUTING.getStatus().equals(entryStatus);
        };
        for (DynamicObject task : tasks) {
            ImportServiceManagerHelper.stopTaskById(task.getString("serviceid"));
        }
        MultiImpTaskHelper.setTaskStatus(tasks, MultiImpTaskStatusEnum.TERMINATE, MultiImpTaskEntryStatusEnum.TERMINATE, entryFilter);
        return MultiImpTaskHelper.saveTasks(tasks, null);
    }

    public static OperationResult executeTasks(DynamicObject[] tasks, Map<String, List<String>> opData) {
        if (tasks == null) {
            return new OperationResult();
        }
        if (opData != null && opData.size() > 0) {
            for (DynamicObject task : tasks) {
                String pkValue = task.getString("id");
                if (!opData.containsKey(pkValue)) continue;
                MultiImpTaskHelper.setTaskStatus(new DynamicObject[]{task}, MultiImpTaskStatusEnum.EXECUTING, null, null);
            }
        }
        return MultiImpTaskHelper.saveTasks(tasks, null);
    }

    public static Map<String, Object> buildExecParams(long taskId, List<DynamicObject> entries) {
        if (taskId <= 0L || CollectionUtils.isEmpty(entries)) {
            return new HashMap<String, Object>(0);
        }
        ArrayList<SubDataConfigureInfo> configInfos = new ArrayList<SubDataConfigureInfo>(entries.size());
        for (DynamicObject entry : entries) {
            DynamicObjectCollection impFiles;
            SubDataConfigureInfo configInfo = new SubDataConfigureInfo();
            SubDataInstallInfo installInfo = new SubDataInstallInfo();
            installInfo.setFormId(DynamicObjectUtils.getDynamicObjectStringValue(entry, "billentity", "target_formid"));
            installInfo.setName(DynamicObjectUtils.getDynamicObjectStringValue(entry, "billentity", "name"));
            installInfo.setCode(DynamicObjectUtils.getDynamicObjectStringValue(entry, "billentity", "importcode"));
            installInfo.setDataImportType(entry.getString("importtype"));
            installInfo.setKeyFields(entry.getString("replacekeyfield"));
            DynamicObjectCollection dynamicObjectCollection = impFiles = entry.getDynamicObjectType().getProperties().containsKey((Object)"impfile") ? entry.getDynamicObjectCollection("impfile") : null;
            if (impFiles != null && !impFiles.isEmpty()) {
                DynamicObject impFile = (DynamicObject)impFiles.get(0);
                installInfo.setFileUrl(DynamicObjectUtils.getDynamicObjectStringValue(impFile, "fbasedataid", "url"));
            }
            configInfo.setInstallInfo(installInfo);
            configInfos.add(configInfo);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("std_im_t_t", JSONObject.toJSONString(configInfos));
        params.put("im_t_id", taskId);
        return params;
    }

    private static void setTaskStatus(DynamicObject[] tasks, MultiImpTaskStatusEnum statusEnum, MultiImpTaskEntryStatusEnum entryStatusEnum, Predicate<DynamicObject> entryFilter) {
        if (tasks == null || tasks.length < 1) {
            return;
        }
        if (statusEnum != null) {
            for (DynamicObject task : tasks) {
                task.set("impstatus", (Object)statusEnum.getStatus());
            }
        }
        if (entryStatusEnum != null) {
            List entries = Arrays.stream(tasks).flatMap(t -> t.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
            if (entryFilter != null) {
                entries = entries.stream().filter(entryFilter).collect(Collectors.toList());
            }
            for (DynamicObject entry : entries) {
                entry.set("execstatus", (Object)entryStatusEnum.getStatus());
            }
        }
    }

    private static OperationResult saveTasks(DynamicObject[] tasks, Map<String, String> optionVariables) {
        OperateOption operateOption = OperateOption.create();
        if (optionVariables != null && !optionVariables.isEmpty()) {
            for (Map.Entry entry : optionVariables.entrySet()) {
                operateOption.setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (DynamicObject task : tasks) {
            task.set("modifier", (Object)RequestContext.get().getCurrUserId());
            task.set("modifytime", (Object)KDDateUtils.now());
        }
        return SaveServiceHelper.saveOperate((String)"dmw_imptask", (DynamicObject[])tasks, (OperateOption)operateOption);
    }

    public static Map<String, Object> getTaskAttachment(long taskId, String attachmentPanel) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"dmw_imptask", (Object)taskId, (String)attachmentPanel, (boolean)false);
        return CollectionUtils.isEmpty((Collection)attachments) ? new HashMap(0) : (Map)attachments.get(0);
    }

    public static String getImportFileUrl(long taskId) {
        Map<String, Object> importFile = MultiImpTaskHelper.getTaskAttachment(taskId, "attachmentpanelap");
        return importFile != null && !importFile.isEmpty() ? (String)importFile.get("url") : null;
    }

    public static <T extends Map> T deserializeOpCacheValue(OperateOption opOption, String cacheKey, Class<T> clz) {
        if (opOption == null || StringUtils.isEmpty((String)cacheKey) || clz == null) {
            return null;
        }
        String cachedString = opOption.getVariableValue(cacheKey, null);
        if (StringUtils.isEmpty((String)cachedString)) {
            return null;
        }
        try {
            return (T)((Map)SerializationUtils.fromJsonString((String)cachedString, clz));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static void importServiceIdWriteBack(long taskId, String serviceId) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"dmw_imptask", (QFilter[])new QFilter[]{filter});
        task.set("serviceid", (Object)serviceId);
        SaveServiceHelper.update((DynamicObject)task);
    }

    public static void updateExecuteResult(MultiImpTaskExecResult execResult) {
        MultiImpTaskHelper.updateExecuteResult(execResult, true);
    }

    public static void updateEntryExecuteResult(MultiImpTaskExecResult execResult) {
        MultiImpTaskHelper.updateExecuteResult(execResult, false);
    }

    private static void updateExecuteResult(MultiImpTaskExecResult execResult, boolean isUpdateHeadStatus) {
        if (execResult == null || execResult.getTaskId() <= 0L || CollectionUtils.isEmpty(execResult.getDetailResults())) {
            return;
        }
        Map<String, MultiImpTaskDetailExecResult> resultMap = execResult.getDetailResults().stream().filter(Objects::nonNull).collect(Collectors.toMap(MultiImpTaskDetailExecResult::getEntityNumber, r -> r, (v1, v2) -> v2));
        QFilter filter = new QFilter("id", "=", (Object)execResult.getTaskId());
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"dmw_imptask", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection entries = task.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            String entityNumber = DynamicObjectUtils.getDynamicObjectStringValue(entry, "billentity", "target_formid");
            MultiImpTaskDetailExecResult detailResult = resultMap.get(entityNumber);
            if (detailResult == null) continue;
            if (detailResult.getStatus() != null) {
                entry.set("execstatus", (Object)detailResult.getStatus().getStatus());
            }
            entry.set("cnt", (Object)detailResult.getCount());
            entry.set("failcnt", (Object)detailResult.getFailCount());
            entry.set("faillogid", detailResult.getLogId());
            String failReason = detailResult.getFailReason();
            if (StringUtils.isNotEmpty((String)failReason) && failReason.length() > 1000) {
                failReason = failReason.substring(0, 1000);
            }
            entry.set("failreason", (Object)failReason);
        }
        if (isUpdateHeadStatus) {
            MultiImpTaskHelper.setTaskStatusByEntryWhenExecuting(task);
        }
        SaveServiceHelper.update((DynamicObject)task);
    }

    public static void failTaskByEntityBeforeImport(long taskId, Collection<String> entityNumber) {
        MultiImpTaskHelper.failTask(taskId, entityNumber, null, null);
    }

    public static void failTaskWhenServiceTerminated(long taskId, Collection<String> entityNumbers) {
        MultiImpTaskEntryStatusEnum[] excludeStatus = new MultiImpTaskEntryStatusEnum[]{MultiImpTaskEntryStatusEnum.EXECUTING, MultiImpTaskEntryStatusEnum.SUCCESS, MultiImpTaskEntryStatusEnum.TERMINATE};
        String failReason = ResManager.loadKDString((String)"\u624b\u5de5\u7ec8\u6b62\u3002", (String)"MultiImpTaskHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        MultiImpTaskHelper.failTask(taskId, entityNumbers, excludeStatus, failReason);
    }

    private static void failTask(long taskId, Collection<String> entityNumbers, MultiImpTaskEntryStatusEnum[] excludeStatus, String failReason) {
        if (taskId <= 0L || CollectionUtils.isEmpty(entityNumbers)) {
            return;
        }
        List<Object> entries = MultiImpTaskHelper.getEntriesByEntityNumber(taskId, entityNumbers);
        if (excludeStatus != null && excludeStatus.length > 0) {
            List excludeStatusList = Arrays.stream(excludeStatus).filter(Objects::nonNull).map(MultiImpTaskEntryStatusEnum::getStatus).collect(Collectors.toList());
            entries = entries.stream().filter(e -> !excludeStatusList.contains(e.getString("execstatus"))).collect(Collectors.toList());
        }
        MultiImpTaskExecResult execResult = new MultiImpTaskExecResult(taskId);
        List detailExecResults = null;
        if (CollectionUtils.isNotEmpty(entries)) {
            detailExecResults = entries.stream().map(e -> {
                String formId = DynamicObjectUtils.getDynamicObjectStringValue(e, "billentity", "target_formid");
                MultiImpTaskDetailExecResult detailResult = new MultiImpTaskDetailExecResult(formId, MultiImpTaskEntryStatusEnum.FAIL);
                detailResult.setFailReason(failReason);
                return detailResult;
            }).collect(Collectors.toList());
        }
        execResult.setDetailResults(detailExecResults);
        MultiImpTaskHelper.updateExecuteResult(execResult);
    }

    public static String getTaskStatusByEntryStatus(DynamicObject task) {
        if (task == null) {
            return "";
        }
        MultiImpTaskStatusEnum taskStatusEnum = null;
        DynamicObjectCollection entries = task.getDynamicObjectCollection("entryentity");
        List entryStatus = entries.stream().map(e -> e.getString("execstatus")).collect(Collectors.toList());
        boolean hasExecutingEntry = entryStatus.stream().anyMatch(s -> MultiImpTaskEntryStatusEnum.EXECUTING.getStatus().equals(s));
        boolean hasFailedEntry = entryStatus.stream().anyMatch(s -> MultiImpTaskEntryStatusEnum.FAIL.getStatus().equals(s));
        List allSuccessList = entryStatus.stream().filter(s -> MultiImpTaskEntryStatusEnum.SUCCESS.getStatus().equals(s)).collect(Collectors.toList());
        if (hasExecutingEntry) {
            taskStatusEnum = MultiImpTaskStatusEnum.EXECUTING;
        } else if (hasFailedEntry) {
            taskStatusEnum = MultiImpTaskStatusEnum.FAIL;
        } else {
            MultiImpTaskStatusEnum multiImpTaskStatusEnum = taskStatusEnum = !allSuccessList.isEmpty() ? MultiImpTaskStatusEnum.SUCCESS : MultiImpTaskStatusEnum.SAVE;
        }
        if (taskStatusEnum != null && !MultiImpTaskStatusEnum.TERMINATE.getStatus().equals(task.getString("impstatus"))) {
            return taskStatusEnum.getStatus();
        }
        return task.getString("impstatus");
    }

    private static void setTaskStatusByEntryWhenExecuting(DynamicObject task) {
        if (task == null) {
            return;
        }
        task.set("impstatus", (Object)MultiImpTaskHelper.getTaskStatusByEntryStatus(task));
    }

    public static List<DynamicObject> getEntriesByEntityNumber(Object taskId, Collection<String> entityNumbers) {
        if (taskId == null) {
            return new ArrayList<DynamicObject>(0);
        }
        QFilter taskFilter = new QFilter("id", "=", taskId);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"dmw_imptask", (QFilter[])new QFilter[]{taskFilter});
        if (task == null) {
            return new ArrayList<DynamicObject>(0);
        }
        DynamicObjectCollection entries = task.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entries) && CollectionUtils.isNotEmpty(entityNumbers)) {
            return entries.stream().filter(entry -> entityNumbers.contains(DynamicObjectUtils.getDynamicObjectStringValue(entry, "billentity", "target_formid"))).collect(Collectors.toList());
        }
        return entries;
    }

    public static DynamicObject getTaskById(Object taskId) {
        QFilter taskFilter = new QFilter("id", "=", taskId);
        return BusinessDataServiceHelper.loadSingle((String)"dmw_imptask", (QFilter[])new QFilter[]{taskFilter});
    }

    public static DynamicObject[] getTaskByIds(Collection<Long> taskIds) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((Object[])taskIds.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"dmw_imptask"));
    }

    public static DynamicObject getEntryByNumber(Object taskId, String number) {
        List<DynamicObject> dyList = MultiImpTaskHelper.getEntriesByEntityNumber(taskId, Collections.singletonList(number));
        return CollectionUtils.isNotEmpty(dyList) ? dyList.get(0) : null;
    }
}

