/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.dmw.engine.multiimport.model.SubDataInstallResult;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.utils.FileUtils;

public class StdImportLoggerHelper {
    private static final Log logger = LogFactory.getLog(StdImportLoggerHelper.class);
    private static final long DEFAULT_TIMEOUT_30MIN = 0x6DDD00L;

    public static Object createImportLog(String name, String formId) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_importlog");
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)TimeServiceHelper.now());
        dyn.set("importtype", (Object)"1");
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            dyn.set("sourceObj_id", (Object)formId);
        }
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_importlog", dyn, null);
        dyn.set("billno", (Object)billno);
        Object[] result = SaveServiceHelper.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
        if (result == null || result.length == 0) {
            return null;
        }
        dyn = (DynamicObject)result[0];
        return dyn.getPkValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String wait2ImportEnd(Object logId, String formId, String pageId) {
        logger.info(logId + " start waiting " + System.currentTimeMillis());
        if (logId == null) {
            return ResManager.loadKDString((String)"\u67e5\u8be2\u5bfc\u5165\u65e5\u5fd7ID\u5f02\u5e38", (String)"StdImportLoggerHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        }
        String msg = "";
        int sleepSecond = 500;
        long start = System.currentTimeMillis();
        int interruptedCount = 0;
        int progress = 0;
        try {
            while (!StdImportLoggerHelper.isComplete(logId)) {
                block10: {
                    Integer lastProgress = StdImportLoggerHelper.getLatestProgress(pageId);
                    if (lastProgress > progress) {
                        progress = lastProgress;
                        start = System.currentTimeMillis();
                    }
                    if (System.currentTimeMillis() - start > 0x6DDD00L) {
                        throw new DmwImptException(ResManager.loadKDString((String)"\u5bfc\u5165\u5df2\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u53bb\u5355\u636e\u7684\u5217\u8868\u754c\u9762\u201c\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u201d", (String)"StdImportLoggerHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), 30001);
                    }
                    try {
                        Thread.sleep(sleepSecond);
                    }
                    catch (InterruptedException e) {
                        int n = interruptedCount;
                        interruptedCount = (byte)(interruptedCount + 1);
                        if (n <= 3) break block10;
                        logger.info(logId + " InterruptedException " + FileUtils.getExceptionDetailInfo((Throwable)e));
                        throw new DmwImptException(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5df2\u88ab\u591a\u6b21\u4e2d\u65ad\u3002", (String)"StdImportLoggerHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e, 3001);
                    }
                }
                sleepSecond = FileUtils.getDynamicSleepSecond((int)sleepSecond, (int)5000);
            }
        }
        catch (DmwImptException e) {
            msg = ResManager.loadKDString((String)"\u7b49\u5f85\u5bfc\u5165\u4efb\u52a1\u7ed3\u675f\u65f6\u53d1\u751f\u5f02\u5e38:", (String)"StdImportLoggerHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]) + e.getMessage() + logId;
        }
        logger.info(logId + " end waiting " + System.currentTimeMillis());
        return msg;
    }

    public static void parseExcelImportResult(Object importLogId, SubDataInstallResult result) {
        if (importLogId == null) {
            result.setError(ResManager.loadKDString((String)"\u67e5\u8be2\u5bfc\u5165\u65e5\u5fd7ID\u5f02\u5e38", (String)"StdImportLoggerHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObject log = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"id, importstatus, data, total, failed", (QFilter[])new QFilter("id", "=", importLogId).toArray());
        if (log == null) {
            result.setError(ResManager.loadKDString((String)"\u5bfc\u5165\u65e5\u5fd7\u672a\u6210\u529f\u67e5\u8be2\u5230\uff0c\u8bf7\u5230\u5355\u636e\u5217\u8868\u754c\u9762\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u8fdb\u884c\u786e\u8ba4\uff0c\u5bfc\u5165\u65e5\u5fd7id\uff1a", (String)"StdImportLoggerHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0])).append(importLogId.toString());
            return;
        }
        String data = log.getString("data");
        if (StringUtils.isEmpty((CharSequence)data)) {
            result.setError(ResManager.loadKDString((String)"\u5bfc\u5165\u65e5\u5fd7\u4e2d\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u5230\u5355\u636e\u5217\u8868\u754c\u9762\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u8fdb\u884c\u786e\u8ba4\uff0c\u5bfc\u5165\u65e5\u5fd7id\uff1a", (String)"StdImportLoggerHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0])).append(importLogId.toString());
            return;
        }
        JSONObject info = JSON.parseObject((String)data).getJSONObject("info");
        boolean success = true;
        for (Object value : info.values()) {
            ImportLogger importLogger = (ImportLogger)SerializationUtils.fromJsonString((String)value.toString(), ImportLogger.class);
            if (importLogger.getFailed() > 0) {
                success = false;
            } else if (importLogger.getTotal() <= 0) {
                success = false;
            }
            result.setTotal(result.getTotal() + importLogger.getTotal());
            result.setFailed(result.getFailed() + importLogger.getFailed());
            result.setSuccess(success);
            result.append(importLogger.toString());
        }
    }

    private static Integer getLatestProgress(String pageId) {
        IPageCache cache = SessionManager.getCurrent().getPageCache(pageId);
        if (cache == null) {
            return 0;
        }
        String importLog = cache.get("Cached_Import_Logger");
        if (StringUtils.isEmpty((CharSequence)importLog)) {
            return 0;
        }
        JSONObject map = JSON.parseObject((String)importLog);
        logger.info("");
        Object obj = map.get((Object)"progress");
        if (obj != null && !"".equals(obj)) {
            try {
                return Integer.parseInt(String.valueOf(obj).trim());
            }
            catch (NumberFormatException e) {
                logger.info("ExcelImpl.import.getProgress\u51fa\u73b0\u8f6c\u6362\u95ee\u9898\uff0c\u65e0\u6cd5\u5c06\u83b7\u53d6\u7684progress\u8f6c\u6362\u6210int\uff1a{}", obj);
            }
        }
        return 0;
    }

    public static boolean isComplete(Object logId) {
        return QueryServiceHelper.exists((String)"bos_importlog", (QFilter[])new QFilter("id", "=", logId).and("importstatus", "=", (Object)"1").toArray());
    }

    public static String getImportLogResultToUrl(Object logId) throws DmwImptException {
        if (logId == null) {
            return null;
        }
        DynamicObject log = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"id, creator, data, isdeleted", (QFilter[])new QFilter("id", "=", logId).toArray());
        if (log == null) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u67e5\u8be2\u5bfc\u5165\u65e5\u5fd7ID\u5f02\u5e38", (String)"StdImportLoggerHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), 404);
        }
        if ("1".equals(log.getString("isdeleted"))) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u5bfc\u5165\u65e5\u5fd7\u7ed3\u679c\u6587\u4ef6\u88ab\u5220\u9664", (String)"StdImportLoggerHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]), 404);
        }
        String dataStr = log.getString("data");
        if (StringUtils.isEmpty((CharSequence)dataStr)) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u5bfc\u5165\u7ed3\u679c\u4fe1\u606f", (String)"StdImportLoggerHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]), 404);
        }
        try {
            JSONObject dataObj = JSON.parseObject((String)dataStr);
            JSONObject info = dataObj.getJSONObject("info");
            long userObj = log.getLong("creator");
            long curUserId = UserServiceHelper.getCurrentUserId();
            if (!StringUtils.equals((CharSequence)String.valueOf(userObj), (CharSequence)String.valueOf(curUserId))) {
                throw new DmwImptException(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u67e5\u770b\u5bfc\u5165\u65e5\u5fd7\uff0c\u8be5\u5bfc\u5165\u4efb\u52a1\u5e76\u975e\u672c\u4eba\u521b\u5efa", (String)"StdImportLoggerHelper_8", (String)"imsc-dmw-platform", (Object[])new Object[0]), 404);
            }
            for (Object value : info.values()) {
                ImportLogger importLogger = (ImportLogger)SerializationUtils.fromJsonString((String)value.toString(), ImportLogger.class);
                String errFile = importLogger.getErrFile();
                if (StringUtils.isEmpty((CharSequence)errFile)) continue;
                return errFile;
            }
        }
        catch (Exception e) {
            throw new DmwImptException(e.getMessage(), (Throwable)e, 404);
        }
        return null;
    }
}

