/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldMappingInfoModel;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;

public class ExcelRowInfoModel
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1894431991802138724L;
    private static final Log logger = LogFactory.getLog(ExcelRowInfoModel.class);
    private List<ExcelFieldMappingInfoModel> excelFieldInfoModelList;
    private Map<Integer, String> rowDataMap = new HashMap<Integer, String>(16);
    private static ExcelRowInfoModel mappingModel = new ExcelRowInfoModel();

    public static ExcelRowInfoModel getInstance() {
        try {
            return (ExcelRowInfoModel)mappingModel.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error((Throwable)e);
            return new ExcelRowInfoModel();
        }
    }

    public List<ExcelFieldMappingInfoModel> getExcelFieldInfoModelList() {
        return this.excelFieldInfoModelList;
    }

    public void setExcelFieldInfoModelList(List<ExcelFieldMappingInfoModel> excelFieldInfoModelList, Map<Integer, String> rowDataMap) {
        this.rowDataMap = rowDataMap;
        this.excelFieldInfoModelList = excelFieldInfoModelList;
    }

    public Map<Integer, String> getRowDataMap() {
        return this.rowDataMap;
    }

    public String getFieldValue(ExcelFieldMappingInfoModel fieldMapInfo, Map<String, List<ExcelRowInfoModel>> relSheetMap) {
        String expression = fieldMapInfo.getExpression();
        if (StringUtil.isNotEmpty(expression)) {
            BOSExpression bosExpression = new BOSExpression(expression);
            HashMap<String, Object> ctx = new HashMap<String, Object>(10);
            Map<String, List<ExcelFieldMappingInfoModel>> expressionFieldMap = fieldMapInfo.getExpressionFieldMap();
            for (Map.Entry<String, List<ExcelFieldMappingInfoModel>> mapEntry : expressionFieldMap.entrySet()) {
                List<ExcelFieldMappingInfoModel> expressionFieldList = mapEntry.getValue();
                block3: for (ExcelFieldMappingInfoModel expressionMapInfo : expressionFieldList) {
                    Map<Integer, String> relRowDataMap = this.rowDataMap;
                    if (!CommonUtils.isNull(relSheetMap)) {
                        for (Map.Entry<Object, Object> entry : relSheetMap.entrySet()) {
                            if (!mapEntry.getKey().equals(((String)entry.getKey()).split("\\.")[0])) continue;
                            List rowList = (List)entry.getValue();
                            relRowDataMap = ((ExcelRowInfoModel)rowList.get(rowList.size() - 1)).getRowDataMap();
                            break;
                        }
                    }
                    for (Map.Entry<Object, Object> entry : relRowDataMap.entrySet()) {
                        if (expressionMapInfo.getCustomColumnIndex() != ((Integer)entry.getKey()).intValue()) continue;
                        ctx.put(expressionMapInfo.getCustomFieldKey(), this.parseValue(expression, expressionMapInfo.getCustomFieldKey(), (String)entry.getValue()));
                        continue block3;
                    }
                }
            }
            BOSUDFunction[] functions = this.createUdFunctions(bosExpression.getFuncs());
            try {
                return String.valueOf(FormulaEngine.execExcelFormula((Expr)bosExpression.getExpr(), ctx, (UDFunction[])functions));
            }
            catch (Exception e) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u53d6\u503c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u5bfc\u5165\u65b9\u6848\u5b57\u6bb5\u6620\u5c04\u4e2d\u3010%1$s(%2$s)\u3011\u5b57\u6bb5\u914d\u7f6e\u7684\u8ba1\u7b97\u516c\u5f0f\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%3$s\u3002", (String)"ExcelRowInfoModel_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), fieldMapInfo.getStdFieldKey(), fieldMapInfo.getStdFieldName(), e.getMessage() == null ? e : e.getMessage());
                logger.error(errMsg, (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("ExcelRowInfoModel.getFieldValue", errMsg), new Object[0]);
            }
        }
        for (Map.Entry<Integer, String> entry : this.rowDataMap.entrySet()) {
            if (fieldMapInfo.getCustomColumnIndex() != entry.getKey().intValue()) continue;
            return entry.getValue();
        }
        return "";
    }

    private Object parseValue(String expression, String fieldKey, String value) {
        if (StringUtil.isEmpty(value)) {
            return value;
        }
        String newValue = value.trim();
        String errorInfo = "expression:" + expression + "field:" + fieldKey + "fieldvalue:" + value;
        if (newValue.indexOf(48) == 0) {
            return value;
        }
        try {
            return Integer.valueOf(newValue);
        }
        catch (NumberFormatException e) {
            logger.error(errorInfo);
            try {
                return Long.valueOf(newValue);
            }
            catch (NumberFormatException e2) {
                logger.error(errorInfo);
                try {
                    return new BigDecimal(newValue);
                }
                catch (NumberFormatException e3) {
                    logger.error(errorInfo);
                    return value;
                }
            }
        }
    }

    private BOSUDFunction[] createUdFunctions(Set<String> funcs) {
        BOSExpressionContext expContext = new BOSExpressionContext(null);
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        FunctionTypes cloudFunc = ConvertFuncLoader.loadBizCloudFuncTypes();
        functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(cloudFunc.getFunctionTypes());
        FunctionManage funcLib = FunctionManage.get((FunctionTypes)functionTypes);
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>(16);
        for (String funcName : funcs) {
            if (!funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)funcLib.getFuncMap().get(funcName)).getInstance((ExpressionContext)expContext);
            instances.add(instance);
        }
        return instances.toArray(new BOSUDFunction[0]);
    }
}

