/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExportHelper {
    private static final Log logger = LogFactory.getLog(ExcelExportHelper.class);

    public static void exportMapToExcel(String name, List<String> headData, Map<String, List<Object>> dataMap, IFormView view) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(name);
        CellStyle headStyle = workbook.createCellStyle();
        headStyle.setWrapText(true);
        headStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Row headerRow = sheet.createRow(0);
        for (int i = 0; i < headData.size(); ++i) {
            Cell cell = headerRow.createCell(i);
            ExcelExportHelper.setCellValue(cell, headData.get(i));
            cell.setCellStyle(headStyle);
            sheet.setColumnWidth(i, 6000);
        }
        CellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        int rowIndex = 1;
        for (List<Object> rowData : dataMap.values()) {
            Row row = sheet.createRow(rowIndex++);
            int columnIndex = 0;
            for (Object cellData : rowData) {
                Cell cell = row.createCell(columnIndex);
                ExcelExportHelper.setCellValue(cell, cellData);
                cell.setCellStyle(style);
                sheet.setColumnWidth(columnIndex++, 6000);
            }
        }
        StringBuilder fileName = new StringBuilder(name).append(".xlsx");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)byteArrayOutputStream);
            byte[] array = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream ins = new ByteArrayInputStream(array);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName.toString(), (InputStream)ins, 5000);
            view.openUrl(url);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("ExcelExportHelper error:%s.", e.getMessage())});
        }
    }

    private static void setCellValue(Cell cell, Object cellData) {
        if (cellData instanceof String) {
            cell.setCellValue((String)cellData);
        } else if (cellData instanceof Integer) {
            cell.setCellValue((double)((Integer)cellData).intValue());
        } else if (cellData instanceof Double) {
            cell.setCellValue(((Double)cellData).doubleValue());
        } else if (cellData instanceof Boolean) {
            cell.setCellValue(((Boolean)cellData).booleanValue());
        } else {
            cell.setCellValue(cellData.toString());
        }
    }
}

