/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.helper.ReadSheetRowHandler;
import kd.imsc.dmw.utils.FileUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelReader {
    private static final Log logger = LogFactory.getLog(ExcelReader.class);

    public void read(InputStream in, List<String> sheetNameList, ReadSheetRowHandler sheetHandler) throws Exception {
        XSSFReader reader = this.getXSSFReader(in);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)reader.getSheetsData();
        CommonReaderWay readerWay = new CommonReaderWay(sheetHandler, this.getXMLReader(reader, sheetHandler), sheets);
        while (sheets.hasNext()) {
            long startTime = System.currentTimeMillis();
            InputStream sheetStream = sheets.next();
            String sheetName = sheets.getSheetName();
            if (sheetNameList.contains(sheetName.trim())) {
                readerWay.handle(sheetStream, sheetName);
                logger.info("ExcelReader.read:" + sheetName + " end:" + (System.currentTimeMillis() - startTime));
                if (readerWay.interrupt(sheetStream, sheetName)) break;
            }
            sheetStream.close();
        }
    }

    public void read(InputStream in, SheetHandler sheetHandler) throws Exception {
        XSSFReader reader = this.getXSSFReader(in);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)reader.getSheetsData();
        HashSet<String> sheetNames = new HashSet<String>(16);
        while (sheets.hasNext()) {
            sheets.next();
            if (!StringUtils.isNotBlank((CharSequence)sheets.getSheetName())) continue;
            sheetNames.add(sheets.getSheetName());
        }
        sheetNames.remove("dropdown_items_sheet");
        sheetNames.remove("basedata_items_sheet");
        sheetHandler.setSheetNames(sheetNames);
        sheets = (XSSFReader.SheetIterator)reader.getSheetsData();
        CommonReaderWay readerWay = new CommonReaderWay(sheetHandler, this.getXMLReader(reader, sheetHandler), sheets);
        while (sheets.hasNext()) {
            InputStream sheet = sheets.next();
            String sheetName = sheets.getSheetName();
            if (!sheetNames.contains(sheetName)) continue;
            readerWay.handle(sheet, sheetName);
            if (!readerWay.interrupt(sheet, sheetName)) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSSFReader getXSSFReader(InputStream in) throws Exception {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            OPCPackage pkg = OPCPackage.open((File)tempFile);
            XSSFReader reader = new XSSFReader(pkg);
            reader.setUseReadOnlySharedStringsTable(false);
            XSSFReader xSSFReader = reader;
            return xSSFReader;
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                boolean delete = tempFile.delete();
                logger.info("\u91ca\u653e\u8d44\u6e90\uff0c\u5220\u9664\u6587\u4ef6{}", (Object)delete);
            }
        }
    }

    private XMLReader getXMLReader(XSSFReader reader, SheetHandler sheetHandler) throws Exception {
        sheetHandler.setSharedStringsTable((SharedStringsTable)reader.getSharedStringsTable());
        sheetHandler.setStylesTable(reader.getStylesTable());
        XMLReader parser = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
        parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parser.setContentHandler((ContentHandler)sheetHandler);
        return parser;
    }

    static class CommonReaderWay
    implements ReaderWay {
        protected SheetHandler sheetHandler;
        protected XMLReader parser;
        protected XSSFReader.SheetIterator sheets;

        public CommonReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            this.sheetHandler = sheetHandler;
            this.parser = parser;
            this.sheets = sheets;
        }

        @Override
        public void handle(InputStream sheet, String sheetName) throws Exception {
            InputSource sheetSource = new InputSource(sheet);
            if (StringUtils.isNotBlank((CharSequence)sheetName)) {
                this.sheetHandler.setSheetName(sheetName);
                Comments comments = this.sheets.getSheetComments();
                if (comments != null) {
                    this.sheetHandler.addSheetComments(sheetName, (CommentsTable)comments);
                }
                this.parser.parse(sheetSource);
            }
        }

        @Override
        public boolean interrupt(InputStream sheet, String sheetName) {
            if (StringUtils.isNotBlank((CharSequence)sheetName)) {
                return this.sheetHandler.isInterrupt();
            }
            return true;
        }
    }

    static interface ReaderWay {
        public void handle(InputStream var1, String var2) throws Exception;

        public boolean interrupt(InputStream var1, String var2);
    }
}

