/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.engine.multiimport.model.AllEntityDataInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelSheetMappingModel;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.ExcelReader;
import kd.imsc.dmw.helper.ReadSheetRowHandler;
import kd.imsc.dmw.utils.CommonUtils;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportExcelReadHelper {
    private static final Log logger = LogFactory.getLog(ImportExcelReadHelper.class);

    private ImportExcelReadHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Tuple<List<String>, Map<String, List<ExcelFieldInfoModel>>> getAllSheetInfo(InputStream inputStream, int rowIndex, boolean needHide) throws DmwImptException {
        if (inputStream == null) {
            throw new DmwImptException("inputStream is null", 1001);
        }
        try (XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);){
            int sheetNum = xssfWorkbook.getNumberOfSheets();
            ArrayList<String> sheetNameList = new ArrayList<String>(16);
            HashMap sheetInfoMap = new HashMap(16);
            int i = 0;
            while (true) {
                block21: {
                    ArrayList<ExcelFieldInfoModel> columns;
                    short lastCellNum;
                    XSSFRow row;
                    String sheetName;
                    XSSFSheet sheetAt;
                    block22: {
                        block20: {
                            if (i >= sheetNum) break block20;
                            boolean sheetHidden = xssfWorkbook.isSheetHidden(i);
                            if (sheetHidden && !needHide) break block21;
                            sheetAt = xssfWorkbook.getSheetAt(i);
                            int firstRowNum = sheetAt.getFirstRowNum();
                            int lastRowNum = sheetAt.getLastRowNum();
                            sheetName = sheetAt.getSheetName().trim();
                            if (firstRowNum > rowIndex || lastRowNum < rowIndex) {
                                throw new DmwImptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4f20\u5165\u5f02\u5e38\uff0c\u9875\u7b7e[%1$s]\u4e3a\u7a7a\u6216\u8005\u5f02\u5e38\u3002", (String)"ImportExcelReadHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), sheetName), 1001);
                            }
                            row = sheetAt.getRow(rowIndex);
                            int firstCellNum = row.getFirstCellNum();
                            lastCellNum = row.getLastCellNum();
                            columns = new ArrayList<ExcelFieldInfoModel>(8);
                            break block22;
                        }
                        Tuple tuple = Tuple.create(sheetNameList, sheetInfoMap);
                        return tuple;
                    }
                    for (int j = firstCellNum; j < lastCellNum; ++j) {
                        XSSFCell cell = row.getCell(j);
                        if (cell == null) {
                            throw new DmwImptException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u5b58\u5728\u5f02\u5e38\uff0c\u9875\u7b7e[%1$s]\u4e2d\u7b2c[%2$d]\u884c\u7b2c[%3$s]\u5217\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u5f02\u5e38\u3002", (String)"ImportExcelReadHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), sheetName, rowIndex + 1, ImportExcelReadHelper.convertToLetterColumnName(j + 1)), 1001);
                        }
                        ExcelFieldInfoModel excelFieldInfoModel = new ExcelFieldInfoModel();
                        excelFieldInfoModel.setRow(i);
                        excelFieldInfoModel.setColumn(j);
                        excelFieldInfoModel.setColumnLetter(ImportExcelReadHelper.convertToLetterColumnName(j + 1));
                        excelFieldInfoModel.setValue(cell.toString().trim());
                        excelFieldInfoModel.setSheetNumber("S" + (i + 1));
                        excelFieldInfoModel.setSheetName(sheetAt.getSheetName());
                        columns.add(excelFieldInfoModel);
                    }
                    sheetNameList.add(sheetName);
                    sheetInfoMap.put(sheetName, columns);
                }
                ++i;
            }
        }
        catch (IOException e) {
            logger.error("ImportExcelReadHelper->getAllSheetInfo->IOException:", (Throwable)e);
            throw new DmwImptException("File IO Exception", (Throwable)e, 1001);
        }
        catch (NotOfficeXmlFileException e2) {
            logger.error("ImportExcelReadHelper->getAllSheetInfo->NotOfficeXmlFileException:", (Throwable)e2);
            throw new DmwImptException(ResManager.loadKDString((String)"\u6587\u4ef6\u4f20\u5165\u5f02\u5e38\uff0c\u9875\u7b7e\u4e3a\u7a7a\u6216\u8005\u5f02\u5e38\u3002", (String)"ImportExcelReadHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e2, 1001);
        }
    }

    public static String convertToLetterColumnName(int columnNumber) {
        if (columnNumber <= 0 || columnNumber > 230) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        while (columnNumber > 0) {
            str.append((char)(--columnNumber % 26 + 65));
            columnNumber /= 26;
        }
        return str.reverse().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AllEntityDataInfoModel batchReadRowContentByFile(File file, List<ExcelSheetMappingModel> sheetMappingList) throws KDException {
        if (file == null || !file.exists() || CommonUtils.isNull(sheetMappingList)) {
            throw new KDException(new ErrorCode("", ""), new Object[]{"file or sheetName is null", 1001});
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ExcelReader excelReader = new ExcelReader();
            ReadSheetRowHandler rowHandler = new ReadSheetRowHandler(sheetMappingList);
            ArrayList<String> sheetNameList = new ArrayList<String>(16);
            for (ExcelSheetMappingModel excelSheetMappingModel : sheetMappingList) {
                sheetNameList.addAll(excelSheetMappingModel.getFormIdMap().keySet());
            }
            excelReader.read(fileInputStream, sheetNameList, rowHandler);
            AllEntityDataInfoModel allEntityDataInfoModel = rowHandler.getAllEntityDataInfo();
            return allEntityDataInfoModel;
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("", ""), new Object[]{ResManager.loadKDString((String)"\u6587\u4ef6\u4f20\u5165\u5f02\u5e38\uff0c\u9875\u7b7e\u4e3a\u7a7a\u6216\u8005\u5f02\u5e38\u3002", (String)"ImportExcelReadHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), e, 1001});
        }
    }

    public static <T> List<T> getSameElements(List<T> list1, List<T> list2) {
        if (list1 == null || list2 == null) {
            return new ArrayList(0);
        }
        logger.info("list1 fields {}", (Object)JSON.toJSONString(list1));
        logger.info("list2 fields {}", (Object)JSON.toJSONString(list2));
        return list1.stream().filter(list2::contains).collect(Collectors.toList());
    }

    public static List<String> mapFields(List<ExcelFieldInfoModel> list1) {
        if (list1 == null) {
            return new ArrayList<String>(0);
        }
        return list1.stream().map(ExcelFieldInfoModel::getValue).collect(Collectors.toList());
    }
}

