/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.imsc.dmw.consts.AttachmentConst;
import kd.imsc.dmw.engine.multiimport.model.BizOperationResult;
import kd.imsc.dmw.helper.MulImportCheckerProxy;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.dmw.utils.ImptFileUtils;

public class MultiImpAttachmentHelper {
    private static final Log logger = LogFactory.getLog(MultiImpAttachmentHelper.class);

    public static Map<String, Object> copyAttachmentToPage(String srcEntityNumber, Object srcPkValue, String srcAttachmentPanel, String destEntityNumber, String destAttachmentPanel, IFormView destView) throws KDBizException {
        MultiImpAttachmentInfo srcAttachment;
        String attachmentPageCacheKey;
        if (destView == null) {
            return new HashMap<String, Object>(0);
        }
        Map attachmentCache = new HashMap(1);
        String pageId = destView.getPageId();
        IPageCache pageCache = destView.getPageCache();
        String attachmentCachedString = pageCache.get(attachmentPageCacheKey = "TampAttCache" + pageId);
        if (StringUtils.isNotEmpty((CharSequence)attachmentCachedString)) {
            attachmentCache = (Map)SerializationUtils.fromJsonString((String)attachmentCachedString, Map.class);
            attachmentCache.remove(destAttachmentPanel);
            pageCache.put(attachmentPageCacheKey, SerializationUtils.toJsonString(attachmentCache));
        }
        if ((srcAttachment = MultiImpAttachmentHelper.getSrcEntityAttachment(srcEntityNumber, srcPkValue, srcAttachmentPanel)) == null) {
            return new HashMap<String, Object>(0);
        }
        ArrayList<HashMap<String, Object>> destAttachmentList = new ArrayList<HashMap<String, Object>>();
        Map<String, Object> destTempFile = new HashMap<String, Object>(0);
        try (InputStream in = MultiImpAttachmentHelper.getAttachmentInputStreamFromUrl(srcAttachment.getUrl());){
            if (in != null) {
                destTempFile = MultiImpAttachmentHelper.createDestTempFileFromSrcAttachment(destEntityNumber, in, srcAttachment);
                destAttachmentList.add((HashMap<String, Object>)destTempFile);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return destTempFile;
        }
        attachmentCache.put(destAttachmentPanel, destAttachmentList);
        pageCache.put(attachmentPageCacheKey, SerializationUtils.toJsonString(attachmentCache));
        return destTempFile;
    }

    public static InputStream getAttachmentInputStreamFromUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        try {
            if (url.contains("tempfile/download.do?configKey")) {
                return CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);
            }
            return FileServiceFactory.getAttachmentFileService().getInputStream(MultiImpAttachmentHelper.getAttachmentRelativePath(url));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File downloadFile(String url, String fileName, String fileFormat) throws Exception {
        if (StringUtils.isEmpty((CharSequence)url)) return null;
        if (StringUtils.isEmpty((CharSequence)fileName)) return null;
        if (StringUtils.isEmpty((CharSequence)fileFormat)) {
            return null;
        }
        String relPath = MultiImpAttachmentHelper.getAttachmentRelativePath(url);
        String timeStamp = new SimpleDateFormat("yyyyMMddHHmmssSS").format(new Date());
        String dir = String.format("%d_%s", UserServiceHelper.getCurrentUserId(), timeStamp);
        File targetFile = ImptFileUtils.createTempFile(dir, fileName, String.format(".%s", fileFormat));
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            FileServiceFactory.getAttachmentFileService().download(relPath, (OutputStream)fos, "imsc-dmw");
            File file = targetFile;
            return file;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File downloadFileWithFileName(String url, File dir, String fileName) throws IOException {
        if (StringUtils.isEmpty((CharSequence)url)) return null;
        if (dir == null) return null;
        if (!dir.exists()) return null;
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        File targetFile = new File(dir.getAbsolutePath() + File.separator + fileName);
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            String relPath = MultiImpAttachmentHelper.getAttachmentRelativePath(url);
            FileServiceFactory.getAttachmentFileService().download(relPath, (OutputStream)fos, "imsc-dmw");
            File file = targetFile;
            return file;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static String getAttachmentRelativePath(String path) throws Exception {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return path;
        }
        if (path.contains("path=")) {
            path = StringUtils.substringAfter((String)path, (String)"path=");
        }
        path = URLDecoder.decode(path, "UTF-8");
        path = path.replaceFirst("//", "");
        return FilePathUtil.dealPath((String)path, (String)"attach");
    }

    public static MultiImpAttachmentInfo getSrcEntityAttachment(String srcEntityNumber, Object srcPkValue, String srcAttachmentPanel) {
        List attachments = AttachmentServiceHelper.getAttachments((String)srcEntityNumber, (Object)srcPkValue, (String)srcAttachmentPanel);
        if (attachments.isEmpty()) {
            return null;
        }
        MultiImpAttachmentInfo attachment = new MultiImpAttachmentInfo();
        Map attachmentInfo = (Map)attachments.get(0);
        AttachmentDto attachmentDto = AttachmentServiceHelper.getAttachmentInfoByAttPk(attachmentInfo.get("attPkId"));
        attachment.setName((String)attachmentInfo.get("name")).setUid((String)attachmentInfo.get("uid")).setType(AttachmentConst.FILE_TYPE_MAP.get((String)attachmentInfo.get("type"))).setUrl(attachmentDto.getResourcePath()).setSize((Long)attachmentInfo.get("size"));
        return attachment;
    }

    private static Map<String, Object> createDestTempFileFromSrcAttachment(String destEntityNumber, InputStream in, MultiImpAttachmentInfo srcAttachment) {
        String fileName = srcAttachment.getName();
        String fileType = srcAttachment.getType();
        HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
        attachMap.put("entityNum", destEntityNumber);
        long time = System.currentTimeMillis();
        attachMap.put("createdate", time);
        attachMap.put("lastModified", time);
        attachMap.put("name", srcAttachment.getName());
        try {
            attachMap.put("size", in.available());
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        attachMap.put("status", "success");
        attachMap.put("type", fileType);
        attachMap.put("uid", AttachmentServiceHelper.generateUid());
        StringBuilder newUrl = new StringBuilder();
        String contextPath = RequestContext.get().getClientFullContextPath();
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        newUrl.append(contextPath);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = tempFileCache.saveAsUrl(fileName, in, 7200);
        newUrl.append(tempUrl);
        attachMap.put("url", newUrl);
        attachMap.put("size", srcAttachment.getSize());
        return attachMap;
    }

    public static void uploadByAttachUrl(String fileName, String attchUrl, Object destBillPkId, String destEntityNumber, String destAttachmentPanel) {
        ArrayList destAttachmentList = new ArrayList();
        Map<Object, Object> destTempFile = new HashMap(0);
        try (InputStream in = MultiImpAttachmentHelper.getAttachmentInputStreamFromUrl(attchUrl);){
            if (in != null) {
                String appNumberPath = "/tenant_devother_dev/1150102438640877568/202403/dmw/dmw_imptask/1901467272988425216/attachments";
                String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), StandardCharsets.UTF_8).toString();
                String uploadPath = String.join((CharSequence)File.separator, appNumberPath, traceIdHash, fileName);
                FileItem fi = new FileItem(fileName, uploadPath, in);
                FileService fs = FileServiceFactory.getAttachmentFileService();
                String realUrl = fs.upload(fi);
                String type = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                destTempFile = MultiImpAttachmentHelper.createUploadFileMap(destEntityNumber, fileName, type, realUrl, 21071L);
                destAttachmentList.add(destTempFile);
                AttachmentServiceHelper.upload((String)destEntityNumber, (Object)destBillPkId, (String)destAttachmentPanel, destAttachmentList);
                List taskAttachments = AttachmentServiceHelper.getAttachments((String)destEntityNumber, (Object)destBillPkId, (String)destAttachmentPanel);
                if (!taskAttachments.isEmpty()) {
                    Map attachMap = (Map)taskAttachments.get(0);
                    FileUtils.syncWriteFileBillMapping((String)((String)attachMap.get("name")), (String)"dmw", (String)((String)attachMap.get("url")), (String)destEntityNumber, (String)destAttachmentPanel, (String)String.valueOf(destBillPkId), (String)"", (long)Long.parseLong(attachMap.get("attPkId").toString()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static Map<String, Object> createUploadFileMap(String destEntityNumber, String fileName, String fileType, String realUrl, long size) {
        HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
        attachMap.put("entityNum", destEntityNumber);
        long time = System.currentTimeMillis();
        attachMap.put("createdate", time);
        attachMap.put("lastModified", time);
        attachMap.put("name", fileName);
        attachMap.put("status", "success");
        attachMap.put("type", fileType);
        attachMap.put("uid", AttachmentServiceHelper.generateUid());
        attachMap.put("url", realUrl);
        attachMap.put("size", size);
        return attachMap;
    }

    public static BizOperationResult validateFileBySchemeTpl(String importFileUrl, String modelInfo) {
        BizOperationResult checkResult = new BizOperationResult(true);
        if (StringUtils.isEmpty((CharSequence)importFileUrl)) {
            return checkResult;
        }
        InputStream inStream = MultiImpAttachmentHelper.getAttachmentInputStreamFromUrl(importFileUrl);
        checkResult = MulImportCheckerProxy.invokePostDataChecker(inStream, modelInfo);
        return checkResult;
    }

    public static class MultiImpAttachmentInfo {
        private String name;
        private String type;
        private String uid;
        private String url;
        private Long size;

        public MultiImpAttachmentInfo() {
        }

        public MultiImpAttachmentInfo(String name, String type, String uid, String url) {
            this.name = name;
            this.type = type;
            this.uid = uid;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public MultiImpAttachmentInfo setName(String name) {
            this.name = name;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public MultiImpAttachmentInfo setType(String type) {
            this.type = type;
            return this;
        }

        public String getUid() {
            return this.uid;
        }

        public MultiImpAttachmentInfo setUid(String uid) {
            this.uid = uid;
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public MultiImpAttachmentInfo setUrl(String url) {
            this.url = url;
            return this;
        }

        public Long getSize() {
            return this.size;
        }

        public MultiImpAttachmentInfo setSize(Long size) {
            this.size = size;
            return this;
        }
    }
}

