/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.model.EntryObjectFieldModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldInfoModel;
import kd.imsc.dmw.engine.multiimport.model.FieldMappingModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTemplateReadInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ViewSchemeBaseInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ViewSchemeMappingInfoModel;
import kd.imsc.dmw.enums.MultiImpTaskEntryStatusEnum;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.CopyFileHelper;
import kd.imsc.dmw.helper.IImportStepListener;
import kd.imsc.dmw.helper.MulImportCheckerProxy;
import kd.imsc.dmw.helper.SchemeDataPackageTransHelper;
import kd.imsc.dmw.helper.TemplateMappingHelper;
import kd.imsc.dmw.helper.checker.DataCheckerBuilderFactory;
import kd.imsc.dmw.helper.checker.IDataChecker;
import kd.imsc.dmw.helper.checker.SchemeImportChecker;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.ImptFileUtils;
import kd.imsc.dmw.utils.ObjectUtils;
import kd.imsc.dmw.utils.StringUtil;

public class MultiImpSchemeHelper {
    private static final Log logger = LogFactory.getLog(MultiImpSchemeHelper.class);
    public static final String BASE = "b";
    public static final String MAPPING = "m";
    public static final String TEMPLATE = "t";
    public static final String TEMPLATE_NAME = "t_n";
    public static final String SCHEMEDETAILNAME = "d";
    public static final String SCHEMEDETAILFILENAME_FORMAT = "sch";
    public static final String SCHEMEDETAILFILENAME = "d.sch";
    private static final byte[] SCHEME_HEADER = "FESFESFESAFSEFEAFEASEFSEFSEF".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SCHEME_TAIL = "FSDFSDASFSFSDADFASDFEFESFSDFE".getBytes(StandardCharsets.UTF_8);
    private static final Map<String, String> ENTRY_FIELDS_ID_NAMES;

    private MultiImpSchemeHelper() {
    }

    public static void createEntryByScheme(DynamicObject schemeDynObj, DynamicObjectCollection taskEntryEntity) {
        for (DynamicObject entry2 : taskEntryEntity) {
            DynamicObjectCollection subEntryEntity = entry2.getDynamicObjectCollection("subentryentity");
            subEntryEntity.clear();
        }
        taskEntryEntity.clear();
        DynamicObjectCollection schemeEntry = schemeDynObj.getDynamicObjectCollection("entryentity");
        schemeEntry.sort(Comparator.comparing(entry -> DynamicObjectUtils.getString(entry, "importcode")));
        int seq = 1;
        for (DynamicObject se : schemeEntry) {
            DynamicObject entry3 = taskEntryEntity.addNew();
            entry3.set("seq", (Object)seq++);
            entry3.set("execstatus", (Object)MultiImpTaskEntryStatusEnum.SAVE.getStatus());
            MultiImpSchemeHelper.copyEntryFromScheme(se, entry3, "billentity");
            MultiImpSchemeHelper.copyEntryFromScheme(se, entry3, "sourcesheet");
            MultiImpSchemeHelper.copyEntryFromScheme(se, entry3, "importtype");
            MultiImpSchemeHelper.copyEntryFromScheme(se, entry3, "relpropname");
            MultiImpSchemeHelper.copyEntryFromScheme(se, entry3, "replacekeyfield");
            MultiImpSchemeHelper.copyEntryFromScheme(se, entry3, "subentryentity");
            MultiImpSchemeHelper.setEntryObjectPropName(entry3);
            MultiImpSchemeHelper.setEntrySourceSheet(entry3);
        }
    }

    private static void copyEntryFromScheme(DynamicObject schemeEntry, DynamicObject taskEntry, String prop) {
        Object propValue = schemeEntry.get(prop);
        if ("subentryentity".equals(prop)) {
            DynamicObjectCollection schemeDetails = (DynamicObjectCollection)propValue;
            DynamicObjectCollection taskDetails = taskEntry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject sd : schemeDetails) {
                DynamicObject td = taskDetails.addNew();
                MultiImpSchemeHelper.copyEntryFromScheme(sd, td, "stdpartname");
                MultiImpSchemeHelper.copyEntryFromScheme(sd, td, "fieldname");
                MultiImpSchemeHelper.copyEntryFromScheme(sd, td, "fieldnumber");
                MultiImpSchemeHelper.copyEntryFromScheme(sd, td, "mustinput");
                MultiImpSchemeHelper.copyEntryFromScheme(sd, td, "textfield");
                MultiImpSchemeHelper.copyEntryFromScheme(sd, td, "selectvalue");
                MultiImpSchemeHelper.copyEntryFromScheme(sd, td, "formuladesc");
                MultiImpSchemeHelper.copyEntryFromScheme(sd, td, "formula");
                MultiImpSchemeHelper.copyEntryFromScheme(sd, td, "formula_tag");
            }
            propValue = taskDetails;
        }
        taskEntry.set(prop, propValue);
    }

    private static void setEntryObjectPropName(DynamicObject taskEntry) {
        List<EntryObjectFieldModel> entryObjectFields = ENTRY_FIELDS_ID_NAMES.entrySet().stream().map(f -> new EntryObjectFieldModel((String)f.getKey(), (String)f.getValue())).collect(Collectors.toList());
        DynamicObject srcBillEntity = taskEntry.getDynamicObject("billentity");
        String billEntityNumber = srcBillEntity == null ? null : srcBillEntity.getString("target_formid");
        entryObjectFields.forEach(f -> f.setIdValue(taskEntry.getString(f.getIdKey())));
        MultiImpSchemeHelper.setPropFullCaption(billEntityNumber, entryObjectFields);
        for (EntryObjectFieldModel entryField : entryObjectFields) {
            taskEntry.set(entryField.getNameKey(), (Object)entryField.getNameValue());
        }
    }

    private static void setEntrySourceSheet(DynamicObject taskEntry) {
        String sourceSheet = taskEntry.getString("sourcesheet");
        if (StringUtils.isNotEmpty((String)sourceSheet) && sourceSheet.contains(",")) {
            sourceSheet = sourceSheet.replace(',', ' ');
            sourceSheet = sourceSheet.trim();
            taskEntry.set("sourcesheetview", (Object)sourceSheet);
        }
    }

    public static List<DynamicObject> getSchemeById(List<Long> schemeIds) {
        if (CollectionUtils.isEmpty(schemeIds)) {
            return new ArrayList<DynamicObject>(0);
        }
        DynamicObject[] schemes = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"dmw_impscheme"));
        return Stream.of(schemes).collect(Collectors.toList());
    }

    public static void setPropFullCaption(String entityNumber, List<EntryObjectFieldModel> entryFields) {
        List propKeys;
        List list = propKeys = CollectionUtils.isEmpty(entryFields) ? null : entryFields.stream().filter(f -> StringUtils.isNotEmpty((String)f.getIdValue())).flatMap(f -> Arrays.stream(f.getSplittedIdValues())).collect(Collectors.toList());
        if (StringUtils.isEmpty((String)entityNumber) || CollectionUtils.isEmpty(propKeys)) {
            return;
        }
        List<FieldMappingModel> fieldsMapping = TemplateMappingHelper.getFormFieldsMapping(entityNumber);
        if (fieldsMapping == null || fieldsMapping.isEmpty()) {
            return;
        }
        Map<String, String> idNameMap = fieldsMapping.stream().filter(f -> StringUtils.isNotEmpty((String)f.getStdFieldName())).collect(Collectors.toMap(FieldMappingModel::getStdFieldId, FieldMappingModel::getStdFieldName, (v1, v2) -> v2));
        for (EntryObjectFieldModel entryField : entryFields) {
            String[] fieldKeys = entryField.getSplittedIdValues();
            String nameJointer = entryField.getNameDelimiter();
            String nameValue = Arrays.stream(fieldKeys).map(idNameMap::get).filter(StringUtils::isNotEmpty).reduce((n1, n2) -> String.join((CharSequence)nameJointer, n1, n2)).orElse("");
            entryField.setNameValue(nameValue);
        }
    }

    public static void openMultiImportScheme(IFormView view, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("dmw_scheme_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848", (String)"MultiImpSchemeHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        view.showForm(showParameter);
    }

    public static void importMultiImpScheme(String url, IImportStepListener listener) throws DmwImptException {
        if (StringUtils.isEmpty((String)url) || listener == null) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u65b9\u6848\u5bfc\u5165\u5931\u8d25\uff0c\u9644\u4ef6\u6216\u8005\u5bfc\u5165\u8fc7\u7a0b\u76d1\u542c\u5668\u4e3a\u7a7a\u3002", (String)"MultiImpSchemeHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), 101);
        }
        listener.step(ResManager.loadKDString((String)"\u5f00\u59cb\u5bfc\u5165\u65b9\u6848", (String)"MultiImpSchemeHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), true);
        JSONObject schemeObj = null;
        HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>(16);
        try (InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream, Charset.forName("GBK"));){
            ZipEntry entry;
            listener.step(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u5b8c\u6210\uff0c\u5f00\u59cb\u89e3\u538b\u65b9\u6848", (String)"MultiImpSchemeHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), true);
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                byte[] contentBytes = ImptFileUtils.getZipFileContent(zipInputStream);
                if (SCHEMEDETAILFILENAME.equals(name)) {
                    listener.step(ResManager.loadKDString((String)"\u89e3\u538b\u6587\u4ef6\u5b8c\u6210\uff0c\u5f00\u59cb\u89e3\u6790\u65b9\u6848", (String)"MultiImpSchemeHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), true);
                    schemeObj = MultiImpSchemeHelper.parseSchemeConfigFormat(contentBytes);
                    continue;
                }
                byteMap.put(name, contentBytes);
            }
        }
        catch (IOException e) {
            listener.fail(ResManager.loadKDString((String)"\u9644\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u9644\u4ef6\u6d41\u3002", (String)"MultiImpSchemeHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        if (schemeObj == null) {
            listener.fail(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u65e0\u65b9\u6848\u6587\u4ef6\u4fe1\u606f[%1$s]\u3002", (String)"MultiImpSchemeHelper_15", (String)"imsc-dmw-platform", (Object[])new Object[0]), SCHEMEDETAILFILENAME));
            return;
        }
        listener.step(ResManager.loadKDString((String)"\u89e3\u6790\u65b9\u6848\u5b8c\u6210\uff0c\u5f00\u59cb\u6821\u9a8c\u65b9\u6848\u662f\u5426\u88ab\u4fee\u6539", (String)"MultiImpSchemeHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]), true);
        IDataChecker checker = DataCheckerBuilderFactory.getDataCheckerWithClassName(SchemeImportChecker.class.getName());
        checker.dataCheck(Tuple.create((Object)schemeObj, byteMap));
        listener.step(ResManager.loadKDString((String)"\u6821\u9a8c\u65b9\u6848\u5b8c\u6210", (String)"MultiImpSchemeHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]), true);
        JSONObject template = schemeObj.getJSONObject(TEMPLATE);
        String tName = template.getString(TEMPLATE_NAME);
        int length = ((byte[])byteMap.get(tName)).length;
        String tUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(tName, (byte[])byteMap.get(tName), 900);
        HashMap<String, Object> urlMap = new HashMap<String, Object>(3);
        urlMap.put("url", tUrl);
        urlMap.put("name", tName);
        urlMap.put("size", length);
        listener.success(schemeObj.getJSONObject(BASE).toJSONString(), schemeObj.getJSONObject(MAPPING).toJSONString(), SerializationUtils.serializeToBase64(urlMap));
    }

    /*
     * Exception decompiling
     */
    public static String exportMultiImpScheme(long schemeId) throws DmwImptException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] buildSchemeConfigFormat(ViewSchemeBaseInfoModel infoModel, Map<String, ViewSchemeMappingInfoModel> mappingInfoModelMap, String fileName, String fileMd5) {
        infoModel.setAttachMap(new HashMap<String, Object>(1));
        JSONObject detailObj = new JSONObject().fluentPut(BASE, (Object)infoModel.toSchemeJson()).fluentPut(MAPPING, mappingInfoModelMap).fluentPut(TEMPLATE, (Object)new JSONObject().fluentPut(TEMPLATE_NAME, (Object)fileName).fluentPut(fileName, (Object)fileMd5));
        byte[] bytes = detailObj.toJSONString().getBytes(StandardCharsets.UTF_8);
        ObjectUtils.reverseArray(bytes);
        byte[] tarBytes = new byte[bytes.length + SCHEME_HEADER.length + SCHEME_TAIL.length];
        int desPos = 0;
        System.arraycopy(SCHEME_HEADER, 0, tarBytes, desPos, SCHEME_HEADER.length);
        System.arraycopy(bytes, 0, tarBytes, desPos += SCHEME_HEADER.length, bytes.length);
        System.arraycopy(SCHEME_TAIL, 0, tarBytes, desPos += bytes.length, SCHEME_TAIL.length);
        return tarBytes;
    }

    private static JSONObject parseSchemeConfigFormat(byte[] contentBytes) throws DmwImptException {
        try {
            byte[] tarBytes = new byte[contentBytes.length - SCHEME_HEADER.length - SCHEME_TAIL.length];
            int desPos = 0;
            System.arraycopy(contentBytes, SCHEME_HEADER.length, tarBytes, desPos, tarBytes.length);
            ObjectUtils.reverseArray(tarBytes);
            return JSON.parseObject((String)new String(tarBytes, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u89e3\u6790\u5bfc\u5165\u65b9\u6848\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u53ef\u80fd\u5b58\u5728\u4fee\u6539\u6216\u8005\u6587\u4ef6\u8fc7\u671f\u3002", (String)"MultiImpSchemeHelper_11", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e, 1001);
        }
    }

    public static OperationResult executeSchemeSaveOperation(DynamicObject baseInfoDyObj, long schemeFid, OperationStatus operation, Map<String, Object> urlMap, String tempInfoStr, Map<String, DynamicObject> schemeFieldMappingConfig) {
        DynamicObject detailsData = SchemeDataPackageTransHelper.guideToDetails(baseInfoDyObj, schemeFieldMappingConfig, tempInfoStr, schemeFid, operation);
        if (detailsData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38 \uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6392\u67e5\u5904\u7406\u3002", (String)"MultiImpSchemeHelper_12", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        try {
            String url;
            List<ExcelFieldInfoModel> list;
            ImportTemplateReadInfoModel infoModel;
            String path = null;
            String entityNum = "";
            if (urlMap != null) {
                String url2 = String.valueOf(urlMap.get("url"));
                String fileName = String.valueOf(urlMap.get("name"));
                path = CopyFileHelper.uploadFile(url2, fileName);
                entityNum = String.valueOf(urlMap.get("entityNum"));
            }
            if ("dmw_importschemeguide".equals(entityNum)) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{detailsData});
            }
            if (urlMap != null && tempInfoStr != null && !tempInfoStr.isEmpty() && !CommonUtils.isNull((infoModel = (ImportTemplateReadInfoModel)JSON.parseObject((String)tempInfoStr, ImportTemplateReadInfoModel.class)).getSheetTemplateMap()) && (StringUtil.isEmpty((list = infoModel.getSheetTemplateMap().values().iterator().next()).get(0).getSheetNumber()) || StringUtil.isEmpty(list.get(0).getSheetName())) && (infoModel = MulImportCheckerProxy.parseTemplateInfoByUrlWithAttachFileCache(url = String.valueOf(urlMap.get("url")), 0)) != null) {
                detailsData.set("modelinfo_tag", (Object)infoModel.toString());
            }
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"dmw_impscheme", (DynamicObject[])new DynamicObject[]{detailsData}, (OperateOption)OperateOption.create());
            if (path != null) {
                if (operation != null && OperationStatus.EDIT.equals((Object)operation)) {
                    DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{new QFilter("finterid", "=", (Object)String.valueOf(detailsData.get("id")))});
                }
                urlMap.put("url", path);
                SchemeDataPackageTransHelper.handleFilePackage(urlMap, detailsData);
                AttachmentServiceHelper.upload((String)"dmw_impscheme", (Object)detailsData.get("id"), (String)"attachmentpanelap", Collections.singletonList(urlMap));
                BillFileMappingWriter.syncWriteFileBillMapping((String)path);
            }
            if (!operationResult.isSuccess() && detailsData.getLong("id") > 0L) {
                DeleteServiceHelper.delete((IDataEntityType)detailsData.getDataEntityType(), (Object[])new Object[]{detailsData.getLong("id")});
            }
            return operationResult;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38 \uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6392\u67e5\u5904\u7406\u3002", (String)"MultiImpSchemeHelper_12", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    public static OperationResult executeSchemeDataImport(String baseInfo, String mapInfo, Map<String, Object> urlMap) throws DmwImptException {
        if (StringUtils.isEmpty((String)baseInfo) || StringUtils.isEmpty((String)mapInfo) || urlMap == null) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MultiImpSchemeHelper_13", (String)"imsc-dmw-platform", (Object[])new Object[0]), 3001);
        }
        try {
            boolean exists = CacheFactory.getCommonCacheFactory().getTempFileCache().exists((String)urlMap.get("url"));
            if (!exists) {
                throw new DmwImptException(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u5931\u8d25\uff0c\u65b9\u6848\u6a21\u677fExcel\u5df2\u5931\u6548\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002", (String)"MultiImpSchemeHelper_14", (String)"imsc-dmw-platform", (Object[])new Object[0]), 3001);
            }
        }
        catch (Exception e) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u5931\u8d25\uff0c\u65b9\u6848\u6a21\u677fExcel\u5df2\u5931\u6548\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002", (String)"MultiImpSchemeHelper_14", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e, 3001);
        }
        JSONObject baseInfoObj = JSON.parseObject((String)baseInfo);
        JSONObject mapInfoObj = JSON.parseObject((String)mapInfo);
        ViewSchemeBaseInfoModel baseInfoModel = MultiImpSchemeHelper.parseViewSchemeBaseInfoModel(baseInfoObj);
        Map<String, ViewSchemeMappingInfoModel> infoModelMap = MultiImpSchemeHelper.parseViewSchemeMappingInfoModel(mapInfoObj);
        DynamicObject baseInfoDyObj = SchemeDataPackageTransHelper.schemeDetailBaseInfoToDyObj(baseInfoModel);
        Map<String, DynamicObject> targetMapDetailMap = SchemeDataPackageTransHelper.buildSchemeMapToDyCollection(infoModelMap);
        return MultiImpSchemeHelper.executeSchemeSaveOperation(baseInfoDyObj, 0L, OperationStatus.ADDNEW, urlMap, baseInfoModel.getTemplateInfo(), targetMapDetailMap);
    }

    private static ViewSchemeBaseInfoModel parseViewSchemeBaseInfoModel(JSONObject schemeBaseObj) {
        return (ViewSchemeBaseInfoModel)schemeBaseObj.toJavaObject(ViewSchemeBaseInfoModel.class);
    }

    private static Map<String, ViewSchemeMappingInfoModel> parseViewSchemeMappingInfoModel(JSONObject schemeMappingObj) {
        if (schemeMappingObj == null || schemeMappingObj.isEmpty()) {
            return new HashMap<String, ViewSchemeMappingInfoModel>(1);
        }
        Set keySet = schemeMappingObj.keySet();
        HashMap<String, ViewSchemeMappingInfoModel> infoModelMap = new HashMap<String, ViewSchemeMappingInfoModel>(keySet.size());
        for (String key : keySet) {
            infoModelMap.put(key, (ViewSchemeMappingInfoModel)schemeMappingObj.getJSONObject(key).toJavaObject(ViewSchemeMappingInfoModel.class));
        }
        return infoModelMap;
    }

    static {
        ObjectUtils.reverseArray(SCHEME_HEADER);
        ObjectUtils.reverseArray(SCHEME_TAIL);
        ENTRY_FIELDS_ID_NAMES = new HashMap<String, String>();
        ENTRY_FIELDS_ID_NAMES.put("replacekeyfield", "replacekeyword");
    }
}

