/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.consts.ImpTarCloudEnum;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.helper.license.LicenseHelper;
import kd.imsc.dmw.utils.QFilterUtils;

public class PermissionHelper {
    private static final Log logger = LogFactory.getLog(PermissionHelper.class);
    private static final String LICENCES_KEY = "i_t_l_p";
    public static final String IMSC_CHECK_REPAIR = "4LZ195+J5E30";
    public static final String IMSC_DMW_CHECK = "4LZ15+4444IQ";
    public static final String IMSC_DMW_UPDATECHECK_PARAM = "4TP+NKO7H64E";
    public static final String IMSC_DMW_RESERVT_CHECKPARAM = "4TP+RZP+11MC";
    public static final String IMSC_MIGRATE_EXEC = "4M/H7HJLM6=V";
    public static final String IMSC_MARK_COMPLETE = "4M/HAKWAHJKO";
    public static final String IMSC_VIEW_LOG = "4M/HDY7QQ6KA";
    public static final String ISCQX06 = "1O5/61259CWS";
    public static final String ISCQX37 = "2F0/XKR9O2+F";
    public static final String ISCQX03 = "1O5+X0V9AM=+";
    public static final String QXX0021 = "4730fc9f000004ae";
    public static final String QXX0002 = "47156aff000000ac";
    public static final String QXX0003 = "4715a0df000000ac";

    public static boolean hasPermission(String entityNumber, String permItem) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return false;
        }
        String appId = EntityMetadataCache.getDataEntityType((String)entityNumber).getAppId();
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)appId, (String)entityNumber, (String)permItem);
    }

    public static void checkPermission(IFormView view, String entityNum, String ... permItemIds) {
        String entityName;
        String permEntityNumber = entityNum;
        if (view != null) {
            entityName = view instanceof ListView ? ((ListView)view).getBillFormId() : view.getModel().getDataEntity().getDataEntityType().getName();
            permEntityNumber = entityName;
            logger.info("PermissionHelper.checkPermission do update entityNum" + entityName);
            if ("dmw_migrateproject".equals(entityNum)) {
                if ("dmw_migrateuserguide_eas".equals(entityName)) {
                    permEntityNumber = "dmw_migrateproject_eas";
                }
                if ("dmw_migrateuserguide_nc".equals(entityName)) {
                    permEntityNumber = "dmw_migrateproject_nc";
                }
                if ("dmw_migrateuserguide_ecc".equals(entityName)) {
                    permEntityNumber = "dmw_migrateproject_ecc";
                }
            }
        }
        entityName = EntityMetadataCache.getDataEntityType((String)permEntityNumber).getDisplayName().getLocaleValue();
        List<String> ids = Arrays.asList(permItemIds);
        QFilter idInFilter = QFilterUtils.getIdInFilter(ids);
        DynamicObjectCollection nameMap = QueryServiceHelper.query((String)"perm_permitem", (String)"id,name", (QFilter[])idInFilter.toArray());
        HashMap<String, String> idMap = new HashMap<String, String>(16);
        for (DynamicObject dbPerm : nameMap) {
            idMap.put(dbPerm.getString("id"), dbPerm.getString("name"));
        }
        for (String permItemId : permItemIds) {
            boolean hasExportPermission = PermissionHelper.hasPermission(permEntityNumber, permItemId);
            if (hasExportPermission) continue;
            String permTips = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u5355\u636e\"%1$s\"\u7684\"%2$s\"\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"PermissionUtils_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), entityName, idMap.get(permItemId));
            throw new DmwBizException(permTips);
        }
    }

    public static QFilter buildImpTargetQFilter(IFormView formView) {
        QFilter qFilter;
        Boolean value;
        String key;
        Set<Map.Entry<String, Boolean>> entries;
        ImpTarCloudEnum[] values;
        if (formView == null) {
            return null;
        }
        String licenceKey = formView.getPageCache().get(LICENCES_KEY);
        if (StringUtils.isNotEmpty((String)licenceKey)) {
            return QFilter.of((String)licenceKey, (Object[])new Object[0]);
        }
        ArrayList<String> allowList = new ArrayList<String>(4);
        ArrayList<String> cloudList = new ArrayList<String>(4);
        ArrayList<String> featureList = new ArrayList<String>(4);
        block5: for (ImpTarCloudEnum value2 : values = ImpTarCloudEnum.values()) {
            switch (value2.getType()) {
                case 0: {
                    allowList.add(value2.getCode());
                    continue block5;
                }
                case 1: {
                    cloudList.add(value2.getCode());
                    continue block5;
                }
                case 2: {
                    featureList.add(value2.getCode());
                    continue block5;
                }
            }
        }
        QFilter filter = null;
        if (CollectionUtils.isNotEmpty(allowList)) {
            logger.info("Check Base {}", allowList);
            filter = new QFilter("cloud", "in", allowList);
        }
        if (CollectionUtils.isNotEmpty(cloudList)) {
            Map<String, Boolean> licenceMap = LicenseHelper.checkLicenseByModules(cloudList);
            logger.info("Check License {}", (Object)JSON.toJSONString(licenceMap));
            if (licenceMap != null && !licenceMap.isEmpty()) {
                ArrayList<String> keyList = new ArrayList<String>(licenceMap.size());
                entries = licenceMap.entrySet();
                for (Map.Entry<String, Boolean> entry : entries) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value == null || !value.booleanValue()) continue;
                    keyList.add(key);
                }
                if (CollectionUtils.isNotEmpty(keyList)) {
                    qFilter = new QFilter("checkgroup", "=", (Object)String.valueOf(1)).and("cloud", "in", keyList);
                    if (filter == null) {
                        filter = qFilter;
                    } else {
                        filter.or(qFilter);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(featureList)) {
            Map<String, Boolean> groupMap = LicenseHelper.checkLicenseByGroups(cloudList);
            logger.info("Check feature {}", (Object)JSON.toJSONString(groupMap));
            if (groupMap != null && !groupMap.isEmpty()) {
                ArrayList<String> keyList = new ArrayList<String>(groupMap.size());
                entries = groupMap.entrySet();
                for (Map.Entry<String, Boolean> entry : entries) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value == null || !value.booleanValue()) continue;
                    keyList.add(key);
                }
                if (CollectionUtils.isNotEmpty(keyList)) {
                    qFilter = new QFilter("checkgroup", "=", (Object)String.valueOf(2)).and("cloud", "in", keyList);
                    if (filter == null) {
                        filter = qFilter;
                    } else {
                        filter.or(qFilter);
                    }
                }
            }
        }
        if (filter != null) {
            formView.getPageCache().put(LICENCES_KEY, filter.toString());
        }
        return filter;
    }
}

