/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.utils.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ReadSheetHeadRowHandler
extends SheetHandler {
    private static final Log log = LogFactory.getLog(ReadSheetHeadRowHandler.class);
    private final Map<String, SXSSFSheet> sheets = new HashMap<String, SXSSFSheet>();
    private SXSSFWorkbook book;
    private SheetHandler.ParsedRow currentParsedRow;

    public ReadSheetHeadRowHandler(SXSSFWorkbook book) {
        this.book = book;
        super.setInterrupt(false);
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFSheet sheet = this.sheets.get(row.getSheetName());
        if (sheet == null) {
            sheet = this.initSheet(row.getSheetName());
        }
        this.currentParsedRow = row;
        int currRowNum = this.currentParsedRow.getRowNum();
        this.handleOtherSheet(sheet, currRowNum);
    }

    private SXSSFSheet initSheet(String sheetName) {
        if (this.book == null) {
            this.book = new SXSSFWorkbook(1);
        }
        SXSSFSheet sheet = this.book.createSheet(sheetName);
        if (this.sheets.isEmpty()) {
            sheet.setColumnWidth(0, 10000);
        }
        this.sheets.put(sheetName, sheet);
        return sheet;
    }

    private void handleOtherSheet(SXSSFSheet sheet, int currRowNum) {
        if (currRowNum > 0) {
            return;
        }
        for (Map.Entry entry : this.currentParsedRow.getData().entrySet()) {
            Integer key = (Integer)entry.getKey();
            JSONObject styleObj = (JSONObject)this.currentParsedRow.getStyles().get(key);
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(key.intValue());
            String value = (String)entry.getValue();
            this.setCellVal(cell, value, styleObj);
        }
    }

    private void setCellVal(SXSSFCell cell, String val, JSONObject styleObj) {
        String fmt = styleObj.getString("fmt");
        if (StringUtils.isNotBlank(fmt)) {
            try {
                cell.setCellValue(new BigDecimal(val).doubleValue());
            }
            catch (Exception e) {
                log.error("setCellVal\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                cell.setCellValue(val);
            }
        } else {
            cell.setCellValue(val);
        }
    }
}

