/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class ScheduleHelper {
    public ScheduleHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static JobFormInfo buildJobFormInfo(String jobName, String taskClassName, String clickClassName, IFormView view, Map<String, Object> params) {
        String routeAppId = "";
        if (view != null) {
            routeAppId = view.getFormShowParameter().getServiceAppId();
        }
        JobInfo jobInfo = ScheduleHelper.getJobInfo(jobName, taskClassName, routeAppId, params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setClickClassName(clickClassName);
        jobFormInfo.setCanBackground(true);
        if (view != null) {
            jobFormInfo.setParentPageId(view.getPageId());
            FormShowParameter showParams = view.getFormShowParameter();
            jobFormInfo.setParentPageId(showParams.getParentPageId());
            jobFormInfo.getParams().putAll(showParams.getCustomParams());
        }
        if (view != null && view.getFormShowParameter().getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        }
        return jobFormInfo;
    }

    public static JobInfo getJobInfo(String jobName, String taskClassName, String serviceAppId, Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(jobName);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(params);
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            jobInfo.setAppId(serviceAppId);
        }
        return jobInfo;
    }

    private void toBackground(String taskId, IFormView view, JobFormInfo jobFormInfo) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        if (TaskClientProxy.isExistTask((String)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (jobFormInfo != null) {
            TaskClientProxy.addTask((IFormView)view, (JobFormInfo)Objects.requireNonNull(jobFormInfo), (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)(taskId + "-background-monitor"), (Runnable)subscriber);
        }
    }

    public static Map<String, Object> getTaskCustomData(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return new HashMap<String, Object>(16);
        }
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return new HashMap<String, Object>(16);
        }
        return (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
    }

    public static int getDynamicSleepSecond(int beginSecond, int maxSecond) {
        if (beginSecond >= maxSecond) {
            return maxSecond;
        }
        return beginSecond * 13 / 10;
    }
}

