/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.PrintCountField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.AttachmentCountField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldInfoModel;
import kd.imsc.dmw.engine.multiimport.model.FieldMappingModel;
import kd.imsc.dmw.engine.multiimport.model.StdTemplateReadInfoModel;
import kd.imsc.dmw.enums.SelectValueEnum;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.StdTemplateReadHelper;
import kd.imsc.dmw.helper.modifier.FieldModifierBuilderFactory;
import kd.imsc.dmw.helper.modifier.IFieldModifier;
import kd.imsc.dmw.helper.similarity.proxy.StrSimilarityProxy;
import kd.imsc.dmw.helper.similarity.proxy.StrSimilarityResult;
import kd.imsc.dmw.utils.CommonUtils;

public class TemplateMappingHelper {
    public static final Log logger = LogFactory.getLog(TemplateMappingHelper.class);
    private static final String STDFIELDID = "stdfieldid";
    private static final String STDFIELDNAME = "stdfieldname";
    private static final String STDPARENT = "stdpartname";
    private static final String SHEETFIELD = "sheetfield";
    private static final String STDBILLHEAD = "billhead";

    private TemplateMappingHelper() {
    }

    public static List<FieldMappingModel> getStdTemplateFieldList(String formId, String formName) throws DmwImptException {
        if (kd.bos.util.StringUtils.isEmpty((String)formId) || kd.bos.util.StringUtils.isEmpty((String)formName)) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u5355\u636e\u9875\u9762\u6807\u8bc6\uff0c\u6216\u8005\u5355\u636e\u540d\u79f0\u4e3a\u7a7a\uff01", (String)"TemplateMappingHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), 4001);
        }
        logger.info("Std Import Template Url {}", (Object)StdTemplateReadHelper.pushBillTemplate(formId, formName));
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
            if (dataEntityType == null) {
                throw new DmwImptException(String.format(ResManager.loadKDString((String)"[%1$s]\u5143\u6570\u636e\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01", (String)"TemplateMappingHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), formId), 4001);
            }
            StdTemplateReadInfoModel stdImportSchemeTemplate = StdTemplateReadHelper.getStdImportSchemeTemplate(formId, formName);
            if (stdImportSchemeTemplate == null) {
                throw new DmwImptException(String.format(ResManager.loadKDString((String)"[%1$s]\u5143\u6570\u636e\u5168\u91cf\u6a21\u677f\u83b7\u53d6\u5931\u8d25\uff01", (String)"TemplateMappingHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), formId), 4001);
            }
            List<ExcelFieldInfoModel> keyInfoModelList = stdImportSchemeTemplate.getKeyFieldList();
            List<ExcelFieldInfoModel> nameInfoModelList = stdImportSchemeTemplate.getNameFieldList();
            if (keyInfoModelList == null || keyInfoModelList.isEmpty()) {
                throw new DmwImptException(String.format(ResManager.loadKDString((String)"[%1$s]\u5143\u6570\u636e\u5168\u91cf\u6a21\u677f\u5b57\u6bb5\u6807\u8bc6\u83b7\u53d6\u5931\u8d25\uff01", (String)"TemplateMappingHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), formId), 4001);
            }
            Map allEntities = dataEntityType.getAllEntities();
            ArrayList<FieldMappingModel> mappingModels = new ArrayList<FieldMappingModel>(16);
            logger.info("Std Template Column size {}", (Object)keyInfoModelList.size());
            DynamicObject impTargetDyObj = TemplateMappingHelper.getImportTargetDyByFormId(formId);
            if (impTargetDyObj == null) {
                throw new DmwImptException(String.format(ResManager.loadKDString((String)"[%1$s]\u4e0d\u652f\u6301\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u7684\u5bfc\u5165", (String)"TemplateMappingHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]), formId), 4001);
            }
            IFieldModifier iFieldModifier = FieldModifierBuilderFactory.getDataCheckerWithClassName(impTargetDyObj.getString("importcode").split("\\.")[0]);
            for (int i = 0; i < keyInfoModelList.size(); ++i) {
                ExcelFieldInfoModel keyFieldInfoModel = keyInfoModelList.get(i);
                String fieldKey = keyFieldInfoModel.getValue();
                if (fieldKey.contains(".")) {
                    fieldKey = fieldKey.split("\\.")[0];
                }
                if (!mappingModels.isEmpty() && ((FieldMappingModel)mappingModels.get(mappingModels.size() - 1)).getStdFieldId().equals(fieldKey)) continue;
                FieldMappingModel mappingModel = new FieldMappingModel();
                mappingModel.setStdFieldId(fieldKey);
                String entryInfo = stdImportSchemeTemplate.getTemplateEntryInfo(i);
                if (kd.bos.util.StringUtils.isNotEmpty((String)entryInfo) && entryInfo.contains("#")) {
                    Tuple result;
                    String partName = entryInfo.split("#")[0].trim();
                    String entry = entryInfo.split("#")[1].trim();
                    EntityType entityType = (EntityType)allEntities.get(entry);
                    if (entityType instanceof EntryType) {
                        mappingModel.setStdPartName(partName);
                        mappingModel.setPartHead(false);
                    } else {
                        mappingModel.setStdPartName(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"TemplateMappingHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                        mappingModel.setPartHead(true);
                    }
                    IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldKey);
                    logger.info("index {} fieldKey {} partName {} entry {} ", new Object[]{i, fieldKey, partName, entry});
                    if (property != null) {
                        mappingModel.setStdFieldName(property.getDisplayName().getLocaleValue());
                    } else {
                        mappingModel.setStdFieldName(nameInfoModelList.get(i).getValue());
                    }
                    boolean isNull = nameInfoModelList.get(i).getValue().startsWith("*");
                    if (iFieldModifier != null && (result = iFieldModifier.needModify(formId, fieldKey)) != null && ((Boolean)result.item1).booleanValue() && result.item2 != null && result.item2 instanceof Boolean) {
                        isNull = (Boolean)result.item2;
                    }
                    mappingModel.setNull(isNull);
                }
                mappingModels.add(mappingModel);
            }
            logger.info("Std Template parse size {}", (Object)mappingModels.size());
            return mappingModels;
        }
        catch (DmwImptException e) {
            logger.error((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new DmwImptException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u6620\u5c04\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01", (String)"TemplateMappingHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e, 4001);
        }
    }

    public static List<FieldMappingModel> getFormFieldsMapping(String formId) {
        return TemplateMappingHelper.getKeyFieldItems(formId);
    }

    private static List<FieldMappingModel> getKeyFieldItems(String formId) {
        if (kd.bos.util.StringUtils.isEmpty((String)formId)) {
            return new ArrayList<FieldMappingModel>(1);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        if (entityType instanceof QueryEntityType) {
            formId = ((QueryEntityType)entityType).getEntityName();
        }
        ArrayList<FieldMappingModel> keyfieldItems = new ArrayList<FieldMappingModel>(16);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        HashSet itemSet = new HashSet(16);
        entityItems.forEach(item -> {
            boolean valid = item instanceof Field;
            if (valid) {
                Field f = (Field)item;
                if (!(!kd.bos.util.StringUtils.isNotEmpty((String)f.getFieldName()) || !f.getFeatures().isImportable() || f instanceof CheckBoxField || f instanceof RadioField || f instanceof RadioGroupField || f instanceof ModifierField || f instanceof PictureField || f instanceof UserAvatarField || f instanceof IconField || f instanceof AttachmentCountField || f instanceof AttachmentField || f instanceof PrintCountField || f instanceof FlexField)) {
                    itemSet.add(item.getKey());
                }
                if (item instanceof DateRangeField && f.getFeatures().isImportable()) {
                    if (StringUtils.isNotBlank((CharSequence)((DateRangeField)item).getStartDateFieldName())) {
                        itemSet.add(((DateRangeField)f).getStartDateFieldKey());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((DateRangeField)item).getEndDateFieldName())) {
                        itemSet.add(((DateRangeField)f).getEndDateFieldKey());
                    }
                }
                if (item instanceof TimeRangeField && f.getFeatures().isImportable()) {
                    if (StringUtils.isNotBlank((CharSequence)((TimeRangeField)item).getStartDateFieldName())) {
                        itemSet.add(((TimeRangeField)f).getStartDateFieldKey());
                    }
                    if (StringUtils.isNotBlank((CharSequence)((TimeRangeField)item).getEndDateFieldName())) {
                        itemSet.add(((TimeRangeField)f).getEndDateFieldKey());
                    }
                }
            }
        });
        for (IDataEntityProperty p : entityType.getProperties()) {
            if (!itemSet.contains(p.getName())) continue;
            FieldMappingModel model = new FieldMappingModel();
            model.setStdFieldId(p.getName()).setStdFieldName(p.getDisplayName().getLocaleValue());
            keyfieldItems.add(model);
        }
        if (entityType.getPrimaryKey() != null) {
            FieldMappingModel model = new FieldMappingModel();
            model.setStdFieldId(entityType.getPrimaryKey().getName()).setStdFieldName(ResManager.loadKDString((String)"\u5185\u7801", (String)"TemplateMappingHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            keyfieldItems.add(model);
        }
        return keyfieldItems;
    }

    public static DynamicObject getImportTargetDyByFormId(String formId) {
        if (kd.bos.util.StringUtils.isEmpty((String)formId)) {
            return null;
        }
        QFilter qFilter = new QFilter("target_formid", "=", (Object)formId);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"dmw_importtarget", (QFilter[])qFilter.toArray());
        if (dynamicObjectMap == null || dynamicObjectMap.isEmpty()) {
            return null;
        }
        return (DynamicObject)dynamicObjectMap.values().stream().findFirst().get();
    }

    public static boolean autoInvokeKeyFieldMapping(DynamicObjectCollection collection, List<ComboItem> comboItemList, List<String> mulSheetNameList, String targetName, Set<String> unChangeStdFieldSet) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        if (comboItemList == null || comboItemList.isEmpty()) {
            return false;
        }
        if (mulSheetNameList == null || mulSheetNameList.isEmpty()) {
            return false;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)targetName)) {
            return false;
        }
        boolean isMatch = false;
        HashMap<String, StrSimilarityResult> similarityResultMap = new HashMap<String, StrSimilarityResult>(8);
        for (DynamicObject fieldDyObj : collection) {
            boolean idMapper;
            String stdFieldName = fieldDyObj.getString(STDFIELDNAME);
            if (unChangeStdFieldSet.contains(fieldDyObj.getString(STDFIELDID))) continue;
            fieldDyObj.set(SHEETFIELD, null);
            fieldDyObj.set("selectvalue", (Object)SelectValueEnum.SOURCEFIELD.getValue());
            fieldDyObj.set("formuladesc", null);
            fieldDyObj.set("formula", null);
            fieldDyObj.set("formula_tag", null);
            List mapperFieldList = comboItemList.stream().filter(t -> {
                String value = t.getValue();
                if (value.contains(".")) {
                    return value.substring(value.indexOf(46) + 1).equals(stdFieldName);
                }
                return value.equals(stdFieldName);
            }).collect(Collectors.toList());
            int idx = collection.indexOf((Object)fieldDyObj);
            if (mapperFieldList != null && mapperFieldList.size() == 1) {
                isMatch = true;
                fieldDyObj.set(SHEETFIELD, (Object)((ComboItem)mapperFieldList.get(0)).getValue());
                similarityResultMap.put(((ComboItem)mapperFieldList.get(0)).getValue(), new StrSimilarityResult(((ComboItem)mapperFieldList.get(0)).getValue(), 2.0, idx));
                continue;
            }
            boolean bl = idMapper = CommonUtils.isNull(mapperFieldList) && ("id".equals(fieldDyObj.getString(STDFIELDID)) || ResManager.loadKDString((String)"\u5185\u7801", (String)"TemplateMappingHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]).equals(fieldDyObj.getString(STDFIELDNAME)));
            if (idMapper) {
                fieldDyObj.set(SHEETFIELD, null);
                continue;
            }
            StrSimilarityResult similarityResult = null;
            if (mulSheetNameList.size() == 1) {
                List<String> sheetList = comboItemList.stream().map(ComboItem::getValue).collect(Collectors.toList());
                Tuple<String, Double> similarityTuple = StrSimilarityProxy.getSimilaritiesWord(stdFieldName, sheetList);
                if (similarityTuple != null) {
                    similarityResult = new StrSimilarityResult((String)similarityTuple.item1, (Double)similarityTuple.item2, idx);
                }
            } else {
                Tuple<String, Double> similarityTuple;
                List<String> sheetList;
                String sheetName;
                String string = sheetName = fieldDyObj.getBoolean(STDBILLHEAD) ? targetName : fieldDyObj.getString(STDPARENT);
                if (mapperFieldList != null && mapperFieldList.size() > 1) {
                    String matchValue = String.join((CharSequence)".", sheetName, stdFieldName);
                    similarityTuple = StrSimilarityProxy.getSimilaritiesWord(matchValue, sheetList = mapperFieldList.stream().map(ComboItem::getValue).collect(Collectors.toList()));
                    if (similarityTuple != null) {
                        similarityResult = new StrSimilarityResult((String)similarityTuple.item1, (Double)similarityTuple.item2, idx);
                    }
                } else {
                    Tuple<String, Double> sheetMatchTuple = StrSimilarityProxy.getSimilaritiesWord(sheetName, mulSheetNameList, 0.55f);
                    if (sheetMatchTuple == null) {
                        fieldDyObj.set(SHEETFIELD, null);
                        continue;
                    }
                    sheetList = comboItemList.stream().filter(t -> t.getValue().startsWith((String)sheetMatchTuple.item1 + '.')).map(s -> s.getValue().substring(s.getValue().indexOf(46) + 1)).collect(Collectors.toList());
                    similarityTuple = StrSimilarityProxy.getSimilaritiesWord(stdFieldName, sheetList);
                    if (similarityTuple != null) {
                        similarityResult = new StrSimilarityResult((String)sheetMatchTuple.item1 + "." + (String)similarityTuple.item1, (Double)similarityTuple.item2, idx);
                    }
                }
            }
            if (similarityResult == null) {
                fieldDyObj.set(SHEETFIELD, null);
                continue;
            }
            StrSimilarityResult matchResult = (StrSimilarityResult)similarityResultMap.get(similarityResult.getMatch());
            if (matchResult != null && !(matchResult.getScore() < similarityResult.getScore())) continue;
            similarityResultMap.put(similarityResult.getMatch(), similarityResult);
        }
        Set entrySet = similarityResultMap.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!(((StrSimilarityResult)entry.getValue()).getScore() < 1.1)) continue;
            ((DynamicObject)collection.get(((StrSimilarityResult)entry.getValue()).getIdx())).set(SHEETFIELD, entry.getKey());
            isMatch = true;
        }
        similarityResultMap.clear();
        return isMatch;
    }
}

