/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.alerter;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.engine.multiimport.model.ImportTargetSchemeInfoModel;
import kd.imsc.dmw.enums.SelectValueEnum;
import kd.imsc.dmw.helper.alerter.IDataAlerter;
import kd.imsc.dmw.helper.modifier.BaseCloudFieldModifier;
import kd.imsc.dmw.utils.StringUtils;

public class FieldModifyAlerter
implements IDataAlerter<ImportTargetSchemeInfoModel, String> {
    @Override
    public String dataAlert(ImportTargetSchemeInfoModel infoModel) {
        if (infoModel == null || StringUtils.isEmpty(infoModel.getFormId()) || StringUtils.isEmpty(infoModel.getFormName()) || infoModel.getSchemeInfoDyObj() == null) {
            throw new IllegalArgumentException("info model illegal!");
        }
        DynamicObject infoDyObj = infoModel.getSchemeInfoDyObj();
        DynamicObjectCollection collection = infoDyObj.getDynamicObjectCollection("entryentity");
        if (collection == null || collection.isEmpty()) {
            throw new IllegalStateException("FieldMapping is null");
        }
        StringBuilder alertFieldBuilder = new StringBuilder();
        for (DynamicObject fieldMapDy : collection) {
            String fieldKey = fieldMapDy.getString("stdfieldid");
            String modifyKey = String.format("%s.%s", infoModel.getFormId(), fieldKey);
            String fieldMsg = String.format("%s.%s", fieldMapDy.getString("stdpartname"), fieldMapDy.getString("stdfieldname"));
            boolean modify = BaseCloudFieldModifier.isModify(modifyKey);
            if (!modify || (!SelectValueEnum.SOURCEFIELD.getValue().equals(fieldMapDy.getString("selectvalue")) || !StringUtils.isEmpty(fieldMapDy.getString("sheetfield"))) && (!SelectValueEnum.FORMULA.getValue().equals(fieldMapDy.getString("selectvalue")) || !StringUtils.isEmpty(fieldMapDy.getString("formuladesc")))) continue;
            if (StringUtils.isNotEmpty(alertFieldBuilder.toString())) {
                alertFieldBuilder.append(',');
            }
            alertFieldBuilder.append(fieldMsg);
        }
        return alertFieldBuilder.toString();
    }

    @Override
    public String alertFormat(List<String> alertMsgList) {
        if (CollectionUtils.isEmpty(alertMsgList)) {
            return null;
        }
        String infoMsg = alertMsgList.stream().map(t -> {
            String[] split = t.split("#");
            if (split.length == 1) {
                return "\"" + split[0] + "\"";
            }
            return new StringBuilder("\"").append(split[0]).append("\"").append(ResManager.loadKDString((String)"\u7684", (String)"FieldModifyAlerter_1", (String)"imsc-dmw-platform", (Object[])new Object[0])).append("\"").append(split[1]).append("\"");
        }).collect(Collectors.joining("\u3001"));
        return String.format(ResManager.loadKDString((String)"%1$s\u672a\u6307\u5b9a\u6587\u6863\u5185\u5b57\u6bb5\u6620\u5c04\uff0c\u82e5\u4e0d\u6620\u5c04\uff0c\u6267\u884c\u5bfc\u5165\u65f6\u7cfb\u7edf\u5c06\u81ea\u52a8\u751f\u6210\u7f16\u7801\u3002", (String)"FieldModifyAlerter_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), infoMsg);
    }
}

