/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.bostype.bos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import kd.imsc.dmw.helper.bostype.bos.BOSObjectType;
import kd.imsc.dmw.helper.bostype.util.Base64Encoder;
import kd.imsc.dmw.helper.bostype.util.Uuid;

public final class BOSUuid
implements Serializable {
    private static final long serialVersionUID = -65533L;
    private transient Uuid uuid;
    private transient BOSObjectType type;
    private transient byte encoding;
    private static final byte MIXED_ENCODING = 0;
    private static final byte BASE64_ENCODING = 1;
    private volatile String toString = null;
    private static final byte BASE64_SHORT_ENCODING = 2;
    private static final int COMPATIBLE_MIXED_ENCODING_LENGTH = 40;
    private static final int MIXED_ENCODING_LENGTH = 44;
    private static final int BASE64_ENCODING_LENGTH = 28;
    private static final int BASE64_SHORT_ENCODING_LENGTH = 16;
    private static String UTF8 = "UTF-8";

    public static synchronized BOSUuid create(BOSObjectType type) {
        assert (type != null);
        return new BOSUuid(Uuid.create(), type, 1);
    }

    public static BOSUuid create(String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException("Invalid typeString.");
        }
        assert (typeString.length() == 8 || typeString.length() == 4);
        return BOSUuid.create(BOSObjectType.create(typeString));
    }

    private BOSUuid(Uuid uuid, BOSObjectType type, byte encoding) {
        if (type == null) {
            throw new IllegalArgumentException("Invalid BOSObjectType.");
        }
        this.encoding = type.toInteger() == 0 ? (byte)0 : encoding;
        this.uuid = uuid;
        this.type = type;
    }

    public BOSObjectType getType() {
        return this.type;
    }

    public static BOSUuid read(String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("id is null or length is 0. '" + id + "'");
        }
        if (id.length() == 44 || id.length() == 40) {
            Uuid uuid = Uuid.read(id.substring(0, 36));
            String type = id.substring(36).intern();
            return new BOSUuid(uuid, BOSObjectType.create(type), 0).setToString(id);
        }
        if (id.length() == 28) {
            if (id.charAt(id.length() - 1) != '=') {
                throw new IllegalArgumentException("the argument 'id' is invalid. '" + id + "'");
            }
            byte[] array = Base64Encoder.base64ToByteArray(id);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(array));
            try {
                Uuid uuid = Uuid.read(in);
                BOSObjectType type = BOSObjectType.read(in);
                return new BOSUuid(uuid, type, 1).setToString(id);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
        if (id.length() == 16) {
            byte[] array = Base64Encoder.base64ToByteArray(id);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(array));
            try {
                Uuid uuid = Uuid.read2(in);
                BOSObjectType type = BOSObjectType.read(in);
                return new BOSUuid(uuid, type, 2).setToString(id);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
        throw new IllegalArgumentException("The argument 'id' is invalid. '" + id + "' length:" + id.length());
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        if (this.encoding == 1) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(28);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                this.uuid.write(out);
                this.type.write(out);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
            this.toString = Base64Encoder.byteArrayToBase64(baos.toByteArray());
        } else if (this.encoding == 2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                this.uuid.write2(out);
                this.type.write(out);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
            this.toString = Base64Encoder.byteArrayToBase64(baos.toByteArray());
        } else if (this.encoding == 0) {
            this.toString = this.uuid.toString() + this.type.toString();
        } else {
            throw new AssertionError((Object)"unhandled encoding.");
        }
        return this.toString;
    }

    private BOSUuid setToString(String toString) {
        this.toString = toString;
        return this;
    }

    public static boolean isValidLength(String bosuuid) {
        if (bosuuid == null || bosuuid.length() == 0) {
            return false;
        }
        return bosuuid.length() == 44 || bosuuid.length() == 40 || bosuuid.length() == 28 || bosuuid.length() == 16;
    }

    public static boolean isValidLength(String bosuuid, boolean trim) {
        if (bosuuid == null || bosuuid.length() == 0) {
            return false;
        }
        String id = null;
        id = trim ? bosuuid.trim() : bosuuid;
        return BOSUuid.isValidLength(id);
    }

    public static boolean isValid(String bosuuid, boolean trim) {
        if (!BOSUuid.isValidLength(bosuuid, trim)) {
            return false;
        }
        try {
            BOSUuid.read(bosuuid.trim());
        }
        catch (IllegalArgumentException e1) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static BOSObjectType getBOSObjectType(String bosuuid, boolean validate) {
        if (validate && !BOSUuid.isValid(bosuuid, true)) {
            return null;
        }
        return BOSUuid.read(bosuuid.trim()).getType();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BOSUuid) {
            return this.uuid.equals(((BOSUuid)obj).uuid) && this.type.equals(((BOSUuid)obj).type);
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.uuid.write(s);
        this.type.write(s);
        s.writeByte(this.encoding);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.uuid = Uuid.read(s);
        this.type = BOSObjectType.read(s);
        this.encoding = s.readByte();
    }

    public void write(DataOutput out) throws IOException {
        this.uuid.write(out);
        this.type.write(out);
        out.writeByte(this.encoding);
        if (this.toString != null) {
            out.writeByte(1);
            out.write(this.toString().getBytes(UTF8));
        } else {
            out.writeByte(0);
        }
    }

    public static BOSUuid read(DataInput in) throws IOException {
        BOSUuid bosUuid = new BOSUuid(Uuid.read(in), BOSObjectType.read(in), in.readByte());
        if (in.readByte() == 1) {
            int i = 0;
            if (bosUuid.encoding == 1) {
                i = 28;
            } else if (bosUuid.encoding == 2) {
                i = 16;
            } else if (bosUuid.encoding == 0) {
                i = bosUuid.type.toString().length() == 4 ? 40 : 44;
            }
            if (i != 0) {
                byte[] bytes = new byte[i];
                in.readFully(bytes, 0, i);
                bosUuid.toString = new String(bytes, UTF8);
            }
        }
        return bosUuid;
    }
}

