/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.eas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DbUtil;

public class EasQueryHelper {
    private EasQueryHelper() {
    }

    public static List<Map<String, Object>> queryEasData(Long dbLinkId, String sql) throws DmwBizException {
        IscServiceImpl service = new IscServiceImpl(dbLinkId);
        String templateSql = DbUtil.buildPaginationSql(sql);
        String countSql = DbUtil.changeCountSql(sql);
        return service.pageQuery(templateSql, countSql, 1000L);
    }

    public static List<Map<String, Object>> queryEasData(Long dbLinkId, String templateSql, String countSql) throws DmwBizException {
        IscServiceImpl service = new IscServiceImpl(dbLinkId);
        return service.pageQuery(templateSql, countSql, 1000L);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> saveXhData(String tableName, List<Map<String, Object>> allEasData, String[] xhFieldNames, String[] easFieldNames) {
        void var12_15;
        HashMap<String, String> errMap = new HashMap<String, String>(2);
        errMap.put("IsInterrupted", "no");
        ArrayList<DynamicObject> xhNewDataList = new ArrayList<DynamicObject>(10);
        String fields = String.join((CharSequence)",", xhFieldNames);
        DynamicObject[] xhExistData = BusinessDataServiceHelper.load((String)tableName, (String)("id,number," + fields), (QFilter[])new QFilter[0]);
        ArrayList<String> xhExistNumber = new ArrayList<String>(8);
        ArrayList<Object> xhExistId = new ArrayList<Object>(8);
        ArrayList<String> easExistNumber = new ArrayList<String>(8);
        for (DynamicObject data : xhExistData) {
            xhExistId.add(data.getPkValue());
            xhExistNumber.add(data.getString("number"));
        }
        for (Map map : allEasData) {
            Object number = map.get("fnumber");
            if (number == null) continue;
            easExistNumber.add(number.toString());
            int index = xhExistNumber.indexOf(number.toString());
            if (index != -1) {
                for (int i = 0; i < easFieldNames.length; ++i) {
                    Object tempValue = map.get(easFieldNames[i]);
                    Object easFieldValue = tempValue != null ? tempValue : "";
                    xhExistData[index].set(xhFieldNames[i], easFieldValue);
                }
                continue;
            }
            DynamicObject xhData = BusinessDataServiceHelper.newDynamicObject((String)tableName);
            for (int i = 0; i < easFieldNames.length; ++i) {
                Object tempValue = map.get(easFieldNames[i]);
                Object easFieldValue = tempValue != null ? tempValue : "";
                xhData.set(xhFieldNames[i], easFieldValue);
            }
            xhData.set("status", (Object)"C");
            xhData.set("enable", (Object)"1");
            xhNewDataList.add(xhData);
        }
        ArrayList redundantId = new ArrayList(8);
        boolean bl = false;
        while (var12_15 < xhExistNumber.size()) {
            String xhNum = (String)xhExistNumber.get((int)var12_15);
            if (!easExistNumber.contains(xhNum)) {
                redundantId.add(xhExistId.get((int)var12_15));
            }
            ++var12_15;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (TXHandle h1 = TX.required();){
            try {
                OperationResult resultDelete;
                DeleteServiceHelper deleteHelper = new DeleteServiceHelper();
                if (!redundantId.isEmpty() && !(resultDelete = deleteHelper.deleteOperate("delete", tableName, redundantId.toArray(), OperateOption.create())).isSuccess()) {
                    stringBuilder.append(CommonUtils.getErrDetail(resultDelete));
                }
                int batchSize = 1000;
                int numNewBatches = (int)Math.ceil((double)xhNewDataList.size() / (double)batchSize);
                for (int i = 0; i < numNewBatches; ++i) {
                    int start = i * batchSize;
                    int end = Math.min(start + batchSize, xhNewDataList.size());
                    List batch = xhNewDataList.subList(start, end);
                    OperationResult result = SaveServiceHelper.saveOperate((String)tableName, (DynamicObject[])batch.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    if (result.isSuccess()) continue;
                    stringBuilder.append(CommonUtils.getErrDetail(result));
                }
                SaveServiceHelper.update((DynamicObject[])xhExistData);
            }
            catch (Exception ex) {
                errMap.put("IsInterrupted", "yes");
                h1.markRollback();
                stringBuilder.append(ResManager.loadKDString((String)"\u67e5\u8be2\u7684EAS\u6570\u636e\u4fdd\u5b58\u51fa\u9519\u3002", (String)"EasQueryHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
        }
        errMap.put("errmsg", stringBuilder.toString());
        return errMap;
    }

    public static boolean judgeDbLinkIsNull(DynamicObject dbLink, IFormView view) {
        if (dbLink == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u96c6\u6210\u8fde\u63a5\u914d\u7f6e\u3002", (String)"UserguideEASEditPlugin_19", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static boolean dbLinkTestClick(DynamicObject dbLink, IFormView view) {
        IscServiceImpl iscService = new IscServiceImpl((Long)dbLink.getPkValue());
        Map<String, Object> result = iscService.testConnect();
        if (Boolean.FALSE.equals(result.get("success"))) {
            String msgTpl = ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\uff0c\u539f\u56e0\u4e3a:%s", (String)"EasQueryHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            String msg = String.format(msgTpl, result.get("message"));
            view.showErrorNotification(msg);
            return false;
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f", (String)"EasQueryHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        return true;
    }

    public static void jumpIscLinkConfClick(IFormView view, String dbLinkMark) {
        DynamicObject dbLink = (DynamicObject)view.getModel().getValue(dbLinkMark);
        if (dbLink == null) {
            return;
        }
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        linkQueryPkIdCollection.addLinkQueryPkId(dbLink.getPkValue());
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("isc_database_link");
        param.setFormId("bos_list");
        param.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)param);
    }
}

