/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.similarity.proxy;

import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.helper.similarity.IStringSimilarity;
import kd.imsc.dmw.helper.similarity.impl.JaccardStringSimilarity;
import kd.imsc.dmw.utils.StringUtils;

public class StrSimilarityProxy {
    private static final String SIMILARITY = JaccardStringSimilarity.class.getName();
    private static final double THRESHOLD = 0.65;

    public static Tuple<String, Double> getSimilaritiesWord(String first, List<String> wordList) {
        return StrSimilarityProxy.getSimilaritiesWord(first, wordList, 0.65);
    }

    public static Tuple<String, Double> getSimilaritiesWord(String first, List<String> wordList, double scoreHold) {
        if (StringUtils.isEmpty(first) || CollectionUtils.isEmpty(wordList)) {
            return null;
        }
        String result = null;
        double tempScore = 0.0;
        IStringSimilarity iStringSimilarity = StrSimilarityProxy.innerFindSimilarityAlgorithm(SIMILARITY);
        for (String word : wordList) {
            double score;
            if (StringUtils.isEmpty(word) || !((score = iStringSimilarity.calcStrSimilarity(first, word)) >= scoreHold) || !(tempScore < score)) continue;
            tempScore = score;
            result = word;
        }
        if (StringUtils.isEmpty(result)) {
            return null;
        }
        return Tuple.create(result, (Object)tempScore);
    }

    private static IStringSimilarity innerFindSimilarityAlgorithm(String algorithm) {
        if (JaccardStringSimilarity.class.getName().equals(algorithm)) {
            return JaccardStringSimilarity.INSTANCE;
        }
        throw new UnsupportedOperationException("Unknown SimilarityAlgorithm\uff1a" + algorithm);
    }
}

