/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.tpl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;

public class MigrateCheckItemHelper {
    private MigrateCheckItemHelper() {
    }

    public static String buildEASSql(String table, Collection<Object> ids) {
        HashSet<String> hasTables = new HashSet<String>(Collections.singletonList("T_BD_ACCOUNTVIEW"));
        StringBuilder builder = new StringBuilder();
        if (hasTables.contains(table.toUpperCase())) {
            builder.append("select a.fid,a.fname_l2,a.fnumber,c.fnumber orgnum,c.fname_l2 orgname from ").append(table).append(" as a left join T_ORG_COMPANY c on a.FCOMPANYID  = c.fid where a.fid in (");
        } else {
            builder.append("select a.fid ,a.fname_l2,a.fnumber from ").append(table).append(" as a where a.fid in (");
        }
        for (Object id : ids) {
            builder.append('\'').append(id).append('\'').append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(')');
        return builder.toString();
    }

    public static String buildNCSql(String table, Collection<Object> ids) {
        return "";
    }

    public static void openHandFixPage(IFormView view, CheckItemLog checkItemLog, Long dbLink, String checkItemFormId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("dmw_hand_fix");
        parameter.setPageId(view.getPageId() + "dmw_hand_fix");
        parameter.setCustomParam("checkItemLog", (Object)JSONObject.toJSONString((Object)checkItemLog));
        parameter.setCustomParam("dblinkid", (Object)dbLink);
        parameter.setCustomParam("checkitemFormId", (Object)checkItemFormId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(parameter);
    }

    public static void openCheckDetailPage(IFormView view, CheckItemLog checkItemLog) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("dmw_check_detail");
        parameter.setPageId(view.getParentView().getPageId() + "dmw_check_detail");
        parameter.setCustomParam("checkItemLog", (Object)JSONObject.toJSONString((Object)checkItemLog));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(parameter);
    }

    public static void openXhFixPage(IFormView view, String fixUrl, CheckItemLog checkItemLog) {
        Map<String, List<Object>> errorXhIdMap = checkItemLog.getErrorXhIdMap();
        List<Object> tempIdList = errorXhIdMap.get(fixUrl);
        List<Object> idList = new ArrayList(8);
        QFilter qFilter = QFilter.isNotNull((String)"id");
        if (!CommonUtils.isNull(tempIdList)) {
            idList = tempIdList.stream().map(n -> Long.valueOf(n.toString())).collect(Collectors.toList());
        } else {
            List<Map<String, Object>> fixXhDataList = checkItemLog.getFixXhSysDataList();
            if (fixXhDataList != null && !fixXhDataList.isEmpty()) {
                for (Map<String, Object> data : fixXhDataList) {
                    if (CommonUtils.isNull(data.get("id"))) continue;
                    idList.add(Long.valueOf(data.get("id").toString()));
                }
            }
        }
        if (!idList.isEmpty()) {
            qFilter.and(new QFilter("id", "in", idList));
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setPageId(view.getParentView().getPageId() + fixUrl);
        parameter.setBillFormId(fixUrl.toLowerCase());
        parameter.getListFilterParameter().setFilter(qFilter);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)parameter);
    }

    public static String getSrcSysTableName(DynamicObject migrateDynObj) {
        if (migrateDynObj == null) {
            return "";
        }
        String easObj = migrateDynObj.getString("easobjectid");
        if (StringUtils.isEmpty((String)easObj)) {
            return "";
        }
        String[] split = easObj.split(";");
        Long easObjId = Long.valueOf(split[0]);
        QFilter qFilter = new QFilter("id", "=", (Object)easObjId);
        DynamicObject iscSchema = QueryServiceHelper.queryOne((String)"isc_metadata_schema", (String)"table_name", (QFilter[])qFilter.toArray());
        if (iscSchema == null) {
            return "";
        }
        return iscSchema.getString("table_name");
    }

    public static String getRepairLogFormId(String checkItemFormId) {
        String repairLogFormId = "dmw_migratecheckitem";
        switch (checkItemFormId) {
            case "dmw_migratecheckitem_eas": {
                repairLogFormId = "dmw_migraterepairlog_eas";
                break;
            }
            case "dmw_migratecheckitem_nc": {
                repairLogFormId = "dmw_migraterepairlog_nc";
                break;
            }
            case "dmw_migratecheckitem_ecc": {
                repairLogFormId = "dmw_migraterepairlog_ecc";
                break;
            }
        }
        return repairLogFormId;
    }

    public static Map<Long, String> verifyServiceFlowByStart(String checkitemFormId, long serviceFlowId, DynamicObject flowDynObj) {
        Map<Long, String> releasedErrorMsgMap;
        HashSet<Long> serviceFlowIdSet = new HashSet<Long>(1);
        serviceFlowIdSet.add(serviceFlowId);
        DynamicObject[] flowDynObjs = null;
        if (flowDynObj != null) {
            flowDynObjs = new DynamicObject[]{flowDynObj};
        }
        if ((releasedErrorMsgMap = MigrateCheckItemHelper.verifyServiceFlowReleased(checkitemFormId, serviceFlowIdSet, flowDynObjs)).containsKey(serviceFlowId)) {
            return releasedErrorMsgMap;
        }
        return MigrateCheckItemHelper.verifyServiceFlowDefine(flowDynObjs);
    }

    private static Map<Long, String> verifyServiceFlowReleased(String checkitemFormId, Set<Long> serviceFlowIdSet, DynamicObject[] flowDynObjs) {
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(16);
        String errorMsg = ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u3010%s\u3011\u7684\u670d\u52a1\u6d41\u7a0b\u5fc5\u987b\u4e3a\u5df2\u53d1\u5e03\u4e14\u542f\u7528\u3002", (String)"MigrateCheckItemHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        if (!CommonUtils.isNull(flowDynObjs)) {
            for (DynamicObject flowDynObj : flowDynObjs) {
                long flowId = flowDynObj.getLong("id");
                if (!flowDynObj.getBoolean("is_released") || !"1".equals(flowDynObj.getString("enable"))) {
                    errorMsgMap.put(flowId, String.format(errorMsg, flowDynObj.getString("name")));
                }
                serviceFlowIdSet.remove(flowId);
            }
        }
        if (!serviceFlowIdSet.isEmpty()) {
            DynamicObject[] checkItemDynObjs;
            String msg = ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u3010%s\u3011\u7684\u670d\u52a1\u6d41\u7a0b\u672a\u90e8\u7f72\u3002", (String)"MigrateCheckItemHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            for (DynamicObject checkItemDynObj : checkItemDynObjs = BusinessDataServiceHelper.load((String)checkitemFormId, (String)String.join((CharSequence)",", "serviceflowid", "serviceflowname"), (QFilter[])new QFilter("serviceflowid", "in", serviceFlowIdSet).toArray())) {
                long flowId = checkItemDynObj.getLong("serviceflowid");
                errorMsgMap.put(flowId, String.format(msg, checkItemDynObj.getString("serviceflowname")));
            }
        }
        return errorMsgMap;
    }

    public static Map<Long, String> verifyServiceFlowDefine(Set<Long> serviceFlowIdSet) {
        if (CommonUtils.isNull(serviceFlowIdSet)) {
            return new HashMap<Long, String>(0);
        }
        DynamicObject[] flowDynObjs = BusinessDataServiceHelper.load((String)"isc_service_flow", (String)"id,var_category,var_type,var_name,is_output_param", (QFilter[])new QFilter("id", "in", serviceFlowIdSet).toArray());
        if (CommonUtils.isNull(flowDynObjs)) {
            return new HashMap<Long, String>(0);
        }
        return MigrateCheckItemHelper.verifyServiceFlowDefine(flowDynObjs);
    }

    private static Map<Long, String> verifyServiceFlowDefine(DynamicObject[] flowDynObjs) {
        Set<Long> errorMsgFlowIdSet = MigrateCheckItemHelper.getErrorMsgFlowId(flowDynObjs);
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(16);
        String errorMsg = ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u4e2d\u5fc5\u987b\u8bbe\u7f6e\u53d8\u91cf\u7c7b\u578b\u4e3a\u3010\u96c6\u6210\u5bf9\u8c61\u3011\uff0c\u6570\u636e\u7c7b\u578b\u7f16\u7801\u4e3a\u3010dmw_migratecheckitemresult\u3011\uff0c\u53d8\u91cf\u540d\u4e3a\u3010checkResult\u3011\uff0c\u662f\u5426\u8f93\u51fa\u53c2\u6570\u4e3a\u3010\u662f\u3011\u3002", (String)"MigrateCheckItemHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        for (DynamicObject flowDynObj : flowDynObjs) {
            long serviceFlowId = flowDynObj.getLong("id");
            if (!errorMsgFlowIdSet.contains(serviceFlowId)) continue;
            errorMsgMap.put(serviceFlowId, errorMsg);
        }
        return errorMsgMap;
    }

    private static Set<Long> getErrorMsgFlowId(DynamicObject[] flowDynObjs) {
        HashSet<Long> errorMsgFlowIdSet = new HashSet<Long>(flowDynObjs.length);
        for (DynamicObject flowDynObj : flowDynObjs) {
            DynamicObjectCollection variablesColl = flowDynObj.getDynamicObjectCollection("variables");
            boolean isExist = false;
            for (DynamicObject variablesDynObj : variablesColl) {
                if (!variablesDynObj.getBoolean("is_output_param") || !"isc_metadata_schema".equals(variablesDynObj.getString("var_category")) || 1363973704933914447L != DynamicObjectUtils.getPkValue(variablesDynObj, "var_type") || !"checkResult".equals(variablesDynObj.getString("var_name"))) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            errorMsgFlowIdSet.add(flowDynObj.getLong("id"));
        }
        return errorMsgFlowIdSet;
    }
}

