/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.tpl;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.dmw.common.pagemodel.DmwMigrateuserguide;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideProjectHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;

public class MigrateUserGuideRelationHelper {
    private static final Long SERVICEFLOWID = 2043558740204004352L;

    private MigrateUserGuideRelationHelper() {
    }

    public static void buildCheckAndExecEntries(IFormView view) {
        int i;
        DynamicObjectCollection mulSchemeMigObjects;
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if (StringUtil.isEmpty(projectFormId)) {
            return;
        }
        IDataModel modal = view.getModel();
        long migrateProjectId = MigrateUserGuideProjectHelper.getCurrentMigrationProjectId(view);
        String schemeIsChanged = view.getPageCache().get("schemeIsChanged");
        if (migrateProjectId == 0L || "yes".equals(schemeIsChanged)) {
            mulSchemeMigObjects = MigrateUserGuideProjectHelper.buildMigObjFromMulScheme(view, true);
        } else {
            boolean isModify = MigrateUserGuideProjectHelper.isEntryChanged(view, migrateProjectId);
            DynamicObject migrateProject = BusinessDataServiceHelper.loadSingle((Object)migrateProjectId, (String)projectFormId);
            mulSchemeMigObjects = MigrateUserGuideProjectHelper.buildMigObjFromProject(view, migrateProject, isModify);
        }
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)projectFormId);
        String tableName = newDynObj.getDynamicObjectCollection("treeentryentity").getDynamicObjectType().getAlias();
        Map<Long, Object> idMappingMap = MigrateUserGuideProjectHelper.getIdMappingMap(mulSchemeMigObjects, tableName);
        MigrateUserGuideProjectHelper.setMigExecEntry(view, mulSchemeMigObjects, idMappingMap, "dmw_migratescheme");
        MigrateUserGuideRelationHelper.needMidTableMigration(view);
        for (i = 0; i < mulSchemeMigObjects.size(); ++i) {
            MigrateUserGuideRelationHelper.needBotpMigration(view, mulSchemeMigObjects, i);
        }
        for (i = 0; i < mulSchemeMigObjects.size(); ++i) {
            MigrateUserGuideRelationHelper.needDapMigration(view, mulSchemeMigObjects, i);
        }
        for (i = 0; i < mulSchemeMigObjects.size(); ++i) {
            MigrateUserGuideRelationHelper.needRecordMigration(view, mulSchemeMigObjects, i);
        }
        for (i = 0; i < mulSchemeMigObjects.size(); ++i) {
            MigrateUserGuideRelationHelper.needDisableMigration(view, mulSchemeMigObjects, i);
        }
        DynamicObjectCollection execEntries = modal.getEntryEntity("migtreeentryentity");
        modal.updateEntryCache(execEntries);
        view.updateView("migtreeentryentity");
    }

    public static void judgeBotpMigration(IFormView view, int row, boolean isSupport) {
        IDataModel modal = view.getModel();
        if (isSupport) {
            String migModel = (String)modal.getValue("migrationmodel");
            String migMark = "A".equals(migModel) ? "migbotpini" : "migbotpall";
            String name = ResManager.loadKDString((String)"botp\u5173\u7cfb", (String)"MigrateUserGuideRelationHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            MigrateUserGuideRelationHelper.judgeIfSupport(view, row, migMark, "migbotp", name);
        }
        MigrateUserGuideRelationHelper.recordChangeData(view, modal.getEntryEntity("treeentryentity"), new int[]{row}, false);
    }

    public static void judgeDapMigration(IFormView view, int row, boolean isSupport) {
        IDataModel modal = view.getModel();
        if (isSupport) {
            String migModel = (String)modal.getValue("migrationmodel");
            String migMark = "A".equals(migModel) ? "migdapini" : "migdapall";
            String name = ResManager.loadKDString((String)"dap\u5173\u7cfb", (String)"MigrateUserGuideRelationHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            MigrateUserGuideRelationHelper.judgeIfSupport(view, row, migMark, "migdap", name);
        }
        MigrateUserGuideRelationHelper.recordChangeData(view, modal.getEntryEntity("treeentryentity"), new int[]{row}, false);
    }

    public static void judgeRecordMigration(IFormView view, int row, boolean isSupport) {
        IDataModel modal = view.getModel();
        if (isSupport) {
            String migModel = (String)modal.getValue("migrationmodel");
            String migMark = "A".equals(migModel) ? "migrecordini" : "migrecordall";
            String name = ResManager.loadKDString((String)"\u5ba1\u6279\u8bb0\u5f55", (String)"MigrateUserGuideRelationHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            MigrateUserGuideRelationHelper.judgeIfSupport(view, row, migMark, "migrecord", name);
        }
        MigrateUserGuideRelationHelper.recordChangeData(view, modal.getEntryEntity("treeentryentity"), new int[]{row}, false);
    }

    public static void judgeIfSupport(IFormView view, int row, String migMark, String supportMark, String name) {
        IDataModel modal = view.getModel();
        DynamicObjectCollection scopeEntries = modal.getEntryEntity("treeentryentity");
        DynamicObject scopeEntry = (DynamicObject)scopeEntries.get(row);
        DynamicObject migObj = scopeEntry.getDynamicObject("migrateobject");
        if (migObj == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8fc1\u79fb\u5bf9\u8c61\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"MigrateUserGuideRelationHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        boolean ifSupport = migObj.getBoolean(migMark);
        if (!ifSupport) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8fc1\u79fb%s\u3002", (String)"MigrateUserGuideRelationHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), name));
            modal.setValue(supportMark, (Object)false, row);
            view.updateView(supportMark, row);
        }
    }

    private static void needBotpMigration(IFormView view, DynamicObjectCollection mulSchemeMigObjects, int row) {
        String botpType;
        String schemeId;
        String initType;
        IDataModel modal = view.getModel();
        String migModel = (String)modal.getValue("migrationmodel");
        if ("A".equals(migModel)) {
            initType = "inittypebotp";
            schemeId = "initschemebotpid";
            botpType = "migbotpini";
        } else {
            initType = "alltypebotp";
            schemeId = "allschemebotpid";
            botpType = "migbotpall";
        }
        DynamicObject migObj = ((DynamicObject)mulSchemeMigObjects.get(row)).getDynamicObject("migrateobject");
        if (migObj == null) {
            return;
        }
        String isSupport = MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, botpType);
        if (!Boolean.parseBoolean(isSupport)) {
            return;
        }
        String name = ResManager.loadKDString((String)"botp\u5173\u7cfb", (String)"MigrateUserGuideRelationHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        MigrateUserGuideRelationHelper.needRelationMigration(view, migObj, name, initType, schemeId);
    }

    private static void needDapMigration(IFormView view, DynamicObjectCollection mulSchemeMigObjects, int row) {
        String dapType;
        String schemeId;
        String initType;
        IDataModel modal = view.getModel();
        String migModel = (String)modal.getValue("migrationmodel");
        if ("A".equals(migModel)) {
            initType = "inittypedap";
            schemeId = "initschemedapid";
            dapType = "migdapini";
        } else {
            initType = "alltypedap";
            schemeId = "allschemedapid";
            dapType = "migdapall";
        }
        DynamicObject migObj = ((DynamicObject)mulSchemeMigObjects.get(row)).getDynamicObject("migrateobject");
        if (migObj == null) {
            return;
        }
        String isSupport = MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, dapType);
        if (!Boolean.parseBoolean(isSupport)) {
            return;
        }
        String name = ResManager.loadKDString((String)"dap\u5173\u7cfb", (String)"MigrateUserGuideRelationHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        MigrateUserGuideRelationHelper.needRelationMigration(view, migObj, name, initType, schemeId);
    }

    private static void needRecordMigration(IFormView view, DynamicObjectCollection mulSchemeMigObjects, int row) {
        String recordType;
        String schemeId;
        String initType;
        IDataModel modal = view.getModel();
        String migModel = (String)modal.getValue("migrationmodel");
        if ("A".equals(migModel)) {
            initType = "inittyperecord";
            schemeId = "initschemerecordid";
            recordType = "migrecordini";
        } else {
            initType = "alltyperecord";
            schemeId = "allschemerecordid";
            recordType = "migrecordall";
        }
        DynamicObject migObj = ((DynamicObject)mulSchemeMigObjects.get(row)).getDynamicObject("migrateobject");
        if (migObj == null) {
            return;
        }
        String isSupport = MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, recordType);
        if (!Boolean.parseBoolean(isSupport)) {
            return;
        }
        String name = ResManager.loadKDString((String)"\u5ba1\u6279\u8bb0\u5f55", (String)"MigrateUserGuideRelationHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        MigrateUserGuideRelationHelper.needRelationMigration(view, migObj, name, initType, schemeId);
    }

    private static void needDisableMigration(IFormView view, DynamicObjectCollection mulSchemeMigObjects, int row) {
        IDataModel modal = view.getModel();
        DynamicObject migObj = ((DynamicObject)mulSchemeMigObjects.get(row)).getDynamicObject("migrateobject");
        if (migObj == null) {
            return;
        }
        String isSupport = MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, "disableinvaliddata");
        if (!Boolean.parseBoolean(isSupport) || "2".equals(migObj.getString("executetype"))) {
            return;
        }
        String name = ResManager.loadKDString((String)"\u5931\u6548\u6570\u636e\u6062\u590d", (String)"MigrateUserGuideRelationHelper_8", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        String tableName = MigrateUserGuideProjectHelper.getMigObjectTableNameByUserGuide(view);
        if (StringUtil.isNotEmpty(tableName)) {
            DynamicObjectCollection execEntries = modal.getEntryEntity("migtreeentryentity");
            DynamicObject execEntry = execEntries.addNew();
            execEntry.set("id", (Object)DB.genLongId((String)tableName));
            execEntry.set("migratestatus", (Object)"A");
            execEntry.set("parentmigobj", (Object)migObj);
            execEntry.set("migrateobjname", (Object)(migObj.getString("name") + name));
            execEntry.set("schemetype", (Object)"isc_service_flow");
            execEntry.set(String.join((CharSequence)"_", "startscheme", "id"), (Object)DmwMigrateuserguide.ENABLE_SCHEME_ID);
            execEntry.set("migrateexecutetype", (Object)"1");
            execEntry.set("invalidatastatus", (Object)"2");
        }
    }

    public static void needRelationMigration(IFormView view, DynamicObject migObj, String name, String initType, String schemeMark) {
        String tableName = MigrateUserGuideProjectHelper.getMigObjectTableNameByUserGuide(view);
        if (StringUtil.isNotEmpty(tableName)) {
            IDataModel modal = view.getModel();
            DynamicObjectCollection execEntries = modal.getEntryEntity("migtreeentryentity");
            DynamicObject execEntry = execEntries.addNew();
            execEntry.set("id", (Object)DB.genLongId((String)tableName));
            execEntry.set("migratestatus", (Object)"A");
            execEntry.set("parentmigobj", (Object)migObj);
            execEntry.set("migrateobjname", (Object)(migObj.getString("name") + name));
            execEntry.set("schemetype", (Object)migObj.getString(initType));
            execEntry.set(String.join((CharSequence)"_", "startscheme", "id"), migObj.get(schemeMark));
            execEntry.set("migrateexecutetype", (Object)"1");
        }
    }

    public static void needMidTableMigration(IFormView view) {
        IDataModel modal = view.getModel();
        DynamicObjectCollection scopeEntries = modal.getEntryEntity("treeentryentity");
        boolean ifMigMidTable = false;
        for (DynamicObject scopeEntry : scopeEntries) {
            if (!scopeEntry.getBoolean("migbotp") && !scopeEntry.getBoolean("migdap")) continue;
            ifMigMidTable = true;
            break;
        }
        if (!ifMigMidTable) {
            return;
        }
        String tableName = MigrateUserGuideProjectHelper.getMigObjectTableNameByUserGuide(view);
        if (StringUtil.isNotEmpty(tableName)) {
            DynamicObjectCollection execEntries = modal.getEntryEntity("migtreeentryentity");
            DynamicObject execEntry = execEntries.addNew();
            execEntry.set("id", (Object)DB.genLongId((String)tableName));
            execEntry.set("migratestatus", (Object)"A");
            execEntry.set("migrateobjname", (Object)ResManager.loadKDString((String)"IMSCBOTP\u4e2d\u95f4\u8868\u521d\u59cb\u5316(EAS-\u82cd\u7a79)", (String)"MigrateUserGuideRelationHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            execEntry.set("schemetype", (Object)"isc_service_flow");
            execEntry.set(String.join((CharSequence)"_", "startscheme", "id"), (Object)SERVICEFLOWID);
            execEntry.set("migrateexecutetype", (Object)"1");
        }
    }

    public static void recordChangeData(IFormView view, DynamicObjectCollection scopeEntries, int[] rows, boolean fromScheme) {
        String objectMapMapStr = view.getPageCache().get("changeDataMark");
        HashMap<Object, Map<String, String>> objectMapMap = CommonUtils.isNull(objectMapMapStr) || "null".equals(objectMapMapStr) ? new HashMap<Object, Map<String, String>>(8) : (Map)JSON.parseObject((String)objectMapMapStr, Map.class);
        for (int row : rows) {
            Map<String, String> dataMap;
            DynamicObject scopeEntry = (DynamicObject)scopeEntries.get(row);
            DynamicObject migObj = scopeEntry.getDynamicObject("migrateobject");
            if (migObj == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8fc1\u79fb\u5bf9\u8c61\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"MigrateUserGuideRelationHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            Map map = dataMap = CommonUtils.isNull(objectMapMap.get(migObj.getPkValue())) ? new HashMap(8) : (Map)objectMapMap.get(migObj.getPkValue());
            if (!fromScheme) {
                dataMap.put("migbotp", scopeEntry.getString("migbotp"));
                dataMap.put("migdap", scopeEntry.getString("migdap"));
                dataMap.put("migrecord", scopeEntry.getString("migrecord"));
                dataMap.put("disableinvaliddata", scopeEntry.getString("disableinvaliddata"));
                dataMap.put("enableinvaliddata", scopeEntry.getString("enableinvaliddata"));
            }
            dataMap.put("sortnumexec", scopeEntry.getString("sortnumexec"));
            objectMapMap.put(migObj.getPkValue(), dataMap);
        }
        view.getPageCache().put("changeDataMark", JSON.toJSONString(objectMapMap));
    }

    public static String getModifyRecord(IFormView view, DynamicObject migObj, String mark) {
        HashMap objectMapMap;
        String objectMapMapStr = view.getPageCache().get("changeDataMark");
        Map map = objectMapMap = CommonUtils.isNull(objectMapMapStr) || "null".equals(objectMapMapStr) ? new HashMap(8) : (Map)JSON.parseObject((String)objectMapMapStr, Map.class);
        if (objectMapMap.containsKey(migObj.getPkValue())) {
            String attribute;
            switch (mark) {
                case "migbotpini": 
                case "migbotpall": {
                    attribute = "migbotp";
                    break;
                }
                case "migdapini": 
                case "migdapall": {
                    attribute = "migdap";
                    break;
                }
                case "migrecordini": 
                case "migrecordall": {
                    attribute = "migrecord";
                    break;
                }
                default: {
                    attribute = mark;
                }
            }
            return (String)((Map)objectMapMap.get(migObj.getPkValue())).get(attribute);
        }
        return migObj.getString(mark);
    }
}

