/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.mservice;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.imsc.dmw.entity.BalanceQueryParam;
import kd.imsc.dmw.helper.BalanceCheckDataHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;

public class BalanceCheckDataServiceImpl {
    private static final Log logger = LogFactory.getLog(BalanceCheckDataServiceImpl.class);
    private static final String ALGOX_KEY = "datafetch_dmw_easbalance";

    public String getBalanceCheckData(String billId, String checkcurrencynumber, String xhorgid, String xhbooktypeid, String xhperiodtypeid, String xhperiodnumber, String xhcurrencyid) {
        JSONObject resultJson = new JSONObject();
        long begin = System.currentTimeMillis();
        logger.info("getBalanceCheckData->begin " + begin);
        String msg = "";
        try {
            if (StringUtil.isEmpty(checkcurrencynumber) || StringUtil.isEmpty(xhorgid) || StringUtil.isEmpty(xhbooktypeid) || StringUtil.isEmpty(xhperiodtypeid) || StringUtil.isEmpty(xhperiodnumber) || StringUtil.isEmpty(xhcurrencyid)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u5bf9\u5e01\u79cd\u3001\u661f\u701a\u7684\u7ec4\u7ec7\u3001\u661f\u701a\u7684\u8d26\u7c3f\u7c7b\u578b\u3001\u661f\u701a\u7684\u671f\u95f4\u7c7b\u578b\u3001\u661f\u701a\u7684\u4f1a\u8ba1\u671f\u95f4\u3001\u661f\u701a\u7684\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceCheckDataServiceImpl_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            DynamicObject checkDataDynObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(billId), (String)"dmw_balancecheckdata");
            if (checkDataDynObj == null) {
                throw new KDBizException(ResManager.loadKDString((String)"EAS\u79d1\u76ee\u4f59\u989d\u6838\u5bf9\u6570\u636e\u672a\u751f\u6210\u8fdb\u884c\u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"BalanceCheckDataServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            long begin1 = System.currentTimeMillis();
            logger.info("getBalanceCheckData->getEasBalanceDataSet->begin " + begin1);
            DataSet easBalanceDataSet = this.getEasBalanceDataSet(billId, checkcurrencynumber, checkDataDynObj);
            logger.info("getBalanceCheckData->getEasBalanceDataSet->end " + (System.currentTimeMillis() - begin1));
            begin1 = System.currentTimeMillis();
            logger.info("getBalanceCheckData->queryGlBalanceByService->begin " + begin1);
            List<Map<String, Object>> glBalanceDataList = this.queryGlBalanceByService(xhorgid, xhbooktypeid, xhperiodtypeid, xhperiodnumber, xhcurrencyid);
            logger.info("getBalanceCheckData->queryGlBalanceByService->end " + (System.currentTimeMillis() - begin1));
            Map<String, Tuple<String, Map<String, String>>> assistMap = this.getAssistMap(glBalanceDataList);
            Map<String, Map<String, Object>> accountInfoMap = this.getAccountInfoMap(glBalanceDataList);
            begin1 = System.currentTimeMillis();
            logger.info("getBalanceCheckData->getGlBalanceDataList->begin " + begin1);
            List<Map<String, Object>> balanceDataList = this.getGlBalanceDataList(glBalanceDataList, assistMap, accountInfoMap);
            logger.info("getBalanceCheckData->getGlBalanceDataList->end " + (System.currentTimeMillis() - begin1));
            begin1 = System.currentTimeMillis();
            logger.info("getBalanceCheckData->createCheckDataDetailList->begin " + begin1);
            List<DynamicObject> billList = this.createCheckDataDetailList(easBalanceDataSet, balanceDataList, accountInfoMap, checkDataDynObj);
            logger.info("getBalanceCheckData->createCheckDataDetailList->end " + (System.currentTimeMillis() - begin1));
            List pkIdList = new ArrayList(16);
            if (!billList.isEmpty()) {
                OperationResult optResult = SaveServiceHelper.saveOperate((String)"dmw_balancecheckdata", (DynamicObject[])billList.toArray(new DynamicObject[billList.size()]), (OperateOption)CommonUtils.getOperateOption(true));
                if (!optResult.isSuccess()) {
                    msg = CommonUtils.getErrDetail(optResult);
                } else {
                    pkIdList = optResult.getSuccessPkIds();
                }
            }
            resultJson.put("rows", pkIdList);
        }
        catch (KDBizException ex) {
            msg = ex.getMessage();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            msg = sw.toString();
            logger.info(msg);
        }
        resultJson.put("errors", (Object)msg);
        logger.info("getBalanceCheckData->end " + (System.currentTimeMillis() - begin));
        return resultJson.toJSONString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<DynamicObject> createCheckDataDetailList(DataSet easBalanceDataSet, List<Map<String, Object>> balanceDataList, Map<String, Map<String, Object>> accountInfoMap, DynamicObject checkDataDynObj) throws IOException {
        HashMap<String, List<Integer>> accountMergeSeqMap = new HashMap<String, List<Integer>>(16);
        HashMap<String, List<Integer>> assgrpMergeSeqMap = new HashMap<String, List<Integer>>(16);
        HashSet<Integer> accountXhMatchSeqSet = new HashSet<Integer>(16);
        HashSet<Integer> assgrpXhMatchSeqSet = new HashSet<Integer>(16);
        Map<String, List<String>> fieldMap = this.getAmountFieldMap();
        String accountconverjson = checkDataDynObj.getString("accountconverjson_tag");
        List accountConvertList = new ArrayList(16);
        if (StringUtil.isNotEmpty(accountconverjson)) {
            accountConvertList = (List)JSONUtils.cast((String)accountconverjson, List.class);
        }
        DataEntityPropertyCollection propertyColl = checkDataDynObj.getDynamicObjectType().getProperties();
        DynamicObject billAssgrpDynObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_balancecheckdata");
        for (IDataEntityProperty property : propertyColl) {
            if (property instanceof EntryProp || !StringUtil.isNotEmpty(property.getAlias())) continue;
            billAssgrpDynObj.set(property.getName(), checkDataDynObj.get(property));
        }
        DynamicObjectCollection accountCheckEntryColl = checkDataDynObj.getDynamicObjectCollection("entryentity");
        accountCheckEntryColl.clear();
        DynamicObjectCollection accountAssgrpCheckEntryColl = billAssgrpDynObj.getDynamicObjectCollection("entryentity");
        accountAssgrpCheckEntryColl.clear();
        try {
            while (easBalanceDataSet.hasNext()) {
                Row easBalanceRow = easBalanceDataSet.next();
                String easAccountNumer = easBalanceRow.getString("entryentity.accountnumber");
                String convertAccountNumber = easAccountNumer;
                List<Object> destAccountConvertList = new ArrayList(16);
                if (!CommonUtils.isNull(accountConvertList) && !CommonUtils.isNull(destAccountConvertList = accountConvertList.stream().filter(o -> easAccountNumer.equals(o.get("srcacctnum"))).collect(Collectors.toList()))) {
                    convertAccountNumber = (String)((Map)destAccountConvertList.get(0)).get("taracctnum");
                }
                String convertXhAccountNumber = convertAccountNumber;
                List<Map<String, Object>> xhAccountDataList = balanceDataList.stream().filter(o -> convertXhAccountNumber.equals(o.get("accountnumber"))).collect(Collectors.toList());
                this.matchBalanceByAccount(xhAccountDataList, easBalanceRow, fieldMap, accountCheckEntryColl, accountMergeSeqMap, accountXhMatchSeqSet);
                List<Map<String, Object>> xhAssgrapDataList = balanceDataList.stream().filter(o -> convertXhAccountNumber.equals(o.get("accountnumber"))).collect(Collectors.toList());
                this.matchBalanceByAccountAssgrp(xhAssgrapDataList, easBalanceRow, accountAssgrpCheckEntryColl, destAccountConvertList, assgrpMergeSeqMap, assgrpXhMatchSeqSet);
            }
        }
        finally {
            easBalanceDataSet.close();
        }
        List accountXhDataList = balanceDataList.stream().filter(o -> !accountXhMatchSeqSet.contains((Integer)o.get("seq"))).collect(Collectors.toList());
        if (!CommonUtils.isNull(accountXhDataList)) {
            for (Map balanceDataMap : accountXhDataList) {
                void var23_27;
                HashMap<String, Object> checkDataMap = new HashMap<String, Object>(100);
                int seq = accountCheckEntryColl.size() + 1;
                checkDataMap.put("seq", seq);
                this.setBalanceCheckDataMap(checkDataMap, null, balanceDataMap, false);
                DynamicObject entryDynObj = accountCheckEntryColl.addNew();
                for (Map.Entry entry : checkDataMap.entrySet()) {
                    entryDynObj.set((String)entry.getKey(), entry.getValue());
                }
                String xhAccountNumer = (String)balanceDataMap.get("accountnumber");
                List list = (List)accountMergeSeqMap.get(xhAccountNumer);
                if (CommonUtils.isNull(list)) {
                    ArrayList arrayList = new ArrayList(16);
                    accountMergeSeqMap.put(xhAccountNumer, arrayList);
                }
                var23_27.add(seq);
            }
        }
        List<List<Integer>> accountMergeList = accountMergeSeqMap.values().stream().filter(o -> o.size() > 1).collect(Collectors.toList());
        this.setMergeGroupNo(accountCheckEntryColl, fieldMap, accountMergeList, true);
        this.setMergeAccount(accountCheckEntryColl, fieldMap, accountMergeList);
        List assgrpXhDataList = balanceDataList.stream().filter(o -> !assgrpXhMatchSeqSet.contains((Integer)o.get("seq"))).collect(Collectors.toList());
        if (!CommonUtils.isNull(assgrpXhDataList)) {
            for (Map balanceDataMap : assgrpXhDataList) {
                HashMap<String, Object> checkDataMap = new HashMap<String, Object>(100);
                checkDataMap.put("seq", accountAssgrpCheckEntryColl.size() + 1);
                this.setBalanceCheckDataMap(checkDataMap, null, balanceDataMap, true);
                DynamicObject entryDynObj = accountAssgrpCheckEntryColl.addNew();
                for (Map.Entry mapEntry : checkDataMap.entrySet()) {
                    entryDynObj.set((String)mapEntry.getKey(), mapEntry.getValue());
                }
            }
        }
        List<List<Integer>> assgrpMergeList = assgrpMergeSeqMap.values().stream().filter(o -> o.size() > 1).collect(Collectors.toList());
        this.setMergeGroupNo(accountAssgrpCheckEntryColl, fieldMap, assgrpMergeList, true);
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(2);
        billAssgrpDynObj.set("billno", (Object)(checkDataDynObj.get("billno") + "-02"));
        billAssgrpDynObj.set("srcbillid", checkDataDynObj.get("id"));
        billAssgrpDynObj.set("id", (Object)BalanceCheckDataHelper.genLongId("t_dmw_balancecheckdata"));
        billAssgrpDynObj.set("iscontainassgrp", (Object)true);
        billAssgrpDynObj.set("excutestatus", (Object)"2");
        billAssgrpDynObj.set("isdiff", (Object)accountAssgrpCheckEntryColl.stream().anyMatch(o -> (Boolean)o.get("isrowdiff")));
        billList.add(billAssgrpDynObj);
        checkDataDynObj.set("billno", (Object)(checkDataDynObj.get("billno") + "-01"));
        checkDataDynObj.set("iscontainassgrp", (Object)false);
        checkDataDynObj.set("isdiff", (Object)accountCheckEntryColl.stream().anyMatch(o -> (Boolean)o.get("isrowdiff")));
        billList.add(checkDataDynObj);
        return billList;
    }

    private List<Map<String, Object>> queryGlBalanceByService(String xhorgid, String xhbooktypeid, String xhperiodtypeid, String xhperiodNumber, String xhcurrencyid) throws IOException {
        BalanceQueryParam param = new BalanceQueryParam();
        param.setOrgId(Long.parseLong(xhorgid));
        param.setBookTypeId(Long.parseLong(xhbooktypeid));
        param.setCurrencyId(Long.parseLong(xhcurrencyid));
        QFilter filter = new QFilter("periodtype", "=", (Object)Long.parseLong(xhperiodtypeid));
        filter.and("number", "=", (Object)xhperiodNumber);
        List pkList = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])filter.toArray(), null, (int)1);
        if (CommonUtils.isNull(pkList)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4f1a\u8ba1\u671f\u95f4\u7f16\u7801\u4e3a\uff1a%s\u7684\u4f1a\u8ba1\u671f\u95f4\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"BalanceCheckDataServiceImpl_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), xhperiodNumber));
        }
        param.setPeriodId(Long.parseLong(pkList.get(0).toString()));
        param.setSpecialAccount(false);
        param.addSelector("assgrp");
        param.getSelector().addAll(Arrays.asList("beginfor", "beginlocal", "debitfor", "debitlocal", "creditfor", "creditlocal", "yeardebitfor", "yeardebitlocal", "yearcreditfor", "yearcreditlocal", "endfor", "endlocal", "org", "org.number", "booktype", "booktype.number", "period", "period.number", "account", "currency", "currency.number", "assgrp"));
        List<String> groupList = Arrays.asList("account", "assgrp", "period", "period.number", "currency", "currency.number", "currency.name", "org", "org.number", "booktype", "booktype.number");
        param.getGroupBy().addAll(groupList);
        logger.info("queryGlBalanceByService->BalanceQueryParam " + param.toString());
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getBalance", (Object[])new Object[]{param.toString()});
        return (List)JSONUtils.cast((String)result, List.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getGlBalanceDataList(List<Map<String, Object>> dataList, Map<String, Tuple<String, Map<String, String>>> assistMap, Map<String, Map<String, Object>> accountInfoMap) throws IOException {
        ArrayList<Field> fieldList = new ArrayList<Field>(8);
        fieldList.add(new Field("seq", (DataType)DataType.IntegerType));
        fieldList.add(new Field("account", (DataType)DataType.LongType));
        fieldList.add(new Field("accountnumber", (DataType)DataType.StringType));
        fieldList.add(new Field("accountname", (DataType)DataType.StringType));
        fieldList.add(new Field("accountdc", (DataType)DataType.IntegerType));
        fieldList.add(new Field("assgrp", (DataType)DataType.LongType));
        fieldList.add(new Field("assgrpjson", (DataType)DataType.StringType));
        fieldList.add(new Field("assgrpname", (DataType)DataType.StringType));
        fieldList.add(new Field("beginfor", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("beginlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("booktype", (DataType)DataType.LongType));
        fieldList.add(new Field("booktype.number", (DataType)DataType.StringType));
        fieldList.add(new Field("debitfor", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("debitlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("creditfor", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("creditlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("currency", (DataType)DataType.LongType));
        fieldList.add(new Field("currency.number", (DataType)DataType.StringType));
        fieldList.add(new Field("currency.name", (DataType)DataType.StringType));
        fieldList.add(new Field("endfor", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("endlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("org", (DataType)DataType.LongType));
        fieldList.add(new Field("org.number", (DataType)DataType.StringType));
        fieldList.add(new Field("period", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("period.number", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("yeardebitfor", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("yeardebitlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("yearcreditfor", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("yearcreditlocal", (DataType)DataType.BigDecimalType));
        DataSet dataSet = BalanceCheckDataHelper.getGlBalanceDataSet(fieldList, dataList, assistMap, accountInfoMap);
        logger.info("getGlBalanceDataList->dataList " + dataList.size());
        ArrayList<Map<String, Object>> balanceDataList = new ArrayList<Map<String, Object>>(16);
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> rowData = new HashMap<String, Object>(fieldList.size());
                for (Field field : fieldList) {
                    rowData.put(field.getName(), row.get(field.getName()));
                }
                balanceDataList.add(rowData);
            }
            logger.info("getGlBalanceDataList->balanceDataList " + balanceDataList.size());
        }
        finally {
            dataSet.close();
        }
        return balanceDataList;
    }

    private Map<String, Map<String, Object>> getAccountInfoMap(List<Map<String, Object>> glBalanceDataList) throws IOException {
        HashMap<String, Map<String, Object>> accountInfoMap = new HashMap<String, Map<String, Object>>(16);
        Set accountIdSet = glBalanceDataList.stream().map(o -> Long.parseLong(o.get("account").toString())).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", accountIdSet);
        filter.and("isleaf", "=", (Object)"1");
        DynamicObjectCollection accountColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,name,dc", (QFilter[])filter.toArray());
        for (DynamicObject accountDynObj : accountColl) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("accountnumber", accountDynObj.getString("number"));
            map.put("accountname", accountDynObj.getString("name"));
            map.put("accountdc", Integer.parseInt(accountDynObj.getString("dc")));
            accountInfoMap.put(accountDynObj.getString("id"), map);
        }
        return accountInfoMap;
    }

    private Map<String, Tuple<String, Map<String, String>>> getAssistMap(List<Map<String, Object>> glBalanceDataList) throws IOException {
        HashMap<String, Tuple<String, Map<String, String>>> assistMap = new HashMap<String, Tuple<String, Map<String, String>>>(16);
        Set assgrpIdSet = glBalanceDataList.stream().map(o -> Long.parseLong(o.get("assgrp").toString())).collect(Collectors.toSet());
        DynamicObjectCollection asstActItemColl = QueryServiceHelper.query((String)"bd_asstacttype", (String)"valuetype,valuesource,flexfield,assistanttype,name,number", null);
        DynamicObjectCollection assGrpValueColl = QueryServiceHelper.query((String)"gl_assist", (String)"assvals,id", (QFilter[])new QFilter("id", "in", assgrpIdSet).toArray());
        StringBuilder assgrpNameBuilder = new StringBuilder();
        for (DynamicObject assGrpValueDynObj : assGrpValueColl) {
            Map assValsMap = (Map)JSONUtils.cast((String)assGrpValueDynObj.getString("assvals"), Map.class);
            assgrpNameBuilder.setLength(0);
            HashMap<String, String> asstActTypeMap = new HashMap<String, String>(16);
            for (Map.Entry mapEntry : assValsMap.entrySet()) {
                String key = (String)mapEntry.getKey();
                String flexfieldValue = mapEntry.getValue().toString();
                for (DynamicObject actItemDynObj : asstActItemColl) {
                    if (!key.equals(actItemDynObj.getString("flexfield"))) continue;
                    assgrpNameBuilder.append(actItemDynObj.getString("name")).append(":");
                    String valuetype = actItemDynObj.getString("valuetype");
                    if ("3".equals(valuetype)) {
                        asstActTypeMap.put(actItemDynObj.getString("number"), flexfieldValue);
                        assgrpNameBuilder.append(flexfieldValue).append(";");
                        continue;
                    }
                    DynamicObjectCollection dynColl = QueryServiceHelper.query((String)actItemDynObj.getString("valuesource"), (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(flexfieldValue)).toArray());
                    if (CommonUtils.isNull(dynColl)) continue;
                    asstActTypeMap.put(actItemDynObj.getString("number"), ((DynamicObject)dynColl.get(0)).getString("number"));
                    assgrpNameBuilder.append(((DynamicObject)dynColl.get(0)).getString("number")).append(" ").append(((DynamicObject)dynColl.get(0)).getString("name")).append(";");
                }
            }
            if (asstActTypeMap.isEmpty()) continue;
            assistMap.put(assGrpValueDynObj.getString("id"), (Tuple<String, Map<String, String>>)new Tuple((Object)assgrpNameBuilder.toString(), asstActTypeMap));
        }
        return assistMap;
    }

    private DataSet getEasBalanceDataSet(String billId, String checkcurrencynumber, DynamicObject checkDataDynObj) {
        JobSession job = AlgoX.createSession((String)ALGOX_KEY);
        ArrayList<String> fieldKeyList = new ArrayList<String>(16);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"dmw_easbalance");
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty propertity : properties) {
            if (propertity instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)propertity;
                DataEntityPropertyCollection entryPros = entryProp.getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty pro : entryPros) {
                    if (!StringUtil.isNotEmpty(pro.getAlias())) continue;
                    fieldKeyList.add(String.join((CharSequence)".", propertity.getName(), pro.getName()));
                }
                continue;
            }
            if (!StringUtil.isNotEmpty(propertity.getAlias())) continue;
            fieldKeyList.add(propertity.getName());
        }
        String easorgnumber = checkDataDynObj.getString("easorgnumber");
        String booktypenumber = checkDataDynObj.getString("booktypenumber");
        String periodnumber = checkDataDynObj.getString("periodnumber");
        String selectFields = String.join((CharSequence)",", fieldKeyList);
        QFilter qFilter = new QFilter("easorgnumber", "=", (Object)easorgnumber);
        qFilter.and(new QFilter("booktypenumber", "=", (Object)booktypenumber));
        qFilter.and(new QFilter("periodnumber", "=", (Object)periodnumber));
        qFilter.and(new QFilter("entryentity.currencyfornumber", "=", (Object)checkcurrencynumber));
        DynamicObjectCollection balanceDynColl = QueryServiceHelper.query((String)"dmw_easbalance", (String)"excutestatus", (QFilter[])qFilter.toArray(), null, (int)1);
        if (CommonUtils.isNull(balanceDynColl) || "0".equals(((DynamicObject)balanceDynColl.get(0)).getString("excutestatus")) || "3".equals(((DynamicObject)balanceDynColl.get(0)).getString("excutestatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6210\u529f\u83b7\u53d6\u5230EAS\u79d1\u76ee\u4f59\u989d\u6570\u636e\uff0c\u8bf7\u5148\u83b7\u53d6\u79d1\u76ee\u4f59\u989d\u6570\u636e\u3002", (String)"BalanceCheckDataServiceImpl_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        String excuteStatus = ((DynamicObject)balanceDynColl.get(0)).getString("excutestatus");
        if ("1".equals(excuteStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"EAS\u79d1\u76ee\u4f59\u989d\u6570\u636e\u5f53\u524d\u5728\u83b7\u53d6\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BalanceCheckDataServiceImpl_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        Input[] inputs = new Input[]{new OrmInput("dmw_easbalance", "dmw_easbalance", selectFields, qFilter.toArray())};
        DataSetX balanceDataSetX = job.fromInput(inputs);
        return BalanceCheckDataHelper.jobSessionCommit(job, balanceDataSetX);
    }

    /*
     * WARNING - void declaration
     */
    private void matchBalanceByAccount(List<Map<String, Object>> xhAccountDataList, Row easBalanceRow, Map<String, List<String>> fieldMap, DynamicObjectCollection accountCheckEntryColl, Map<String, List<Integer>> accountMergeSeqMap, Set<Integer> accountXhMatchSeqSet) {
        if (!CommonUtils.isNull(xhAccountDataList)) {
            void var15_38;
            ArrayList<HashMap<String, Object>> checkDataList = new ArrayList<HashMap<String, Object>>(xhAccountDataList.size());
            for (Map<String, Object> xhAccountMap : xhAccountDataList) {
                HashMap<String, Object> checkDataDetailMap = new HashMap<String, Object>(100);
                this.setBalanceCheckDataMap(checkDataDetailMap, easBalanceRow, xhAccountMap, false);
                checkDataList.add(checkDataDetailMap);
                accountXhMatchSeqSet.add((Integer)xhAccountMap.get("seq"));
            }
            Map checkDataDetailMap = (Map)checkDataList.get(0);
            int accountSeq = accountCheckEntryColl.size() + 1;
            checkDataDetailMap.put("seq", accountSeq);
            int count = checkDataList.size();
            for (int i = 1; i < count; ++i) {
                Map xhAccountMap = (Map)checkDataList.get(i);
                for (Map.Entry<String, List<String>> entry : fieldMap.entrySet()) {
                    String string = entry.getValue().get(0);
                    checkDataDetailMap.put(string, ((BigDecimal)checkDataDetailMap.get(string)).add((BigDecimal)xhAccountMap.get(string)));
                }
            }
            for (Map.Entry<String, List<String>> fieldMapEntry : fieldMap.entrySet()) {
                String xhAmountField2 = fieldMapEntry.getValue().get(0);
                String string = fieldMapEntry.getValue().get(1);
                checkDataDetailMap.put(string, ((BigDecimal)checkDataDetailMap.get(fieldMapEntry.getKey())).subtract((BigDecimal)checkDataDetailMap.get(xhAmountField2)));
            }
            boolean isAllZero = true;
            boolean isRowDiff = false;
            for (Map.Entry entry : fieldMap.entrySet()) {
                String string = (String)((List)entry.getValue()).get(0);
                String easAmountField = (String)entry.getKey();
                String diffAmountField = (String)((List)entry.getValue()).get(1);
                if (BigDecimal.ZERO.compareTo((BigDecimal)checkDataDetailMap.get(easAmountField)) != 0 || BigDecimal.ZERO.compareTo((BigDecimal)checkDataDetailMap.get(string)) != 0) {
                    isAllZero = false;
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)checkDataDetailMap.get(diffAmountField)) != 0) {
                    isRowDiff = true;
                }
                if (isAllZero || !isRowDiff) continue;
                break;
            }
            checkDataDetailMap.put("isallzero", isAllZero);
            checkDataDetailMap.put("isrowdiff", isRowDiff);
            DynamicObject entryDynObj = accountCheckEntryColl.addNew();
            for (Map.Entry entry : checkDataDetailMap.entrySet()) {
                entryDynObj.set((String)entry.getKey(), entry.getValue());
            }
            String string = (String)xhAccountDataList.get(0).get("accountnumber");
            List<Integer> list = accountMergeSeqMap.get(string);
            if (CommonUtils.isNull(list)) {
                ArrayList arrayList = new ArrayList(16);
                accountMergeSeqMap.put(string, arrayList);
            }
            var15_38.add(accountSeq);
        } else {
            HashMap<String, Object> checkDataDetailMap = new HashMap<String, Object>(100);
            int accountSeq = accountCheckEntryColl.size() + 1;
            checkDataDetailMap.put("seq", accountSeq);
            this.setBalanceCheckDataMap(checkDataDetailMap, easBalanceRow, null, false);
            DynamicObject entryDynObj = accountCheckEntryColl.addNew();
            for (Map.Entry mapEntry : checkDataDetailMap.entrySet()) {
                entryDynObj.set((String)mapEntry.getKey(), mapEntry.getValue());
            }
            String easAccountNumer = easBalanceRow.getString("entryentity.accountnumber");
            List<Integer> seqList = accountMergeSeqMap.get(easAccountNumer);
            if (CommonUtils.isNull(seqList)) {
                seqList = new ArrayList<Integer>(16);
                accountMergeSeqMap.put(easAccountNumer, seqList);
            }
            seqList.add(accountSeq);
        }
    }

    private void matchBalanceByAccountAssgrp(List<Map<String, Object>> xhAssgrapDataList, Row easBalanceRow, DynamicObjectCollection accountAssgrpCheckEntryColl, List<Map<String, String>> destAccountConvertList, Map<String, List<Integer>> assgrpMergeSeqMap, Set<Integer> assgrpXhMatchSeqSet) throws IOException {
        boolean isMatch = false;
        if (!CommonUtils.isNull(xhAssgrapDataList)) {
            String assgrpTag = easBalanceRow.getString("entryentity.assgrp_tag");
            Map<String, String> easAsstActTypeMap = this.getEasAsstActTypeMap(assgrpTag);
            for (Map<String, Object> balanceDataMap : xhAssgrapDataList) {
                String msg;
                String xhAccountNumer = (String)balanceDataMap.get("accountnumber");
                String assgrpjson = (String)balanceDataMap.get("assgrpjson");
                Map<String, String> xhAsstActTypeMap = new HashMap<String, String>(16);
                if (StringUtil.isNotEmpty(assgrpjson)) {
                    xhAsstActTypeMap = (Map)JSONUtils.cast((String)assgrpjson, Map.class);
                }
                if ((msg = this.verifyAsstActTypeConvert(easAsstActTypeMap, xhAsstActTypeMap, destAccountConvertList)).length() > 0) {
                    throw new KDBizException(msg);
                }
                int allCount = easAsstActTypeMap.size();
                int matchCount = 0;
                block1: for (Map.Entry<String, String> mapEntry : easAsstActTypeMap.entrySet()) {
                    List list;
                    String convertAssgrpNumber = mapEntry.getKey();
                    Object convertAssgrpValue = mapEntry.getValue();
                    if (!CommonUtils.isNull(destAccountConvertList) && !CommonUtils.isNull(list = destAccountConvertList.stream().filter(o -> (StringUtil.isEmpty((String)o.get("srcasst")) || ((String)mapEntry.getKey()).equals(o.get("srcasst"))) && StringUtil.isNotEmpty((String)o.get("tarasst"))).collect(Collectors.toList()))) {
                        convertAssgrpNumber = (String)((Map)list.get(0)).get("tarasst");
                        List signAssgrpConvertValueList = list.stream().filter(o -> (StringUtil.isEmpty((String)o.get("srcassgrpnumber")) || ((String)mapEntry.getValue()).equals(o.get("srcassgrpnumber"))) && StringUtil.isNotEmpty((String)o.get("tarassgrpnumber"))).collect(Collectors.toList());
                        if (!CommonUtils.isNull(signAssgrpConvertValueList)) {
                            convertAssgrpValue = (String)((Map)signAssgrpConvertValueList.get(0)).get("tarassgrpnumber");
                        }
                    }
                    boolean bl = false;
                    for (Map.Entry<String, String> xhmapEntry : xhAsstActTypeMap.entrySet()) {
                        boolean bl2 = StringUtil.isNotEmpty(convertAssgrpNumber) ? xhmapEntry.getKey().equals(convertAssgrpNumber) && xhmapEntry.getValue().equals(convertAssgrpValue) : true;
                        if (!bl2) continue;
                        ++matchCount;
                        continue block1;
                    }
                }
                if (allCount != matchCount) continue;
                isMatch = true;
                HashMap<String, Object> checkDataDetailMap = new HashMap<String, Object>(100);
                int assgrpSeq = accountAssgrpCheckEntryColl.size() + 1;
                checkDataDetailMap.put("seq", assgrpSeq);
                this.setBalanceCheckDataMap(checkDataDetailMap, easBalanceRow, balanceDataMap, true);
                DynamicObject entryDynObj = accountAssgrpCheckEntryColl.addNew();
                for (Map.Entry entry : checkDataDetailMap.entrySet()) {
                    entryDynObj.set((String)entry.getKey(), entry.getValue());
                }
                List<Integer> seqList = assgrpMergeSeqMap.get(xhAccountNumer + "_" + assgrpjson);
                if (CommonUtils.isNull(seqList)) {
                    seqList = new ArrayList<Integer>(16);
                    assgrpMergeSeqMap.put(xhAccountNumer + "_" + assgrpjson, seqList);
                }
                seqList.add(assgrpSeq);
                assgrpXhMatchSeqSet.add((Integer)balanceDataMap.get("seq"));
            }
        }
        if (!isMatch) {
            HashMap<String, Object> checkDataDetailMap = new HashMap<String, Object>(100);
            int assgrpSeq = accountAssgrpCheckEntryColl.size() + 1;
            checkDataDetailMap.put("seq", assgrpSeq);
            this.setBalanceCheckDataMap(checkDataDetailMap, easBalanceRow, null, true);
            DynamicObject entryDynObj = accountAssgrpCheckEntryColl.addNew();
            for (Map.Entry mapEntry : checkDataDetailMap.entrySet()) {
                entryDynObj.set((String)mapEntry.getKey(), mapEntry.getValue());
            }
        }
    }

    private void setBalanceCheckDataMap(Map<String, Object> checkDataMap, Row easBalanceRow, Map<String, Object> balanceDataMap, boolean isContainAssgrp) {
        BigDecimal yeardebitbeginfor = BigDecimal.ZERO;
        BigDecimal yeardebitbeginlocal = BigDecimal.ZERO;
        BigDecimal yearcreditbeginfor = BigDecimal.ZERO;
        BigDecimal yearcreditbeginlocal = BigDecimal.ZERO;
        BigDecimal begindeditfor = BigDecimal.ZERO;
        BigDecimal begindeditlocal = BigDecimal.ZERO;
        BigDecimal begincreditfor = BigDecimal.ZERO;
        BigDecimal begincreditlocal = BigDecimal.ZERO;
        BigDecimal debitfor = BigDecimal.ZERO;
        BigDecimal debitlocal = BigDecimal.ZERO;
        BigDecimal creditfor = BigDecimal.ZERO;
        BigDecimal creditlocal = BigDecimal.ZERO;
        BigDecimal yeardebitfor = BigDecimal.ZERO;
        BigDecimal yeardebitlocal = BigDecimal.ZERO;
        BigDecimal yearcreditfor = BigDecimal.ZERO;
        BigDecimal yearcreditlocal = BigDecimal.ZERO;
        BigDecimal enddebitfor = BigDecimal.ZERO;
        BigDecimal enddebitlocal = BigDecimal.ZERO;
        BigDecimal endcrebitfor = BigDecimal.ZERO;
        BigDecimal endcrebitlocal = BigDecimal.ZERO;
        BigDecimal xhyeardebitbeginfor = BigDecimal.ZERO;
        BigDecimal xhyeardebitbeginlocal = BigDecimal.ZERO;
        BigDecimal xhyearcreditbeginfor = BigDecimal.ZERO;
        BigDecimal xhyearcreditbeginlocal = BigDecimal.ZERO;
        BigDecimal xhbegindeditfor = BigDecimal.ZERO;
        BigDecimal xhbegindeditlocal = BigDecimal.ZERO;
        BigDecimal xhbegincreditfor = BigDecimal.ZERO;
        BigDecimal xhbegincreditlocal = BigDecimal.ZERO;
        BigDecimal xhdebitfor = BigDecimal.ZERO;
        BigDecimal xhdebitlocal = BigDecimal.ZERO;
        BigDecimal xhcreditfor = BigDecimal.ZERO;
        BigDecimal xhcreditlocal = BigDecimal.ZERO;
        BigDecimal xhyeardebitfor = BigDecimal.ZERO;
        BigDecimal xhyeardebitlocal = BigDecimal.ZERO;
        BigDecimal xhyearcreditfor = BigDecimal.ZERO;
        BigDecimal xhyearcreditlocal = BigDecimal.ZERO;
        BigDecimal xhenddebitfor = BigDecimal.ZERO;
        BigDecimal xhenddebitlocal = BigDecimal.ZERO;
        BigDecimal xhendcrebitfor = BigDecimal.ZERO;
        BigDecimal xhendcrebitlocal = BigDecimal.ZERO;
        if (easBalanceRow != null) {
            checkDataMap.put("easaccountnumber", easBalanceRow.get("entryentity.accountnumber"));
            checkDataMap.put("easaccountname", easBalanceRow.get("entryentity.accountname"));
            if (isContainAssgrp) {
                checkDataMap.put("easassgrp_tag", easBalanceRow.get("entryentity.assgrp_tag"));
                checkDataMap.put("easassgrpname", easBalanceRow.get("entryentity.assgrpname"));
            }
            checkDataMap.put("currencyfornumber", easBalanceRow.get("entryentity.currencyfornumber"));
            checkDataMap.put("currencyforname", easBalanceRow.get("entryentity.currencyforname"));
            yeardebitbeginfor = (BigDecimal)easBalanceRow.get("entryentity.yeardebitbeginfor");
            yeardebitbeginlocal = (BigDecimal)easBalanceRow.get("entryentity.yeardebitbeginlocal");
            yearcreditbeginfor = (BigDecimal)easBalanceRow.get("entryentity.yearcreditbeginfor");
            yearcreditbeginlocal = (BigDecimal)easBalanceRow.get("entryentity.yearcreditbeginlocal");
            begindeditfor = (BigDecimal)easBalanceRow.get("entryentity.begindeditbalancefor");
            begindeditlocal = (BigDecimal)easBalanceRow.get("entryentity.begindeditbalancelocal");
            begincreditfor = (BigDecimal)easBalanceRow.get("entryentity.begincreditbalancefor");
            begincreditlocal = (BigDecimal)easBalanceRow.get("entryentity.begincreditbalancelocal");
            debitfor = (BigDecimal)easBalanceRow.get("entryentity.debitfor");
            debitlocal = (BigDecimal)easBalanceRow.get("entryentity.debitlocal");
            creditfor = (BigDecimal)easBalanceRow.get("entryentity.creditfor");
            creditlocal = (BigDecimal)easBalanceRow.get("entryentity.creditlocal");
            yeardebitfor = (BigDecimal)easBalanceRow.get("entryentity.yeardebitfor");
            yeardebitlocal = (BigDecimal)easBalanceRow.get("entryentity.yeardebitlocal");
            yearcreditfor = (BigDecimal)easBalanceRow.get("entryentity.yearcreditfor");
            yearcreditlocal = (BigDecimal)easBalanceRow.get("entryentity.yearcreditlocal");
            enddebitfor = (BigDecimal)easBalanceRow.get("entryentity.enddebitbalancefor");
            enddebitlocal = (BigDecimal)easBalanceRow.get("entryentity.enddebitbalancefor");
            endcrebitfor = (BigDecimal)easBalanceRow.get("entryentity.endcrebitbalancefor");
            endcrebitlocal = (BigDecimal)easBalanceRow.get("entryentity.endcrebitbalancelocal");
        }
        checkDataMap.put("yeardebitbeginfor", yeardebitbeginfor);
        checkDataMap.put("yeardebitbeginlocal", yeardebitbeginlocal);
        checkDataMap.put("yearcreditbeginfor", yearcreditbeginfor);
        checkDataMap.put("yearcreditbeginlocal", yearcreditbeginlocal);
        checkDataMap.put("begindeditfor", begindeditfor);
        checkDataMap.put("begindeditlocal", begindeditlocal);
        checkDataMap.put("begincreditfor", begincreditfor);
        checkDataMap.put("begincreditlocal", begincreditlocal);
        checkDataMap.put("debitfor", debitfor);
        checkDataMap.put("debitlocal", debitlocal);
        checkDataMap.put("creditfor", creditfor);
        checkDataMap.put("creditlocal", creditlocal);
        checkDataMap.put("yeardebitfor", yeardebitfor);
        checkDataMap.put("yeardebitlocal", yeardebitlocal);
        checkDataMap.put("yearcreditfor", yearcreditfor);
        checkDataMap.put("yearcreditlocal", yearcreditlocal);
        checkDataMap.put("enddebitfor", enddebitfor);
        checkDataMap.put("enddebitlocal", enddebitlocal);
        checkDataMap.put("endcrebitfor", endcrebitfor);
        checkDataMap.put("endcrebitlocal", endcrebitlocal);
        if (balanceDataMap != null) {
            checkDataMap.put("accountnumber", balanceDataMap.get("accountnumber"));
            checkDataMap.put("accountname", balanceDataMap.get("accountname"));
            if (isContainAssgrp) {
                checkDataMap.put("assgrp_tag", balanceDataMap.get("assgrpjson"));
                checkDataMap.put("assgrpname", balanceDataMap.get("assgrpname"));
            }
            String currencyNumber = (String)balanceDataMap.get("currency.number");
            if (StringUtil.isNotEmpty(checkDataMap.get("currencyfornumber"))) {
                currencyNumber = checkDataMap.get("currencyfornumber") + "," + currencyNumber;
            }
            String currencyName = (String)balanceDataMap.get("currency.name");
            if (StringUtil.isNotEmpty(checkDataMap.get("currencyforname"))) {
                currencyName = checkDataMap.get("currencyforname") + "," + currencyName;
            }
            checkDataMap.put("currencyfornumber", currencyNumber);
            checkDataMap.put("currencyforname", currencyName);
            BigDecimal endfor = (BigDecimal)balanceDataMap.get("endfor");
            BigDecimal endlocal = (BigDecimal)balanceDataMap.get("endlocal");
            xhyeardebitfor = (BigDecimal)balanceDataMap.get("yeardebitfor");
            xhyeardebitlocal = (BigDecimal)balanceDataMap.get("yeardebitlocal");
            xhyearcreditfor = (BigDecimal)balanceDataMap.get("yearcreditfor");
            xhyearcreditlocal = (BigDecimal)balanceDataMap.get("yearcreditlocal");
            int dc = (Integer)balanceDataMap.get("accountdc");
            BigDecimal amount = endfor.subtract(xhyeardebitfor.subtract(xhyearcreditfor).multiply(new BigDecimal(dc)));
            BigDecimal amountLoc = endlocal.subtract(xhyeardebitlocal.subtract(xhyearcreditlocal).multiply(new BigDecimal(dc)));
            if (dc == 1) {
                xhyeardebitbeginfor = amount;
                xhyeardebitbeginlocal = amountLoc;
            } else {
                xhyearcreditbeginfor = amount;
                xhyearcreditbeginlocal = amountLoc;
            }
            BigDecimal beginfor = (BigDecimal)balanceDataMap.get("beginfor");
            BigDecimal beginlocal = (BigDecimal)balanceDataMap.get("beginlocal");
            if (dc == 1) {
                xhbegindeditfor = beginfor;
                xhbegindeditlocal = beginlocal;
            } else {
                xhbegincreditfor = beginfor;
                xhbegincreditlocal = beginlocal;
            }
            xhdebitfor = (BigDecimal)balanceDataMap.get("debitfor");
            xhdebitlocal = (BigDecimal)balanceDataMap.get("debitlocal");
            xhcreditfor = (BigDecimal)balanceDataMap.get("creditfor");
            xhcreditlocal = (BigDecimal)balanceDataMap.get("creditlocal");
            if (dc == 1) {
                xhenddebitfor = endfor;
                xhenddebitlocal = endlocal;
            } else {
                xhendcrebitfor = endfor;
                xhendcrebitlocal = endlocal;
            }
        }
        checkDataMap.put("xhyeardebitbeginfor", xhyeardebitbeginfor);
        checkDataMap.put("xhyeardebitbeginlocal", xhyeardebitbeginlocal);
        checkDataMap.put("xhyearcreditbeginfor", xhyearcreditbeginfor);
        checkDataMap.put("xhyearcreditbeginlocal", xhyearcreditbeginlocal);
        checkDataMap.put("xhbegindeditfor", xhbegindeditfor);
        checkDataMap.put("xhbegindeditlocal", xhbegindeditlocal);
        checkDataMap.put("xhbegincreditfor", xhbegincreditfor);
        checkDataMap.put("xhbegincreditlocal", xhbegincreditlocal);
        checkDataMap.put("xhdebitfor", xhdebitfor);
        checkDataMap.put("xhdebitlocal", xhdebitlocal);
        checkDataMap.put("xhcreditfor", xhcreditfor);
        checkDataMap.put("xhcreditlocal", xhcreditlocal);
        checkDataMap.put("xhyeardebitfor", xhyeardebitfor);
        checkDataMap.put("xhyeardebitlocal", xhyeardebitlocal);
        checkDataMap.put("xhyearcreditfor", xhyearcreditfor);
        checkDataMap.put("xhyearcreditlocal", xhyearcreditlocal);
        checkDataMap.put("xhenddebitfor", xhenddebitfor);
        checkDataMap.put("xhenddebitlocal", xhenddebitlocal);
        checkDataMap.put("xhendcrebitfor", xhendcrebitfor);
        checkDataMap.put("xhendcrebitlocal", xhendcrebitlocal);
        BigDecimal diffyeardebitbeginfor = yeardebitbeginfor.subtract(xhyeardebitbeginfor);
        BigDecimal diffyeardebitbeginlocal = yeardebitbeginlocal.subtract(xhyeardebitbeginlocal);
        BigDecimal diffyearcreditbeginfor = yearcreditbeginfor.subtract(xhyearcreditbeginfor);
        BigDecimal diffyearcreditbeginlocal = yearcreditbeginlocal.subtract(xhyearcreditbeginlocal);
        BigDecimal diffbegindeditfor = begindeditfor.subtract(xhbegindeditfor);
        BigDecimal diffbegindeditlocal = begindeditlocal.subtract(xhbegindeditlocal);
        BigDecimal diffbegincreditfor = begincreditfor.subtract(xhbegincreditfor);
        BigDecimal diffbegincreditlocal = begincreditlocal.subtract(xhbegincreditlocal);
        BigDecimal diffdebitfor = debitfor.subtract(xhdebitfor);
        BigDecimal diffdebitlocal = debitlocal.subtract(xhdebitlocal);
        BigDecimal diffcreditfor = creditfor.subtract(xhcreditfor);
        BigDecimal diffcreditlocal = creditlocal.subtract(xhcreditlocal);
        BigDecimal diffyeardebitfor = yeardebitfor.subtract(xhyeardebitfor);
        BigDecimal diffyeardebitlocal = yeardebitlocal.subtract(xhyeardebitlocal);
        BigDecimal diffyearcreditfor = yearcreditfor.subtract(xhyearcreditfor);
        BigDecimal diffyearcreditlocal = yearcreditlocal.subtract(xhyearcreditlocal);
        BigDecimal diffenddebitfor = enddebitfor.subtract(xhenddebitfor);
        BigDecimal diffenddebitlocal = enddebitlocal.subtract(xhenddebitlocal);
        BigDecimal diffendcrebitfor = endcrebitfor.subtract(xhendcrebitfor);
        BigDecimal diffendcrebitlocal = endcrebitlocal.subtract(xhendcrebitlocal);
        checkDataMap.put("diffyeardebitbeginfor", diffyeardebitbeginfor);
        checkDataMap.put("diffyeardebitbeginlocal", diffyeardebitbeginlocal);
        checkDataMap.put("diffyearcreditbeginfor", diffyearcreditbeginfor);
        checkDataMap.put("diffyearcreditbeginlocal", diffyearcreditbeginlocal);
        checkDataMap.put("diffbegindeditfor", diffbegindeditfor);
        checkDataMap.put("diffbegindeditlocal", diffbegindeditlocal);
        checkDataMap.put("diffbegincreditfor", diffbegincreditfor);
        checkDataMap.put("diffbegincreditlocal", diffbegincreditlocal);
        checkDataMap.put("diffdebitfor", diffdebitfor);
        checkDataMap.put("diffdebitlocal", diffdebitlocal);
        checkDataMap.put("diffcreditfor", diffcreditfor);
        checkDataMap.put("diffcreditlocal", diffcreditlocal);
        checkDataMap.put("diffyeardebitfor", diffyeardebitfor);
        checkDataMap.put("diffyeardebitlocal", diffyeardebitlocal);
        checkDataMap.put("diffyearcreditfor", diffyearcreditfor);
        checkDataMap.put("diffyearcreditlocal", diffyearcreditlocal);
        checkDataMap.put("diffenddebitfor", diffenddebitfor);
        checkDataMap.put("diffenddebitlocal", diffenddebitlocal);
        checkDataMap.put("diffendcrebitfor", diffendcrebitfor);
        checkDataMap.put("diffendcrebitlocal", diffendcrebitlocal);
        boolean isDiffAllZero = diffyeardebitbeginfor.compareTo(BigDecimal.ZERO) == 0 && diffyeardebitbeginlocal.compareTo(BigDecimal.ZERO) == 0 && diffyearcreditbeginfor.compareTo(BigDecimal.ZERO) == 0 && diffyearcreditbeginlocal.compareTo(BigDecimal.ZERO) == 0 && diffbegindeditfor.compareTo(BigDecimal.ZERO) == 0 && diffbegindeditlocal.compareTo(BigDecimal.ZERO) == 0 && diffbegincreditfor.compareTo(BigDecimal.ZERO) == 0 && diffbegincreditlocal.compareTo(BigDecimal.ZERO) == 0 && diffdebitfor.compareTo(BigDecimal.ZERO) == 0 && diffdebitlocal.compareTo(BigDecimal.ZERO) == 0 && diffcreditfor.compareTo(BigDecimal.ZERO) == 0 && diffcreditlocal.compareTo(BigDecimal.ZERO) == 0 && diffyeardebitfor.compareTo(BigDecimal.ZERO) == 0 && diffyeardebitlocal.compareTo(BigDecimal.ZERO) == 0 && diffyearcreditfor.compareTo(BigDecimal.ZERO) == 0 && diffyearcreditlocal.compareTo(BigDecimal.ZERO) == 0 && diffenddebitfor.compareTo(BigDecimal.ZERO) == 0 && diffenddebitlocal.compareTo(BigDecimal.ZERO) == 0 && diffendcrebitfor.compareTo(BigDecimal.ZERO) == 0 && diffendcrebitlocal.compareTo(BigDecimal.ZERO) == 0;
        boolean isAllZero = yeardebitbeginfor.compareTo(BigDecimal.ZERO) == 0 && yeardebitbeginlocal.compareTo(BigDecimal.ZERO) == 0 && yearcreditbeginfor.compareTo(BigDecimal.ZERO) == 0 && yearcreditbeginlocal.compareTo(BigDecimal.ZERO) == 0 && begindeditfor.compareTo(BigDecimal.ZERO) == 0 && begindeditlocal.compareTo(BigDecimal.ZERO) == 0 && begincreditfor.compareTo(BigDecimal.ZERO) == 0 && begincreditlocal.compareTo(BigDecimal.ZERO) == 0 && debitfor.compareTo(BigDecimal.ZERO) == 0 && debitlocal.compareTo(BigDecimal.ZERO) == 0 && creditfor.compareTo(BigDecimal.ZERO) == 0 && creditlocal.compareTo(BigDecimal.ZERO) == 0 && yeardebitfor.compareTo(BigDecimal.ZERO) == 0 && yeardebitlocal.compareTo(BigDecimal.ZERO) == 0 && yearcreditfor.compareTo(BigDecimal.ZERO) == 0 && yearcreditlocal.compareTo(BigDecimal.ZERO) == 0 && enddebitfor.compareTo(BigDecimal.ZERO) == 0 && enddebitlocal.compareTo(BigDecimal.ZERO) == 0 && endcrebitfor.compareTo(BigDecimal.ZERO) == 0 && endcrebitlocal.compareTo(BigDecimal.ZERO) == 0 && xhyeardebitbeginfor.compareTo(BigDecimal.ZERO) == 0 && xhyeardebitbeginlocal.compareTo(BigDecimal.ZERO) == 0 && xhyearcreditbeginfor.compareTo(BigDecimal.ZERO) == 0 && xhyearcreditbeginlocal.compareTo(BigDecimal.ZERO) == 0 && xhbegindeditfor.compareTo(BigDecimal.ZERO) == 0 && xhbegindeditlocal.compareTo(BigDecimal.ZERO) == 0 && xhbegincreditfor.compareTo(BigDecimal.ZERO) == 0 && xhbegincreditlocal.compareTo(BigDecimal.ZERO) == 0 && xhdebitfor.compareTo(BigDecimal.ZERO) == 0 && xhdebitlocal.compareTo(BigDecimal.ZERO) == 0 && xhcreditfor.compareTo(BigDecimal.ZERO) == 0 && xhcreditlocal.compareTo(BigDecimal.ZERO) == 0 && xhyeardebitfor.compareTo(BigDecimal.ZERO) == 0 && xhyeardebitlocal.compareTo(BigDecimal.ZERO) == 0 && xhyearcreditfor.compareTo(BigDecimal.ZERO) == 0 && xhyearcreditlocal.compareTo(BigDecimal.ZERO) == 0 && xhenddebitfor.compareTo(BigDecimal.ZERO) == 0 && xhenddebitlocal.compareTo(BigDecimal.ZERO) == 0 && xhendcrebitfor.compareTo(BigDecimal.ZERO) == 0 && xhendcrebitlocal.compareTo(BigDecimal.ZERO) == 0;
        boolean isRowDiff = false;
        if (easBalanceRow == null && balanceDataMap != null || easBalanceRow != null && balanceDataMap == null) {
            isRowDiff = true;
        } else if (easBalanceRow != null && balanceDataMap != null) {
            isRowDiff = !isDiffAllZero;
        }
        checkDataMap.put("isrowdiff", isRowDiff);
        checkDataMap.put("isallzero", isAllZero);
    }

    private Map<String, String> getEasAsstActTypeMap(String easAssgrpTag) throws IOException {
        Map easAssgrpMap;
        HashMap<String, String> easAsstActTypeMap = new HashMap<String, String>(16);
        if (StringUtil.isNotEmpty(easAssgrpTag) && !CommonUtils.isNull(easAssgrpMap = (Map)JSONUtils.cast((String)easAssgrpTag, Map.class))) {
            Map asstActTypeMap = (Map)easAssgrpMap.get("asstActType");
            for (Map.Entry mapEntry : easAssgrpMap.entrySet()) {
                if ("asstActType".equals(mapEntry.getKey())) continue;
                easAsstActTypeMap.put((String)asstActTypeMap.get(mapEntry.getKey()), mapEntry.getValue().toString());
            }
        }
        return easAsstActTypeMap;
    }

    /*
     * WARNING - void declaration
     */
    private String verifyAsstActTypeConvert(Map<String, String> easAsstActTypeMap, Map<String, String> xhAsstActTypeMap, List<Map<String, String>> destAccountConvertList) {
        HashMap easAssgrpNumberMap = new HashMap(16);
        for (Map.Entry<String, String> entry : easAsstActTypeMap.entrySet()) {
            void var8_14;
            boolean bl;
            if (CommonUtils.isNull(destAccountConvertList) || (bl = destAccountConvertList.stream().filter(o -> ((String)mapEntry.getKey()).equals(o.get("srcasst"))).count() > 0L)) continue;
            Set set = (Set)easAssgrpNumberMap.get(entry.getKey());
            if (CommonUtils.isNull(set)) {
                HashSet hashSet = new HashSet(16);
                easAssgrpNumberMap.put(entry.getKey(), hashSet);
            }
            var8_14.addAll(destAccountConvertList.stream().map(o -> (String)o.get("srcacctnum")).collect(Collectors.toSet()));
        }
        StringBuilder msgBuilder = new StringBuilder();
        if (!easAssgrpNumberMap.isEmpty()) {
            for (Map.Entry entry : easAssgrpNumberMap.entrySet()) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"EAS\u4f1a\u8ba1\u79d1\u76ee%1$s\u7684\u6838\u7b97\u7ef4\u5ea6:%2$s\uff0c\u672a\u914d\u7f6e\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"BalanceCheckDataServiceImpl_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), String.join((CharSequence)"\u3001", (Iterable)entry.getValue()), entry.getKey()));
            }
        }
        HashMap hashMap = new HashMap(16);
        for (Map.Entry<String, String> entry : xhAsstActTypeMap.entrySet()) {
            boolean isExistSrcasst;
            if (CommonUtils.isNull(destAccountConvertList) || (isExistSrcasst = destAccountConvertList.stream().filter(o -> ((String)xhmapEntry.getKey()).equals(o.get("tarasst"))).count() > 0L)) continue;
            HashSet xhAccountNumberSet = (HashSet)hashMap.get(entry.getKey());
            if (CommonUtils.isNull(xhAccountNumberSet)) {
                xhAccountNumberSet = new HashSet(16);
                hashMap.put(entry.getKey(), xhAccountNumberSet);
            }
            xhAccountNumberSet.addAll(destAccountConvertList.stream().map(o -> (String)o.get("taracctnum")).collect(Collectors.toSet()));
        }
        if (!hashMap.isEmpty()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u661f\u701a\u4f1a\u8ba1\u79d1\u76ee%1$s\u7684\u6838\u7b97\u7ef4\u5ea6:%2$s\uff0c\u672a\u914d\u7f6e\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"BalanceCheckDataServiceImpl_5", (String)"imsc-dmw-platform", (Object[])new Object[0]), String.join((CharSequence)"\u3001", (Iterable)entry.getValue()), entry.getKey()));
            }
        }
        return msgBuilder.toString();
    }

    private Map<String, List<String>> getAmountFieldMap() {
        HashMap<String, List<String>> fieldMap = new HashMap<String, List<String>>(20);
        fieldMap.put("yeardebitbeginfor", Arrays.asList("xhyeardebitbeginfor", "diffyeardebitbeginfor"));
        fieldMap.put("yeardebitbeginlocal", Arrays.asList("xhyeardebitbeginlocal", "diffyeardebitbeginlocal"));
        fieldMap.put("yearcreditbeginfor", Arrays.asList("xhyearcreditbeginfor", "diffyearcreditbeginfor"));
        fieldMap.put("yearcreditbeginlocal", Arrays.asList("xhyearcreditbeginlocal", "diffyearcreditbeginlocal"));
        fieldMap.put("begindeditfor", Arrays.asList("xhbegindeditfor", "diffbegindeditfor"));
        fieldMap.put("begindeditlocal", Arrays.asList("xhbegindeditlocal", "diffbegindeditlocal"));
        fieldMap.put("begincreditfor", Arrays.asList("xhbegincreditfor", "diffbegincreditfor"));
        fieldMap.put("begincreditlocal", Arrays.asList("xhbegincreditlocal", "diffbegincreditlocal"));
        fieldMap.put("debitfor", Arrays.asList("xhdebitfor", "diffdebitfor"));
        fieldMap.put("debitlocal", Arrays.asList("xhdebitlocal", "diffdebitlocal"));
        fieldMap.put("creditfor", Arrays.asList("xhcreditfor", "diffcreditfor"));
        fieldMap.put("creditlocal", Arrays.asList("xhcreditlocal", "diffcreditlocal"));
        fieldMap.put("yeardebitfor", Arrays.asList("xhyeardebitfor", "diffyeardebitfor"));
        fieldMap.put("yeardebitlocal", Arrays.asList("xhyeardebitlocal", "diffyeardebitlocal"));
        fieldMap.put("yearcreditfor", Arrays.asList("xhyearcreditfor", "diffyearcreditfor"));
        fieldMap.put("yearcreditlocal", Arrays.asList("xhyearcreditlocal", "diffyearcreditlocal"));
        fieldMap.put("enddebitfor", Arrays.asList("xhenddebitfor", "diffenddebitfor"));
        fieldMap.put("enddebitlocal", Arrays.asList("xhenddebitlocal", "diffenddebitlocal"));
        fieldMap.put("endcrebitfor", Arrays.asList("xhendcrebitfor", "diffendcrebitfor"));
        fieldMap.put("endcrebitlocal", Arrays.asList("xhendcrebitlocal", "diffendcrebitlocal"));
        return fieldMap;
    }

    private void setMergeAccount(DynamicObjectCollection accountCheckEntryColl, Map<String, List<String>> fieldMap, List<List<Integer>> mergeList) {
        if (mergeList.isEmpty()) {
            return;
        }
        for (List<Integer> seqList : mergeList) {
            List mergeCheckDataDetailList = accountCheckEntryColl.stream().filter(o -> seqList.contains(o.get("seq"))).collect(Collectors.toList());
            Map<Object, List<DynamicObject>> groupMap = mergeCheckDataDetailList.stream().collect(Collectors.groupingBy(o -> o.get("easaccountnumber") + "_" + o.get("accountnumber")));
            ArrayList<Integer> mergeSeqList = new ArrayList<Integer>(seqList.size());
            for (Map.Entry<Object, List<DynamicObject>> entry : groupMap.entrySet()) {
                if (entry.getValue().size() > 1) {
                    String xhAmountField;
                    DynamicObject checkEntryDynObj = entry.getValue().get(0);
                    int count = entry.getValue().size();
                    for (int i = 1; i < count; ++i) {
                        DynamicObject entryDynObj = entry.getValue().get(i);
                        for (Map.Entry<String, List<String>> mapEntry : fieldMap.entrySet()) {
                            if (StringUtil.isNotEmpty(entry.getValue().get(0).getString("easaccountnumber"))) {
                                String easAmountField = mapEntry.getKey();
                                checkEntryDynObj.set(easAmountField, (Object)((BigDecimal)checkEntryDynObj.get(easAmountField)).add((BigDecimal)entryDynObj.get(easAmountField)));
                                continue;
                            }
                            xhAmountField = mapEntry.getValue().get(0);
                            checkEntryDynObj.set(xhAmountField, (Object)((BigDecimal)checkEntryDynObj.get(xhAmountField)).add((BigDecimal)entryDynObj.get(xhAmountField)));
                        }
                    }
                    for (Map.Entry<String, List<String>> fieldMapEntry : fieldMap.entrySet()) {
                        String easAmountField = fieldMapEntry.getKey();
                        String xhAmountField2 = fieldMapEntry.getValue().get(0);
                        String diffAmountField = fieldMapEntry.getValue().get(1);
                        checkEntryDynObj.set(diffAmountField, (Object)((BigDecimal)checkEntryDynObj.get(easAmountField)).add((BigDecimal)checkEntryDynObj.get(xhAmountField2)));
                    }
                    boolean isAllZero = true;
                    boolean isRowDiff = false;
                    for (Map.Entry<String, List<String>> fieldMapEntry : fieldMap.entrySet()) {
                        xhAmountField = fieldMapEntry.getValue().get(0);
                        String easAmountField = fieldMapEntry.getKey();
                        String diffAmountField = fieldMapEntry.getValue().get(1);
                        if (BigDecimal.ZERO.compareTo((BigDecimal)checkEntryDynObj.get(easAmountField)) != 0 || BigDecimal.ZERO.compareTo((BigDecimal)checkEntryDynObj.get(xhAmountField)) != 0) {
                            isAllZero = false;
                        }
                        if (BigDecimal.ZERO.compareTo((BigDecimal)checkEntryDynObj.get(diffAmountField)) != 0) {
                            isRowDiff = true;
                        }
                        if (isAllZero || !isRowDiff) continue;
                        break;
                    }
                    checkEntryDynObj.set("isallzero", (Object)isAllZero);
                    checkEntryDynObj.set("isrowdiff", (Object)isRowDiff);
                    accountCheckEntryColl.removeAll((Collection)entry.getValue());
                    accountCheckEntryColl.add((Object)checkEntryDynObj);
                    mergeSeqList.add((Integer)checkEntryDynObj.get("seq"));
                    continue;
                }
                mergeSeqList.add((Integer)entry.getValue().get(0).get("seq"));
            }
            ArrayList<List<Integer>> list = new ArrayList<List<Integer>>(1);
            list.add(mergeSeqList);
            this.setMergeGroupNo(accountCheckEntryColl, fieldMap, list, false);
        }
    }

    private void setMergeGroupNo(DynamicObjectCollection checkEntryColl, Map<String, List<String>> fieldMap, List<List<Integer>> mergeList, boolean isSetGroupNo) {
        if (mergeList.isEmpty()) {
            return;
        }
        int mergegroupno = 1000;
        for (List<Integer> seqList : mergeList) {
            List mergeCheckEntryList = checkEntryColl.stream().filter(o -> seqList.contains(o.get("seq"))).collect(Collectors.toList());
            HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(16);
            for (DynamicObject mergeCheckEntryDynObj : mergeCheckEntryList) {
                if (isSetGroupNo) {
                    mergeCheckEntryDynObj.set("mergegroupno", (Object)mergegroupno);
                    mergeCheckEntryDynObj.set("ismerge", (Object)"1");
                } else if (seqList.size() == 1) {
                    mergeCheckEntryDynObj.set("mergegroupno", (Object)"");
                    mergeCheckEntryDynObj.set("ismerge", (Object)"0");
                }
                for (Map.Entry<String, List<String>> mapEntry : fieldMap.entrySet()) {
                    if (!amountMap.containsKey(mapEntry.getValue().get(0))) {
                        amountMap.put(mapEntry.getValue().get(0), (BigDecimal)mergeCheckEntryDynObj.get(mapEntry.getKey()));
                        continue;
                    }
                    amountMap.put(mapEntry.getValue().get(0), ((BigDecimal)amountMap.get(mapEntry.getValue().get(0))).add((BigDecimal)mergeCheckEntryDynObj.get(mapEntry.getKey())));
                }
            }
            boolean isDiffAllZero = true;
            boolean isAllZero = true;
            boolean isRowDiff = false;
            for (DynamicObject mergeCheckEntryDynObj : mergeCheckEntryList) {
                for (Map.Entry<String, List<String>> mapEntry : fieldMap.entrySet()) {
                    mergeCheckEntryDynObj.set(mapEntry.getValue().get(1), (Object)((BigDecimal)amountMap.get(mapEntry.getValue().get(0))).subtract((BigDecimal)mergeCheckEntryDynObj.get(mapEntry.getValue().get(0))));
                    if (((BigDecimal)mergeCheckEntryDynObj.get(mapEntry.getValue().get(1))).compareTo(BigDecimal.ZERO) != 0) {
                        isDiffAllZero = false;
                    }
                    if (((BigDecimal)mergeCheckEntryDynObj.get(mapEntry.getValue().get(0))).compareTo(BigDecimal.ZERO) == 0 && ((BigDecimal)mergeCheckEntryDynObj.get(mapEntry.getKey())).compareTo(BigDecimal.ZERO) == 0) continue;
                    isAllZero = false;
                }
                String easaccountnumber = (String)mergeCheckEntryDynObj.get("easaccountnumber");
                String accountnumber = (String)mergeCheckEntryDynObj.get("accountnumber");
                if (StringUtil.isEmpty(easaccountnumber) && StringUtil.isNotEmpty(accountnumber) || StringUtil.isNotEmpty(easaccountnumber) && StringUtil.isEmpty(accountnumber)) {
                    isRowDiff = true;
                    continue;
                }
                if (!StringUtil.isNotEmpty(easaccountnumber) || !StringUtil.isNotEmpty(accountnumber)) continue;
                isRowDiff = !isDiffAllZero;
            }
            for (DynamicObject mergeCheckEntryDynObj : mergeCheckEntryList) {
                mergeCheckEntryDynObj.set("isrowdiff", (Object)isRowDiff);
                mergeCheckEntryDynObj.set("isallzero", (Object)isAllZero);
            }
            ++mergegroupno;
        }
    }
}

