/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.datacollect.upload;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;

public class ExcelDataChecker {
    private static final String OPTION_OVERRIDE_ENTRY = "OverrideEntry";
    private static final String OPTION_SET_NULL = "SetNULL";
    private static final String OPTION_SPLIT_SUB_ENTRIES = "SplitSubEntries";
    private final InputStream excelFileStream;
    private final IFormView view;
    private boolean[] condition = new boolean[]{false, true, false, false};
    private boolean[] reallyVerified = new boolean[]{false, false, false, false};
    Map<Integer, String> entityRow = new HashMap<Integer, String>(8);
    private Map<Integer, String> allFieldNumber = new HashMap<Integer, String>(16);
    private Map<Integer, String> allFieldName = new HashMap<Integer, String>(16);
    Set<String> sensitiveFields = new HashSet<String>(16);

    public Set<String> getSensitiveFields() {
        return this.sensitiveFields;
    }

    public ExcelDataChecker(IFormView view, InputStream excelFileStream) {
        this.view = view;
        this.excelFileStream = excelFileStream;
    }

    public Map<Integer, String> getAllFieldNumber() {
        return this.allFieldNumber;
    }

    public Map<Integer, String> getAllFieldName() {
        return this.allFieldName;
    }

    public static String getExcelFormatErrorTips() {
        return ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002 \u8bf7\u68c0\u67e5\u6570\u636e\u6a21\u677f\uff1a1\u3001\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u5b9e\u4f53\u662f\u5426\u5339\u914d\uff1b2\u3001\u6570\u636e\u6a21\u677f\u662f\u5426\u5728\u7b2c\u4e00\u4e2a\u5de5\u4f5c\u8868\u3002", (String)"ExcelDataChecker_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
    }

    public boolean haseErrorColumn() {
        return this.condition[0];
    }

    public boolean isNewFormat() {
        return this.condition[1];
    }

    public boolean hasDataRow() {
        return this.condition[2];
    }

    public boolean isRightEntity() {
        return this.condition[3];
    }

    public void doCheck() throws Exception {
        new ExcelReader().read(this.excelFileStream, new SheetHandler(){

            public void handleRow(SheetHandler.ParsedRow row) {
                if (StringUtils.equals((CharSequence)row.getSheetName(), (CharSequence)"sensitive_fields_sheet")) {
                    ExcelDataChecker.this.handleSensitiveFieldsRow(row);
                    return;
                }
                ExcelDataChecker.this.handleDataRow(row);
            }
        }, true);
    }

    private void handleSensitiveFieldsRow(SheetHandler.ParsedRow currentRow) {
        Map data = currentRow.getData();
        if (data.isEmpty()) {
            return;
        }
        String field = (String)data.get(0);
        if (StringUtils.isNotBlank((CharSequence)field)) {
            this.sensitiveFields.add(field);
        }
    }

    private void handleDataRow(SheetHandler.ParsedRow row) {
        if (row.getRowNum() == 0) {
            this.reallyVerified[0] = true;
            String billFormId = (String)this.view.getFormShowParameter().getCustomParam("BillFormId");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
            if (entityType instanceof QueryEntityType) {
                QueryEntityType queryEntityType = (QueryEntityType)entityType;
                String entityName = row.get(Integer.valueOf(0));
                if (StringUtils.isEmpty((CharSequence)entityName)) {
                    this.condition[0] = true;
                    entityName = row.get(Integer.valueOf(1));
                }
                if (entityName.split(" # ").length < 2 || !entityName.split(" # ")[1].equalsIgnoreCase(queryEntityType.getMainEntityType().getName())) {
                    throw new KDBizException(ExcelDataChecker.getExcelFormatErrorTips());
                }
            } else {
                String entityName = row.get(Integer.valueOf(0));
                if (StringUtils.isEmpty((CharSequence)entityName)) {
                    entityName = row.get(Integer.valueOf(1));
                    this.condition[0] = true;
                }
                if (entityName == null) {
                    throw new KDBizException(ExcelDataChecker.getExcelFormatErrorTips());
                }
                if (entityName.split(" # ").length < 2 || !entityName.split(" # ")[1].equalsIgnoreCase(billFormId)) {
                    throw new KDBizException(ExcelDataChecker.getExcelFormatErrorTips());
                }
            }
            this.entityRow.putAll(row.getData());
            this.condition[3] = true;
        } else if (row.getRowNum() == 1) {
            this.reallyVerified[1] = true;
            Map commentRow = row.getData();
            String specialComment = (String)commentRow.get(this.condition[0] ? 1 : 0);
            if (specialComment != null) {
                this.view.getPageCache().put("ForUpdateMultiLangFields", String.valueOf(specialComment.contains("#ForUpdateMultiLangFields")));
                this.view.getPageCache().put(OPTION_OVERRIDE_ENTRY, String.valueOf(specialComment.contains("#OverrideEntry")));
                this.view.getPageCache().put(OPTION_SET_NULL, String.valueOf(specialComment.contains("#SetNULL")));
                this.view.getPageCache().put(OPTION_SPLIT_SUB_ENTRIES, String.valueOf(specialComment.contains("#SplitSubEntries")));
            }
        } else if (row.getRowNum() == 2) {
            this.reallyVerified[2] = true;
            if (row.isEmpty()) {
                throw new KDBizException(ExcelDataChecker.getExcelFormatErrorTips());
            }
            Map nameRow = row.getData();
            this.condition[1] = !((String)nameRow.get(this.condition[0] ? 1 : 0)).contains(" # ");
            Set<String> fields = this.getHeadField(nameRow, this.entityRow, this.condition[1]);
            this.view.getPageCache().put("MainEntityFields", StringUtils.join((Object[])fields.toArray(), (String)","));
            this.view.getPageCache().put("EntryHasNoId", this.findEntryHashNoId(this.entityRow, nameRow));
        } else if (row.getRowNum() > (this.condition[1] ? 3 : 2)) {
            this.reallyVerified[3] = true;
            if (!row.isEmpty()) {
                this.condition[2] = true;
                if (!(this.reallyVerified[0] && this.reallyVerified[1] && this.reallyVerified[2] && this.reallyVerified[3])) {
                    throw new KDBizException(ExcelDataChecker.getExcelFormatErrorTips());
                }
                throw new KDBizException(new ErrorCode("NEXT_SHEET", ResManager.loadKDString((String)"\u6a21\u677f\u6821\u9a8c\u901a\u8fc7\uff0c\u5df2\u89e3\u6790\u5230\u6570\u636e\u3002", (String)"ExcelDataChecker_1", (String)"imsc-dmw-platform", (Object[])new Object[0])), new Object[0]);
            }
        }
        if (this.condition[1] && row.getRowNum() == 3) {
            this.allFieldName = row.getData();
        }
    }

    private Set<String> getHeadField(Map<Integer, String> nameRow, Map<Integer, String> entityRow, boolean isNewTemplate) {
        Integer endIndex = Integer.MAX_VALUE;
        if (entityRow != null && entityRow.size() >= 2) {
            TreeMap<Integer, String> sortedMap = new TreeMap<Integer, String>(entityRow);
            endIndex = (Integer)new ArrayList(sortedMap.keySet()).get(1);
        }
        HashSet<String> fields = new HashSet<String>(10);
        String number = null;
        String[] nameSplit = null;
        for (Map.Entry<Integer, String> entry : nameRow.entrySet()) {
            number = entry.getValue();
            if (!isNewTemplate && (nameSplit = number.split(" # ")).length == 2) {
                number = nameSplit[1];
                this.allFieldName.put(entry.getKey(), nameSplit[0]);
            }
            if (entry.getKey() < endIndex) {
                fields.add(number);
            }
            this.allFieldNumber.put(entry.getKey(), number);
        }
        return fields;
    }

    private String findEntryHashNoId(Map<Integer, String> entityRow, Map<Integer, String> nameRow) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Map.Entry<Integer, String>> list = new ArrayList<Map.Entry<Integer, String>>(entityRow.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, String>>(){

            @Override
            public int compare(Map.Entry<Integer, String> o1, Map.Entry<Integer, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        Iterator it = list.iterator();
        if (it.hasNext()) {
            it.next();
        }
        ArrayList area = new ArrayList(list.size());
        while (it.hasNext()) {
            area.add(((Map.Entry)it.next()).getKey());
        }
        Integer entryStart = null;
        Integer entryEnd = null;
        for (int i = 0; i < area.size(); ++i) {
            entryStart = (Integer)area.get(i);
            Integer n = entryEnd = i >= area.size() - 1 ? null : (Integer)area.get(i + 1);
            if (this.existEntryId(nameRow, entryStart, entryEnd)) continue;
            if (sb.length() != 0) {
                sb.append('\u3001');
            }
            sb.append('\u201c').append(entityRow.get(entryStart)).append('\u201d');
        }
        return sb.toString();
    }

    private boolean existEntryId(Map<Integer, String> nameRow, Integer entryStart, Integer entryEnd) {
        boolean existId = false;
        ArrayList<Map.Entry<Integer, String>> list = new ArrayList<Map.Entry<Integer, String>>(nameRow.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, String>>(){

            @Override
            public int compare(Map.Entry<Integer, String> o1, Map.Entry<Integer, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : list) {
            if ((Integer)entry.getKey() < entryStart || entryEnd != null && (Integer)entry.getKey() >= entryEnd || entry.getValue() == null || !((String)entry.getValue()).endsWith("_id")) continue;
            existId = true;
            break;
        }
        return existId;
    }

    public boolean validSensitiveFields(Map<String, String> errorInfo) {
        if (this.sensitiveFields == null || this.sensitiveFields.isEmpty()) {
            return true;
        }
        if (this.isBlockAll()) {
            errorInfo.put("content", ResManager.loadKDString((String)"\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u7684\u6587\u4ef6\u4e2d\u542b\u6709\u8131\u654f\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u4f5c\u4e3a\u5bfc\u5165\u6a21\u677f\u3002", (String)"ExcelDataChecker_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> errorInfoFields = new ArrayList<String>(16);
        for (Map.Entry<Integer, String> fieldNumber : this.allFieldNumber.entrySet()) {
            String numberValue = fieldNumber.getValue();
            if (!this.sensitiveFields.contains(numberValue)) continue;
            String fieldName = this.allFieldName.get(fieldNumber.getKey());
            if (fieldName.indexOf(42) == 0) {
                fieldName = fieldName.substring(1);
            }
            errorInfoFields.add(fieldName + "(" + numberValue + ")");
        }
        if (!errorInfoFields.isEmpty()) {
            errorInfo.put("title", ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u5bfc\u5165\u6a21\u677f\u4e2d\u5305\u542b\u8131\u654f\u5b57\u6bb5\uff0c\u5982\u9700\u7ee7\u7eed\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u8fd9\u4e9b\u5b57\u6bb5\u3002", (String)"ExcelDataChecker_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            errorInfo.put("content", String.format(ResManager.loadKDString((String)"\u5305\u542b\u7684\u8131\u654f\u5b57\u6bb5\uff1a%s\u3002", (String)"ExcelDataChecker_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), StringUtils.join((Object[])errorInfoFields.toArray(), (String)",")));
            return false;
        }
        return true;
    }

    private boolean isBlockAll() {
        String isBlockAll = System.getProperty("import_update_is_block_all", Boolean.toString(true));
        return Boolean.parseBoolean(isBlockAll);
    }
}

