/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Type;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isc.util.misc.NetUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class MigrateUserguideEASFormPlugin
extends ImbdDymicTplEditPlugin {
    private static final String SELECT_DC = "select_dc";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"savelink", "modifylink", "dblinktest", "data_center", "configguide"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject linkDynObj = this.loadDatabaseLink();
        boolean isDataNull = CommonUtils.isNull(linkDynObj);
        this.getView().setEnable(Boolean.valueOf(!isDataNull), new String[]{"modifylink", "dblinktest"});
        this.getView().setEnable(Boolean.valueOf(isDataNull), new String[]{"savelink"});
        DynamicObject linkDataDynObj = (DynamicObject)this.getModel().getValue("dblink");
        if (linkDataDynObj != null && !"IMSC_EAS_MIGRATE".equals(DynamicObjectUtils.getString(linkDataDynObj, "number"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"savelink", "modifylink", "dblinktest"});
            isDataNull = false;
            linkDynObj = linkDataDynObj;
        }
        if (linkDynObj != null) {
            this.loadDataByIscDatabaseLink(linkDynObj);
        }
        this.setLinkFieldEnable(isDataNull);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "savelink": {
                Object linkNumber = this.getModel().getValue("linknumber");
                Object linkName = this.getModel().getValue("linkname");
                if (StringUtil.isEmpty(linkNumber) || StringUtil.isEmpty(linkName)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u7f16\u7801\u3001\u8fde\u63a5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MigrateUserguideEASFormPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    return;
                }
                if (!this.checkEASConfig()) {
                    return;
                }
                DynamicObject dblinkDynObj = (DynamicObject)this.getModel().getValue("dblink");
                if (dblinkDynObj != null && !this.verifySave(dblinkDynObj.getLong("id"))) {
                    return;
                }
                DynamicObject dataBaseLinkDynObj = this.loadDatabaseLink();
                boolean isDeploy = !"Y".equals(DynamicObjectUtils.getString(dataBaseLinkDynObj, "deploy_state")) || !"S".equals(DynamicObjectUtils.getString(dataBaseLinkDynObj, "state"));
                DynamicObject linkDynObj = this.createIscDatabaseLinkByGuide(dataBaseLinkDynObj);
                OperationResult optResult = SaveServiceHelper.saveOperate((String)"isc_database_link", (DynamicObject[])new DynamicObject[]{linkDynObj}, (OperateOption)OperateOption.create());
                if (!optResult.isSuccess()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u96c6\u6210\u4e91EAS\u8fde\u63a5\u914d\u7f6e\u5931\u8d25\uff0c%s", (String)"MigrateUserguideEASFormPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), CommonUtils.getErrDetail(optResult));
                    this.getView().showMessage(msg);
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MigrateUserguideEASFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                if (isDeploy) {
                    HashMap<String, Object> request = new HashMap<String, Object>(4);
                    request.put("ierpUrl", UrlService.getDomainContextUrl().replace("localhost", NetUtil.getLocalAddress()));
                    request.put("number", linkDynObj.getString("number"));
                    request.put("password", this.getModel().getValue("adminpassword"));
                    request.put("permissionMode", "PUBLIC");
                    Map result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"deployConnection", (Object[])new Object[]{request});
                    boolean success = (Boolean)result.get("success");
                    if (!success) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"EAS\u90e8\u7f72\u5931\u8d25\uff1a%s", (String)"MigrateUserguideEASFormPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), result.get("message")));
                    } else {
                        linkDynObj.set("deploy_state", (Object)"Y");
                        SaveServiceHelper.update((DynamicObject)linkDynObj);
                    }
                }
                this.setLinkFieldEnable(false);
                this.getModel().setValue("dblink", linkDynObj.getPkValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{"savelink"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"modifylink", "dblinktest"});
                this.getPageCache().put("modifylink", "savelink");
                break;
            }
            case "modifylink": {
                if (this.getModel().getValue("dblink") != null) {
                    String msg = ResManager.loadKDString((String)"\u4fee\u6539\u5f53\u524d\u8fde\u63a5\u914d\u7f6e\u4f1a\u5f71\u54cd\u5176\u4ed6EAS\u6570\u636e\u8fc1\u79fb\u9879\u76ee\u5173\u8054\u7684\u8fde\u63a5\u914d\u7f6e\uff0c\u8bf7\u8c28\u614e\u786e\u8ba4\u662f\u5426\u4fee\u6539\uff1f", (String)"MigrateUserguideEASFormPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("modifylink"));
                    return;
                }
                this.modifyLink();
                break;
            }
            case "data_center": {
                HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>(1);
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String ip = dataEntity.getString("server_ip");
                String port = dataEntity.getString("server_port");
                String protocal = dataEntity.getString("http_protocal");
                paramMap.put("dc_list", this.getDataCenterList(protocal, ip, port));
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("isc_datacenter_list");
                showParameter.setCustomParams(paramMap);
                showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u5217\u8868", (String)"MigrateUserguideEASFormPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_DC));
                showParameter.setShowClose(true);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
            case "configguide": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("dmw_eas_config");
                parameter.getOpenStyle().setPlaceholder(false);
                parameter.getOpenStyle().setShowType(ShowType.PageDrawer);
                parameter.getOpenStyle().setFloatingDirection(FloatingDirection.BottomRight);
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("modifylink".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.modifyLink();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if (action.equals(SELECT_DC) && data instanceof Map) {
            this.getModel().setValue("data_center", ((Map)data).get("datacenter"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "server_ip": {
                String serverIp = StringUtil.toString(newValue);
                if (StringUtil.isEmpty(serverIp) || !Pattern.matches("\\d+\\.\\d+\\.\\d+\\.\\d+", serverIp)) break;
                this.getModel().setValue("http_protocal", (Object)"http");
                break;
            }
            case "http_protocal": {
                if (!"http".equals(newValue)) break;
                this.getView().showMessage(ResManager.loadKDString((String)"http\u662f\u4e0d\u5b89\u5168\u534f\u8bae\uff0c\u4f7f\u7528\u8be5\u534f\u8bae\u5728\u7f51\u7edc\u4e0a\u4f20\u8f93\u6570\u636e\u65f6\u53ef\u80fd\u53d1\u751f\u4fe1\u606f\u6cc4\u9732\uff0c\u8bf7\u614e\u91cd\u8bc4\u4f30\u76f8\u5173\u98ce\u9669\u3002", (String)"MigrateUserguideEASFormPlugin_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void loadDataByIscDatabaseLink(DynamicObject linkDynObj) {
        this.getModel().setValue("linknumber", (Object)linkDynObj.getString("number"));
        this.getModel().setValue("linkname", (Object)linkDynObj.getString("name"));
        this.getModel().setValue("dblink", linkDynObj.getPkValue());
        this.getModel().setValue("server_ip", linkDynObj.get("server_ip"));
        this.getModel().setValue("server_port", linkDynObj.get("server_port"));
        this.getModel().setValue("http_protocal", linkDynObj.get("http_protocal"));
        this.getModel().setValue("data_center", linkDynObj.get("data_center"));
        this.getModel().setValue("user", linkDynObj.get("user"));
        this.getModel().setValue("newpwd", linkDynObj.get("newpwd"));
        this.getModel().setValue("eas_service", linkDynObj.get("eas_service"));
        this.getModel().setValue("ierp_proxy_user", linkDynObj.get("ierp_proxy_user"));
        this.getModel().setValue("max_tps", linkDynObj.get("max_tps"));
    }

    private DynamicObject createIscDatabaseLinkByGuide(DynamicObject linkDynObj) {
        if (linkDynObj == null) {
            linkDynObj = BusinessDataServiceHelper.newDynamicObject((String)"isc_database_link");
            long pkId = DB.genLongId((String)linkDynObj.getDynamicObjectType().getAlias());
            linkDynObj.set("id", (Object)pkId);
        }
        linkDynObj.set("number", this.getModel().getValue("linknumber"));
        linkDynObj.set("name", this.getModel().getValue("linkname"));
        linkDynObj.set("database_type", (Object)"eas");
        linkDynObj.set("dum_link", (Object)"0COJ=WU33VQA");
        linkDynObj.set("isv", (Object)"kingdee.imsc");
        linkDynObj.set("server_ip", this.getModel().getValue("server_ip"));
        linkDynObj.set("server_port", this.getModel().getValue("server_port"));
        linkDynObj.set("http_protocal", this.getModel().getValue("http_protocal"));
        linkDynObj.set("data_center", this.getModel().getValue("data_center"));
        linkDynObj.set("user", this.getModel().getValue("user"));
        linkDynObj.set("newpwd", this.getModel().getValue("newpwd"));
        linkDynObj.set("eas_service", this.getModel().getValue("eas_service"));
        linkDynObj.set("ierp_proxy_user", this.getModel().getValue("ierp_proxy_user"));
        linkDynObj.set("max_tps", this.getModel().getValue("max_tps"));
        linkDynObj.set("enable", (Object)"1");
        linkDynObj.set("status", (Object)"C");
        linkDynObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        return linkDynObj;
    }

    private void setLinkFieldEnable(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"server_ip", "server_port", "user", "newpwd", "http_protocal", "data_center", "max_tps", "eas_service", "ierp_proxy_user", "adminpassword"});
    }

    private DynamicObject loadDatabaseLink() {
        return BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (QFilter[])new QFilter("number", "=", (Object)"IMSC_EAS_MIGRATE").toArray());
    }

    private void modifyLink() {
        this.setLinkFieldEnable(true);
        this.getView().setEnable(Boolean.TRUE, new String[]{"savelink"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"modifylink", "dblinktest"});
        this.getPageCache().put("modifylink", "modifylink");
    }

    private List<String> getDataCenterList(String protocal, String ip, String port) {
        if (!(StringUtil.isEmpty(protocal) || StringUtil.isEmpty(ip) || StringUtil.isEmpty(port))) {
            String s;
            String url = protocal + "://" + ip + ":" + port + "/isc/queryEasInfo/getDataCenterList";
            try {
                s = NetUtil.httpRead((String)url, (String)"UTF-8");
            }
            catch (Exception ex) {
                throw new DmwBizException(ex.getMessage());
            }
            return (List)JSON.parseObject((String)s, (Type)TypeReference.LIST_STRING, (Feature[])new Feature[0]);
        }
        throw new DmwBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u534f\u8bae\u3001IP\u3001\u7aef\u53e3\uff0c\u624d\u80fd\u9009\u62e9\u6570\u636e\u4e2d\u5fc3\u3002", (String)"MigrateUserguideEASFormPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
    }

    private boolean checkEASConfig() {
        DynamicObject dbLinkDynObj;
        DynamicObject user;
        boolean flag = true;
        DynamicObject ierpProxyUserDynObj = (DynamicObject)this.getModel().getValue("ierp_proxy_user");
        if (StringUtil.isEmpty(this.getModel().getValue("server_ip")) || (Integer)this.getModel().getValue("server_port") == 0 || StringUtil.isEmpty(this.getModel().getValue("data_center")) || StringUtil.isEmpty(this.getModel().getValue("user")) || ierpProxyUserDynObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u670d\u52a1\u5668\u7aef\u53e3\u3001\u6570\u636e\u4e2d\u5fc3\u3001\u767b\u5f55\u7528\u6237\u3001\u5f53\u524d\u8d26\u5957\u56de\u8c03\u4ee3\u7406\u7528\u6237\u4e3a\u5fc5\u586b\u9879\u3002", (String)"MigrateUserguideEASFormPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            flag = false;
        }
        if (ierpProxyUserDynObj != null && StringUtil.isEmpty((user = BusinessDataServiceHelper.loadSingle((Object)ierpProxyUserDynObj.getPkValue(), (String)"bos_user", (String)"username")).getString("username"))) {
            this.getModel().setValue("ierp_proxy_user", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ee3\u7406\u7528\u6237\u65e0\u7528\u6237\u540d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MigrateUserguideEASFormPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            flag = false;
        }
        if (!("Y".equals(DynamicObjectUtils.getString(dbLinkDynObj = (DynamicObject)this.getModel().getValue("dblink"), "deploy_state")) && "S".equals(DynamicObjectUtils.getString(dbLinkDynObj, "state")) || !StringUtil.isEmpty(this.getModel().getValue("adminpassword")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"EAS\u7ba1\u7406\u5458\u5bc6\u7801\u4e3a\u5fc5\u586b\u9879\u3002", (String)"MigrateUserguideEASFormPlugin_9", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            flag = false;
        }
        return flag;
    }

    private boolean verifySave(long bdLinkId) {
        QFilter filter = new QFilter("dblink", "=", (Object)bdLinkId);
        filter.and(new QFilter("projectstatus", "=", (Object)"E"));
        String selectors = String.join((CharSequence)",", "number", "executetype", "migratestatus");
        DynamicObject[] projectDynObjs = BusinessDataServiceHelper.load((String)"dmw_migrateproject_eas", (String)selectors, (QFilter[])filter.toArray());
        StringBuilder numberBuilder = new StringBuilder();
        for (DynamicObject projectDynObj : projectDynObjs) {
            long count = projectDynObj.getDynamicObjectCollection("treeentryentity").stream().filter(o -> "2".equals(o.getString("executetype")) && "B".equals(o.getString("migratestatus"))).count();
            if (count > 0L) continue;
            numberBuilder.append(projectDynObj.getString("number")).append("\uff0c");
        }
        if (numberBuilder.length() > 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u8fde\u63a5\u914d\u7f6e\u7684\u8fc1\u79fb\u4e2d\u9879\u76ee\uff1a%s\u8bf7\u8fc1\u79fb\u5b8c\u6210\u540e\uff0c\u518d\u4fee\u6539\u8fde\u63a5\u914d\u7f6e\u3002", (String)"MigrateUserguideEASFormPlugin_10", (String)"imsc-dmw-platform", (Object[])new Object[0]), numberBuilder.toString());
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }
}

