/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.migwizard;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.helper.ShowFormHelper;
import kd.imsc.dmw.helper.migwizard.MigrationWizardHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtils;
import kd.imsc.dmw.utils.StyleUtils;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class MigrationPresetSchemePlugin
extends ImbdDymicTplEditPlugin
implements RowClickEventListener {
    private static final String TARGET_KEYS_ONE = "targetKeysOne";
    private static final String TARGET_KEYS_TWO = "targetKeysTwo";
    private static final String TARGET_KEYS_THREE = "targetKeysThree";
    private static final String MODULE = "module";
    private static final String FIELD = "field";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"migmodelflex", "migschemeflex", "migmodellabel", "migschemelabel"});
        EntryGrid fieldCardEntries = (EntryGrid)this.getView().getControl("filedcardentry");
        fieldCardEntries.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String system = (String)this.getView().getFormShowParameter().getCustomParam("sourcesystem");
        Map<String, Object> fieldModuleMap = this.getMigObjModule(system);
        this.createDomainAndModule(fieldModuleMap, 0);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.switchFlexStyle("migmodelflex");
        this.switchCardFlex(0);
        HashMap<String, String[]> tagMap = new HashMap<String, String[]>(8);
        tagMap.put("EAS", new String[]{"easschemelabel"});
        tagMap.put("NC", new String[]{"ncschemelabel"});
        tagMap.put("ECC", new String[]{"eccschemelabel"});
        MigrationWizardHelper.controlDisplayAndHide(this.getView(), tagMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        Tab tab = (Tab)this.getControl("tabap");
        switch (key) {
            case "migmodelflex": 
            case "migmodellabel": {
                this.switchFlexStyle("migmodelflex");
                tab.activeTab("migrationmodel");
                break;
            }
            case "migschemeflex": 
            case "migschemelabel": {
                this.switchFlexStyle("migschemeflex");
                tab.activeTab("migrationscheme");
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        CardEntry cardEntry = (CardEntry)evt.getSource();
        int row = evt.getRow();
        if ("filedcardentry".equals(cardEntry.getKey())) {
            this.switchCardFlex(row);
            String system = (String)this.getView().getFormShowParameter().getCustomParam("sourcesystem");
            Map<String, Object> fieldModuleMap = this.getMigObjModule(system);
            this.createDomainAndModule(fieldModuleMap, row);
        }
    }

    private void switchCardFlex(int row) {
        DynamicObjectCollection cardEntryEntities = this.getModel().getEntryEntity("filedcardentry");
        for (int i = 0; i < cardEntryEntities.size(); ++i) {
            if (i != row) {
                StyleUtils.setCardRowStyle(this.getView(), "filedcardentry", i, "cardentryflex", "#FFFFFF", "#666666");
                StyleUtils.setCardRowStyle(this.getView(), "filedcardentry", i, "modename", "#FFFFFF", "#666666");
                continue;
            }
            StyleUtils.setCardRowStyle(this.getView(), "filedcardentry", i, "cardentryflex", "#F2F6FF", "#5582F3");
            StyleUtils.setCardRowStyle(this.getView(), "filedcardentry", i, "modename", "#F2F6FF", "#5582F3");
        }
    }

    private void switchFlexStyle(String mode) {
        if ("migmodelflex".equals(mode)) {
            StyleUtils.setContainerStyle(this.getView(), "migmodelflex", "", "#5582F3", "#FFFFFF");
            StyleUtils.setContainerStyle(this.getView(), "migschemeflex", "", "#FFFFFF", "#666666");
        } else {
            StyleUtils.setContainerStyle(this.getView(), "migmodelflex", "", "#FFFFFF", "#666666");
            StyleUtils.setContainerStyle(this.getView(), "migschemeflex", "", "#5582F3", "#FFFFFF");
        }
    }

    private Map<String, Object> getMigObjModule(String system) {
        String tableName = "";
        switch (system) {
            case "EAS": {
                tableName = "dmw_migratemodule_eas";
                break;
            }
            case "NC": {
                tableName = "dmw_migratemodule_nc";
                break;
            }
            case "ECC": {
                tableName = "dmw_migratemodule_ecc";
                break;
            }
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection fieldAndModuleArray = QueryServiceHelper.query((String)tableName, (String)"id,number,name,parent,parent.id,type,sortnum,issupportinit,issupportall", (QFilter[])qFilter.toArray(), (String)"type,sortnum");
        ArrayList<DynamicObject> fieldList = new ArrayList<DynamicObject>(8);
        HashMap<Long, List<DynamicObject>> fieldModuleMap = new HashMap<Long, List<DynamicObject>>(8);
        for (DynamicObject fieldAndModule : fieldAndModuleArray) {
            List<DynamicObject> moduleList;
            Long id = fieldAndModule.getLong("id");
            String type = fieldAndModule.getString("type");
            if ("B".equals(type)) {
                Long parentId = fieldAndModule.getLong("parent.id");
                moduleList = (List<DynamicObject>)fieldModuleMap.get(parentId);
                if (moduleList == null) continue;
                moduleList.add(fieldAndModule);
                fieldModuleMap.put(parentId, moduleList);
                continue;
            }
            if (!"A".equals(type)) continue;
            moduleList = fieldModuleMap.containsKey(id) ? (List)fieldModuleMap.get(id) : new ArrayList(8);
            fieldList.add(fieldAndModule);
            fieldModuleMap.put(id, moduleList);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(FIELD, fieldList);
        map.put(MODULE, fieldModuleMap);
        return map;
    }

    private void createDomainAndModule(Map<String, Object> fieldModuleMap, int selectRow) {
        DynamicObjectCollection fieldCardEntries = this.getModel().getEntryEntity("filedcardentry");
        fieldCardEntries.clear();
        Map moduleMap = (Map)fieldModuleMap.get(MODULE);
        List fieldList = (List)fieldModuleMap.get(FIELD);
        int index = 0;
        for (DynamicObject field : fieldList) {
            if (CommonUtils.isNull(field)) continue;
            long fieldId = field.getLong("id");
            DynamicObject fieldEntry = fieldCardEntries.addNew();
            fieldEntry.set("id", (Object)fieldId);
            fieldEntry.set("seq", (Object)(index + 1));
            fieldEntry.set("modename", (Object)field.getString("name"));
            if (index == selectRow) {
                this.createModule((List)moduleMap.get(fieldId), "onecolumnflex", TARGET_KEYS_ONE, "imsc_module_column_one", false, false);
                this.createModule((List)moduleMap.get(fieldId), "twocolumnflex", TARGET_KEYS_TWO, "imsc_module_column_two", true, false);
                this.createModule((List)moduleMap.get(fieldId), "threecolumnflex", TARGET_KEYS_THREE, "imsc_module_column_three", false, true);
            }
            ++index;
        }
    }

    private void createModule(List<DynamicObject> moduleList, String parentFlex, String targetKeyCache, String addFlex, boolean isSupportInit, boolean isSupportAll) {
        int count = 0;
        Container schemeContainer = (Container)this.getView().getControl(parentFlex);
        this.deleteFlexCache(schemeContainer, targetKeyCache);
        ArrayList<Map> maps = new ArrayList<Map>(8);
        for (DynamicObject module : moduleList) {
            if (++count == 1) continue;
            String targetKey = addFlex + count;
            this.buildFlexCache(targetKey, targetKeyCache);
            FlexPanelAp panelAp = this.createFlexPanelAp(targetKey, parentFlex);
            maps.add(panelAp.createControl());
            HashMap<String, Object> customParams = new HashMap<String, Object>(2);
            if (isSupportInit) {
                customParams.put("isSupportInitAll", module.getBoolean("issupportinit") ? "yes" : "no");
            } else if (isSupportAll) {
                customParams.put("isSupportInitAll", module.getBoolean("issupportall") ? "yes" : "no");
            } else {
                customParams.put("modulename", module.getString("name"));
            }
            FormShowParameter formShowParameter = ShowFormHelper.showFrom("dmw_module_card", targetKey, ShowType.InContainer, customParams);
            this.getView().showForm(formShowParameter);
        }
        schemeContainer.addControls(maps);
        this.getView().updateView("rightflex");
    }

    private void buildFlexCache(String targetKey, String targetKeyCache) {
        String targetKeys = this.getView().getPageCache().get(targetKeyCache);
        List<String> targetKeyList = StringUtils.isBlank(targetKeys) ? new ArrayList(8) : (List)JSON.parseObject((String)targetKeys, List.class);
        targetKeyList.add(targetKey);
        this.getView().getPageCache().put(targetKeyCache, JSON.toJSONString(targetKeyList));
    }

    private void deleteFlexCache(Container container, String targetKeyCache) {
        String targetKeys = this.getView().getPageCache().get(targetKeyCache);
        String[] targetKeyArray = StringUtils.isBlank(targetKeys) ? new String[]{} : (String[])JSON.parseObject((String)targetKeys, String[].class);
        container.deleteControls(targetKeyArray);
        this.getView().getPageCache().put(targetKeyCache, "");
    }

    private FlexPanelAp createFlexPanelAp(String key, String parentKey) {
        FlexPanelAp flexPanel = new FlexPanelAp();
        flexPanel.setParentId(parentKey);
        flexPanel.setCollapsible(false);
        flexPanel.setShrink(0);
        flexPanel.setGrow(0);
        flexPanel.setKey(key);
        Style style = new Style();
        Border border = new Border();
        border.setBottom("1px_solid_#d9d9d9");
        border.setTop("1px_solid_#d9d9d9");
        border.setLeft("1px_solid_#d9d9d9");
        border.setRight("1px_solid_#d9d9d9");
        style.setBorder(border);
        flexPanel.setStyle(style);
        return flexPanel;
    }
}

