/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.model.EntryObjectFieldModel;
import kd.imsc.dmw.helper.MultiImpSchemeHelper;

public class MultiImpBaseSchemeTplEdit
extends AbstractFormPlugin
implements IBillPlugin {
    private static final Map<String, String> ENTRY_FIELDS_ID_NAMES = new HashMap<String, String>();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryObjectPropName();
        this.getModel().setDataChanged(false);
    }

    protected void setEntryObjectPropName() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntity) {
            this.setEntryObjectPropName(entry);
            this.setEntrySourceSheet(entry);
        }
        this.getView().updateView("entryentity");
    }

    protected void setEntryObjectPropName(DynamicObject taskEntry) {
        List<EntryObjectFieldModel> entryObjectFields = ENTRY_FIELDS_ID_NAMES.entrySet().stream().map(f -> new EntryObjectFieldModel((String)f.getKey(), (String)f.getValue())).collect(Collectors.toList());
        DynamicObject srcBillEntity = taskEntry.getDynamicObject("billentity");
        String billEntityNumber = srcBillEntity == null ? null : srcBillEntity.getString("target_formid");
        entryObjectFields.forEach(f -> f.setIdValue(taskEntry.getString(f.getIdKey())));
        MultiImpSchemeHelper.setPropFullCaption(billEntityNumber, entryObjectFields);
        for (EntryObjectFieldModel entryField : entryObjectFields) {
            taskEntry.set(entryField.getNameKey(), (Object)entryField.getNameValue());
        }
    }

    protected void setEntrySourceSheet(DynamicObject taskEntry) {
        String sourceSheet = taskEntry.getString("sourcesheet");
        if (StringUtils.isNotEmpty((String)sourceSheet) && sourceSheet.contains(",")) {
            sourceSheet = sourceSheet.replaceAll(",", " ");
            sourceSheet = sourceSheet.trim();
            taskEntry.set("sourcesheetview", (Object)sourceSheet);
        }
    }

    protected DynamicObject getCurrentRowEntry() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (currentRowIndex < 0 || currentRowIndex >= entryEntity.size()) {
            return null;
        }
        return (DynamicObject)entryEntity.get(currentRowIndex);
    }

    public String getStringValue(String key) {
        return this.getStringValue(key, -1);
    }

    public String getStringValue(String key, int i) {
        Object value;
        Object object = value = i > 0 ? this.getValue(key, i) : this.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value instanceof ILocaleString ? ((ILocaleString)value).getLocaleValue() : null;
    }

    public Object getValue(String key, int i) {
        return this.getModel().getValue(key, i);
    }

    public Object getValue(String key) {
        return this.getModel().getValue(key);
    }

    static {
        ENTRY_FIELDS_ID_NAMES.put("replacekeyfield", "replacekeyword");
    }
}

