/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldInfoModel;
import kd.imsc.dmw.engine.multiimport.model.FieldMappingModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTemplateReadInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ViewSchemeMappingInfoModel;
import kd.imsc.dmw.enums.SelectValueEnum;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.DynamicFlexPanelControlProxy;
import kd.imsc.dmw.helper.ImportExcelReadHelper;
import kd.imsc.dmw.helper.TemplateMappingHelper;
import kd.imsc.dmw.plugin.formplugin.multiimport.scheme.AbstractBaseMappingFormPlugin;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;

public class ImportFieldMappingFormPlugin
extends AbstractBaseMappingFormPlugin {
    private static final Log logger = LogFactory.getLog(ImportFieldMappingFormPlugin.class);
    private static final String NODE_ID = "id";
    private static final String NODE_TEXT = "text";
    private static final String NODE_LONGTEXT = "longText";
    private static final String NODE_PARENTID = "parentid";
    private static final String NODE_CHILDREN = "children";
    private static final String NODE_ISOPENED = "isOpened";
    private static final String NODE_LABELPARA = "labelPara";
    private static final String NODE_CHECKABLE = "checkable";
    private static final String NODE_DISABLED = "disabled";
    private static final String NODE_LABELSHOWTYPE = "labelShowType";
    private static final String NODE_LEAF = "leaf";
    private static final String NODE_EXPEND = "expend";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"formuladesc"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        logger.info("ThreadName {}", (Object)Thread.currentThread().getName());
        this.getModel().beginInit();
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        ViewSchemeMappingInfoModel infoModel = this.getSchemeMappingInfoModel();
        this.initFieldWayArea(infoModel);
        String sheet = infoModel == null ? pageCache.get(this.getTargetFormId() + "_sheet") : infoModel.getMulSheets();
        String[] selectSheets = this.getMulSheetNames(sheet);
        List<ComboItem> comboItemList = this.initExcelDocComboItem(selectSheets);
        this.initFormulaTreeNodes(selectSheets);
        this.initFieldMapping(comboItemList, selectSheets);
        String targetFormId = this.getTargetFormId();
        this.initKeyFields(targetFormId);
        this.getModel().endInit();
        pageCache.put(DynamicFlexPanelControlProxy.getFormIdInitEndKey(targetFormId), String.valueOf(true));
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String formulaJson = (String)returnData;
        if (kd.bos.util.StringUtils.isNotEmpty((String)formulaJson)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            if (StringUtil.isEmpty(formula.getExpression())) {
                formulaJson = "";
            }
            this.getModel().setValue("formula", (Object)(formulaJson.length() > 500 ? formulaJson.substring(0, 500) : formulaJson));
            this.getModel().setValue("formula_tag", (Object)formulaJson);
            this.getModel().setValue("formuladesc", (Object)formula.getExprDesc());
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("formuladesc".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_formula");
            IPageCache pageCache = this.getView().getParentView().getPageCache();
            String str = pageCache.get(this.getTargetFormId() + "treenodes");
            showParameter.getCustomParams().put("treenodes", str);
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String formula = (String)this.getModel().getValue("formula_tag", rowIndex);
            if (kd.bos.util.StringUtils.isEmpty((String)formula)) {
                CRFormula crFormula = new CRFormula();
                formula = SerializationUtils.toJsonString((Object)crFormula);
            }
            showParameter.getCustomParams().put("formula", formula);
            String funcsXML = this.getFuncsXML();
            showParameter.getCustomParams().put("functiontypes", funcsXML);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "formuladesc"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.addCustPlugin("kd.bos.ext.imsc.dmw.form.formext.FormulaFormPlugin");
            this.getView().showForm(showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        parentPageCache.put("s_edit", Boolean.toString(true));
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        String newValue = (String)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        String targetFormId = this.getTargetFormId();
        if ("mul_template_sheet_combo".equals(fieldName)) {
            String comboChange = this.getPageCache().get(targetFormId + "_sheet_combos");
            if (String.valueOf(Boolean.FALSE).equals(comboChange)) {
                this.getPageCache().put(targetFormId + "_sheet_combos", String.valueOf(Boolean.TRUE));
                return;
            }
            this.getPageCache().put(targetFormId + "_sheet_combos", String.valueOf(Boolean.TRUE));
            String oldValue = (String)changeData.getOldValue();
            if (kd.bos.util.StringUtils.isEmpty((String)newValue)) {
                parentPageCache.put(targetFormId + "_sheet", newValue);
                this.controlMulSheetVisible(false);
                if (oldValue.startsWith(",")) {
                    oldValue = oldValue.replaceFirst(",", "");
                }
                String[] oldSheets = oldValue.split(",");
                this.resetExcelDocField(null, oldSheets);
                this.initFormulaTreeNodes(null);
                return;
            }
            if (newValue.startsWith(",")) {
                newValue = newValue.replaceFirst(",", "");
            }
            parentPageCache.put(targetFormId + "_sheet", newValue);
            String[] sheets = newValue.split(",");
            this.controlMulSheetVisible(sheets.length > 1);
            this.resetMulSheetReleFields(sheets, oldValue, targetFormId, parentPageCache);
            this.initFormulaTreeNodes(sheets);
            return;
        }
        if ("sheet_rele_combo".equals(fieldName)) {
            parentPageCache.put(targetFormId + "_sheet_rele", newValue);
            return;
        }
        if ("std_import_way".equals(fieldName)) {
            parentPageCache.put(targetFormId + "_import_way", newValue);
            if (kd.bos.util.StringUtils.isEmpty((String)newValue)) {
                this.controlStdImportReleVisible(false);
                return;
            }
            this.controlStdImportReleVisible(!"new".equals(newValue));
            return;
        }
        if ("std_import_rele".equals(fieldName)) {
            if (kd.bos.util.StringUtils.isEmpty((String)newValue)) {
                parentPageCache.put(targetFormId + "_import_rele", null);
                return;
            }
            if (newValue.startsWith(",")) {
                newValue = newValue.replaceFirst(",", "");
            }
            parentPageCache.put(targetFormId + "_import_rele", newValue);
            String[] fieldArray = newValue.split(",");
            if (fieldArray.length > 5) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u9009\u62e9\u4e0d\u80fd\u8d85\u8fc7\u4e94\u4e2a\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u5b57\u6bb5\u3002", (String)"ImportFieldMappingFormPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                this.getModel().setValue("std_import_rele", changeData.getOldValue());
                this.getView().updateView("std_import_rele");
            }
        }
        if ("sheetfield".equals(fieldName)) {
            String excelFieldMapStr = parentPageCache.get(targetFormId + "_excel_field_map");
            Map<String, String> fieldMappingValue = kd.bos.util.StringUtils.isEmpty((String)excelFieldMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)excelFieldMapStr, Map.class);
            String stdField = (String)this.getModel().getValue("stdfieldid", rowIndex);
            fieldMappingValue.put(stdField, newValue);
            parentPageCache.put(targetFormId + "_excel_field_map", JSON.toJSONString(fieldMappingValue));
        } else if ("selectvalue".equals(fieldName) || "formuladesc".equals(fieldName) || "formula".equals(fieldName)) {
            String stdField = (String)this.getModel().getValue("stdfieldid", rowIndex);
            String formuladescMapStr = parentPageCache.get(targetFormId + "_formuladesc_field_map");
            Map formuladescMappingValue = kd.bos.util.StringUtils.isEmpty((String)formuladescMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)formuladescMapStr, Map.class);
            HashMap<String, String> map = new HashMap<String, String>(3);
            String selectValue = (String)this.getModel().getValue("selectvalue", rowIndex);
            map.put("selectvalue", selectValue);
            String formulaDesc = (String)this.getModel().getValue("formuladesc", rowIndex);
            map.put("formuladesc", formulaDesc);
            String formula = (String)this.getModel().getValue("formula", rowIndex);
            map.put("formula", formula);
            String formulaTag = (String)this.getModel().getValue("formula_tag", rowIndex);
            map.put("formula_tag", formulaTag);
            formuladescMappingValue.put(stdField, map);
            parentPageCache.put(targetFormId + "_formuladesc_field_map", JSON.toJSONString(formuladescMappingValue));
            if ("selectvalue".equals(fieldName)) {
                if (SelectValueEnum.FORMULA.getValue().equals(newValue)) {
                    this.getModel().setValue("sheetfield", null, rowIndex);
                } else {
                    this.getModel().setValue("formuladesc", null, rowIndex);
                    this.getModel().setValue("formula", null, rowIndex);
                    this.getModel().setValue("formula_tag", null, rowIndex);
                }
            } else if ("formuladesc".equals(fieldName) && StringUtil.isEmpty(newValue)) {
                this.getModel().setValue("formula", null, rowIndex);
                this.getModel().setValue("formula_tag", null, rowIndex);
            }
        }
    }

    private void initSheetComboItems() {
        List<String> sheetList = this.getSheetNameItems();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(sheetList.size());
        for (String s : sheetList) {
            ComboItem item = new ComboItem(new LocaleString(s), s);
            comboItemList.add(item);
        }
        ComboEdit mulSheetComboField = (ComboEdit)this.getControl("mul_template_sheet_combo");
        mulSheetComboField.setComboItems(comboItemList);
    }

    private ViewSchemeMappingInfoModel getSchemeMappingInfoModel() {
        JSONObject mappingObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("imp_m_info");
        if (mappingObj == null) {
            return null;
        }
        return (ViewSchemeMappingInfoModel)mappingObj.toJavaObject(ViewSchemeMappingInfoModel.class);
    }

    private void initFieldWayArea(ViewSchemeMappingInfoModel infoModel) {
        this.initSheetComboItems();
        if (infoModel != null) {
            String importWay;
            boolean showMulSheetVisible = false;
            this.getModel().setValue("mul_template_sheet_combo", (Object)infoModel.getMulSheets());
            boolean isMulSheets = false;
            if (infoModel.getMulSheets().startsWith(",")) {
                infoModel.setMulSheets(infoModel.getMulSheets().replaceFirst(",", ""));
                isMulSheets = infoModel.getMulSheets().split(",").length > 1;
            }
            showMulSheetVisible = infoModel.getSheetReleValue() != null && isMulSheets;
            this.controlMulSheetVisible(showMulSheetVisible);
            if (showMulSheetVisible && kd.bos.util.StringUtils.isNotEmpty((String)infoModel.getSheetReleValue())) {
                this.initMulSheetReleFields(this.getMulSheetNames(infoModel.getMulSheets()));
                this.getModel().setValue("sheet_rele_combo", (Object)infoModel.getSheetReleValue());
            }
            boolean showImportReleVisible = !"new".equals(importWay = infoModel.getImportWay());
            this.controlStdImportReleVisible(showImportReleVisible);
            if (showImportReleVisible) {
                this.getModel().setValue("std_import_rele", (Object)infoModel.getKeyFields());
            }
            this.getModel().setValue("std_import_way", (Object)importWay);
        } else {
            String targetFormId = this.getTargetFormId();
            IPageCache pageCache = this.getView().getParentView().getPageCache();
            this.initCacheSheet(targetFormId, pageCache);
            String cacheImportWay = pageCache.get(targetFormId + "_import_way");
            String cacheImportRele = pageCache.get(targetFormId + "_import_rele");
            if (kd.bos.util.StringUtils.isNotEmpty((String)cacheImportWay)) {
                this.getModel().setValue("std_import_way", (Object)cacheImportWay);
                this.getModel().setValue("std_import_rele", (Object)cacheImportRele);
                this.getView().setVisible(Boolean.valueOf(!"new".equals(cacheImportWay)), new String[]{"std_import_rele"});
                return;
            }
            DynamicObject dyDefault = TemplateMappingHelper.getImportTargetDyByFormId(this.getTargetFormId());
            if (dyDefault == null) {
                return;
            }
            String importWay = dyDefault.getString("importway");
            this.getModel().setValue("std_import_way", (Object)importWay);
            String keyFields = dyDefault.getString("mulreplacefield");
            this.getView().setVisible(Boolean.valueOf(!keyFields.isEmpty()), new String[]{"std_import_rele"});
            this.getModel().setValue("std_import_rele", (Object)(kd.bos.util.StringUtils.isEmpty((String)keyFields) ? null : keyFields));
            pageCache.put(targetFormId + "_import_way", importWay);
            pageCache.put(targetFormId + "_import_rele", kd.bos.util.StringUtils.isEmpty((String)keyFields) ? null : keyFields);
        }
    }

    private void initCacheSheet(String targetFormId, IPageCache pageCache) {
        boolean showMulSheetVisible = false;
        List<String> sheetNameItems = this.getSheetNameItems();
        String cacheSheet = pageCache.get(targetFormId + "_sheet");
        Object cacheSheetRele = pageCache.get(targetFormId + "_sheet_rele");
        if (kd.bos.util.StringUtils.isEmpty((String)cacheSheet)) {
            this.controlMulSheetVisible(false);
            return;
        }
        List sheetList = Arrays.stream(cacheSheet.split(",")).filter(sheetNameItems::contains).collect(Collectors.toList());
        if (!sheetList.isEmpty()) {
            List<String> sameFields;
            cacheSheet = String.join((CharSequence)",", sheetList) + ",";
            boolean bl = showMulSheetVisible = sheetList.size() > 1;
            cacheSheetRele = showMulSheetVisible ? ((sameFields = this.initMulSheetReleFields(this.getMulSheetNames(cacheSheet))).isEmpty() ? null : (sameFields.contains(cacheSheetRele) ? cacheSheetRele : sameFields.get(0))) : null;
        } else {
            cacheSheet = null;
            cacheSheetRele = null;
        }
        pageCache.put(targetFormId + "_sheet", cacheSheet);
        this.getModel().setValue("mul_template_sheet_combo", (Object)cacheSheet);
        pageCache.put(targetFormId + "_sheet_rele", (String)cacheSheetRele);
        this.getModel().setValue("sheet_rele_combo", cacheSheetRele);
        this.controlMulSheetVisible(showMulSheetVisible);
    }

    private void getExcelField(String[] sheets, List<String> excelFields, Map<String, String> formualFieldMap) {
        Map formuladescMappingValue;
        String targetFormId = this.getTargetFormId();
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String excelFieldMapStr = pageCache.get(targetFormId + "_excel_field_map");
        Map fieldMappingValue = kd.bos.util.StringUtils.isEmpty((String)excelFieldMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)excelFieldMapStr, Map.class);
        String formuladescMapStr = pageCache.get(targetFormId + "_formuladesc_field_map");
        Map map = formuladescMappingValue = kd.bos.util.StringUtils.isEmpty((String)formuladescMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)formuladescMapStr, Map.class);
        if (!fieldMappingValue.isEmpty() || !formuladescMappingValue.isEmpty()) {
            ImportTemplateReadInfoModel templateInfoModel = this.getTemplateInfoModel();
            if (templateInfoModel == null) {
                return;
            }
            boolean isMulSheet = sheets.length > 1;
            for (String sheet : sheets) {
                List<ExcelFieldInfoModel> infoModels = templateInfoModel.getSheetTemplateMap().get(sheet);
                if (infoModels == null || infoModels.isEmpty()) continue;
                for (ExcelFieldInfoModel infoModel : infoModels) {
                    String excelField = !isMulSheet ? infoModel.getValue() : sheet + "." + infoModel.getValue();
                    excelFields.add(excelField);
                    formualFieldMap.put(String.join((CharSequence)".", infoModel.getSheetNumber(), infoModel.getColumnLetter()), infoModel.getValue());
                }
            }
        }
    }

    private Set<String> createFieldMappingEntry(List<FieldMappingModel> stdFieldList, List<String> excelFields, Map<String, String> formualFieldMap, List<String> clearFieldList) {
        String selectValue = null;
        String formulaDesc = null;
        String formulaJson = null;
        String formulaJsonTag = null;
        String excelField = null;
        HashSet<String> unChangeStdFieldSet = new HashSet<String>(16);
        String targetFormId = this.getTargetFormId();
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String excelFieldMapStr = pageCache.get(targetFormId + "_excel_field_map");
        Map<String, String> fieldMappingValue = kd.bos.util.StringUtils.isEmpty((String)excelFieldMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)excelFieldMapStr, Map.class);
        String formuladescMapStr = pageCache.get(targetFormId + "_formuladesc_field_map");
        Map<String, Map> formuladescMappingValue = kd.bos.util.StringUtils.isEmpty((String)formuladescMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)formuladescMapStr, Map.class);
        DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (FieldMappingModel model : stdFieldList) {
            DynamicObject dynamicObject = collection.addNew();
            dynamicObject.set("stdfieldid", (Object)model.getStdFieldId());
            dynamicObject.set("stdpartname", (Object)model.getStdPartName());
            dynamicObject.set("stdfieldname", (Object)model.getStdFieldName());
            dynamicObject.set("stdfieldrequired", (Object)(!model.isNull() ? null : "1"));
            dynamicObject.set("billhead", (Object)model.isPartHead());
            excelField = null;
            if (!fieldMappingValue.isEmpty()) {
                String cacheExcelField = (String)fieldMappingValue.get(model.getStdFieldId());
                if (excelFields.contains(cacheExcelField)) {
                    excelField = cacheExcelField;
                    unChangeStdFieldSet.add(model.getStdFieldId());
                } else if (clearFieldList.size() < 11 && StringUtil.isNotEmpty(cacheExcelField)) {
                    clearFieldList.add(dynamicObject.getString("stdfieldname"));
                }
                fieldMappingValue.put(model.getStdFieldId(), excelField);
            }
            dynamicObject.set("sheetfield", excelField);
            selectValue = SelectValueEnum.SOURCEFIELD.getValue();
            formulaDesc = null;
            formulaJson = null;
            formulaJsonTag = null;
            Map map = (Map)formuladescMappingValue.get(model.getStdFieldId());
            if (!CommonUtils.isNull(map)) {
                selectValue = (String)map.get("selectvalue");
                formulaDesc = (String)map.get("formuladesc");
                formulaJson = (String)map.get("formula");
                formulaJsonTag = (String)map.get("formula_tag");
                unChangeStdFieldSet.add(model.getStdFieldId());
                String formulaFieldDesc = (String)map.get("formuladesc");
                String formulaFieldDescTag = (String)map.get("formula_tag");
                if (StringUtil.isNotEmpty(formulaFieldDesc) && StringUtil.isNotEmpty(formulaFieldDescTag)) {
                    CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)formulaFieldDescTag, CRFormula.class);
                    String[] fieldStrings = FormulaEngine.extractVariables((String)crFormula.getExpression());
                    boolean isContain = true;
                    for (String fieldStr : fieldStrings) {
                        if (formualFieldMap.containsKey(fieldStr) && formulaFieldDesc.indexOf(formualFieldMap.get(fieldStr)) >= 0) continue;
                        isContain = false;
                        break;
                    }
                    if (isContain) {
                        isContain = formulaFieldDesc.equals(this.tranExpression(crFormula.getExpression()));
                    }
                    if (!isContain) {
                        selectValue = SelectValueEnum.SOURCEFIELD.getValue();
                        formulaDesc = null;
                        formulaJson = null;
                        formulaJsonTag = null;
                        unChangeStdFieldSet.remove(model.getStdFieldId());
                        if (clearFieldList.size() < 11) {
                            clearFieldList.add(dynamicObject.getString("stdfieldname"));
                        }
                    }
                }
                map.put("selectvalue", selectValue);
                map.put("formuladesc", formulaDesc);
                map.put("formula", formulaJson);
                map.put("formula_tag", formulaJsonTag);
                formuladescMappingValue.put(model.getStdFieldId(), map);
            }
            dynamicObject.set("selectvalue", (Object)selectValue);
            dynamicObject.set("formuladesc", formulaDesc);
            dynamicObject.set("formula", formulaJson);
            dynamicObject.set("formula_tag", formulaJsonTag);
        }
        pageCache.put(targetFormId + "_excel_field_map", JSON.toJSONString(fieldMappingValue));
        pageCache.put(targetFormId + "_formuladesc_field_map", JSON.toJSONString(formuladescMappingValue));
        return unChangeStdFieldSet;
    }

    private void initFieldMapping(List<ComboItem> comboItemList, String[] sheets) {
        try {
            String targetFormId = this.getTargetFormId();
            List<FieldMappingModel> stdFieldList = TemplateMappingHelper.getStdTemplateFieldList(targetFormId, this.getTargetFormName());
            if (stdFieldList == null || stdFieldList.isEmpty()) {
                return;
            }
            ArrayList<String> excelFields = new ArrayList<String>(16);
            HashMap<String, String> formualFieldMap = new HashMap<String, String>(16);
            this.getExcelField(sheets, excelFields, formualFieldMap);
            ArrayList<String> clearFieldList = new ArrayList<String>(16);
            Set<String> unChangeStdFieldSet = this.createFieldMappingEntry(stdFieldList, excelFields, formualFieldMap, clearFieldList);
            String msg = "";
            if (!clearFieldList.isEmpty()) {
                if (clearFieldList.size() > 10) {
                    clearFieldList.remove(10);
                    msg = ResManager.loadKDString((String)"\u56e0\u6a21\u677f\u6570\u636e\u53d8\u5316\uff0c\u5df2\u6e05\u7a7a%s\u7b49\u5b57\u6bb5\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ImportFieldMappingFormPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                } else {
                    msg = ResManager.loadKDString((String)"\u56e0\u6a21\u677f\u6570\u636e\u53d8\u5316\uff0c\u5df2\u6e05\u7a7a%s\u5b57\u6bb5\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ImportFieldMappingFormPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                }
                msg = String.format(msg, StringUtils.join((Object[])clearFieldList.toArray(), (char)'\uff0c'));
            }
            this.autoMappingStdDiyField(comboItemList, unChangeStdFieldSet, msg);
        }
        catch (DmwImptException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void initKeyFields(String targetFormId) {
        List<FieldMappingModel> keyFieldLost = TemplateMappingHelper.getFormFieldsMapping(targetFormId);
        if (keyFieldLost == null || keyFieldLost.isEmpty()) {
            return;
        }
        ArrayList<ComboItem> dataReplaceComboList = new ArrayList<ComboItem>(keyFieldLost.size());
        for (FieldMappingModel model : keyFieldLost) {
            dataReplaceComboList.add(new ComboItem(new LocaleString(model.getStdFieldName()), model.getStdFieldId()));
        }
        ComboEdit mulSheetComboField = (ComboEdit)this.getControl("std_import_rele");
        mulSheetComboField.setComboItems(dataReplaceComboList);
    }

    private String[] getMulSheetNames(String sheetNames) {
        if (sheetNames == null || kd.bos.util.StringUtils.isEmpty((String)sheetNames)) {
            return new String[0];
        }
        if (sheetNames.startsWith(",")) {
            sheetNames = sheetNames.replaceFirst(",", "");
        }
        return sheetNames.split(",");
    }

    private Set<String> getUnChangeStdFieldSet(List<String> unChangeSheetList, String[] oldSheets) {
        ImportTemplateReadInfoModel templateInfoModel;
        HashSet<String> unChangeStdFieldSet = new HashSet<String>(16);
        if (!unChangeSheetList.isEmpty() && (templateInfoModel = this.getTemplateInfoModel()) != null) {
            String targetFormId = this.getTargetFormId();
            IPageCache pageCache = this.getView().getParentView().getPageCache();
            String formuladescMapStr = pageCache.get(targetFormId + "_formuladesc_field_map");
            Map formuladescMappingValue = kd.bos.util.StringUtils.isEmpty((String)formuladescMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)formuladescMapStr, Map.class);
            ArrayList<String> excelFields = new ArrayList<String>(16);
            HashMap<String, String> formualFieldMap = new HashMap<String, String>(16);
            this.getExcelField(unChangeSheetList.toArray(new String[unChangeSheetList.size()]), excelFields, formualFieldMap);
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            for (String sheetName : unChangeSheetList) {
                List<ExcelFieldInfoModel> infoModels = templateInfoModel.getSheetTemplateMap().get(sheetName);
                if (infoModels == null || infoModels.isEmpty()) continue;
                boolean oldMulSelect = oldSheets != null && oldSheets.length > 1;
                for (DynamicObject fieldDyObj : collection) {
                    Map map;
                    String matchValue = oldMulSelect || oldSheets == null ? fieldDyObj.getString("sheetfield") : String.join((CharSequence)".", oldSheets[0], fieldDyObj.getString("sheetfield"));
                    long count = infoModels.stream().filter(o -> String.join((CharSequence)".", sheetName, o.getValue()).equals(matchValue)).count();
                    if (count > 0L) {
                        unChangeStdFieldSet.add(fieldDyObj.getString("stdfieldid"));
                    }
                    if (CommonUtils.isNull(map = (Map)formuladescMappingValue.get(fieldDyObj.getString("stdfieldid")))) continue;
                    String formulaFieldDesc = (String)map.get("formuladesc");
                    String formulaFieldDescTag = (String)map.get("formula_tag");
                    if (!StringUtil.isNotEmpty(formulaFieldDesc) || !StringUtil.isNotEmpty(formulaFieldDescTag)) continue;
                    CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)((String)map.get("formula_tag")), CRFormula.class);
                    String[] fieldStrings = FormulaEngine.extractVariables((String)crFormula.getExpression());
                    boolean isContain = true;
                    for (String fieldStr : fieldStrings) {
                        if (formualFieldMap.containsKey(fieldStr) && formulaFieldDesc.indexOf((String)formualFieldMap.get(fieldStr)) >= 0) continue;
                        isContain = false;
                        break;
                    }
                    if (isContain) {
                        isContain = formulaFieldDesc.equals(this.tranExpression(crFormula.getExpression()));
                    }
                    if (!isContain) continue;
                    unChangeStdFieldSet.add(fieldDyObj.getString("stdfieldid"));
                }
            }
        }
        return unChangeStdFieldSet;
    }

    private void resetExcelDocField(String[] newSheets, String[] oldSheets) {
        List<ComboItem> comboItemList = this.initExcelDocComboItem(newSheets);
        ArrayList<String> unChangeSheetList = new ArrayList<String>(16);
        ArrayList<String> deleteSheetList = new ArrayList<String>(16);
        if (!CommonUtils.isNull(newSheets) && !CommonUtils.isNull(oldSheets)) {
            ArrayList<String> oldSheetList = new ArrayList<String>(Arrays.asList(oldSheets));
            for (String newSheet : newSheets) {
                if (!oldSheetList.contains(newSheet)) continue;
                unChangeSheetList.add(newSheet);
                oldSheetList.remove(newSheet);
            }
            deleteSheetList.addAll(oldSheetList);
        }
        if (CommonUtils.isNull(newSheets)) {
            deleteSheetList.addAll(Arrays.asList(oldSheets));
        }
        Set<String> unChangeStdFieldSet = this.getUnChangeStdFieldSet(unChangeSheetList, oldSheets);
        String msg = this.getClearFieldMsg(deleteSheetList.toArray(new String[deleteSheetList.size()]));
        this.autoMappingStdDiyField(comboItemList, unChangeStdFieldSet, msg);
        this.editSheetField(unChangeSheetList, newSheets, oldSheets);
    }

    private String getClearFieldMsg(String[] deleteSheets) {
        String msg = "";
        if (CommonUtils.isNull(deleteSheets)) {
            return msg;
        }
        String targetFormId = this.getTargetFormId();
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String excelFieldMapStr = pageCache.get(targetFormId + "_excel_field_map");
        Map fieldMappingValue = kd.bos.util.StringUtils.isEmpty((String)excelFieldMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)excelFieldMapStr, Map.class);
        ArrayList<String> clearFieldList = new ArrayList<String>(16);
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        Map<String, String> stdFieldMap = collection.stream().collect(Collectors.toMap(o -> o.getString("stdfieldid"), o -> o.getString("stdfieldname"), (v1, v2) -> v1));
        String formuladescMapStr = pageCache.get(targetFormId + "_formuladesc_field_map");
        Map formuladescMappingValue = kd.bos.util.StringUtils.isEmpty((String)formuladescMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)formuladescMapStr, Map.class);
        ImportTemplateReadInfoModel templateInfoModel = this.getTemplateInfoModel();
        boolean msgFlag = false;
        if (templateInfoModel != null) {
            block0: for (String sheet : deleteSheets) {
                List<ExcelFieldInfoModel> infoModels = templateInfoModel.getSheetTemplateMap().get(sheet);
                if (infoModels == null || infoModels.isEmpty()) continue;
                for (ExcelFieldInfoModel infoModel : infoModels) {
                    String excelField = infoModel.getValue();
                    if (clearFieldList.size() >= 10) {
                        msgFlag = true;
                        continue block0;
                    }
                    for (Map.Entry mapEntry : fieldMappingValue.entrySet()) {
                        if (!StringUtil.isNotEmpty((String)mapEntry.getValue())) continue;
                        String[] valueStrs = ((String)mapEntry.getValue()).split("\\.");
                        if (valueStrs.length > 1) {
                            excelField = String.join((CharSequence)".", sheet, infoModel.getValue());
                        }
                        if (!((String)mapEntry.getValue()).equals(excelField)) continue;
                        clearFieldList.add(stdFieldMap.get(mapEntry.getKey()));
                    }
                    for (Map.Entry mapEntry : formuladescMappingValue.entrySet()) {
                        long count;
                        Map foumualMap = (Map)mapEntry.getValue();
                        if (CommonUtils.isNull(foumualMap) || (count = foumualMap.values().stream().filter(o -> o.contains(String.join((CharSequence)".", infoModel.getSheetNumber(), infoModel.getColumnLetter()))).count()) <= 0L) continue;
                        clearFieldList.add(stdFieldMap.get(mapEntry.getKey()));
                    }
                }
            }
        }
        if (!clearFieldList.isEmpty()) {
            msg = msgFlag ? ResManager.loadKDString((String)"\u56e0\u6a21\u677f\u6570\u636e\u53d8\u5316\uff0c\u5df2\u6e05\u7a7a%s\u7b49\u5b57\u6bb5\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ImportFieldMappingFormPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u56e0\u6a21\u677f\u6570\u636e\u53d8\u5316\uff0c\u5df2\u6e05\u7a7a%s\u5b57\u6bb5\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ImportFieldMappingFormPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            msg = String.format(msg, StringUtils.join((Object[])clearFieldList.toArray(), (char)'\uff0c'));
        }
        return msg;
    }

    private void editSheetField(List<String> unChangeSheetList, String[] newSheets, String[] oldSheets) {
        block3: {
            block2: {
                if (unChangeSheetList.isEmpty() || newSheets == null || newSheets.length != 1) break block2;
                DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject fieldDyObj : collection) {
                    String sheetField = fieldDyObj.getString("sheetfield");
                    if (!StringUtil.isNotEmpty(sheetField) || !sheetField.contains(".")) continue;
                    String value = sheetField.substring(sheetField.indexOf(46) + 1);
                    this.getModel().setValue("sheetfield", (Object)value, fieldDyObj.getInt("seq") - 1);
                }
                break block3;
            }
            if (newSheets == null || newSheets.length <= 1 || oldSheets == null || oldSheets.length != 1) break block3;
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject fieldDyObj : collection) {
                String sheetField = fieldDyObj.getString("sheetfield");
                if (!StringUtil.isNotEmpty(sheetField) || sheetField.contains(".")) continue;
                this.getModel().setValue("sheetfield", (Object)String.join((CharSequence)".", oldSheets[0], fieldDyObj.getString("sheetfield")), fieldDyObj.getInt("seq") - 1);
            }
        }
    }

    private List<ComboItem> initExcelDocComboItem(String[] sheets) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
        ComboEdit sheetFieldControl = (ComboEdit)this.getControl("sheetfield");
        if (sheets == null || sheets.length == 0) {
            sheetFieldControl.setComboItems(new ArrayList());
            this.clearAutoMappingStdDiyField();
            return comboItemList;
        }
        boolean isMulSheet = sheets.length > 1;
        ImportTemplateReadInfoModel templateInfoModel = this.getTemplateInfoModel();
        if (templateInfoModel == null || this.getModel().getValue("mul_template_sheet_combo") == null) {
            this.clearAutoMappingStdDiyField();
            return comboItemList;
        }
        for (String sheet : sheets) {
            List<ExcelFieldInfoModel> infoModels = templateInfoModel.getSheetTemplateMap().get(sheet);
            if (infoModels == null || infoModels.isEmpty()) continue;
            for (ExcelFieldInfoModel infoModel : infoModels) {
                String comboValue = !isMulSheet ? infoModel.getValue() : sheet + "." + infoModel.getValue();
                ComboItem item = new ComboItem(new LocaleString(comboValue), comboValue);
                comboItemList.add(item);
            }
        }
        sheetFieldControl.setComboItems(comboItemList);
        return comboItemList;
    }

    private JSONObject createNodeJsonObj(String nodeId, String parentId, String nodeText, boolean isOpened) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(NODE_ID, (Object)nodeId);
        jsonObj.put(NODE_TEXT, (Object)nodeText);
        jsonObj.put(NODE_LONGTEXT, (Object)nodeText);
        jsonObj.put(NODE_PARENTID, (Object)parentId);
        jsonObj.put(NODE_ISOPENED, (Object)isOpened);
        jsonObj.put(NODE_LABELPARA, (Object)new JSONArray(0));
        jsonObj.put(NODE_CHECKABLE, (Object)false);
        jsonObj.put(NODE_DISABLED, (Object)false);
        jsonObj.put(NODE_LABELSHOWTYPE, (Object)0);
        jsonObj.put(NODE_LEAF, (Object)false);
        jsonObj.put(NODE_EXPEND, (Object)false);
        return jsonObj;
    }

    private void initFormulaTreeNodes(String[] selectSheets) {
        int index = 0;
        ImportTemplateReadInfoModel templateInfoModel = this.getTemplateInfoModel();
        String nodeText = ResManager.loadKDString((String)"\u6587\u6863", (String)"ImportFieldMappingFormPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        String rootNodeId = "billhead";
        JSONObject rootNode = this.createNodeJsonObj(rootNodeId, "", nodeText, true);
        if (selectSheets != null && selectSheets.length > 0) {
            JSONArray childrenNodes = new JSONArray(selectSheets.length);
            rootNode.put(NODE_CHILDREN, (Object)childrenNodes);
            List<String> sheetList = this.getSheetNameItems();
            List<String> selectSheetList = Arrays.asList(selectSheets);
            for (String sheetName : sheetList) {
                ++index;
                if (!selectSheetList.contains(sheetName)) continue;
                String nodeId = "S" + index;
                JSONObject subNode = this.createNodeJsonObj(nodeId, rootNodeId, sheetName, true);
                childrenNodes.add((Object)subNode);
                List<ExcelFieldInfoModel> infoModels = templateInfoModel.getSheetTemplateMap().get(sheetName);
                if (infoModels == null || infoModels.isEmpty()) continue;
                JSONArray childrenNodes2 = new JSONArray(infoModels.size());
                subNode.put(NODE_CHILDREN, (Object)childrenNodes2);
                for (ExcelFieldInfoModel infoModel : infoModels) {
                    JSONObject subNode2 = this.createNodeJsonObj(String.join((CharSequence)".", nodeId, infoModel.getColumnLetter()), nodeId, infoModel.getValue(), false);
                    childrenNodes2.add((Object)subNode2);
                }
            }
        }
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        pageCache.put(this.getTargetFormId() + "treenodes", JSON.toJSONString((Object)rootNode));
    }

    private void autoMappingStdDiyField(List<ComboItem> comboItemList, Set<String> unChangeStdFieldSet, String msg) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        String targetName = this.getTargetFormName();
        List<String> mulSheetNameList = Arrays.asList(this.getMulSheetNames((String)this.getModel().getValue("mul_template_sheet_combo")));
        boolean auto = TemplateMappingHelper.autoInvokeKeyFieldMapping(collection, comboItemList, mulSheetNameList, targetName, unChangeStdFieldSet);
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        if (auto) {
            String targetFormId = this.getTargetFormId();
            String excelFieldMapStr = pageCache.get(targetFormId + "_excel_field_map");
            Map fieldMappingValue = kd.bos.util.StringUtils.isEmpty((String)excelFieldMapStr) ? new HashMap(16) : (Map)JSON.parseObject((String)excelFieldMapStr, Map.class);
            collection.forEach(entry -> fieldMappingValue.put(entry.getString("stdfieldid"), entry.getString("sheetfield")));
            pageCache.put(targetFormId + "_excel_field_map", JSON.toJSONString(fieldMappingValue));
            List mappedEntrys = collection.stream().filter(entry -> kd.bos.util.StringUtils.isNotEmpty((String)entry.getString("sheetfield"))).collect(Collectors.toList());
            if (!mappedEntrys.isEmpty()) {
                msg = String.join((CharSequence)" ", msg, ResManager.loadKDString((String)"\u5df2\u6839\u636e\u6587\u6863Sheet\u9875\u7b7e\u4e2d\u5217\u540d\u81ea\u52a8\u5339\u914d\u5bf9\u8c61\u4e2d\u4e3a\u7a7a\u5b57\u6bb5\u3002", (String)"ImportFieldMappingFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
        }
        if (StringUtil.isNotEmpty(msg)) {
            pageCache.put("s_edit", Boolean.toString(true));
            this.getView().showTipNotification(msg);
        }
        this.getView().updateView("entryentity");
    }

    private void clearAutoMappingStdDiyField() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (DynamicObject fieldDyObj : collection) {
            fieldDyObj.set("sheetfield", null);
            fieldDyObj.set("selectvalue", (Object)SelectValueEnum.SOURCEFIELD.getValue());
            fieldDyObj.set("formuladesc", null);
            fieldDyObj.set("formula", null);
            fieldDyObj.set("formula_tag", null);
        }
        this.getView().updateView("entryentity");
    }

    private void resetMulSheetReleFields(String[] sheets, String oldValue, String targetFormId, IPageCache parentPageCache) {
        List<String> oldSameFields;
        String[] oldSheets = new String[4];
        if (StringUtil.isNotEmpty(oldValue)) {
            if (oldValue.startsWith(",")) {
                oldValue = oldValue.replaceFirst(",", "");
            }
            oldSheets = oldValue.split(",");
        }
        if (sheets == null || sheets.length <= 1) {
            this.getModel().setValue("sheet_rele_combo", null);
            this.resetExcelDocField(sheets, oldSheets);
            return;
        }
        ImportTemplateReadInfoModel templateInfoModel = this.getTemplateInfoModel();
        if (templateInfoModel == null) {
            return;
        }
        List<String> sameFields = this.getSameFields(sheets, templateInfoModel);
        if (sameFields.isEmpty() && !(oldSameFields = this.getSameFields(oldSheets, templateInfoModel)).isEmpty()) {
            this.getPageCache().put(targetFormId + "_sheet_combos", String.valueOf(Boolean.FALSE));
            this.getModel().setValue("mul_template_sheet_combo", (Object)oldValue);
            this.controlMulSheetVisible(oldSheets.length > 1);
            parentPageCache.put(targetFormId + "_sheet", oldValue);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u591a\u9875\u7b7e\u65e0\u76f8\u540c\u5173\u8054\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"ImportFieldMappingFormPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(sameFields.size());
        for (String sameField : sameFields) {
            ComboItem item = new ComboItem(new LocaleString(sameField), sameField);
            comboItemList.add(item);
        }
        ComboEdit mulSheetComboField = (ComboEdit)this.getControl("sheet_rele_combo");
        mulSheetComboField.setComboItems(comboItemList);
        this.getModel().setValue("sheet_rele_combo", comboItemList.isEmpty() ? null : ((ComboItem)comboItemList.get(0)).getValue());
        this.resetExcelDocField(sheets, oldSheets);
    }

    private List<String> getSameFields(String[] sheets, ImportTemplateReadInfoModel templateInfoModel) {
        ArrayList<String> sameFields = new ArrayList<String>();
        for (int i = 0; i < sheets.length; ++i) {
            List<ExcelFieldInfoModel> infoModels = templateInfoModel.getSheetTemplateMap().get(sheets[i]);
            List<String> fields = ImportExcelReadHelper.mapFields(infoModels);
            if (i == 0) {
                sameFields.addAll(fields);
                continue;
            }
            List<String> sameFieldList = ImportExcelReadHelper.getSameElements(sameFields, fields);
            sameFields.clear();
            if (sameFieldList == null) continue;
            sameFields.addAll(sameFieldList);
        }
        return sameFields;
    }

    private List<String> initMulSheetReleFields(String[] sheets) {
        ArrayList<String> sameFields = new ArrayList<String>(16);
        if (sheets == null || sheets.length <= 1) {
            return sameFields;
        }
        ImportTemplateReadInfoModel templateInfoModel = this.getTemplateInfoModel();
        if (templateInfoModel == null) {
            return sameFields;
        }
        for (int i = 0; i < sheets.length; ++i) {
            List<ExcelFieldInfoModel> infoModels = templateInfoModel.getSheetTemplateMap().get(sheets[i]);
            List<String> fields = ImportExcelReadHelper.mapFields(infoModels);
            if (i == 0) {
                sameFields.addAll(fields);
                continue;
            }
            List<String> sameFieldList = ImportExcelReadHelper.getSameElements(sameFields, fields);
            sameFields.clear();
            if (sameFieldList == null) continue;
            sameFields.addAll(sameFieldList);
        }
        if (sameFields.isEmpty()) {
            return sameFields;
        }
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(sameFields.size());
        for (String sameField : sameFields) {
            ComboItem item = new ComboItem(new LocaleString(sameField), sameField);
            comboItemList.add(item);
        }
        ComboEdit mulSheetComboField = (ComboEdit)this.getControl("sheet_rele_combo");
        mulSheetComboField.setComboItems(comboItemList);
        return sameFields;
    }

    private void controlMulSheetVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"sheet_rele_combo"});
    }

    private void controlStdImportReleVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"std_import_rele"});
        if (!visible) {
            this.getModel().setValue("std_import_rele", null);
        }
    }

    private String getFuncsXML() {
        String funcsXML = this.getPageCache().get("functiontypes");
        if (kd.bos.util.StringUtils.isEmpty((String)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            FunctionTypes cloudFunc = ConvertFuncLoader.loadBizCloudFuncTypes();
            functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(cloudFunc.getFunctionTypes());
        }
        return funcsXML;
    }

    private String tranExpression(String expression) {
        if (kd.bos.util.StringUtils.isBlank((String)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || kd.bos.util.StringUtils.isBlank((String)vars[0])) {
            return expressionDesc;
        }
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String json = pageCache.get(this.getTargetFormId() + "treenodes");
        TreeNode rootNode = new TreeNode();
        if (kd.bos.util.StringUtils.isNotEmpty((String)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        List<String> orderVars = Arrays.asList(vars);
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }
}

