/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.scheme;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.property.WizardPlugin;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.model.BizOperationResult;
import kd.imsc.dmw.engine.multiimport.model.ImportTargetSchemeInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTemplateReadInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ViewSchemeBaseInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ViewSchemeMappingInfoModel;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.DynamicFlexPanelControlProxy;
import kd.imsc.dmw.helper.MulImportCheckerProxy;
import kd.imsc.dmw.helper.MultiImpSchemeHelper;
import kd.imsc.dmw.helper.PermissionHelper;
import kd.imsc.dmw.helper.SchemeDataPackageTransHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;

public class ImportSchemeGuideFormPlugin
extends WizardPlugin
implements TabSelectListener,
UploadListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ImportSchemeGuideFormPlugin.class);
    private static final String GUIDE = "guidecontent";
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_PRE = "btnprev";
    private static final String BTN_NEXT = "btnnext";
    private static final String BTN_FINISH = "btnfinish";
    private static final String TABPAGEAP1 = "tabpageap1";
    private static final String WIZARDAP = "wizardap";
    private static final String MAPPING_AREA = "flexmappingarea";
    private static final String FIELD_MAPPING_FORM_ID = "dmw_schemefieldmapping";
    private static final String FIELD_LABEL_FORM_ID = "dmw_importlabel";
    private static final String CONTROL_CACHE_KEY = "c_ks";
    private static final String PAGE_CACHE_KEY = "p_ks";
    private static final String TEMPLATE_CACHE_KEY = "t_ks";
    private static final String URL_CACHE_KEY = "u_ks";
    public static final String SCHEME_CHANGE = "s_edit";
    private static final String TEM_CHANGE = "t_change";
    private static final String SCHEME_NAME = "billname";
    private static final String SCHEME_ATTACHMENT = "scheme_attachment";
    private static final String TARGETOBJS = "targetobjs";
    private static final String IPTM_SCHEME = "dmw_impscheme";
    private static final String ALERT_CALLBACK = "d_a_c";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String parentFormId = e.getFormShowParameter().getParentFormId();
        if (StringUtils.isEmpty((String)parentFormId)) {
            e.setCancel(true);
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(GUIDE);
        tab.addTabSelectListener((TabSelectListener)this);
        AttachmentPanel attachControl = (AttachmentPanel)this.getControl(SCHEME_ATTACHMENT);
        attachControl.addUploadListener((UploadListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl(TARGETOBJS);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_FINISH, BTN_CANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.changeNextBtnVisible(true);
        this.changePreBtnVisible(false);
        int status = this.getView().getFormShowParameter().getStatusValue();
        OperationStatus operationStatus = OperationStatus.forValue((int)status);
        logger.info("afterCreateNewData status {}", (Object)operationStatus);
        this.initSchemeGuideBaseInfo();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        logger.info("tabSelected {}", (Object)tabSelectEvent.getTabKey());
        if (TABPAGEAP1.equals(tabSelectEvent.getTabKey())) {
            String templateInfo = this.readCache(TEMPLATE_CACHE_KEY);
            if (StringUtils.isEmpty((String)templateInfo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5b8c\u6210\u6a21\u677f\u4e0a\u4f20!", (String)"ImportSchemeGuideFormPlugin_9", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            ImportTemplateReadInfoModel infoModel = (ImportTemplateReadInfoModel)JSON.parseObject((String)templateInfo, ImportTemplateReadInfoModel.class);
            if (infoModel == null || infoModel.getSheetTemplateMap() == null || CollectionUtils.isEmpty(infoModel.getSheetTemplateMap().keySet())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6a21\u677f\u662f\u5426\u6b63\u786e!", (String)"ImportSchemeGuideFormPlugin_10", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            this.initImportSchemeDataArea(this.getTargetCollection(), infoModel);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        Tab tab = (Tab)this.getControl(GUIDE);
        String currentTab = tab.getCurrentTab();
        logger.info("currentTab {}", (Object)currentTab);
        if (key.equals(BTN_NEXT)) {
            try {
                this.checkSchemeBaseInfoFinish();
                this.next();
                this.changeNextBtnVisible(false);
                this.changePreBtnVisible(true);
            }
            catch (DmwImptException e) {
                this.getView().showTipNotification(e.getMessage());
            }
            return;
        }
        if (key.equals(BTN_PRE)) {
            this.previous();
            this.changeNextBtnVisible(true);
            this.changePreBtnVisible(false);
            return;
        }
        if (key.equals(BTN_CANCEL)) {
            this.getView().close();
            return;
        }
        if (BTN_FINISH.equals(key)) {
            List<ImportTargetSchemeInfoModel> infoModelList = this.getSchemeFieldMappingConfigWithOutDataCheck();
            BizOperationResult result = MulImportCheckerProxy.invokeDataAlerter(infoModelList);
            if (result.getSuccess() || StringUtils.isEmpty((String)result.getErrorDesc())) {
                try {
                    this.finish();
                }
                catch (DmwImptException e) {
                    this.getView().showErrorNotification(e.getMessage());
                }
                return;
            }
            StringBuilder msgBuilder = new StringBuilder(result.getErrorDesc());
            msgBuilder.append("\r\n").append("\r\n").append(ResManager.loadKDString((String)"\u786e\u8ba4\u4e0d\u8fdb\u884c\u5b57\u6bb5\u6620\u5c04\u7ee7\u7eed\u4fdd\u5b58\u65b9\u6848?", (String)"ImportSchemeGuideFormPlugin_18", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            this.getView().showConfirm("", msgBuilder.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(ALERT_CALLBACK, (IFormPlugin)this));
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        this.putCache(SCHEME_CHANGE, Boolean.toString(true));
        this.putCache(TEM_CHANGE, Boolean.toString(true));
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6a21\u677f\u5f02\u5e38\u6216\u5931\u8d25", (String)"ImportSchemeGuideFormPlugin_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap urlMap = (LinkedHashMap)urls[0];
        String url = (String)urlMap.get("url");
        try {
            ImportTemplateReadInfoModel infoModel = MulImportCheckerProxy.parseTemplateInfoByUrlWithTempFileCache(url, 0);
            if (infoModel == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89e3\u6790\u6a21\u677f\u5931\u8d25", (String)"ImportSchemeGuideFormPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            this.clearImportSchemeDataArea();
            this.putCache(TEMPLATE_CACHE_KEY, infoModel.toString());
            this.putCache(URL_CACHE_KEY, SerializationUtils.serializeToBase64((Object)urlMap));
        }
        catch (DmwImptException e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
        try {
            this.checkSchemeBaseInfoFinish();
            this.setNextEnable(true);
        }
        catch (DmwImptException e) {
            this.setNextEnable(false);
        }
    }

    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            return;
        }
        for (Object url : urls) {
            LinkedHashMap map = (LinkedHashMap)url;
            map.put("visible", "0101");
        }
        this.getView().updateView(SCHEME_ATTACHMENT);
    }

    public void remove(UploadEvent evt) {
        super.remove(evt);
        this.clearCache(TEMPLATE_CACHE_KEY);
        this.putCache(SCHEME_CHANGE, Boolean.toString(true));
        this.putCache(TEM_CHANGE, Boolean.toString(true));
        this.setNextEnable(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter qFilter;
        String key = evt.getProperty().getName();
        if (TARGETOBJS.equals(key) && (qFilter = PermissionHelper.buildImpTargetQFilter(this.getView())) != null) {
            evt.getFormShowParameter().setCustomParam("l_f_s", (Object)qFilter.toString());
            evt.getCustomQFilters().add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        MulBasedataDynamicObjectCollection targetobjs;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (TARGETOBJS.equals(name) && (targetobjs = (MulBasedataDynamicObjectCollection)this.getModel().getValue(TARGETOBJS)) != null && targetobjs.size() > 1) {
            String code = "";
            for (DynamicObject targetObj : targetobjs) {
                String curCode = targetObj.getDynamicObject("fbasedataid").getString("importcode").split("\\.")[0];
                if (StringUtils.isEmpty((String)code)) {
                    code = curCode;
                    continue;
                }
                if (code.equals(curCode)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u540c\u5206\u7ec4\u7684\u4e1a\u52a1\u5bf9\u8c61\uff0c\u5efa\u8bae\u5206\u5f00\u5efa\u7acb\u5bfc\u5165\u65b9\u6848", (String)"ImportSchemeGuideFormPlugin_17", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                this.getModel().setValue(TARGETOBJS, e.getChangeSet()[0].getOldValue());
                break;
            }
        }
        try {
            this.checkSchemeBaseInfoFinish();
            this.setNextEnable(true);
        }
        catch (DmwImptException e2) {
            this.setNextEnable(false);
        }
        this.putCache(SCHEME_CHANGE, Boolean.toString(true));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (ALERT_CALLBACK.equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            try {
                this.finish();
            }
            catch (DmwImptException ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        }
    }

    private boolean isAddNew() {
        return this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW;
    }

    private long getSchemeId() {
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("s_g_id");
        if (schemeId == null) {
            return 0L;
        }
        return (Long)schemeId;
    }

    private String getSchemeNumber() {
        DynamicObject dynamicObject = DynamicObjectUtils.buildDynamicObject(IPTM_SCHEME);
        return DynamicObjectUtils.autoNumber(dynamicObject, IPTM_SCHEME, null);
    }

    private void initSchemeGuideBaseInfo() {
        if (this.isAddNew()) {
            this.getModel().setValue("billno", (Object)this.getSchemeNumber());
            this.setNextEnable(false);
        } else {
            ViewSchemeBaseInfoModel schemeBaseInfoModel = SchemeDataPackageTransHelper.schemeDetailToGuideBaseInfoParse(this.getSchemeId());
            if (schemeBaseInfoModel == null) {
                this.getModel().setValue("billno", (Object)this.getSchemeNumber());
                this.setNextEnable(false);
                return;
            }
            this.getModel().setValue("billno", (Object)schemeBaseInfoModel.getNumber());
            this.getModel().setValue(SCHEME_NAME, (Object)schemeBaseInfoModel.getName());
            this.getModel().setValue(TARGETOBJS, schemeBaseInfoModel.getTargetObjs());
            this.getModel().setValue("usestatus", (Object)schemeBaseInfoModel.getUseStatus());
            this.getModel().setValue("sharestatus", (Object)schemeBaseInfoModel.getShare());
            this.getModel().setValue("schemedesc", (Object)schemeBaseInfoModel.getDesc());
            this.initSchemeAttachment(schemeBaseInfoModel.getAttachMap(), schemeBaseInfoModel.getTemplateInfo());
            this.cacheComboItem();
        }
    }

    private void cacheComboItem() {
        DynamicObjectCollection targetObjList = this.getTargetCollection();
        Map<String, ViewSchemeMappingInfoModel> modelMap = SchemeDataPackageTransHelper.schemeMappingInfoModelParse(this.getSchemeId());
        if (targetObjList == null || modelMap.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        for (DynamicObject targetObj : targetObjList) {
            DynamicObject tarInfoObj = targetObj.getDynamicObject("fbasedataid");
            String targetFormId = tarInfoObj.getString("target_formid");
            ViewSchemeMappingInfoModel viewSchemeMappingInfoModel = modelMap.get(targetFormId);
            if (viewSchemeMappingInfoModel == null) continue;
            String mulSheets = viewSchemeMappingInfoModel.getMulSheets();
            String sheetReleValue = viewSchemeMappingInfoModel.getSheetReleValue();
            String importWay = viewSchemeMappingInfoModel.getImportWay();
            String keyFields = viewSchemeMappingInfoModel.getKeyFields();
            Map<String, String> fieldMappingValue = viewSchemeMappingInfoModel.getFieldMappingValue();
            pageCache.put(targetFormId + "_sheet", mulSheets);
            pageCache.put(targetFormId + "_sheet_rele", sheetReleValue);
            pageCache.put(targetFormId + "_import_way", importWay);
            pageCache.put(targetFormId + "_import_rele", keyFields);
            pageCache.put(targetFormId + "_excel_field_map", JSON.toJSONString(fieldMappingValue));
            Map<String, Map<String, String>> formulaDescMappingValue = viewSchemeMappingInfoModel.getFormulaDescMap();
            pageCache.put(targetFormId + "_formuladesc_field_map", JSON.toJSONString(formulaDescMappingValue));
        }
    }

    private void setNextEnable(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEXT});
        this.getView().setEnable(Boolean.FALSE, new String[]{WIZARDAP});
    }

    private void initSchemeAttachment(Map<String, Object> attachMap, String templateInfo) {
        try {
            AttachmentPanel attachPanel = (AttachmentPanel)this.getView().getControl(SCHEME_ATTACHMENT);
            if (attachMap == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ImportSchemeGuideFormPlugin_20", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            attachMap.put("visible", "0101");
            attachPanel.upload(Collections.singletonList(attachMap));
            ImportTemplateReadInfoModel infoModel = null;
            if (StringUtils.isNotEmpty((String)templateInfo)) {
                infoModel = (ImportTemplateReadInfoModel)JSON.parseObject((String)templateInfo, ImportTemplateReadInfoModel.class);
            }
            if (infoModel == null) {
                infoModel = MulImportCheckerProxy.parseTemplateInfoByUrlWithAttachFileCache((String)attachMap.get("url"), 0);
            }
            if (infoModel == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89e3\u6790\u6a21\u677f\u5931\u8d25", (String)"ImportSchemeGuideFormPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            this.putCache(TEMPLATE_CACHE_KEY, infoModel.toString());
            this.putCache(URL_CACHE_KEY, SerializationUtils.serializeToBase64(attachMap));
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_NEXT});
            this.getView().updateView(SCHEME_ATTACHMENT);
        }
        catch (DmwImptException e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89e3\u6790\u6a21\u677f\u5931\u8d25", (String)"ImportSchemeGuideFormPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    private Container getMappingContainer() {
        return (Container)this.getView().getControl(MAPPING_AREA);
    }

    private void previous() {
        Tab tab = (Tab)this.getView().getControl(GUIDE);
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            if (currentTab.equals(((Control)tab.getItems().get(0)).getKey())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u4e3a\u7b2c\u4e00\u9875\uff01", (String)"ImportSchemeGuideFormPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            break;
        }
    }

    private void changeNextBtnVisible(boolean show) {
        this.getView().setVisible(Boolean.valueOf(show), new String[]{BTN_NEXT});
        this.getView().setVisible(Boolean.valueOf(!show), new String[]{BTN_FINISH});
    }

    private void changePreBtnVisible(boolean show) {
        this.getView().setVisible(Boolean.valueOf(show), new String[]{BTN_PRE});
        this.getView().setVisible(Boolean.valueOf(!show), new String[]{BTN_CANCEL});
    }

    private void next() {
        Tab tab = (Tab)this.getView().getControl(GUIDE);
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            if (currentTab.equals(((Control)tab.getItems().get(tab.getItems().size() - 1)).getKey())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5411\u5bfc\u5df2\u5b8c\u6210\uff0c\u662f\u5426\u9000\u51fa\u672c\u9875?", (String)"ImportSchemeGuideFormPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exitGuideCallBack"));
                break;
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
            break;
        }
    }

    private void finish() throws DmwImptException {
        boolean isChange = Boolean.parseBoolean(this.readCache(SCHEME_CHANGE));
        logger.info("SchemeEdit {}", (Object)isChange);
        if (!isChange) {
            this.getView().close();
            return;
        }
        Map<String, DynamicObject> schemeFieldMappingConfig = this.getSchemeFieldMappingConfig();
        DynamicObject baseInfoDyObj = this.getSchemeBaseConfig();
        Map urlMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.readCache(URL_CACHE_KEY));
        String tempInfoStr = this.readCache(TEMPLATE_CACHE_KEY);
        OperationResult operationResult = MultiImpSchemeHelper.executeSchemeSaveOperation(baseInfoDyObj, this.getSchemeId(), this.getView().getFormShowParameter().getStatus(), urlMap, tempInfoStr, schemeFieldMappingConfig);
        if (operationResult != null) {
            if (operationResult.isSuccess()) {
                this.getView().returnDataToParent((Object)Boolean.TRUE);
                this.getView().close();
            } else {
                throw new KDBizException(CommonUtils.getErrDetail(operationResult));
            }
        }
    }

    private DynamicObject getSchemeBaseConfig() {
        return this.getModel().getDataEntity();
    }

    private Map<String, DynamicObject> getSchemeFieldMappingConfig() throws DmwImptException {
        Set<Map.Entry<String, String>> entries = this.getPageCacheKey().entrySet();
        HashMap<String, DynamicObject> fieldMap = new HashMap<String, DynamicObject>(entries.size());
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, String> entry : entries) {
            logger.info("Get FieldMapping key {} value {}", (Object)entry.getKey(), (Object)entry.getValue());
            DynamicObject fieldMappingConfigDy = this.getView().getView(entry.getValue()).getModel().getDataEntity(true);
            String formId = DynamicFlexPanelControlProxy.getFormIdWithMappingTemplateKey(entry.getKey());
            String targetName = this.getTargetName(formId);
            BizOperationResult result = MulImportCheckerProxy.invokeSchemeMidDataCheck(targetName, fieldMappingConfigDy);
            if (!result.getSuccess()) {
                msg.append(result.getErrorDesc());
                continue;
            }
            fieldMap.put(formId, fieldMappingConfigDy);
        }
        if (StringUtils.isNotEmpty((String)msg.toString())) {
            throw new DmwImptException(msg.toString(), 1001);
        }
        return fieldMap;
    }

    private List<ImportTargetSchemeInfoModel> getSchemeFieldMappingConfigWithOutDataCheck() {
        ArrayList<ImportTargetSchemeInfoModel> infoModelList = new ArrayList<ImportTargetSchemeInfoModel>(8);
        Set<Map.Entry<String, String>> entries = this.getPageCacheKey().entrySet();
        for (Map.Entry<String, String> entry : entries) {
            DynamicObject fieldMappingConfigDy = this.getView().getView(entry.getValue()).getModel().getDataEntity(true);
            String formId = DynamicFlexPanelControlProxy.getFormIdWithMappingTemplateKey(entry.getKey());
            infoModelList.add(new ImportTargetSchemeInfoModel(formId, this.getTargetName(formId), fieldMappingConfigDy));
        }
        return infoModelList;
    }

    private void checkSchemeBaseInfoFinish() throws DmwImptException {
        logger.info("\u5f00\u59cb\u68c0\u67e5\u5fc5\u5f55\u5b57\u6bb5\u662f\u5426\u586b\u5199\u5b8c\u6210");
        String schemeName = (String)this.getModel().getValue(SCHEME_NAME);
        if (StringUtils.isEmpty((String)schemeName)) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0", (String)"ImportSchemeGuideFormPlugin_14", (String)"imsc-dmw-platform", (Object[])new Object[0]), 2001);
        }
        DynamicObjectCollection targetCount = this.getTargetCollection();
        if (targetCount == null || targetCount.isEmpty()) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u8bf7\u786e\u5b9a\u8be5\u65b9\u6848\u7684\u5bfc\u5165\u5bf9\u8c61", (String)"ImportSchemeGuideFormPlugin_15", (String)"imsc-dmw-platform", (Object[])new Object[0]), 2001);
        }
        String templateInfo = this.readCache(TEMPLATE_CACHE_KEY);
        if (StringUtils.isEmpty((String)templateInfo)) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6a21\u677f\u662f\u5426\u5b8c\u6210\u4e0a\u4f20", (String)"ImportSchemeGuideFormPlugin_16", (String)"imsc-dmw-platform", (Object[])new Object[0]), 2001);
        }
        logger.info("\u5b8c\u6210\u5fc5\u5f55\u5b57\u6bb5\u5f55\u5165");
    }

    private void initImportSchemeDataArea(DynamicObjectCollection targetObjList, ImportTemplateReadInfoModel infoModel) {
        Container mappingContainer = this.getMappingContainer();
        List<String> curKeyList = this.getCurControlKeyList();
        List<String> selectKeyList = DynamicFlexPanelControlProxy.getSelectControlKeys(targetObjList);
        Tuple<List<String>, List<String>> tuple = DynamicFlexPanelControlProxy.spiltControlKeys(curKeyList, selectKeyList);
        Map<String, String> pageCacheKey = this.getPageCacheKey();
        if (tuple != null && tuple.item1 != null && !((List)tuple.item1).isEmpty()) {
            String[] deleteKeys = ((List)tuple.item1).toArray(new String[0]);
            mappingContainer.deleteControls(deleteKeys);
            for (String deleteKey : deleteKeys) {
                pageCacheKey.remove(deleteKey);
            }
        }
        ArrayList<String> saveKeyList = new ArrayList<String>();
        if (tuple != null && tuple.item2 != null && !((List)tuple.item2).isEmpty()) {
            saveKeyList.addAll((Collection)tuple.item2);
        }
        targetObjList.sort((o1, o2) -> {
            String code1 = o1.getDynamicObject("fbasedataid").getString("importcode");
            String code2 = o2.getDynamicObject("fbasedataid").getString("importcode");
            return code1.compareTo(code2);
        });
        String temChange = this.readCache(TEM_CHANGE);
        Map<String, ViewSchemeMappingInfoModel> modelMap = StringUtils.isEmpty((String)temChange) || "FALSE".equals(temChange) ? SchemeDataPackageTransHelper.schemeMappingInfoModelParse(this.getSchemeId()) : null;
        for (DynamicObject targetObj : targetObjList) {
            String templateKey;
            DynamicObject tarInfoObj = targetObj.getDynamicObject("fbasedataid");
            String targetFormId = tarInfoObj.getString("target_formid");
            String labelKey = DynamicFlexPanelControlProxy.getLabelTemplateKey(targetFormId);
            ArrayList<Map> maps = new ArrayList<Map>();
            if (!saveKeyList.contains(labelKey)) {
                FlexPanelAp labelPanelAp = this.createFlexPanelAp(labelKey);
                maps.add(labelPanelAp.createControl());
                saveKeyList.add(labelKey);
            }
            if (!saveKeyList.contains(templateKey = DynamicFlexPanelControlProxy.getMappingTemplateKey(targetFormId))) {
                FlexPanelAp templatePanelAp = this.createFlexPanelAp(templateKey);
                maps.add(templatePanelAp.createControl());
                saveKeyList.add(templateKey);
            }
            if (maps.isEmpty()) continue;
            mappingContainer.addControls(maps);
            this.openDynamicFormInner(tarInfoObj, labelKey, FIELD_LABEL_FORM_ID, null, null);
            String pageId = this.openDynamicFormInner(tarInfoObj, templateKey, FIELD_MAPPING_FORM_ID, infoModel, modelMap == null ? null : modelMap.get(targetFormId));
            pageCacheKey.put(templateKey, pageId);
        }
        this.putControlKey(saveKeyList);
        this.putPageCacheKey(pageCacheKey);
    }

    private void clearImportSchemeDataArea() {
        Container mappingContainer = this.getMappingContainer();
        List<String> curKeyList = this.getCurControlKeyList();
        if (curKeyList == null || curKeyList.isEmpty()) {
            return;
        }
        for (String key : curKeyList) {
            mappingContainer.deleteControls(new String[]{key});
        }
        this.clearCache(CONTROL_CACHE_KEY);
        this.clearCache(PAGE_CACHE_KEY);
    }

    private FlexPanelAp createFlexPanelAp(String key) {
        FlexPanelAp mappingFlex = new FlexPanelAp();
        mappingFlex.setCollapsible(false);
        mappingFlex.setShrink(0);
        mappingFlex.setGrow(0);
        mappingFlex.setKey(key);
        return mappingFlex;
    }

    private String openDynamicFormInner(DynamicObject importObj, String key, String formId, ImportTemplateReadInfoModel infoModel, ViewSchemeMappingInfoModel mappingInfoModel) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParam("import_target", (Object)importObj);
        if (infoModel != null) {
            showParameter.setCustomParam("import_t_info", (Object)infoModel);
        }
        if (mappingInfoModel != null) {
            showParameter.setCustomParam("imp_m_info", (Object)mappingInfoModel);
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(key);
        String pageId = UUID.randomUUID().toString().replace("-", "") + System.currentTimeMillis();
        this.getView().getPageCache().put(key, pageId);
        showParameter.setPageId(pageId);
        this.getView().showForm(showParameter);
        return pageId;
    }

    private DynamicObjectCollection getTargetCollection() {
        Object value = this.getModel().getValue(TARGETOBJS);
        if (value == null) {
            return null;
        }
        return (DynamicObjectCollection)value;
    }

    private String getTargetName(String formId) {
        if (StringUtils.isEmpty((String)formId)) {
            return "";
        }
        DynamicObjectCollection collection = this.getTargetCollection();
        if (collection == null) {
            return "";
        }
        for (DynamicObject targetObj : collection) {
            DynamicObject detailObj = targetObj.getDynamicObject("fbasedataid");
            if (!formId.equals(detailObj.getString("target_formid"))) continue;
            return detailObj.getString("name");
        }
        return "";
    }

    private void putControlKey(List<String> controlKeys) {
        this.putCache(CONTROL_CACHE_KEY, JSON.toJSONString(controlKeys));
    }

    private List<String> getCurControlKeyList() {
        String controlKeyStr = this.getPageCache().get(CONTROL_CACHE_KEY);
        if (StringUtils.isEmpty((String)controlKeyStr)) {
            return new ArrayList<String>();
        }
        return JSON.parseArray((String)controlKeyStr, String.class);
    }

    private void clearCache(String key) {
        this.getPageCache().remove(key);
    }

    private void putCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private String readCache(String key) {
        return this.getPageCache().get(key);
    }

    private void putPageCacheKey(Map<String, String> pageMap) {
        this.putCache(PAGE_CACHE_KEY, JSON.toJSONString(pageMap));
    }

    private Map<String, String> getPageCacheKey() {
        String pageStr = this.getPageCache().get(PAGE_CACHE_KEY);
        if (StringUtils.isEmpty((String)pageStr)) {
            return new HashMap<String, String>(1);
        }
        return (Map)JSON.parseObject((String)pageStr).toJavaObject(Map.class);
    }
}

