/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.scheme;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.engine.multiimport.model.FieldMappingModel;
import kd.imsc.dmw.helper.TemplateMappingHelper;

public class ImportTargetBaseDataFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ImportTargetBaseDataFormPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String parentFormId = e.getFormShowParameter().getParentFormId();
        if (kd.bos.util.StringUtils.isEmpty((String)parentFormId)) {
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initKeyFieldComboItems();
        this.getView().setVisible(Boolean.valueOf(!"new".equals(this.getModel().getValue("importway"))), new String[]{"mulreplacefield"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        logger.info("propertyChanged {}", (Object)fieldName);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        if ("entitymeta".equals(fieldName)) {
            this.clearKeyFieldValue();
            this.initKeyFieldComboItems();
            return;
        }
        if ("importway".equals(fieldName)) {
            String newValue = (String)changeData.getNewValue();
            if (newValue.equals("new") || StringUtils.isEmpty((CharSequence)newValue)) {
                this.clearKeyFieldValue();
                this.getView().setVisible(Boolean.FALSE, new String[]{"mulreplacefield"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"mulreplacefield"});
            }
        }
    }

    private void initKeyFieldComboItems() {
        String formId = (String)this.getModel().getValue("target_formid");
        if (StringUtils.isEmpty((CharSequence)formId)) {
            ((ComboEdit)this.getControl("mulreplacefield")).setComboItems(null);
            return;
        }
        List<FieldMappingModel> fieldList = TemplateMappingHelper.getFormFieldsMapping(formId);
        if (CollectionUtils.isEmpty(fieldList)) {
            ((ComboEdit)this.getControl("mulreplacefield")).setComboItems(null);
            return;
        }
        List itemList = fieldList.stream().map(a -> new ComboItem(new LocaleString(a.getStdFieldName()), a.getStdFieldId())).collect(Collectors.toList());
        ((ComboEdit)this.getControl("mulreplacefield")).setComboItems(itemList);
    }

    private void clearKeyFieldValue() {
        this.getModel().setValue("mulreplacefield", null);
    }
}

