/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imsc.dmw.engine.multiimport.helper.ImportServiceManagerHelper;
import kd.imsc.dmw.engine.multiimport.helper.MultiImpTaskHelper;
import kd.imsc.dmw.engine.multiimport.model.SubDataConfigureInfo;
import kd.imsc.dmw.engine.multiimport.result.ImportSimpleResult;
import kd.imsc.dmw.engine.multiimport.result.ImportTotalResult;
import kd.imsc.dmw.enums.ImpFailCodeEnum;

public class ImportServiceProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(ImportServiceProgressFormPlugin.class);
    private static final String TITLE = "title";
    private static final String PROGRESSBAR = "progressbar";
    private static final String TOTAL_FLEX = "totalflexpanel";
    private static final String TOTAL_COUNT = "totalcount";
    private static final String SUCCESS_FLEX = "successflexpanel";
    private static final String SUCCESS_COUNT = "successcount";
    private static final String SUCCESS_HINT = "successhint";
    private static final String SUCCESS_UNIT = "successunit";
    private static final String FAIL_FLEX = "failflexpanel";
    private static final String FAIL_COUNT = "failcount";
    private static final String FAIL_HINT = "failhint";
    private static final String FAIL_UNIT = "failunit";
    private static final String WAIT_FLEX = "waitflexpanel";
    private static final String WAIT_COUNT = "waitcount";
    private static final String WAIT_HINT = "waithint";
    private static final String WAIT_UNIT = "waitunit";
    private static final String PROGRESS_LAB = "progress";
    private static final String BTN_STOP = "btnstop";
    private static final String BTN_BG = "btnbg";
    private static final String BTN_CLOSE = "btnclose";
    private static final String DOWNLOADING = "is_download";
    private static final String IS_START_KEY = "is_start";
    private static final String IS_FINISH_KEY = "is_finish";
    private static final String IMPORT_SERVICE_ID_KEY = "imp_s_id";
    private static final String JOB_FROM_INFO = "job_f_i";
    private static final String IMPORT_TOTAL_COUNT = "im_t_c";
    private static final String CHANGE_BG = "change_bg";
    private boolean canClose = false;
    private static final Map<Boolean, String> colorMap = new HashMap<Boolean, String>(2);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTN_STOP, BTN_BG, BTN_CLOSE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_STOP, BTN_BG, BTN_CLOSE, TOTAL_FLEX, TOTAL_COUNT, SUCCESS_FLEX, SUCCESS_COUNT, SUCCESS_HINT, SUCCESS_UNIT, FAIL_FLEX, FAIL_COUNT, FAIL_HINT, FAIL_UNIT, WAIT_FLEX, WAIT_COUNT, WAIT_HINT});
        this.doFileDownLoad();
    }

    public void click(EventObject e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_STOP)) {
            this.stop();
            return;
        }
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_BG)) {
            this.tranBackground();
            return;
        }
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_CLOSE)) {
            this.closeForm();
        }
    }

    public void onProgress(ProgressEvent e) {
        String importServiceId = this.getImportServiceId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isEmpty((CharSequence)importServiceId)) {
            this.setTitleInfo(ResManager.loadKDString((String)"\u5f00\u59cb\u5bfc\u5165", (String)"ImportServiceProgressFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            this.dispatchTask();
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)importServiceId)) {
            this.updateTaskProgress(e);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!this.isStart()) {
            String down = this.getView().getPageCache().get(DOWNLOADING);
            e.setCancel(!StringUtils.isNotEmpty((CharSequence)down) || !down.equalsIgnoreCase("FALSE"));
            return;
        }
        if (!this.canClose && !this.isFinished()) {
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (jobFormInfo == null) {
                return;
            }
            String importServiceId = this.getImportServiceId();
            if (StringUtils.isEmpty((CharSequence)importServiceId)) {
                return;
            }
            if (jobFormInfo.isCanStop()) {
                this.stop();
                e.setCancel(true);
            } else if (jobFormInfo.isCanBackground()) {
                this.tranBackground();
                e.setCancel(true);
            } else {
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            this.startBar();
        } else if (StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)CHANGE_BG)) {
            this.doTranBackground();
        } else {
            this.doStop();
        }
    }

    private JobFormInfo getJobFormInfo() {
        String jobStr = this.readPageCacheByKey(JOB_FROM_INFO);
        if (StringUtils.isEmpty((CharSequence)jobStr)) {
            jobStr = (String)this.getView().getFormShowParameter().getCustomParam("im_j_i");
        }
        if (StringUtils.isEmpty((CharSequence)jobStr)) {
            this.getView().close();
            throw new KDException(new ErrorCode("100021", ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u591a\u5bf9\u8c61\u5bfc\u5165\u4fe1\u606f", (String)"ImportServiceProgressFormPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0])), new Object[0]);
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)jobStr, JobFormInfo.class);
    }

    private long getTaskId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("im_t_id");
    }

    private String readPageCacheByKey(String key) {
        return this.getView().getPageCache().get(key);
    }

    private void putPageCache(String key, String value) {
        this.getView().getPageCache().put(key, value);
    }

    private String getImportServiceId() {
        return this.getPageCache().get(IMPORT_SERVICE_ID_KEY);
    }

    private void setImportServiceId(String taskId) {
        this.getPageCache().put(IMPORT_SERVICE_ID_KEY, taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(IS_START_KEY);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(IS_START_KEY, String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(IS_FINISH_KEY);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(IS_FINISH_KEY, String.valueOf(finished));
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getView().getControl(PROGRESSBAR);
    }

    private void setProgressValue(int progress) {
        ((Label)this.getView().getControl(PROGRESS_LAB)).setText(String.format("%d", progress) + "%");
    }

    private void doFileDownLoad() {
        this.getView().getPageCache().put(DOWNLOADING, "TRUE");
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        JobInfo jobInfo = jobFormInfo.getJobInfo();
        Map params = jobInfo.getParams();
        String mulImpInfoStr = (String)params.get("std_im_t_t");
        List infoList = JSON.parseArray((String)mulImpInfoStr, SubDataConfigureInfo.class);
        List<String> formIdList = infoList.stream().map(a -> a.getInstallInfo().getFormId()).collect(Collectors.toList());
        Map<String, Object> attachmentInfo = MultiImpTaskHelper.getTaskAttachment(this.getTaskId(), "attachmentpanelap");
        if (attachmentInfo == null) {
            this.getView().getPageCache().put(DOWNLOADING, "FALSE");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u65e0\u6cd5\u8fdb\u884c\u6a21\u677f\u6570\u636e\u4e0b\u8f7d", (String)"ImportServiceProgressFormPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            MultiImpTaskHelper.failTaskByEntityBeforeImport(this.getTaskId(), formIdList);
            return;
        }
        String[] nameArrays = ((String)attachmentInfo.get("name")).split("\\.");
        params.put("im_f_i", new JSONObject().fluentPut("url", (Object)((String)attachmentInfo.get("url"))).fluentPut("name", (Object)nameArrays[0]).fluentPut("format", (Object)nameArrays[1]).toJSONString());
        params.put("std_im_t_t", JSON.toJSONString((Object)infoList));
        jobInfo.setParams(params);
        jobFormInfo.setJobInfo(jobInfo);
        this.putPageCache(JOB_FROM_INFO, SerializationUtils.toJsonString((Object)jobFormInfo));
        this.putPageCache(IMPORT_TOTAL_COUNT, String.valueOf(infoList.size()));
        this.setProgressValue(0);
        this.startBar();
    }

    private List<String> getImportFormIdList() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        JobInfo jobInfo = jobFormInfo.getJobInfo();
        Map params = jobInfo.getParams();
        String mulImpInfoStr = (String)params.get("std_im_t_t");
        List infoList = JSON.parseArray((String)mulImpInfoStr, SubDataConfigureInfo.class);
        return infoList.stream().map(a -> a.getInstallInfo().getFormId()).collect(Collectors.toList());
    }

    private void startBar() {
        ProgressBar bar = this.getProgressBar();
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = this.getProgressBar();
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getImportServiceId(), (String)"");
        this.returnResult("");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
            jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
        }
        String serviceId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.setImportServiceId(serviceId);
        this.setButtonVisible(jobFormInfo);
        MultiImpTaskHelper.importServiceIdWriteBack(this.getTaskId(), serviceId);
    }

    private void updateTaskProgress(ProgressEvent e) {
        TaskInfo taskInfo = ImportServiceManagerHelper.getTaskInfoById(this.getImportServiceId());
        logger.info("taskInfo progress {} status {} ", (Object)taskInfo.getProgress(), (Object)taskInfo.getStatus());
        String status = taskInfo.getStatus();
        if (StringUtils.equalsIgnoreCase((CharSequence)"BEGIN", (CharSequence)status)) {
            this.setTitleInfo(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5f00\u59cb", (String)"ImportServiceProgressFormPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            e.setProgress(0);
            this.updateImportResultInfo("RUNNING", null);
            return;
        }
        ImportTotalResult importResult = ImportServiceManagerHelper.getImportResultByTaskId(this.getImportServiceId());
        logger.info("taskInfo importResult {} ", (Object)JSON.toJSONString((Object)importResult));
        if (importResult.getCode() != 200) {
            this.getView().getPageCache().put(DOWNLOADING, "FALSE");
            switch (importResult.getCode()) {
                case 100: {
                    this.setTitleInfo(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5bfc\u5165\u6587\u4ef6", (String)"ImportServiceProgressFormPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    break;
                }
                case -1: {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u67e5\u8be2", (String)"ImportServiceProgressFormPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]), importResult.getMsg()));
                    this.setProgressValue(100);
                    this.stopBar();
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTN_STOP, BTN_BG});
                    this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
                    MultiImpTaskHelper.failTaskByEntityBeforeImport(this.getTaskId(), this.getImportFormIdList());
                    break;
                }
                case 102: {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01", (String)"ImportServiceProgressFormPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    this.setProgressValue(100);
                    this.stopBar();
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTN_STOP, BTN_BG});
                    this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
                    MultiImpTaskHelper.failTaskByEntityBeforeImport(this.getTaskId(), this.getImportFormIdList());
                    break;
                }
            }
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"RUNNING", (CharSequence)status) || taskInfo.getProgress() < 100) {
            this.setTitleInfo(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d", (String)"ImportServiceProgressFormPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            e.setProgress(taskInfo.getProgress() >= 100 ? 99 : taskInfo.getProgress());
            this.setProgressValue(taskInfo.getProgress() >= 100 ? 99 : taskInfo.getProgress());
            this.updateImportResultInfo("RUNNING", null);
            return;
        }
        int failCount = this.updateImportResultInfo("COMPLETE", importResult);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)status)) {
            this.setFinished(true);
            e.setProgress(100);
            this.setProgressValue(100);
            if (ImportServiceProgressFormPlugin.isShowStackTrace()) {
                this.getView().showErrMessage(taskInfo.getFailureReason(), "");
            } else {
                String errMsg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u65e5\u5fd7 %1s", (String)"ImportServiceProgressFormPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]), taskInfo.getFailureReason());
                this.getView().showErrorNotification(errMsg);
            }
            this.stopBar();
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_STOP, BTN_BG});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
            MultiImpTaskHelper.failTaskByEntityBeforeImport(this.getTaskId(), this.getImportFormIdList());
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"COMPLETED", (CharSequence)status) || taskInfo.getProgress() == 100) {
            this.setFinished(true);
            this.setProgressValue(100);
            e.setProgress(100);
            this.setTitleInfo(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5", (String)"ImportServiceProgressFormPlugin_9", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_STOP, BTN_BG});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
            this.stopBar();
            if (failCount == 0) {
                this.closeForm();
            }
        }
    }

    private void stop() {
        if (this.isFinished()) {
            this.closeForm();
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_stop", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u6267\u884c", (String)"ImportServiceProgressFormPlugin_10", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62\u6267\u884c", (String)"ImportServiceProgressFormPlugin_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u7ec8\u6b62\u6267\u884c\uff1f", (String)"ImportServiceProgressFormPlugin_12", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doStop() {
        this.stopBar();
        logger.info("\u7ec8\u6b62\u5bfc\u5165\u4efb\u52a1");
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo == null) {
            this.closeForm();
            return;
        }
        JobInfo jobInfo = jobFormInfo.getJobInfo();
        Map params = jobInfo.getParams();
        String mulImpInfoStr = (String)params.get("std_im_t_t");
        List infoList = JSON.parseArray((String)mulImpInfoStr, SubDataConfigureInfo.class);
        List<String> formIdList = infoList.stream().map(a -> a.getInstallInfo().getFormId()).collect(Collectors.toList());
        MultiImpTaskHelper.failTaskWhenServiceTerminated(this.getTaskId(), formIdList);
        String importServiceId = this.getImportServiceId();
        if (!StringUtils.isEmpty((CharSequence)importServiceId)) {
            ImportServiceManagerHelper.stopTaskById(importServiceId);
            TaskClientProxy.suspend((JobFormInfo)this.getJobFormInfo(), (String)importServiceId);
        }
        this.closeForm();
    }

    private void tranBackground() {
        if (this.isFinished()) {
            this.closeForm();
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGE_BG, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ImportServiceProgressFormPlugin_13", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u540e\u53f0\u6267\u884c", (String)"ImportServiceProgressFormPlugin_14", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u8f6c\u5165\u540e\u53f0\u6267\u884c\uff1f", (String)"ImportServiceProgressFormPlugin_15", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doTranBackground() {
        this.closeForm();
        String impServiceId = this.getImportServiceId();
        if (StringUtils.isEmpty((CharSequence)impServiceId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)impServiceId);
        if (!TaskClientProxy.isExistTask((String)impServiceId)) {
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), impServiceId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }

    private void setTitleInfo(String desc) {
        Label lblDesc = (Label)this.getControl(TITLE);
        lblDesc.setText(desc);
        this.getView().updateView(TITLE);
    }

    private int updateImportResultInfo(String status, ImportTotalResult importResult) {
        if (importResult == null || "RUNNING".equals(status) || importResult.getImportMap() == null || importResult.getImportMap().isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TOTAL_FLEX, TOTAL_COUNT});
            ((Label)this.getView().getControl(TOTAL_COUNT)).setText(ResManager.loadKDString((String)"\u5bfc\u5165\u4e2d", (String)"ImportServiceProgressFormPlugin_16", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return -1;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{TOTAL_FLEX, TOTAL_COUNT, SUCCESS_FLEX, SUCCESS_COUNT, SUCCESS_HINT, SUCCESS_UNIT, FAIL_FLEX, FAIL_COUNT, FAIL_HINT, FAIL_UNIT, WAIT_FLEX, WAIT_COUNT, WAIT_HINT, WAIT_UNIT});
        Map<String, ImportSimpleResult> importMap = importResult.getImportMap();
        Set<Map.Entry<String, ImportSimpleResult>> entries = importMap.entrySet();
        int totalCount = 0;
        int failCount = 0;
        int successCount = 0;
        for (Map.Entry<String, ImportSimpleResult> entry : entries) {
            ImportSimpleResult value = entry.getValue();
            if (ImpFailCodeEnum.SUCCESS.getCode() == value.getFailCode().getCode()) {
                failCount = value.getFail() > 0 ? failCount + 1 : failCount;
                successCount = value.getFail() == 0 ? successCount + 1 : successCount;
                continue;
            }
            ++failCount;
        }
        totalCount = Integer.parseInt(this.getPageCache().get(IMPORT_TOTAL_COUNT));
        ((Label)this.getView().getControl(TOTAL_COUNT)).setText(String.format(ResManager.loadKDString((String)"\u5171%d\u4e2a\u4e1a\u52a1\u5bf9\u8c61\uff1a", (String)"ImportServiceProgressFormPlugin_17", (String)"imsc-dmw-platform", (Object[])new Object[0]), totalCount));
        ((Label)this.getView().getControl(SUCCESS_COUNT)).setText(String.valueOf(successCount));
        ((Label)this.getView().getControl(FAIL_COUNT)).setText(String.valueOf(failCount));
        ((Label)this.getView().getControl(WAIT_COUNT)).setText(String.valueOf(totalCount - successCount - failCount));
        this.setProgressStyle(totalCount > 0 && totalCount == successCount);
        return failCount;
    }

    private void setButtonVisible(JobFormInfo jobFormInfo) {
        if (jobFormInfo.isCanStop()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_STOP});
        }
        if (jobFormInfo.isCanBackground()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BG});
        }
    }

    private void setProgressStyle(boolean success) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("fc", colorMap.get(success));
        this.getView().updateControlMetadata(PROGRESS_LAB, map);
        this.getView().updateControlMetadata(PROGRESSBAR, map);
    }

    private void returnResult(String msg) {
        HashMap<String, String> dataMap = new HashMap<String, String>(2);
        String impServiceId = this.getImportServiceId();
        if (!StringUtils.isEmpty((CharSequence)impServiceId)) {
            dataMap.put("im_s_id", impServiceId);
        }
        dataMap.put("msg", msg);
        this.getView().returnDataToParent(dataMap);
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && "true".equals(showStackTrace)) {
            return true;
        }
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }

    static {
        colorMap.put(Boolean.TRUE, "#1BA854");
        colorMap.put(Boolean.FALSE, "#FB2323");
    }
}

